/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.AutodiscoverDnsClient;
import microsoft.exchange.webservices.data.AutodiscoverEndpoints;
import microsoft.exchange.webservices.data.AutodiscoverErrorCode;
import microsoft.exchange.webservices.data.AutodiscoverLocalException;
import microsoft.exchange.webservices.data.AutodiscoverRemoteException;
import microsoft.exchange.webservices.data.AutodiscoverRequest;
import microsoft.exchange.webservices.data.ConfigurationSettingsBase;
import microsoft.exchange.webservices.data.DomainSettingName;
import microsoft.exchange.webservices.data.EWSHttpException;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.ExchangeCredentials;
import microsoft.exchange.webservices.data.ExchangeServiceBase;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FormatException;
import microsoft.exchange.webservices.data.GetDomainSettingsRequest;
import microsoft.exchange.webservices.data.GetDomainSettingsResponse;
import microsoft.exchange.webservices.data.GetDomainSettingsResponseCollection;
import microsoft.exchange.webservices.data.GetUserSettingsRequest;
import microsoft.exchange.webservices.data.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.GetUserSettingsResponseCollection;
import microsoft.exchange.webservices.data.HttpClientWebRequest;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.IAutodiscoverRedirectionUrl;
import microsoft.exchange.webservices.data.IFuncDelegate;
import microsoft.exchange.webservices.data.IFunctionDelegate;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.OutlookConfigurationSettings;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TraceFlags;
import microsoft.exchange.webservices.data.UserSettingName;
import microsoft.exchange.webservices.data.WindowsLiveCredentials;
import microsoft.exchange.webservices.data.XMLNodeType;

public final class AutodiscoverService
extends ExchangeServiceBase
implements IAutodiscoverRedirectionUrl,
IFunctionDelegate {
    private String domain;
    private Boolean isExternal = true;
    private URI url;
    private IAutodiscoverRedirectionUrl redirectionUrlValidationCallback;
    private AutodiscoverDnsClient dnsClient;
    private String dnsServerAddress;
    boolean enableScpLookup = true;
    private static final String AutodiscoverLegacyPath = "/autodiscover/autodiscover.xml";
    private static final String AutodiscoverLegacyUrl = "%s://%s/autodiscover/autodiscover.xml";
    private static final String AutodiscoverLegacyHttpsUrl = "https://%s/autodiscover/autodiscover.xml";
    private static final String AutodiscoverLegacyHttpUrl = "http://%s/autodiscover/autodiscover.xml";
    private static final String AutodiscoverSoapHttpsUrl = "https://%s/autodiscover/autodiscover.svc";
    private static final String AutodiscoverSoapWsSecurityHttpsUrl = "https://%s/autodiscover/autodiscover.svc/wssecurity";
    private static final String AutodiscoverRequestNamespace = "http://schemas.microsoft.com/exchange/autodiscover/outlook/requestschema/2006";
    protected static final int AutodiscoverMaxRedirections = 10;
    private static final String AutodiscoverSoapEnabledHeaderName = "X-SOAP-Enabled";
    private static final String AutodiscoverWsSecurityEnabledHeaderName = "X-WSSecurity-Enabled";
    private static final ExchangeVersion MinimumRequestVersionForAutoDiscoverSoapService = ExchangeVersion.Exchange2010;

    private boolean defaultAutodiscoverRedirectionUrlValidationCallback(String redirectionUrl) throws AutodiscoverLocalException {
        throw new AutodiscoverLocalException(String.format(Strings.AutodiscoverRedirectBlocked, redirectionUrl));
    }

    private <TSettings extends ConfigurationSettingsBase> TSettings getLegacyUserSettingsAtUrl(Class<TSettings> cls, String emailAddress, URI url) throws Exception {
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Trying to call Autodiscover for %s on %s.", emailAddress, url));
        ConfigurationSettingsBase settings = (ConfigurationSettingsBase)cls.newInstance();
        HttpWebRequest request = this.prepareHttpWebRequestForUrl(url);
        this.traceHttpRequestHeaders(TraceFlags.AutodiscoverRequestHttpHeaders, request);
        OutputStream urlOutStream = request.getOutputStream();
        if (this.isTraceEnabledFor(TraceFlags.AutodiscoverRequest)) {
            ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(memoryStream);
            this.writeLegacyAutodiscoverRequest(emailAddress, settings, writer);
            writer.flush();
            this.traceXml(TraceFlags.AutodiscoverRequest, memoryStream);
            memoryStream.writeTo(urlOutStream);
            urlOutStream.flush();
            urlOutStream.close();
            memoryStream.close();
        } else {
            PrintWriter writer = new PrintWriter(urlOutStream);
            this.writeLegacyAutodiscoverRequest(emailAddress, settings, writer);
            writer.flush();
            urlOutStream.flush();
            urlOutStream.close();
        }
        request.executeRequest();
        request.getResponseCode();
        OutParam<URI> outParam = new OutParam<URI>();
        if (this.tryGetRedirectionResponse(request, outParam)) {
            URI redirectUrl = (URI)outParam.getParam();
            settings.makeRedirectionResponse(redirectUrl);
            return (TSettings)settings;
        }
        InputStream serviceResponseStream = request.getInputStream();
        if (this.isTraceEnabledFor(TraceFlags.AutodiscoverResponse)) {
            int data;
            ByteArrayOutputStream memoryStream = new ByteArrayOutputStream();
            while (-1 != (data = serviceResponseStream.read())) {
                memoryStream.write(data);
            }
            memoryStream.flush();
            this.traceResponse(request, memoryStream);
            ByteArrayInputStream memoryStreamIn = new ByteArrayInputStream(memoryStream.toByteArray());
            EwsXmlReader reader = new EwsXmlReader(memoryStreamIn);
            reader.read(new XMLNodeType(7));
            settings.loadFromXml(reader);
        } else {
            EwsXmlReader reader = new EwsXmlReader(serviceResponseStream);
            reader.read(new XMLNodeType(7));
            settings.loadFromXml(reader);
        }
        serviceResponseStream.close();
        try {
            request.close();
        }
        catch (Exception e2) {
            request = null;
        }
        return (TSettings)settings;
    }

    private void writeLegacyAutodiscoverRequest(String emailAddress, ConfigurationSettingsBase settings, PrintWriter writer) throws IOException {
        writer.write(String.format("<Autodiscover xmlns=\"%s\">", AutodiscoverRequestNamespace));
        writer.write("<Request>");
        writer.write(String.format("<EMailAddress>%s</EMailAddress>", emailAddress));
        writer.write(String.format("<AcceptableResponseSchema>%s</AcceptableResponseSchema>", settings.getNamespace()));
        writer.write("</Request>");
        writer.write("</Autodiscover>");
    }

    private URI getRedirectUrl(String domainName) throws EWSHttpException, XMLStreamException, IOException, ServiceLocalException, URISyntaxException {
        OutParam<URI> outParam;
        String url = String.format(AutodiscoverLegacyHttpUrl, "autodiscover." + domainName);
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Trying to get Autodiscover redirection URL from %s.", url));
        HttpClientWebRequest request = new HttpClientWebRequest(this.getSimpleHttpConnectionManager());
        try {
            request.setUrl(URI.create(url).toURL());
        }
        catch (MalformedURLException e) {
            String strErr = String.format("Incorrect format : %s", url);
            throw new ServiceLocalException(strErr);
        }
        request.setAllowAutoRedirect(false);
        request.setPreAuthenticate(false);
        request.setRequestMethod("GET");
        request.setUseDefaultCredentials(this.getUseDefaultCredentials());
        if (!this.getUseDefaultCredentials()) {
            ExchangeCredentials serviceCredentials = this.getCredentials();
            if (null == serviceCredentials) {
                throw new ServiceLocalException(Strings.CredentialsRequired);
            }
            serviceCredentials.preAuthenticate();
            serviceCredentials.prepareWebRequest(request);
        }
        try {
            ((HttpWebRequest)request).prepareAsyncConnection();
        }
        catch (Exception ex) {
            ex.getMessage();
            request = null;
        }
        if (request != null && this.tryGetRedirectionResponse(request, outParam = new OutParam<URI>())) {
            URI redirectUrl = (URI)outParam.getParam();
            return redirectUrl;
        }
        try {
            ((HttpWebRequest)request).close();
        }
        catch (Exception e2) {
            request = null;
        }
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, "No Autodiscover redirection URL was returned.");
        return null;
    }

    private boolean tryGetRedirectionResponse(HttpWebRequest request, OutParam<URI> redirectUrl) throws XMLStreamException, IOException, EWSHttpException {
        String location;
        if (AutodiscoverRequest.isRedirectionResponse(request) && (location = request.getResponseHeaderField("Location")) != null && !location.isEmpty()) {
            try {
                redirectUrl.setParam((Object)new URI(location));
                if (((URI)redirectUrl.getParam()).getScheme().toLowerCase().equals("https") && ((URI)redirectUrl.getParam()).getPath().equalsIgnoreCase(AutodiscoverLegacyPath)) {
                    this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Redirection URL found: '%s'", ((URI)redirectUrl.getParam()).toString()));
                    return true;
                }
            }
            catch (URISyntaxException ex) {
                this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Invalid redirection URL was returned: '%s'", location));
                return false;
            }
        }
        return false;
    }

    protected <TSettings extends ConfigurationSettingsBase> TSettings getLegacyUserSettings(Class<TSettings> cls, String emailAddress) throws Exception {
        if (this.url != null) {
            URI autodiscoverUrl = new URI(this.url.toString() + AutodiscoverLegacyPath);
            return this.getLegacyUserSettingsAtUrl(cls, emailAddress, autodiscoverUrl);
        }
        if (this.domain != null && !this.domain.isEmpty()) {
            URI autodiscoverUrl = new URI(String.format(AutodiscoverLegacyHttpsUrl, this.domain));
            return this.getLegacyUserSettingsAtUrl(cls, emailAddress, autodiscoverUrl);
        }
        int currentHop = 1;
        OutParam<Integer> outParam = new OutParam<Integer>();
        outParam.setParam((Object)new Integer(currentHop));
        ArrayList<String> redirectionEmailAddresses = new ArrayList<String>();
        return this.internalGetLegacyUserSettings(cls, emailAddress, redirectionEmailAddresses, outParam);
    }

    private <TSettings extends ConfigurationSettingsBase> TSettings internalGetLegacyUserSettings(Class<TSettings> cls, String emailAddress, List<String> redirectionEmailAddresses, OutParam<Integer> currentHop) throws Exception {
        String domainName = EwsUtilities.domainFromEmailAddress(emailAddress);
        OutParam<Integer> outParamInt = new OutParam<Integer>();
        List<URI> urls = this.getAutodiscoverServiceUrls(domainName, outParamInt);
        int scpUrlCount = (Integer)outParamInt.getParam();
        if (urls.size() == 0) {
            throw new ServiceValidationException(Strings.AutodiscoverServiceRequestRequiresDomainOrUrl);
        }
        this.isExternal = true;
        int currentUrlIndex = 0;
        AutodiscoverRemoteException delayedException = null;
        ConfigurationSettingsBase settings = null;
        do {
            URI autodiscoverUrl = urls.get(currentUrlIndex);
            boolean isScpUrl = currentUrlIndex < scpUrlCount;
            try {
                settings = (ConfigurationSettingsBase)this.getLegacyUserSettingsAtUrl(cls, emailAddress, autodiscoverUrl);
                switch (settings.getResponseType()) {
                    case Success: {
                        if (isScpUrl) {
                            this.isExternal = false;
                        }
                        this.url = autodiscoverUrl;
                        return (TSettings)settings;
                    }
                    case RedirectUrl: {
                        if ((Integer)currentHop.getParam() < 10) {
                            currentHop.setParam((Object)((Integer)currentHop.getParam() + 1));
                            this.traceMessage(TraceFlags.AutodiscoverResponse, String.format("Autodiscover service returned redirection URL '%s'.", settings.getRedirectTarget()));
                            urls.add(currentUrlIndex, new URI(settings.getRedirectTarget()));
                            break;
                        }
                        throw new AutodiscoverLocalException(Strings.MaximumRedirectionHopsExceeded);
                    }
                    case RedirectAddress: {
                        if ((Integer)currentHop.getParam() < 10) {
                            currentHop.setParam((Object)((Integer)currentHop.getParam() + 1));
                            this.traceMessage(TraceFlags.AutodiscoverResponse, String.format("Autodiscover service returned redirection email address '%s'.", settings.getRedirectTarget()));
                            this.disableScpLookupIfDuplicateRedirection(settings.getRedirectTarget(), redirectionEmailAddresses);
                            return this.internalGetLegacyUserSettings(cls, settings.getRedirectTarget(), redirectionEmailAddresses, currentHop);
                        }
                        throw new AutodiscoverLocalException(Strings.MaximumRedirectionHopsExceeded);
                    }
                    case Error: {
                        if (isScpUrl) {
                            this.traceMessage(TraceFlags.AutodiscoverConfiguration, "Error returned by Autodiscover service found via SCP, treating as inconclusive.");
                            delayedException = new AutodiscoverRemoteException(Strings.AutodiscoverError, settings.getError());
                            ++currentUrlIndex;
                            break;
                        }
                        throw new AutodiscoverRemoteException(Strings.AutodiscoverError, settings.getError());
                    }
                    default: {
                        EwsUtilities.EwsAssert(false, "Autodiscover.GetConfigurationSettings", "An unexpected error has occured. This code path should never be reached.");
                        break;
                    }
                }
            }
            catch (XMLStreamException ex) {
                this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("%s failed: XML parsing error: %s", this.url, ex.getMessage()));
                ++currentUrlIndex;
            }
            catch (IOException ex) {
                this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("%s failed: I/O error: %s", this.url, ex.getMessage()));
                ++currentUrlIndex;
            }
            catch (Exception ex) {
                HttpWebRequest response = null;
                OutParam<URI> outParam1 = new OutParam<URI>();
                if (response != null && this.tryGetRedirectionResponse(response, outParam1)) {
                    URI redirectUrl = (URI)outParam1.getParam();
                    this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Host returned a redirection to url %s", redirectUrl.toString()));
                    currentHop.setParam((Object)((Integer)currentHop.getParam() + 1));
                    urls.add(currentUrlIndex, redirectUrl);
                    continue;
                }
                if (response != null) {
                    this.processHttpErrorResponse(response, ex);
                }
                this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("%s failed: %s (%s)", this.url, ex.getClass().getName(), ex.getMessage()));
                ++currentUrlIndex;
            }
        } while (currentUrlIndex < urls.size());
        URI redirectionUrl = this.getRedirectUrl(domainName);
        OutParam outParam = new OutParam();
        if (redirectionUrl != null && this.tryLastChanceHostRedirection(cls, emailAddress, redirectionUrl, outParam)) {
            settings = (ConfigurationSettingsBase)outParam.getParam();
            return (TSettings)settings;
        }
        redirectionUrl = this.getRedirectionUrlFromDnsSrvRecord(domainName);
        if (redirectionUrl != null && this.tryLastChanceHostRedirection(cls, emailAddress, redirectionUrl, outParam)) {
            settings = (ConfigurationSettingsBase)outParam.getParam();
            return (TSettings)settings;
        }
        if (delayedException != null) {
            throw delayedException;
        }
        throw new AutodiscoverLocalException(Strings.AutodiscoverCouldNotBeLocated);
    }

    protected URI getRedirectionUrlFromDnsSrvRecord(String domainName) throws Exception {
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Trying to get Autodiscover host from DNS SRV record for %s.", domainName));
        String hostname = this.dnsClient.findAutodiscoverHostFromSrv(domainName);
        if (hostname != null && !hostname.isEmpty()) {
            this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Autodiscover host %s was returned.", hostname));
            return new URI(String.format(AutodiscoverLegacyHttpsUrl, hostname));
        }
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, "No matching Autodiscover DNS SRV records were found.");
        return null;
    }

    private <TSettings extends ConfigurationSettingsBase> boolean tryLastChanceHostRedirection(Class<TSettings> cls, String emailAddress, URI redirectionUrl, OutParam<TSettings> settings) throws AutodiscoverLocalException, AutodiscoverRemoteException, Exception {
        ArrayList<String> redirectionEmailAddresses = new ArrayList<String>();
        if (this.callRedirectionUrlValidationCallback(redirectionUrl.toString())) {
            for (int currentHop = 0; currentHop < 10; ++currentHop) {
                try {
                    settings.setParam((Object)this.getLegacyUserSettingsAtUrl(cls, emailAddress, redirectionUrl));
                    switch (((ConfigurationSettingsBase)settings.getParam()).getResponseType()) {
                        case Success: {
                            return true;
                        }
                        case Error: {
                            throw new AutodiscoverRemoteException(Strings.AutodiscoverError, ((ConfigurationSettingsBase)settings.getParam()).getError());
                        }
                        case RedirectAddress: {
                            this.disableScpLookupIfDuplicateRedirection(((ConfigurationSettingsBase)settings.getParam()).getRedirectTarget(), redirectionEmailAddresses);
                            OutParam<Integer> outParam = new OutParam<Integer>();
                            outParam.setParam((Object)new Integer(currentHop));
                            settings.setParam((Object)this.internalGetLegacyUserSettings(cls, emailAddress, redirectionEmailAddresses, outParam));
                            currentHop = (Integer)outParam.getParam();
                            return true;
                        }
                        case RedirectUrl: {
                            try {
                                redirectionUrl = new URI(((ConfigurationSettingsBase)settings.getParam()).getRedirectTarget());
                                break;
                            }
                            catch (URISyntaxException ex) {
                                this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Service returned invalid redirection URL %s", ((ConfigurationSettingsBase)settings.getParam()).getRedirectTarget()));
                                return false;
                            }
                        }
                        default: {
                            String failureMessage = String.format("Autodiscover call at %s failed with error %s, target %s", new Object[]{redirectionUrl, ((ConfigurationSettingsBase)settings.getParam()).getResponseType(), ((ConfigurationSettingsBase)settings.getParam()).getRedirectTarget()});
                            this.traceMessage(TraceFlags.AutodiscoverConfiguration, failureMessage);
                            return false;
                        }
                    }
                    continue;
                }
                catch (XMLStreamException ex) {
                    this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("%s failed: XML parsing error: %s", redirectionUrl.toString(), ex.getMessage()));
                    return false;
                }
                catch (IOException ex) {
                    this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("%s failed: I/O error: %s", redirectionUrl, ex.getMessage()));
                    return false;
                }
                catch (Exception ex) {
                    HttpWebRequest response = null;
                    OutParam<URI> outParam = new OutParam<URI>();
                    if (response != null && this.tryGetRedirectionResponse(response, outParam)) {
                        redirectionUrl = (URI)outParam.getParam();
                        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Host returned a redirection to url %s", redirectionUrl));
                        continue;
                    }
                    if (response != null) {
                        this.processHttpErrorResponse(response, ex);
                    }
                    this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("%s failed: %s (%s)", this.url, ex.getClass().getName(), ex.getMessage()));
                    return false;
                }
            }
        }
        return false;
    }

    private void disableScpLookupIfDuplicateRedirection(String emailAddress, List<String> redirectionEmailAddresses) {
        if (redirectionEmailAddresses.contains(emailAddress = emailAddress.toLowerCase())) {
            this.enableScpLookup = false;
        } else {
            redirectionEmailAddresses.add(emailAddress);
        }
    }

    protected GetUserSettingsResponse internalGetLegacyUserSettings(String emailAddress, List<UserSettingName> requestedSettings) throws Exception {
        if (this.getCredentials() != null && this.getCredentials() instanceof WindowsLiveCredentials) {
            throw new AutodiscoverLocalException(Strings.WLIDCredentialsCannotBeUsedWithLegacyAutodiscover);
        }
        OutlookConfigurationSettings settings = this.getLegacyUserSettings(OutlookConfigurationSettings.class, emailAddress);
        return settings.convertSettings(emailAddress, requestedSettings);
    }

    protected GetUserSettingsResponse internalGetSoapUserSettings(String smtpAddress, List<UserSettingName> requestedSettings) throws Exception {
        ArrayList<String> smtpAddresses = new ArrayList<String>();
        smtpAddresses.add(smtpAddress);
        ArrayList<String> redirectionEmailAddresses = new ArrayList<String>();
        redirectionEmailAddresses.add(smtpAddress.toLowerCase());
        block4: for (int currentHop = 0; currentHop < 10; ++currentHop) {
            GetUserSettingsResponse response = (GetUserSettingsResponse)this.getUserSettings(smtpAddresses, requestedSettings).getTResponseAtIndex(0);
            switch (response.getErrorCode()) {
                case RedirectAddress: {
                    this.traceMessage(TraceFlags.AutodiscoverResponse, String.format("Autodiscover service returned redirection email address '%s'.", response.getRedirectTarget()));
                    smtpAddresses.clear();
                    smtpAddresses.add(response.getRedirectTarget().toLowerCase());
                    this.url = null;
                    this.domain = null;
                    this.disableScpLookupIfDuplicateRedirection(response.getRedirectTarget(), redirectionEmailAddresses);
                    continue block4;
                }
                case RedirectUrl: {
                    this.traceMessage(TraceFlags.AutodiscoverResponse, String.format("Autodiscover service returned redirection URL '%s'.", response.getRedirectTarget()));
                    this.url = new URI(response.getRedirectTarget());
                    continue block4;
                }
                default: {
                    return response;
                }
            }
        }
        throw new AutodiscoverLocalException(Strings.AutodiscoverCouldNotBeLocated);
    }

    protected GetUserSettingsResponseCollection getUserSettings(final List<String> smtpAddresses, List<UserSettingName> settings) throws Exception {
        EwsUtilities.validateParam(smtpAddresses, "smtpAddresses");
        EwsUtilities.validateParam(settings, "settings");
        return this.getSettings(GetUserSettingsResponseCollection.class, UserSettingName.class, smtpAddresses, settings, null, this, new IFuncDelegate<String>(){

            @Override
            public String func() throws FormatException {
                return EwsUtilities.domainFromEmailAddress((String)smtpAddresses.get(0));
            }
        });
    }

    private <TGetSettingsResponseCollection, TSettingName> TGetSettingsResponseCollection getSettings(Class<TGetSettingsResponseCollection> cls, Class<TSettingName> cls1, List<String> identities, List<TSettingName> settings, ExchangeVersion requestedVersion, IFunctionDelegate<List<String>, List<TSettingName>, ExchangeVersion, URI, TGetSettingsResponseCollection> getSettingsMethod, IFuncDelegate<String> getDomainMethod) throws Exception {
        if (this.getRequestedServerVersion().compareTo(MinimumRequestVersionForAutoDiscoverSoapService) < 0) {
            throw new ServiceVersionException(String.format(Strings.AutodiscoverServiceIncompatibleWithRequestVersion, new Object[]{MinimumRequestVersionForAutoDiscoverSoapService}));
        }
        if (this.url != null) {
            return getSettingsMethod.func(identities, settings, requestedVersion, this.url);
        }
        if (this.domain != null && !this.domain.isEmpty()) {
            URI autodiscoverUrl = this.getAutodiscoverEndpointUrl(this.domain);
            TGetSettingsResponseCollection response = getSettingsMethod.func(identities, settings, requestedVersion, autodiscoverUrl);
            this.url = autodiscoverUrl;
            return response;
        }
        this.isExternal = true;
        String domainName = getDomainMethod.func();
        OutParam<Integer> outParam = new OutParam<Integer>();
        List<String> hosts = this.getAutodiscoverServiceHosts(domainName, outParam);
        int scpHostCount = (Integer)outParam.getParam();
        if (hosts.size() == 0) {
            throw new ServiceValidationException(Strings.AutodiscoverServiceRequestRequiresDomainOrUrl);
        }
        for (int currentHostIndex = 0; currentHostIndex < hosts.size(); ++currentHostIndex) {
            String host = hosts.get(currentHostIndex);
            boolean isScpHost = currentHostIndex < scpHostCount;
            OutParam<URI> outParams = new OutParam<URI>();
            if (!this.tryGetAutodiscoverEndpointUrl(host, outParams)) continue;
            URI autodiscoverUrl = (URI)outParams.getParam();
            TGetSettingsResponseCollection response = getSettingsMethod.func(identities, settings, requestedVersion, autodiscoverUrl);
            this.url = autodiscoverUrl;
            if (isScpHost) {
                this.isExternal = false;
            }
            return response;
        }
        URI autodiscoverUrl = this.getRedirectUrl(domainName);
        OutParam<URI> outParamUrl = new OutParam<URI>();
        if (autodiscoverUrl != null && this.callRedirectionUrlValidationCallback(autodiscoverUrl.toString()) && this.tryGetAutodiscoverEndpointUrl(autodiscoverUrl.getHost(), outParamUrl)) {
            autodiscoverUrl = (URI)outParamUrl.getParam();
            TGetSettingsResponseCollection response = getSettingsMethod.func(identities, settings, requestedVersion, autodiscoverUrl);
            this.url = autodiscoverUrl;
            return response;
        }
        autodiscoverUrl = this.getRedirectionUrlFromDnsSrvRecord(domainName);
        if (autodiscoverUrl != null && this.callRedirectionUrlValidationCallback(autodiscoverUrl.toString()) && this.tryGetAutodiscoverEndpointUrl(autodiscoverUrl.getHost(), outParamUrl)) {
            autodiscoverUrl = (URI)outParamUrl.getParam();
            TGetSettingsResponseCollection response = getSettingsMethod.func(identities, settings, requestedVersion, autodiscoverUrl);
            this.url = autodiscoverUrl;
            return response;
        }
        throw new AutodiscoverLocalException(Strings.AutodiscoverCouldNotBeLocated);
    }

    private GetUserSettingsResponseCollection internalGetUserSettings(List<String> smtpAddresses, List<UserSettingName> settings, ExchangeVersion requestedVersion, URI autodiscoverUrl) throws ServiceLocalException, Exception {
        for (int currentHop = 0; currentHop < 10; ++currentHop) {
            GetUserSettingsRequest request = new GetUserSettingsRequest(this, autodiscoverUrl);
            request.setSmtpAddresses(smtpAddresses);
            request.setSettings(settings);
            GetUserSettingsResponseCollection response = request.execute();
            if (response.getErrorCode() != AutodiscoverErrorCode.RedirectUrl || response.getRedirectionUrl() == null) {
                return response;
            }
            this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Request to %s returned redirection to %s", autodiscoverUrl.toString(), response.getRedirectionUrl()));
            autodiscoverUrl = response.getRedirectionUrl();
        }
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Maximum number of redirection hops %d exceeded", 10));
        throw new AutodiscoverLocalException(Strings.MaximumRedirectionHopsExceeded);
    }

    protected GetDomainSettingsResponseCollection getDomainSettings(final List<String> domains, List<DomainSettingName> settings, ExchangeVersion requestedVersion) throws Exception {
        EwsUtilities.validateParam(domains, "domains");
        EwsUtilities.validateParam(settings, "settings");
        return this.getSettings(GetDomainSettingsResponseCollection.class, DomainSettingName.class, domains, settings, requestedVersion, this, new IFuncDelegate<String>(){

            @Override
            public String func() {
                return (String)domains.get(0);
            }
        });
    }

    private GetDomainSettingsResponseCollection internalGetDomainSettings(List<String> domains, List<DomainSettingName> settings, ExchangeVersion requestedVersion, URI autodiscoverUrl) throws ServiceLocalException, Exception {
        for (int currentHop = 0; currentHop < 10; ++currentHop) {
            GetDomainSettingsRequest request = new GetDomainSettingsRequest(this, autodiscoverUrl);
            request.setDomains(domains);
            request.setSettings(settings);
            request.setRequestedVersion(requestedVersion);
            GetDomainSettingsResponseCollection response = request.execute();
            if (response.getErrorCode() != AutodiscoverErrorCode.RedirectUrl || response.getRedirectionUrl() == null) {
                return response;
            }
            autodiscoverUrl = response.getRedirectionUrl();
        }
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Maximum number of redirection hops %d exceeded", 10));
        throw new AutodiscoverLocalException(Strings.MaximumRedirectionHopsExceeded);
    }

    private URI getAutodiscoverEndpointUrl(String host) throws Exception {
        URI autodiscoverUrl = null;
        OutParam<URI> outParam = new OutParam<URI>();
        if (this.tryGetAutodiscoverEndpointUrl(host, outParam)) {
            return autodiscoverUrl;
        }
        throw new AutodiscoverLocalException(Strings.NoSoapOrWsSecurityEndpointAvailable);
    }

    private boolean tryGetAutodiscoverEndpointUrl(String host, OutParam<URI> url) throws Exception {
        OutParam<EnumSet<AutodiscoverEndpoints>> outParam = new OutParam<EnumSet<AutodiscoverEndpoints>>();
        if (this.tryGetEnabledEndpointsForHost(host, outParam)) {
            EnumSet endpoints = (EnumSet)outParam.getParam();
            url.setParam((Object)new URI(String.format(AutodiscoverSoapHttpsUrl, host)));
            if (!endpoints.contains((Object)AutodiscoverEndpoints.Soap) && !endpoints.contains((Object)AutodiscoverEndpoints.WsSecurity)) {
                this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("No Autodiscover endpoints are available  for host %s", host));
                return false;
            }
            return true;
        }
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("No Autodiscover endpoints are available for host %s", host));
        return false;
    }

    protected List<URI> getAutodiscoverServiceUrls(String domainName, OutParam<Integer> scpHostCount) throws URISyntaxException {
        ArrayList<URI> urls = new ArrayList<URI>();
        scpHostCount.setParam((Object)new Integer(urls.size()));
        urls.add(new URI(String.format(AutodiscoverLegacyHttpsUrl, domainName)));
        urls.add(new URI(String.format(AutodiscoverLegacyHttpsUrl, "autodiscover." + domainName)));
        return urls;
    }

    protected List<String> getAutodiscoverServiceHosts(String domainName, OutParam<Integer> outParam) throws URISyntaxException, ClassNotFoundException {
        List<URI> urls = this.getAutodiscoverServiceUrls(domainName, outParam);
        ArrayList<String> lst = new ArrayList<String>();
        for (URI url : urls) {
            lst.add(url.getHost());
        }
        return lst;
    }

    private boolean tryGetEnabledEndpointsForHost(String host, OutParam<EnumSet<AutodiscoverEndpoints>> endpoints) throws Exception {
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Determining which endpoints are enabled for host %s", host));
        for (int currentHop = 0; currentHop < 10; ++currentHop) {
            OutParam<URI> outParam;
            URI autoDiscoverUrl = new URI(String.format(AutodiscoverLegacyHttpsUrl, host));
            endpoints.setParam((Object)EnumSet.of(AutodiscoverEndpoints.None));
            HttpClientWebRequest request = new HttpClientWebRequest(this.getSimpleHttpConnectionManager());
            try {
                request.setUrl(autoDiscoverUrl.toURL());
            }
            catch (MalformedURLException e) {
                String strErr = String.format("Incorrect format : %s", this.url);
                throw new ServiceLocalException(strErr);
            }
            request.setRequestMethod("GET");
            request.setAllowAutoRedirect(false);
            request.setPreAuthenticate(false);
            request.setUseDefaultCredentials(this.getUseDefaultCredentials());
            if (!this.getUseDefaultCredentials()) {
                ExchangeCredentials serviceCredentials = this.getCredentials();
                if (null == serviceCredentials) {
                    throw new ServiceLocalException(Strings.CredentialsRequired);
                }
                serviceCredentials.preAuthenticate();
                serviceCredentials.prepareWebRequest(request);
            }
            try {
                ((HttpWebRequest)request).prepareAsyncConnection();
            }
            catch (Exception ex) {
                ex.getMessage();
                request = null;
            }
            if (request != null) {
                outParam = new OutParam<URI>();
                if (!this.tryGetRedirectionResponse(request, outParam)) {
                    endpoints.setParam((Object)this.getEndpointsFromHttpWebResponse(request));
                    this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Host returned enabled endpoint flags: %s", ((EnumSet)endpoints.getParam()).toString()));
                    return true;
                }
            } else {
                return false;
            }
            URI redirectUrl = (URI)outParam.getParam();
            this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Host returned redirection to host '%s'", redirectUrl.getHost()));
            host = redirectUrl.getHost();
            try {
                ((HttpWebRequest)request).close();
                continue;
            }
            catch (Exception e2) {
                request = null;
            }
        }
        this.traceMessage(TraceFlags.AutodiscoverConfiguration, String.format("Maximum number of redirection hops %d exceeded", 10));
        throw new AutodiscoverLocalException(Strings.MaximumRedirectionHopsExceeded);
    }

    private EnumSet<AutodiscoverEndpoints> getEndpointsFromHttpWebResponse(HttpWebRequest request) throws EWSHttpException {
        EnumSet<AutodiscoverEndpoints> endpoints = EnumSet.noneOf(AutodiscoverEndpoints.class);
        endpoints.add(AutodiscoverEndpoints.Legacy);
        if (request.getResponseHeaders().get(AutodiscoverSoapEnabledHeaderName) != null && !request.getResponseHeaders().get(AutodiscoverSoapEnabledHeaderName).isEmpty()) {
            endpoints.add(AutodiscoverEndpoints.Soap);
        }
        if (request.getResponseHeaders().get(AutodiscoverWsSecurityEnabledHeaderName) != null && !request.getResponseHeaders().get(AutodiscoverWsSecurityEnabledHeaderName).isEmpty()) {
            endpoints.add(AutodiscoverEndpoints.WsSecurity);
        }
        return endpoints;
    }

    protected void traceResponse(HttpWebRequest request, ByteArrayOutputStream memoryStream) throws XMLStreamException, IOException, EWSHttpException {
        this.traceHttpResponseHeaders(TraceFlags.AutodiscoverResponseHttpHeaders, request);
        String contentType = request.getResponseContentType();
        if (contentType != null && !contentType.isEmpty()) {
            if ((contentType = contentType.toLowerCase()).toLowerCase().startsWith("text/") || contentType.toLowerCase().startsWith("application/soap")) {
                this.traceXml(TraceFlags.AutodiscoverResponse, memoryStream);
            } else {
                this.traceMessage(TraceFlags.AutodiscoverResponse, "Non-textual response");
            }
        }
    }

    protected HttpWebRequest prepareHttpWebRequestForUrl(URI url) throws ServiceLocalException, URISyntaxException {
        return this.prepareHttpWebRequestForUrl(url, false, false);
    }

    private boolean callRedirectionUrlValidationCallback(String redirectionUrl) throws AutodiscoverLocalException {
        IAutodiscoverRedirectionUrl callback = this.redirectionUrlValidationCallback == null ? this : this.redirectionUrlValidationCallback;
        return callback.autodiscoverRedirectionUrlValidationCallback(redirectionUrl);
    }

    @Override
    protected void processHttpErrorResponse(HttpWebRequest httpWebResponse, Exception webException) throws Exception {
        this.internalProcessHttpErrorResponse(httpWebResponse, webException, TraceFlags.AutodiscoverResponseHttpHeaders, TraceFlags.AutodiscoverResponse);
    }

    @Override
    public boolean autodiscoverRedirectionUrlValidationCallback(String redirectionUrl) throws AutodiscoverLocalException {
        return this.defaultAutodiscoverRedirectionUrlValidationCallback(redirectionUrl);
    }

    public AutodiscoverService() throws ArgumentException {
        this(ExchangeVersion.Exchange2010);
    }

    public AutodiscoverService(ExchangeVersion requestedServerVersion) throws ArgumentException {
        this(null, null, requestedServerVersion);
    }

    public AutodiscoverService(String domain) throws ArgumentException {
        this(null, domain);
    }

    public AutodiscoverService(String domain, ExchangeVersion requestedServerVersion) throws ArgumentException {
        this(null, domain, requestedServerVersion);
    }

    public AutodiscoverService(URI url) throws ArgumentException {
        this(url, url.getHost());
    }

    public AutodiscoverService(URI url, ExchangeVersion requestedServerVersion) throws ArgumentException {
        this(url, url.getHost(), requestedServerVersion);
    }

    protected AutodiscoverService(URI url, String domain) throws ArgumentException {
        EwsUtilities.validateDomainNameAllowNull(domain, "domain");
        this.url = url;
        this.domain = domain;
        this.dnsClient = new AutodiscoverDnsClient(this);
    }

    protected AutodiscoverService(URI url, String domain, ExchangeVersion requestedServerVersion) throws ArgumentException {
        super(requestedServerVersion);
        EwsUtilities.validateDomainNameAllowNull(domain, "domain");
        this.url = url;
        this.domain = domain;
        this.dnsClient = new AutodiscoverDnsClient(this);
    }

    protected AutodiscoverService(ExchangeServiceBase service, ExchangeVersion requestedServerVersion) {
        super(service, requestedServerVersion);
        this.dnsClient = new AutodiscoverDnsClient(this);
    }

    protected AutodiscoverService(ExchangeServiceBase service) {
        super(service, service.getRequestedServerVersion());
    }

    public GetUserSettingsResponse getUserSettings(String userSmtpAddress, UserSettingName ... userSettingNames) throws Exception {
        ArrayList<UserSettingName> requestedSettings = new ArrayList<UserSettingName>();
        for (UserSettingName userSettingName : userSettingNames) {
            requestedSettings.add(userSettingName);
        }
        if (userSmtpAddress == null || userSmtpAddress.isEmpty()) {
            throw new ServiceValidationException(Strings.InvalidAutodiscoverSmtpAddress);
        }
        if (requestedSettings.size() == 0) {
            throw new ServiceValidationException(Strings.InvalidAutodiscoverSettingsCount);
        }
        if (this.getRequestedServerVersion().compareTo(MinimumRequestVersionForAutoDiscoverSoapService) < 0) {
            return this.internalGetLegacyUserSettings(userSmtpAddress, requestedSettings);
        }
        return this.internalGetSoapUserSettings(userSmtpAddress, requestedSettings);
    }

    public GetUserSettingsResponseCollection getUsersSettings(Iterable<String> userSmtpAddresses, UserSettingName ... userSettingNames) throws Exception {
        if (this.getRequestedServerVersion().compareTo(MinimumRequestVersionForAutoDiscoverSoapService) < 0) {
            throw new ServiceVersionException(String.format(Strings.AutodiscoverServiceIncompatibleWithRequestVersion, new Object[]{MinimumRequestVersionForAutoDiscoverSoapService}));
        }
        ArrayList<String> smtpAddresses = new ArrayList<String>();
        smtpAddresses.addAll((Collection)userSmtpAddresses);
        ArrayList<UserSettingName> settings = new ArrayList<UserSettingName>();
        for (UserSettingName userSettingName : userSettingNames) {
            settings.add(userSettingName);
        }
        return this.getUserSettings(smtpAddresses, settings);
    }

    public GetDomainSettingsResponse getDomainSettings(String domain, ExchangeVersion requestedVersion, DomainSettingName ... domainSettingNames) throws Exception {
        ArrayList<String> domains = new ArrayList<String>(1);
        domains.add(domain);
        ArrayList<DomainSettingName> settings = new ArrayList<DomainSettingName>();
        for (DomainSettingName domainSettingName : domainSettingNames) {
            settings.add(domainSettingName);
        }
        return (GetDomainSettingsResponse)this.getDomainSettings(domains, settings, requestedVersion).getTResponseAtIndex(0);
    }

    public GetDomainSettingsResponseCollection getDomainSettings(Iterable<String> domains, ExchangeVersion requestedVersion, DomainSettingName ... domainSettingNames) throws Exception {
        ArrayList<DomainSettingName> settings = new ArrayList<DomainSettingName>();
        for (DomainSettingName domainSettingName : domainSettingNames) {
            settings.add(domainSettingName);
        }
        ArrayList<String> domainslst = new ArrayList<String>();
        domainslst.addAll((Collection)domains);
        return this.getDomainSettings(domainslst, settings, requestedVersion);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String value) throws ArgumentException {
        EwsUtilities.validateDomainNameAllowNull(value, "Domain");
        if (value != null) {
            this.url = null;
        }
        this.domain = value;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI value) {
        if (value != null) {
            this.domain = value.getHost();
        }
        this.url = value;
    }

    public Boolean isExternal() {
        return this.isExternal;
    }

    protected void setIsExternal(Boolean value) {
        this.isExternal = value;
    }

    public IAutodiscoverRedirectionUrl getRedirectionUrlValidationCallback() {
        return this.redirectionUrlValidationCallback;
    }

    public void setRedirectionUrlValidationCallback(IAutodiscoverRedirectionUrl value) {
        this.redirectionUrlValidationCallback = value;
    }

    protected String getDnsServerAddress() {
        return this.dnsServerAddress;
    }

    protected void setDnsServerAddress(String value) {
        this.dnsServerAddress = value;
    }

    public boolean getEnableScpLookup() {
        return this.enableScpLookup;
    }

    public void setEnableScpLookup(boolean value) {
        this.enableScpLookup = value;
    }

    public Object func(List arg1, List arg2, ExchangeVersion arg3, URI arg4) throws ServiceLocalException, Exception {
        if (arg2.get(0).getClass().equals(DomainSettingName.class)) {
            return this.internalGetDomainSettings(arg1, arg2, arg3, arg4);
        }
        if (arg2.get(0).getClass().equals(UserSettingName.class)) {
            return this.internalGetUserSettings(arg1, arg2, arg3, arg4);
        }
        return null;
    }
}

