/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;
import microsoft.exchange.webservices.data.DnsException;
import microsoft.exchange.webservices.data.DnsRecord;

class DnsClient {
    DnsClient() {
    }

    protected static <T extends DnsRecord> List<T> dnsQuery(Class<T> cls, String domain, String dnsServerAddress) throws DnsException {
        ArrayList<DnsRecord> dnsRecordList = new ArrayList<DnsRecord>();
        try {
            NamingEnumeration<? extends Attribute> attributes;
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            env.put("java.naming.provider.url", "dns://" + dnsServerAddress);
            InitialDirContext ictx = new InitialDirContext(env);
            Attributes contextAttributes = ictx.getAttributes(domain, new String[]{"SRV"});
            if (contextAttributes != null && (attributes = contextAttributes.getAll()) != null) {
                while (attributes.hasMore()) {
                    Attribute attr = attributes.next();
                    NamingEnumeration<?> srvValues = attr.getAll();
                    if (srvValues == null) continue;
                    while (srvValues.hasMore()) {
                        DnsRecord dnsRecord = (DnsRecord)cls.newInstance();
                        dnsRecord.load((String)srvValues.next());
                        dnsRecordList.add(dnsRecord);
                    }
                }
            }
        }
        catch (NamingException ne) {
            throw new DnsException(ne.getMessage());
        }
        catch (Exception e) {
            throw new DnsException(e.getMessage());
        }
        return dnsRecordList;
    }
}

