/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.DeleteRequest;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderIdWrapperList;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

final class EmptyFolderRequest
extends DeleteRequest<ServiceResponse> {
    private FolderIdWrapperList folderIds = new FolderIdWrapperList();
    private boolean deleteSubFolders;

    protected EmptyFolderRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParam(this.getFolderIds(), "FolderIds");
        this.getFolderIds().validate(this.getService().getRequestedServerVersion());
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getFolderIds().getCount();
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected String getXmlElementName() {
        return "EmptyFolder";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "EmptyFolderResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "EmptyFolderResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getFolderIds().writeToXml(writer, XmlNamespace.Messages, "FolderIds");
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        writer.writeAttributeValue("DeleteSubFolders", this.deleteSubFolders);
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    protected FolderIdWrapperList getFolderIds() {
        return this.folderIds;
    }

    protected boolean getDeleteSubFolders() {
        return this.deleteSubFolders;
    }

    protected void setDeleteSubFolders(boolean value) {
        this.deleteSubFolders = value;
    }
}

