/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.IGetObjectInstanceDelegate;
import microsoft.exchange.webservices.data.PropertySet;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.XmlNamespace;

class EwsServiceXmlReader
extends EwsXmlReader {
    private ExchangeService service;

    protected EwsServiceXmlReader(InputStream stream, ExchangeService service) throws Exception {
        super(stream);
        this.service = service;
    }

    private Date convertStringToDateTime(String dateTimeString) {
        return this.service.convertUniversalDateTimeStringToDate(dateTimeString);
    }

    private Date convertStringToUnspecifiedDate(String dateTimeString) throws ParseException {
        return this.getService().convertStartDateToUnspecifiedDateTime(dateTimeString);
    }

    public Date readElementValueAsDateTime() throws Exception {
        return this.convertStringToDateTime(this.readElementValue());
    }

    public Date readElementValueAsUnspecifiedDate() throws Exception {
        return this.convertStringToUnspecifiedDate(this.readElementValue());
    }

    public Date readElementValueAsUnbiasedDateTimeScopedToServiceTimeZone() throws Exception {
        String date = this.readElementValue();
        Date tempDate = null;
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            tempDate = formatter.parse(date);
        }
        catch (Exception e) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
            tempDate = formatter.parse(date);
        }
        return tempDate;
    }

    public Date readElementValueAsDateTime(XmlNamespace xmlNamespace, String localName) throws Exception {
        return this.convertStringToDateTime(this.readElementValue(xmlNamespace, localName));
    }

    public <TServiceObject extends ServiceObject> List<TServiceObject> readServiceObjectsCollectionFromXml(String collectionXmlElementName, IGetObjectInstanceDelegate<ServiceObject> getObjectInstanceDelegate, boolean clearPropertyBag, PropertySet requestedPropertySet, boolean summaryPropertiesOnly) throws Exception {
        ArrayList<ServiceObject> serviceObjects = new ArrayList<ServiceObject>();
        ServiceObject serviceObject = null;
        this.readStartElement(XmlNamespace.Messages, collectionXmlElementName);
        if (!this.isEmptyElement()) {
            do {
                this.read();
                if (!this.isStartElement()) continue;
                serviceObject = getObjectInstanceDelegate.getObjectInstanceDelegate(this.getService(), this.getLocalName());
                if (serviceObject == null) {
                    this.skipCurrentElement();
                    continue;
                }
                if (!this.getLocalName().equals(serviceObject.getXmlElementName())) {
                    throw new ServiceLocalException(String.format("The type of the object in the store (%s) does not match that of the local object (%s).", this.getLocalName(), serviceObject.getXmlElementName()));
                }
                serviceObject.loadFromXml(this, clearPropertyBag, requestedPropertySet, summaryPropertiesOnly);
                serviceObjects.add(serviceObject);
            } while (!this.isEndElement(XmlNamespace.Messages, collectionXmlElementName));
        } else {
            this.read();
        }
        return serviceObjects;
    }

    public ExchangeService getService() {
        return this.service;
    }

    public void setService(ExchangeService service) {
        this.service = service;
    }
}

