/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EmailAddress;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ExpandGroupResponse;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.XmlNamespace;

public class ExpandGroupRequest
extends MultiResponseServiceRequest<ExpandGroupResponse> {
    private EmailAddress emailAddress;

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getEmailAddress(), "EmailAddress");
    }

    @Override
    protected ExpandGroupResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ExpandGroupResponse();
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "ExpandDL";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "ExpandDLResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "ExpandDLResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.getEmailAddress() != null) {
            this.getEmailAddress().writeToXml(writer, XmlNamespace.Messages, "Mailbox");
        }
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    protected ExpandGroupRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(EmailAddress emailAddress) {
        this.emailAddress = emailAddress;
    }
}

