/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ServiceObjectPropertyException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class ItemCollection<TItem extends Item>
extends ComplexProperty
implements Iterable<TItem> {
    private List<TItem> items = new ArrayList<TItem>();

    protected ItemCollection() {
    }

    @Override
    protected void loadFromXml(EwsServiceXmlReader reader, String localElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, localElementName);
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().getNodeType() != 1) continue;
                Item item = (Item)EwsUtilities.createEwsObjectFromXmlElementName(Item.class, reader.getService(), reader.getLocalName());
                if (item == null) {
                    reader.skipCurrentElement();
                    continue;
                }
                try {
                    item.loadFromXml(reader, true);
                }
                catch (ServiceObjectPropertyException e) {
                    e.printStackTrace();
                }
                catch (ServiceVersionException e) {
                    e.printStackTrace();
                }
                this.items.add(item);
            } while (!reader.isEndElement(XmlNamespace.Types, localElementName));
        } else {
            reader.read();
        }
    }

    public int getCount() {
        return this.items.size();
    }

    public TItem getItem(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new ArrayIndexOutOfBoundsException(Strings.IndexIsOutOfRange);
        }
        return (TItem)((Item)this.items.get(index));
    }

    public Iterator<TItem> getIterator() {
        return this.items.iterator();
    }

    @Override
    public Iterator<TItem> iterator() {
        return this.items.iterator();
    }
}

