/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.NameResolutionCollection;
import microsoft.exchange.webservices.data.ServiceError;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceResponseException;

final class ResolveNamesResponse
extends ServiceResponse {
    private NameResolutionCollection resolutions;

    protected ResolveNamesResponse(ExchangeService service) {
        EwsUtilities.EwsAssert(service != null, "ResolveNamesResponse.ctor", "service is null");
        this.resolutions = new NameResolutionCollection(service);
    }

    @Override
    protected void readElementsFromXml(EwsServiceXmlReader reader) throws Exception {
        super.readElementsFromXml(reader);
        this.resolutions.loadFromXml(reader);
    }

    @Override
    protected void internalThrowIfNecessary() throws ServiceResponseException {
        if (this.getErrorCode() != ServiceError.ErrorNameResolutionNoResults) {
            super.internalThrowIfNecessary();
        }
    }

    public NameResolutionCollection getResolutions() {
        return this.resolutions;
    }
}

