/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TimeSpan;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.TimeZoneTransition;

class TimeZoneTransitionGroup
extends ComplexProperty {
    private TimeZoneDefinition timeZoneDefinition;
    private String id;
    private List<TimeZoneTransition> transitions = new ArrayList<TimeZoneTransition>();
    private TimeZoneTransition transitionToStandard;
    private TimeZoneTransition transitionToDaylight;
    private static final String PeriodTarget = "Period";
    private static final String GroupTarget = "Group";

    protected void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        this.loadFromXml(reader, "TransitionsGroup");
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        this.writeToXml(writer, "TransitionsGroup");
    }

    @Override
    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.id = reader.readAttributeValue("Id");
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        writer.writeAttributeValue("Id", this.id);
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        reader.ensureCurrentNodeIsStartElement();
        TimeZoneTransition transition = TimeZoneTransition.create(this.timeZoneDefinition, reader.getLocalName());
        transition.loadFromXml(reader);
        EwsUtilities.EwsAssert(transition.getTargetPeriod() != null, "TimeZoneTransitionGroup.TryReadElementFromXml", "The transition's target period is null.");
        this.transitions.add(transition);
        return true;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        for (TimeZoneTransition transition : this.transitions) {
            transition.writeToXml(writer);
        }
    }

    @Override
    public void validate() throws ServiceLocalException {
        if (this.transitions.size() < 1 || this.transitions.size() > 2) {
            throw new ServiceLocalException(Strings.InvalidOrUnsupportedTimeZoneDefinition);
        }
        if (this.transitions.size() == 1 && this.transitions.get(0).getClass() != TimeZoneTransition.class) {
            throw new ServiceLocalException(Strings.InvalidOrUnsupportedTimeZoneDefinition);
        }
        if (this.transitions.size() == 2) {
            for (TimeZoneTransition transition : this.transitions) {
                if (transition.getClass() != TimeZoneTransition.class) continue;
                throw new ServiceLocalException(Strings.InvalidOrUnsupportedTimeZoneDefinition);
            }
        }
        for (TimeZoneTransition transition : this.transitions) {
            if (transition.getTargetPeriod() != null) continue;
            throw new ServiceLocalException(Strings.InvalidOrUnsupportedTimeZoneDefinition);
        }
    }

    protected boolean getSupportsDaylight() {
        return this.transitions.size() == 2;
    }

    private void initializeTransitions() throws ServiceLocalException {
        if (this.transitionToStandard == null) {
            for (TimeZoneTransition transition : this.transitions) {
                if (transition.getTargetPeriod().isStandardPeriod() || this.transitions.size() == 1) {
                    this.transitionToStandard = transition;
                    continue;
                }
                this.transitionToDaylight = transition;
            }
        }
        if (this.transitionToStandard == null) {
            throw new ServiceLocalException(Strings.InvalidOrUnsupportedTimeZoneDefinition);
        }
    }

    private TimeZoneTransition getTransitionToDaylight() throws ServiceLocalException {
        this.initializeTransitions();
        return this.transitionToDaylight;
    }

    private TimeZoneTransition getTransitionToStandard() throws ServiceLocalException {
        this.initializeTransitions();
        return this.transitionToStandard;
    }

    protected CustomTimeZoneCreateParams getCustomTimeZoneCreationParams() {
        CustomTimeZoneCreateParams result = new CustomTimeZoneCreateParams();
        if (this.transitionToDaylight != null) {
            result.setDaylightDisplayName(this.transitionToDaylight.getTargetPeriod().getName());
        }
        result.setStandardDisplayName(this.transitionToStandard.getTargetPeriod().getName());
        return result;
    }

    protected TimeZoneTransitionGroup(TimeZoneDefinition timeZoneDefinition) {
        this.timeZoneDefinition = timeZoneDefinition;
    }

    protected TimeZoneTransitionGroup(TimeZoneDefinition timeZoneDefinition, String id) {
        this(timeZoneDefinition);
        this.id = id;
    }

    protected String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    protected List<TimeZoneTransition> getTransitions() {
        return this.transitions;
    }

    protected static class CustomTimeZoneCreateParams {
        private TimeSpan baseOffsetToUtc;
        private String standardDisplayName;
        private String daylightDisplayName;

        protected CustomTimeZoneCreateParams() {
        }

        protected TimeSpan getBaseOffsetToUtc() {
            return this.baseOffsetToUtc;
        }

        protected void setBaseOffsetToUtc(TimeSpan baseOffsetToUtc) {
            this.baseOffsetToUtc = baseOffsetToUtc;
        }

        protected String getStandardDisplayName() {
            return this.standardDisplayName;
        }

        protected void setStandardDisplayName(String standardDisplayName) {
            this.standardDisplayName = standardDisplayName;
        }

        protected String getDaylightDisplayName() {
            return this.daylightDisplayName;
        }

        protected void setDaylightDisplayName(String daylightDisplayName) {
            this.daylightDisplayName = daylightDisplayName;
        }

        protected boolean getHasDaylightPeriod() {
            return this.daylightDisplayName != null && !this.daylightDisplayName.isEmpty();
        }
    }
}

