/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

class UnsubscribeRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    private String subscriptionId;

    protected UnsubscribeRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "Unsubscribe";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UnsubscribeResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "UnsubscribeResponseMessage";
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateNonBlankStringParam(this.getSubscriptionId(), "SubscriptionId");
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeElementValue(XmlNamespace.Messages, "SubscriptionId", this.getSubscriptionId());
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setSubscriptionId(String subscriptionId) {
        this.subscriptionId = subscriptionId;
    }
}

