/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.EnumSet;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.Base64EncoderStream;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.InvalidOperationException;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.PropertyException;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.UserConfigurationDictionary;
import microsoft.exchange.webservices.data.UserConfigurationProperties;
import microsoft.exchange.webservices.data.WellKnownFolderName;
import microsoft.exchange.webservices.data.XmlNamespace;

public class UserConfiguration {
    private static ExchangeVersion ObjectVersion = ExchangeVersion.Exchange2010;
    private static final EnumSet<UserConfigurationProperties> PropertiesAvailableForNewObject = EnumSet.of(UserConfigurationProperties.BinaryData, UserConfigurationProperties.Dictionary, UserConfigurationProperties.XmlData);
    private final UserConfigurationProperties NoProperties = UserConfigurationProperties.values()[0];
    private ExchangeService service;
    private String name;
    private FolderId parentFolderId = null;
    private ItemId itemId = null;
    private UserConfigurationDictionary dictionary = null;
    private byte[] xmlData = null;
    private byte[] binaryData = null;
    private EnumSet<UserConfigurationProperties> propertiesAvailableForAccess;
    private EnumSet<UserConfigurationProperties> updatedProperties;
    private boolean isNew = false;

    public UserConfiguration(ExchangeService service) throws Exception {
        this(service, PropertiesAvailableForNewObject);
    }

    private static void writeByteArrayToXml(EwsServiceXmlWriter writer, byte[] byteArray, String xmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.EwsAssert(writer != null, "UserConfiguration.WriteByteArrayToXml", "writer is null");
        EwsUtilities.EwsAssert(xmlElementName != null, "UserConfiguration.WriteByteArrayToXml", "xmlElementName is null");
        writer.writeStartElement(XmlNamespace.Types, xmlElementName);
        if (byteArray != null && byteArray.length > 0) {
            writer.writeValue(Base64EncoderStream.encode(byteArray), xmlElementName);
        }
        writer.writeEndElement();
    }

    protected static void writeUserConfigurationNameToXml(EwsServiceXmlWriter writer, XmlNamespace xmlNamespace, String name, FolderId parentFolderId) throws Exception {
        EwsUtilities.EwsAssert(writer != null, "UserConfiguration.WriteUserConfigurationNameToXml", "writer is null");
        EwsUtilities.EwsAssert(name != null, "UserConfiguration.WriteUserConfigurationNameToXml", "name is null");
        EwsUtilities.EwsAssert(parentFolderId != null, "UserConfiguration.WriteUserConfigurationNameToXml", "parentFolderId is null");
        writer.writeStartElement(xmlNamespace, "UserConfigurationName");
        writer.writeAttributeValue("Name", name);
        parentFolderId.writeToXml(writer);
        writer.writeEndElement();
    }

    protected UserConfiguration(ExchangeService service, EnumSet<UserConfigurationProperties> requestedProperties) throws Exception {
        EwsUtilities.validateParam(service, "service");
        if (service.getRequestedServerVersion().ordinal() < ObjectVersion.ordinal()) {
            Object[] objectArray = new Object[2];
            objectArray[0] = this.getClass().getName();
            objectArray[1] = ObjectVersion;
            throw new ServiceVersionException(String.format(Strings.ObjectTypeIncompatibleWithRequestVersion, objectArray));
        }
        this.service = service;
        this.isNew = true;
        this.initializeProperties(requestedProperties);
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String value) {
        this.name = value;
    }

    public FolderId getParentFolderId() {
        return this.parentFolderId;
    }

    protected void setParentFolderId(FolderId value) {
        this.parentFolderId = value;
    }

    public ItemId getItemId() {
        return this.itemId;
    }

    public UserConfigurationDictionary getDictionary() {
        return this.dictionary;
    }

    public byte[] getXmlData() throws PropertyException {
        this.validatePropertyAccess(UserConfigurationProperties.XmlData);
        return this.xmlData;
    }

    public void setXmlData(byte[] value) {
        this.xmlData = value;
        this.markPropertyForUpdate(UserConfigurationProperties.XmlData);
    }

    public byte[] getBinaryData() throws PropertyException {
        this.validatePropertyAccess(UserConfigurationProperties.BinaryData);
        return this.binaryData;
    }

    public void setBinaryData(byte[] value) {
        this.binaryData = value;
        this.markPropertyForUpdate(UserConfigurationProperties.BinaryData);
    }

    public boolean getIsDirty() {
        return !this.updatedProperties.contains((Object)this.NoProperties) || this.dictionary.getIsDirty();
    }

    public static UserConfiguration bind(ExchangeService service, String name, FolderId parentFolderId, UserConfigurationProperties properties) throws IndexOutOfBoundsException, Exception {
        UserConfiguration result = service.getUserConfiguration(name, parentFolderId, properties);
        result.isNew = false;
        return result;
    }

    public static UserConfiguration bind(ExchangeService service, String name, WellKnownFolderName parentFolderName, UserConfigurationProperties properties) throws IndexOutOfBoundsException, Exception {
        return UserConfiguration.bind(service, name, new FolderId(parentFolderName), properties);
    }

    public void save(String name, FolderId parentFolderId) throws Exception {
        EwsUtilities.validateParam(name, "name");
        EwsUtilities.validateParam(parentFolderId, "parentFolderId");
        parentFolderId.validate(this.service.getRequestedServerVersion());
        if (!this.isNew) {
            throw new InvalidOperationException(Strings.CannotSaveNotNewUserConfiguration);
        }
        this.parentFolderId = parentFolderId;
        this.name = name;
        this.service.createUserConfiguration(this);
        this.isNew = false;
        this.resetIsDirty();
    }

    public void save(String name, WellKnownFolderName parentFolderName) throws Exception {
        this.save(name, new FolderId(parentFolderName));
    }

    public void update() throws Exception {
        if (this.isNew) {
            throw new InvalidOperationException(Strings.CannotUpdateNewUserConfiguration);
        }
        if (this.isPropertyUpdated(UserConfigurationProperties.BinaryData) || this.isPropertyUpdated(UserConfigurationProperties.Dictionary) || this.isPropertyUpdated(UserConfigurationProperties.XmlData)) {
            this.service.updateUserConfiguration(this);
        }
        this.resetIsDirty();
    }

    public void delete() throws Exception {
        if (this.isNew) {
            throw new InvalidOperationException(Strings.DeleteInvalidForUnsavedUserConfiguration);
        }
        this.service.deleteUserConfiguration(this.name, this.parentFolderId);
    }

    public void load(UserConfigurationProperties properties) throws Exception {
        this.initializeProperties(EnumSet.of(properties));
        this.service.loadPropertiesForUserConfiguration(this, properties);
    }

    protected void writeToXml(EwsServiceXmlWriter writer, XmlNamespace xmlNamespace, String xmlElementName) throws Exception {
        EwsUtilities.EwsAssert(writer != null, "UserConfiguration.WriteToXml", "writer is null");
        EwsUtilities.EwsAssert(xmlElementName != null, "UserConfiguration.WriteToXml", "xmlElementName is null");
        writer.writeStartElement(xmlNamespace, xmlElementName);
        UserConfiguration.writeUserConfigurationNameToXml(writer, XmlNamespace.Types, this.name, this.parentFolderId);
        if (this.isPropertyUpdated(UserConfigurationProperties.Dictionary)) {
            this.dictionary.writeToXml(writer, "Dictionary");
        }
        if (this.isPropertyUpdated(UserConfigurationProperties.XmlData)) {
            this.writeXmlDataToXml(writer);
        }
        if (this.isPropertyUpdated(UserConfigurationProperties.BinaryData)) {
            this.writeBinaryDataToXml(writer);
        }
        writer.writeEndElement();
    }

    private boolean isPropertyUpdated(UserConfigurationProperties property) {
        boolean isPropertyDirty = false;
        boolean isPropertyEmpty = false;
        switch (property) {
            case Dictionary: {
                isPropertyDirty = this.getDictionary().getIsDirty();
                isPropertyEmpty = this.getDictionary().getCount() == 0;
                break;
            }
            case XmlData: {
                isPropertyDirty = this.updatedProperties.contains((Object)property);
                isPropertyEmpty = this.xmlData == null || this.xmlData.length == 0;
                break;
            }
            case BinaryData: {
                isPropertyDirty = this.updatedProperties.contains((Object)property);
                isPropertyEmpty = this.binaryData == null || this.binaryData.length == 0;
                break;
            }
            default: {
                EwsUtilities.EwsAssert(false, "UserConfiguration.IsPropertyUpdated", "property not supported: " + property.toString());
            }
        }
        return isPropertyDirty && (!isPropertyEmpty || !this.isNew);
    }

    private void writeXmlDataToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.EwsAssert(writer != null, "UserConfiguration.WriteXmlDataToXml", "writer is null");
        UserConfiguration.writeByteArrayToXml(writer, this.xmlData, "XmlData");
    }

    private void writeBinaryDataToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        EwsUtilities.EwsAssert(writer != null, "UserConfiguration.WriteBinaryDataToXml", "writer is null");
        UserConfiguration.writeByteArrayToXml(writer, this.binaryData, "BinaryData");
    }

    protected void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        EwsUtilities.EwsAssert(reader != null, "UserConfiguration.LoadFromXml", "reader is null");
        reader.readStartElement(XmlNamespace.Messages, "UserConfiguration");
        reader.read();
        do {
            if (reader.getNodeType().getNodeType() == 1) {
                if (reader.getLocalName().equals("UserConfigurationName")) {
                    String responseName = reader.readAttributeValue("Name");
                    EwsUtilities.EwsAssert(this.name.equals(responseName), "UserConfiguration.LoadFromXml", "UserConfigurationName does not match: Expected: " + this.name + " Name in response: " + responseName);
                    reader.skipCurrentElement();
                } else if (reader.getLocalName().equals("ItemId")) {
                    this.itemId = new ItemId();
                    this.itemId.loadFromXml(reader, "ItemId");
                } else if (reader.getLocalName().equals("Dictionary")) {
                    this.dictionary.loadFromXml(reader, "Dictionary");
                } else if (reader.getLocalName().equals("XmlData")) {
                    this.xmlData = Base64EncoderStream.decode(reader.readElementValue());
                } else if (reader.getLocalName().equals("BinaryData")) {
                    this.binaryData = Base64EncoderStream.decode(reader.readElementValue());
                } else {
                    EwsUtilities.EwsAssert(false, "UserConfiguration.LoadFromXml", "Xml element not supported: " + reader.getLocalName());
                }
            }
            reader.read();
        } while (!reader.isEndElement(XmlNamespace.Messages, "UserConfiguration"));
    }

    private void initializeProperties(EnumSet<UserConfigurationProperties> requestedProperties) {
        this.itemId = null;
        this.dictionary = new UserConfigurationDictionary();
        this.xmlData = null;
        this.binaryData = null;
        this.propertiesAvailableForAccess = requestedProperties;
        this.resetIsDirty();
    }

    private void resetIsDirty() {
        try {
            this.updatedProperties = EnumSet.of(this.NoProperties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.dictionary.setIsDirty(false);
    }

    private void validatePropertyAccess(UserConfigurationProperties property) throws PropertyException {
        if (this.propertiesAvailableForAccess.contains((Object)property)) {
            throw new PropertyException(Strings.MustLoadOrAssignPropertyBeforeAccess, property.toString());
        }
    }

    private void markPropertyForUpdate(UserConfigurationProperties property) {
        this.updatedProperties.add(property);
        this.propertiesAvailableForAccess.add(property);
    }
}

