/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit;

import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.io.DataSource;
import com.microsoft.gctoolkit.io.GCLogFile;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.jvm.JavaVirtualMachine;
import com.microsoft.gctoolkit.message.DataSourceBus;
import com.microsoft.gctoolkit.message.DataSourceConsumer;
import com.microsoft.gctoolkit.message.JVMEventBus;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GCToolKit {
    private static final Logger LOGGER = Logger.getLogger(GCToolKit.class.getName());
    private final Set<Class<? extends Aggregation>> registeredAggregations = new HashSet<Class<? extends Aggregation>>();

    private JavaVirtualMachine loadJavaVirtualMachine(GCLogFile logFile) {
        return ServiceLoader.load(JavaVirtualMachine.class).stream().map(ServiceLoader.Provider::get).filter(jvm -> jvm.accepts(logFile)).findFirst().orElseThrow(() -> new ServiceConfigurationError("No suitable JavaVirtualMachine implementation found"));
    }

    private DataSourceBus setupDataSourceBus() {
        return ServiceLoader.load(DataSourceBus.class).stream().map(ServiceLoader.Provider::get).findFirst().orElseThrow(() -> new ServiceConfigurationError("No suitable DataSourceBus implementation found"));
    }

    private JVMEventBus setupJVMEventBus() {
        return ServiceLoader.load(JVMEventBus.class).stream().map(ServiceLoader.Provider::get).findFirst().orElseThrow(() -> new ServiceConfigurationError("No suitable JVMEventBus implementation found"));
    }

    private void registerParsers(DataSourceBus bus, Diary diary) {
        ServiceLoader.load(DataSourceConsumer.class).stream().map(ServiceLoader.Provider::get).filter(p -> p.accepts(diary)).forEach(parser -> bus.register((DataSourceConsumer)parser));
    }

    public void loadAggregationsFromServiceLoader() {
        ServiceLoader.load(Aggregation.class).stream().map(ServiceLoader.Provider::get).map(Object::getClass).forEach(this.registeredAggregations::add);
        if (Level.FINER.equals(LOGGER.getLevel())) {
            this.registeredAggregations.forEach(a -> LOGGER.log(Level.FINER, "Registered " + a.toString()));
        }
    }

    public void registerAggregation(Class<? extends Aggregation> aggregationClass) {
        this.registeredAggregations.add(aggregationClass);
    }

    public JavaVirtualMachine analyze(GCLogFile logFile) throws IOException {
        JavaVirtualMachine javaVirtualMachine = this.loadJavaVirtualMachine(logFile);
        try {
            Method analyze = javaVirtualMachine.getClass().getMethod("analyze", Set.class, DataSource.class);
            analyze.invoke((Object)javaVirtualMachine, this.registeredAggregations, logFile);
        }
        catch (ReflectiveOperationException e) {
            LOGGER.log(Level.SEVERE, "Cannot invoke analyze method", e);
        }
        return javaVirtualMachine;
    }
}

