/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.aggregator;

import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.JVMEventDispatcher;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import java.util.function.Consumer;

public abstract class Aggregator<A extends Aggregation> {
    private final A aggregation;
    private final JVMEventDispatcher jvmEventDispatcher = new JVMEventDispatcher();
    private volatile boolean done = false;

    protected Aggregator(A aggregation) {
        this.aggregation = aggregation;
        this.register(JVMTermination.class, this::terminationHandler);
    }

    public A aggregation() {
        return this.aggregation;
    }

    protected <E extends JVMEvent> void register(Class<E> eventClass, Consumer<? super E> process) {
        this.jvmEventDispatcher.register(eventClass, process);
    }

    public <E extends JVMEvent> void consume(E event) {
        this.jvmEventDispatcher.dispatch(event);
    }

    private void terminationHandler(JVMTermination event) {
        this.done = true;
    }

    public boolean isDone() {
        return this.done;
    }
}

