/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.aggregator;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class JVMEventDispatcher {
    private final Map<Class<? extends JVMEvent>, Consumer<JVMEvent>> eventConsumers = new ConcurrentHashMap<Class<? extends JVMEvent>, Consumer<JVMEvent>>();
    private final Consumer<JVMEvent> nopConsumer = evt -> {};

    private <R extends JVMEvent> Consumer<JVMEvent> getConsumerForClass(Class<R> eventClass) {
        Class<R> clazz = eventClass;
        Consumer<JVMEvent> eventConsumer = this.eventConsumers.get(clazz);
        if (eventConsumer != null) {
            return eventConsumer;
        }
        do {
            if ((eventConsumer = this.eventConsumers.get(clazz)) == null) continue;
            if (eventClass != clazz) {
                this.eventConsumers.put(eventClass, eventConsumer);
            }
            return eventConsumer;
        } while (clazz != JVMEvent.class && (clazz = clazz.getSuperclass()) != null);
        this.eventConsumers.put(eventClass, this.nopConsumer);
        return this.nopConsumer;
    }

    public <R extends JVMEvent> void register(Class<R> eventClass, Consumer<? super R> process) {
        this.eventConsumers.put(eventClass, process);
    }

    public <R extends JVMEvent> void dispatch(R event) {
        this.getConsumerForClass(event.getClass()).accept(event);
    }
}

