/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.event;

import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.Objects;

public abstract class GCEvent
extends JVMEvent {
    static final double TIMESTAMP_THRESHOLD = 1.0E-6;
    private final GarbageCollectionTypes gcType;
    private GCCause cause;

    protected GCEvent(DateTimeStamp timeStamp, GarbageCollectionTypes gcType, GCCause cause, double duration) {
        super(timeStamp, duration);
        this.gcType = gcType;
        this.cause = cause;
    }

    protected GCEvent(DateTimeStamp timeStamp, double duration) {
        this(timeStamp, GarbageCollectionTypes.Unknown, GCCause.UNKNOWN_GCCAUSE, duration);
    }

    protected GCEvent(DateTimeStamp timeStamp, GCCause cause, double duration) {
        this(timeStamp, GarbageCollectionTypes.Unknown, cause, duration);
    }

    protected GCEvent(DateTimeStamp timeStamp, GarbageCollectionTypes gcType, double duration) {
        this(timeStamp, gcType, GCCause.UNKNOWN_GCCAUSE, duration);
    }

    public void setGCCause(GCCause cause) {
        this.cause = cause;
    }

    public GCCause getGCCause() {
        return this.cause;
    }

    public GarbageCollectionTypes getGarbageCollectionType() {
        return this.gcType;
    }

    private boolean withinThreshold(double x, double y) {
        return 1.0E-6 > Math.abs(x - y);
    }

    public int hashCode() {
        return Objects.hash(this.gcType.getLabel(), this.getDateTimeStamp().getTimeStamp(), this.getDuration());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCEvent gcEvent = (GCEvent)o;
        return this.gcType.getLabel().equals(gcEvent.gcType.getLabel()) && this.withinThreshold(this.getDateTimeStamp().getTimeStamp(), gcEvent.getDateTimeStamp().getTimeStamp()) && this.withinThreshold(this.getDuration(), gcEvent.getDuration());
    }
}

