/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.io;

import com.microsoft.gctoolkit.io.FileDataSource;
import com.microsoft.gctoolkit.jvm.Diarizer;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.datatype.TripleState;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public abstract class GCLogFile
extends FileDataSource<String> {
    private static final Logger LOGGER = Logger.getLogger(FileDataSource.class.getName());
    public static final String END_OF_DATA_SENTINEL = "END_OF_DATA_SENTINEL";
    private Diary diary;
    private TripleState unifiedFormat = TripleState.UNKNOWN;
    private static final Pattern LINE_STARTS_WITH_DECORATOR = Pattern.compile("^\\[\\d.+?\\]");
    private static final int SHOULD_HAVE_SEEN_A_UNIFIED_DECORATOR_BY_THIS_LINE_IN_THE_LOG = 25;

    protected GCLogFile(Path path) {
        super(path);
    }

    public boolean isUnified() {
        if (!this.unifiedFormat.isKnown()) {
            this.unifiedFormat = this.discoverFormat();
        }
        return this.unifiedFormat.isTrue();
    }

    private Diarizer diarizer() {
        return ServiceLoader.load(Diarizer.class).stream().map(ServiceLoader.Provider::get).filter(p -> p.isUnified() == this.isUnified()).findFirst().orElseThrow(() -> new ServiceConfigurationError("Unable to find a suitable provider to create a diary"));
    }

    @Override
    public Diary diary() throws IOException {
        if (this.diary == null) {
            Diarizer diarizer = this.diarizer();
            this.stream().filter(Objects::nonNull).map(String::trim).filter(s -> s.length() > 0).map(diarizer::diarize).filter(completed -> completed).findFirst();
            this.diary = diarizer.getDiary();
        }
        return this.diary;
    }

    @Override
    public final String endOfData() {
        return END_OF_DATA_SENTINEL;
    }

    private TripleState discoverFormat() {
        try {
            boolean isUnified = this.firstNLines(this.stream(), 25).map(LINE_STARTS_WITH_DECORATOR::matcher).anyMatch(Matcher::find);
            return TripleState.valueOf(isUnified);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Unable to determine log file format", ioe);
            return TripleState.UNKNOWN;
        }
    }

    private Stream<String> firstNLines(Stream<String> stream, int limit) {
        return stream.filter(Objects::nonNull).map(String::trim).filter(s -> s.length() > 0).limit(limit);
    }
}

