/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.io;

import com.microsoft.gctoolkit.io.GCLogFile;
import com.microsoft.gctoolkit.io.GCLogFileSegment;
import com.microsoft.gctoolkit.io.LogFileMetadata;
import com.microsoft.gctoolkit.io.LogFileSegment;
import com.microsoft.gctoolkit.io.RotatingLogFileMetadata;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RotatingGCLogFile
extends GCLogFile {
    private static final Logger LOGGER = Logger.getLogger(RotatingGCLogFile.class.getName());
    private RotatingLogFileMetadata metaData;

    public RotatingGCLogFile(Path path) {
        super(path);
    }

    @Override
    public LogFileMetadata getMetaData() throws IOException {
        if (this.metaData == null) {
            this.metaData = new RotatingLogFileMetadata(this.getPath());
        }
        return this.metaData;
    }

    @Override
    public Stream<String> stream() throws IOException {
        if (this.getMetaData().isDirectory() || this.getMetaData().isPlainText() || this.getMetaData().isZip()) {
            return this.getMetaData().logFiles().flatMap(segment -> segment.stream()).filter(Objects::nonNull).map(String::trim).filter(s -> s.length() > 0);
        }
        return new ArrayList().stream();
    }

    private Stream<String> stream(LogFileMetadata metadata, LinkedList<GCLogFileSegment> segments) throws IOException {
        if (metadata.isPlainText() || metadata.isDirectory()) {
            switch (segments.size()) {
                case 0: {
                    String[] empty = new String[]{};
                    return Arrays.stream(empty);
                }
                case 1: {
                    return segments.getFirst().stream();
                }
            }
            LinkedList<GCLogFileSegment> copySegments = new LinkedList<GCLogFileSegment>(segments);
            Stream<String> allSegments = Stream.concat(copySegments.removeFirst().stream(), copySegments.removeFirst().stream());
            while (!copySegments.isEmpty()) {
                allSegments = Stream.concat(allSegments, copySegments.removeFirst().stream());
            }
            return allSegments;
        }
        if (metadata.isZip()) {
            return this.streamZipFile();
        }
        if (metadata.isGZip()) {
            throw new IOException("Unable to stream GZip files. Please unzip and retry");
        }
        throw new IOException("Unrecognised file type");
    }

    private Stream<String> streamZipFile() throws IOException {
        ZipFile zipFile = new ZipFile(this.path.toFile());
        List entries = zipFile.stream().filter(entry -> !entry.isDirectory()).collect(Collectors.toList());
        Vector streams = new Vector();
        try {
            entries.stream().map(entry -> {
                try {
                    return zipFile.getInputStream((ZipEntry)entry);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }).filter(Objects::nonNull).forEach(streams::add);
        }
        catch (UncheckedIOException uioe) {
            throw uioe.getCause();
        }
        SequenceInputStream sequenceInputStream = new SequenceInputStream(streams.elements());
        return new BufferedReader(new InputStreamReader(sequenceInputStream)).lines();
    }

    public List<LogFileSegment> getOrderedGarbageCollectionLogFiles() throws IOException {
        return this.getMetaData().logFiles().collect(Collectors.toList());
    }
}

