/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.io;

import com.microsoft.gctoolkit.io.GCLogFile;
import com.microsoft.gctoolkit.io.LogFileMetadata;
import com.microsoft.gctoolkit.io.SingleLogFileMetadata;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class SingleGCLogFile
extends GCLogFile {
    private static final Logger LOGGER = Logger.getLogger(SingleGCLogFile.class.getName());
    private SingleLogFileMetadata metadata = null;

    public SingleGCLogFile(Path path) {
        super(path);
    }

    @Override
    public LogFileMetadata getMetaData() throws IOException {
        if (this.metadata == null) {
            this.metadata = new SingleLogFileMetadata(this.path);
        }
        return this.metadata;
    }

    @Override
    public Stream<String> stream() throws IOException {
        return this.stream(this.getMetaData());
    }

    private Stream<String> stream(LogFileMetadata metadata) throws IOException {
        Stream<String> stream = null;
        if (metadata.isPlainText()) {
            stream = Files.lines(metadata.getPath());
        } else if (metadata.isZip()) {
            stream = SingleGCLogFile.streamZipFile(metadata.getPath());
        } else if (metadata.isGZip()) {
            stream = SingleGCLogFile.streamGZipFile(metadata.getPath());
        }
        if (stream == null) {
            throw new IOException("Unable to read " + this.path.toString());
        }
        return stream.filter(Objects::nonNull).map(String::trim).filter(s -> s.length() > 0);
    }

    private static Stream<String> streamZipFile(Path path) throws IOException {
        ZipEntry entry;
        ZipInputStream zipStream = new ZipInputStream(Files.newInputStream(path, new OpenOption[0]));
        while ((entry = zipStream.getNextEntry()) != null && entry.isDirectory()) {
        }
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(zipStream))).lines();
    }

    private static Stream<String> streamGZipFile(Path path) throws IOException {
        GZIPInputStream gzipStream = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));
        return new BufferedReader(new InputStreamReader(new BufferedInputStream(gzipStream))).lines();
    }
}

