/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.jvm;

import com.microsoft.gctoolkit.jvm.SupportedFlags;
import com.microsoft.gctoolkit.parser.datatype.TripleState;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.Arrays;

public class Diary {
    private final TripleState[] states = new TripleState[SupportedFlags.values().length];
    private DateTimeStamp timeOfFirstEvent;

    public Diary() {
        for (int i = 0; i < this.states.length; ++i) {
            this.states[i] = TripleState.UNKNOWN;
        }
    }

    public void setTrue(SupportedFlags flag) {
        if (this.states[flag.ordinal()] == TripleState.UNKNOWN) {
            this.states[flag.ordinal()] = TripleState.TRUE;
        }
    }

    public void setTrue(SupportedFlags ... flags) {
        for (SupportedFlags flag : flags) {
            this.setTrue(flag);
        }
    }

    public void setFalse(SupportedFlags flag) {
        if (this.states[flag.ordinal()] == TripleState.UNKNOWN) {
            this.states[flag.ordinal()] = TripleState.FALSE;
        }
    }

    public void setFalse(SupportedFlags ... flags) {
        for (SupportedFlags flag : flags) {
            this.setFalse(flag);
        }
    }

    public boolean isStateKnown(SupportedFlags flag) {
        return this.states[flag.ordinal()].isKnown();
    }

    public boolean isStateKnown(SupportedFlags ... flags) {
        boolean value = true;
        for (SupportedFlags flag : flags) {
            value &= this.states[flag.ordinal()].isTrue();
        }
        return value;
    }

    public void setState(SupportedFlags flag, boolean flagTurnedOn) {
        if (flagTurnedOn) {
            this.setTrue(flag);
        } else {
            this.setFalse(flag);
        }
    }

    public boolean isTrue(SupportedFlags flag) {
        return this.isStateKnown(flag) && this.states[flag.ordinal()].isTrue();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("LoggingDiary{");
        boolean first = true;
        for (SupportedFlags flag : SupportedFlags.values()) {
            block4: {
                block3: {
                    if (!first) break block3;
                    first = false;
                    if (!false) break block4;
                }
                buffer.append(", ");
            }
            buffer.append(flag.name()).append("=").append((Object)this.states[flag.ordinal()]);
        }
        return buffer.append("}").toString();
    }

    public boolean isComplete() {
        return Arrays.stream(this.states).allMatch(TripleState::isKnown);
    }

    public boolean isCollectorKnown() {
        return this.isGenerationalKnown() || this.isG1GCKnown() || this.isZGCKnown() || this.isShenandoahKnown();
    }

    public boolean isVersionKnown() {
        return this.isUnifiedLogging() || this.isJDK80() || this.isJDK70() && this.isPre70_40Known();
    }

    public boolean isDetailsKnown() {
        return this.isApplicationStoppedTimeKnown() && this.isPrintReferenceGCKnown() && this.isPrintGCDetailsKnown() && this.isAdaptiveSizingKnown() && this.isTLABDataKnown() && this.isPrintPromotionFailureKnown() && this.isPrintFLSStatisticsKnown() && this.isPrintHeapAtGCKnown();
    }

    public boolean isDefNew() {
        return this.isTrue(SupportedFlags.DEFNEW);
    }

    public boolean isSerialFull() {
        return this.isTrue(SupportedFlags.SERIAL);
    }

    public boolean isParNew() {
        return this.isTrue(SupportedFlags.PARNEW);
    }

    public boolean isCMS() {
        return this.isTrue(SupportedFlags.CMS);
    }

    public boolean isICMS() {
        return this.isTrue(SupportedFlags.ICMS);
    }

    public boolean isPSYoung() {
        return this.isTrue(SupportedFlags.PARALLELGC);
    }

    public boolean isPSOldGen() {
        return this.isTrue(SupportedFlags.PARALLELOLDGC);
    }

    public boolean isG1GC() {
        return this.isTrue(SupportedFlags.G1GC);
    }

    public boolean isZGC() {
        return this.isTrue(SupportedFlags.ZGC);
    }

    public boolean isShenandoah() {
        return this.isTrue(SupportedFlags.SHENANDOAH);
    }

    public boolean isGenerational() {
        return this.isCollectorKnown() && !this.isG1GC() && !this.isZGC() && !this.isShenandoah();
    }

    public boolean isPrintGCDetails() {
        return this.isTrue(SupportedFlags.GC_DETAILS);
    }

    public boolean isTenuringDistribution() {
        return this.isTrue(SupportedFlags.TENURING_DISTRIBUTION);
    }

    public boolean isGCCause() {
        return this.isTrue(SupportedFlags.GC_CAUSE);
    }

    public boolean isAdaptiveSizing() {
        return this.isTrue(SupportedFlags.ADAPTIVE_SIZING);
    }

    public boolean isCMSDebugLevel1() {
        return this.isTrue(SupportedFlags.CMS_DEBUG_LEVEL_1);
    }

    public boolean isApplicationStoppedTime() {
        return this.isTrue(SupportedFlags.APPLICATION_STOPPED_TIME);
    }

    public boolean isApplicationRunningTime() {
        return this.isTrue(SupportedFlags.APPLICATION_CONCURRENT_TIME);
    }

    public boolean isTLABData() {
        return this.isTrue(SupportedFlags.TLAB_DATA);
    }

    public boolean isTLABDataKnown() {
        return this.isStateKnown(SupportedFlags.TLAB_DATA);
    }

    public boolean isJDK70() {
        return this.isTrue(SupportedFlags.JDK70);
    }

    public boolean isPre70_40() {
        return this.isTrue(SupportedFlags.PRE_JDK70_40);
    }

    public boolean isPre70_40Known() {
        return this.isStateKnown(SupportedFlags.PRE_JDK70_40);
    }

    public boolean isJDK80() {
        return this.isTrue(SupportedFlags.JDK80);
    }

    public boolean isUnifiedLogging() {
        return this.isTrue(SupportedFlags.UNIFIED_LOGGING);
    }

    public boolean isPrintHeapAtGC() {
        return this.isTrue(SupportedFlags.PRINT_HEAP_AT_GC);
    }

    public boolean isRSetStats() {
        return this.isTrue(SupportedFlags.RSET_STATS);
    }

    public boolean hasPrintReferenceGC() {
        return this.isTrue(SupportedFlags.PRINT_REFERENCE_GC);
    }

    public boolean isMaxTenuringThresholdViolation() {
        return this.isTrue(SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION);
    }

    public boolean isDefNewKnown() {
        return this.isStateKnown(SupportedFlags.DEFNEW);
    }

    public boolean isSerialFullKnown() {
        return this.isStateKnown(SupportedFlags.SERIAL);
    }

    public boolean isParNewKnown() {
        return this.isStateKnown(SupportedFlags.PARNEW);
    }

    public boolean isCMSKnown() {
        return this.isStateKnown(SupportedFlags.CMS);
    }

    public boolean isICMSKnown() {
        return this.isStateKnown(SupportedFlags.ICMS);
    }

    public boolean isPSYoungKnown() {
        return this.isStateKnown(SupportedFlags.PARALLELGC);
    }

    public boolean isPSOldGenKnown() {
        return this.isStateKnown(SupportedFlags.PARALLELOLDGC);
    }

    public boolean isG1GCKnown() {
        return this.isStateKnown(SupportedFlags.G1GC);
    }

    public boolean isZGCKnown() {
        return this.isStateKnown(SupportedFlags.ZGC);
    }

    public boolean isShenandoahKnown() {
        return this.isStateKnown(SupportedFlags.SHENANDOAH);
    }

    public boolean isGenerationalKnown() {
        return this.isStateKnown(SupportedFlags.G1GC);
    }

    public boolean isPrintGCDetailsKnown() {
        return this.isStateKnown(SupportedFlags.GC_DETAILS);
    }

    public boolean isTenuringDistributionKnown() {
        return this.isStateKnown(SupportedFlags.TENURING_DISTRIBUTION);
    }

    public boolean isGCCauseKnown() {
        return this.isStateKnown(SupportedFlags.GC_CAUSE);
    }

    public boolean isAdaptiveSizingKnown() {
        return this.isStateKnown(SupportedFlags.ADAPTIVE_SIZING);
    }

    public boolean isCMSDebugLevel1Known() {
        return this.isStateKnown(SupportedFlags.CMS_DEBUG_LEVEL_1);
    }

    public boolean isApplicationStoppedTimeKnown() {
        return this.isStateKnown(SupportedFlags.APPLICATION_STOPPED_TIME);
    }

    public boolean isApplicationRunningTimeKnown() {
        return this.isStateKnown(SupportedFlags.APPLICATION_CONCURRENT_TIME);
    }

    public boolean isJDK70Known() {
        return this.isStateKnown(SupportedFlags.JDK70);
    }

    public boolean isPre70_45Known() {
        return this.isStateKnown(SupportedFlags.PRE_JDK70_40);
    }

    public boolean isJDK80Known() {
        return this.isStateKnown(SupportedFlags.JDK80);
    }

    public boolean isUnifiedLoggingKnown() {
        return this.isStateKnown(SupportedFlags.UNIFIED_LOGGING);
    }

    public boolean isPrintHeapAtGCKnown() {
        return this.isStateKnown(SupportedFlags.PRINT_HEAP_AT_GC);
    }

    public boolean isRSetStatsKnown() {
        return this.isStateKnown(SupportedFlags.RSET_STATS);
    }

    public boolean isPrintReferenceGCKnown() {
        return this.isStateKnown(SupportedFlags.PRINT_REFERENCE_GC);
    }

    public boolean isPrintPromotionFailure() {
        return this.isTrue(SupportedFlags.PRINT_PROMOTION_FAILURE);
    }

    public boolean isPrintPromotionFailureKnown() {
        return this.isStateKnown(SupportedFlags.PRINT_PROMOTION_FAILURE);
    }

    public boolean isPrintFLSStatistics() {
        return this.isTrue(SupportedFlags.PRINT_FLS_STATISTICS);
    }

    public boolean isPrintFLSStatisticsKnown() {
        return this.isStateKnown(SupportedFlags.PRINT_FLS_STATISTICS);
    }

    public boolean isMaxTenuringThresholdViolationKnown() {
        return this.isStateKnown(SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION);
    }

    public boolean isJVMEventsKnown() {
        return this.isApplicationStoppedTimeKnown() && this.isApplicationRunningTime();
    }

    public void setTimeOfFirstEvent(DateTimeStamp startTime) {
        if (this.timeOfFirstEvent == null) {
            this.timeOfFirstEvent = startTime;
        }
    }

    public DateTimeStamp getTimeOfFirstEvent() {
        return this.timeOfFirstEvent;
    }
}

