/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.time;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeStamp
implements Comparable<DateTimeStamp> {
    private final ZonedDateTime dateTime;
    private final double timeStamp;
    public static final Comparator<DateTimeStamp> comparator = DateTimeStamp.getComparator();
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String DECIMAL_POINT = "(?:\\.|,)";
    private static final String INTEGER = "\\d+";
    private static final String DATE = "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}";
    private static final String TIME = "\\d+(?:\\.|,)\\d{3}";
    private static final String DATE_TAG = "\\[\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}\\]";
    private static final String UPTIME_TAG = "\\[(\\d+(?:\\.|,)\\d{3})s\\]";
    private static final String TIMESTAMP = "(\\d+(?:\\.|,)\\d{3}): ";
    private static final String DATE_STAMP = "(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): ";
    private static final String DATE_TIMESTAMP = "^(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): ";
    private static final Pattern PREUNIFIED_DATE_TIMESTAMP = Pattern.compile("^(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): ");
    private static final Pattern UNIFIED_DATE_TIMESTAMP = Pattern.compile("^(\\[\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}\\])?(\\[(\\d+(?:\\.|,)\\d{3})s\\])?");
    private static final DateTimeStamp EMPTY_DATE = new DateTimeStamp(-1.0);

    private static ZonedDateTime dateFromString(String iso8601DateTime) {
        if (iso8601DateTime != null) {
            TemporalAccessor temporalAccessor = formatter.parse(iso8601DateTime);
            return ZonedDateTime.from(temporalAccessor);
        }
        return null;
    }

    private static double ageFromString(String doubleFormat) {
        if (doubleFormat == null) {
            return -1.0;
        }
        return Double.parseDouble(doubleFormat.replace(",", "."));
    }

    public static DateTimeStamp fromGCLogLine(String line) {
        Matcher matcher;
        int captureGroup = 2;
        if (line.startsWith("[")) {
            matcher = UNIFIED_DATE_TIMESTAMP.matcher(line);
            captureGroup = 3;
        } else {
            matcher = PREUNIFIED_DATE_TIMESTAMP.matcher(line);
        }
        if (matcher.find()) {
            return new DateTimeStamp(DateTimeStamp.dateFromString(matcher.group(1)), DateTimeStamp.ageFromString(matcher.group(captureGroup)));
        }
        return EMPTY_DATE;
    }

    public DateTimeStamp(String iso8601DateTime) {
        this(DateTimeStamp.dateFromString(iso8601DateTime));
    }

    public DateTimeStamp(ZonedDateTime dateTime) {
        this(dateTime, Double.NaN);
    }

    public DateTimeStamp(String iso8601DateTime, double timeStamp) {
        this(DateTimeStamp.dateFromString(iso8601DateTime), timeStamp);
    }

    public DateTimeStamp(double timeStamp) {
        this((ZonedDateTime)null, timeStamp);
    }

    public DateTimeStamp(ZonedDateTime dateTime, double timeStamp) {
        this.dateTime = dateTime;
        this.timeStamp = dateTime != null && (Double.isNaN(timeStamp) || timeStamp < 0.0) ? (double)dateTime.toEpochSecond() + (double)dateTime.getNano() / 1.0E9 : this.getTimestampValue(timeStamp);
    }

    public double getTimeStamp() {
        return this.timeStamp;
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public boolean hasDateStamp() {
        return this.getDateTime() != null;
    }

    public boolean equals(Object obj) {
        boolean eq = false;
        if (obj instanceof DateTimeStamp) {
            DateTimeStamp other = (DateTimeStamp)obj;
            boolean bl = eq = this.getTimeStamp() == other.getTimeStamp();
            if (this.getDateTime() != null && other.getDateTime() != null) {
                eq = eq && this.getDateTime().equals(other.getDateTime());
            }
        }
        return eq;
    }

    public int hashCode() {
        return Objects.hash(this.getDateTime(), this.getTimeStamp());
    }

    public String toString() {
        if (this.dateTime == null) {
            return "@" + String.format(Locale.US, "%.3f", this.timeStamp);
        }
        return this.dateTime + "@" + String.format(Locale.US, "%.3f", this.timeStamp);
    }

    public boolean before(double other) {
        return this.getTimeStamp() < this.getTimestampValue(other);
    }

    public boolean after(double other) {
        return this.getTimeStamp() > this.getTimestampValue(other);
    }

    public boolean before(DateTimeStamp other) {
        return !this.after(other);
    }

    public boolean after(DateTimeStamp other) {
        if (other.hasDateStamp() && this.hasDateStamp()) {
            int comparison = other.compare(this.getDateTime());
            if (comparison < 0) {
                return true;
            }
            if (comparison > 0) {
                return false;
            }
        }
        return this.after(other.getTimeStamp());
    }

    public int compare(ZonedDateTime otherDate) {
        if (this.hasDateStamp() && otherDate != null) {
            if (this.getDateTime().isAfter(otherDate)) {
                return 1;
            }
            if (this.getDateTime().isBefore(otherDate)) {
                return -1;
            }
            return 0;
        }
        if (this.hasDateStamp()) {
            return 1;
        }
        return -1;
    }

    public DateTimeStamp add(double offsetInDecimalSeconds) {
        DateTimeStamp now;
        offsetInDecimalSeconds = this.getTimestampValue(offsetInDecimalSeconds);
        if (this.dateTime != null) {
            int seconds = (int)offsetInDecimalSeconds;
            long nanos = (long)(offsetInDecimalSeconds % 1.0 * 1.0E9);
            now = new DateTimeStamp(this.dateTime.plusSeconds(seconds).plusNanos(nanos), this.timeStamp + offsetInDecimalSeconds);
        } else {
            now = new DateTimeStamp(this.getTimeStamp() + offsetInDecimalSeconds);
        }
        return now;
    }

    private double getTimestampValue(double timestamp) {
        return Double.isNaN(timestamp) ? 0.0 : timestamp;
    }

    public DateTimeStamp minus(double offsetInDecimalSeconds) {
        return this.add(-offsetInDecimalSeconds);
    }

    public double minus(DateTimeStamp dateTimeStamp) {
        return this.timeStamp - dateTimeStamp.timeStamp;
    }

    public double timeSpanInMinutes(DateTimeStamp dateTimeStamp) {
        return this.minus(dateTimeStamp) / 60.0;
    }

    @Override
    public int compareTo(DateTimeStamp dateTimeStamp) {
        return comparator.compare(this, dateTimeStamp);
    }

    private static Comparator<DateTimeStamp> getComparator() {
        return Comparator.nullsLast((o1, o2) -> {
            Comparator<DateTimeStamp> dateTimeStampComparator = DateTimeStamp.compareDateTimeStamp(o1, o2);
            return dateTimeStampComparator.compare((DateTimeStamp)o1, (DateTimeStamp)o2);
        });
    }

    private static Comparator<DateTimeStamp> compareDateTimeStamp(DateTimeStamp o1, DateTimeStamp o2) {
        return Comparator.comparingDouble(DateTimeStamp::getTimeStamp).thenComparing(DateTimeStamp::getDateTime, (dtsA, dtsB) -> {
            if (dtsA == null || dtsB == null) {
                return 0;
            }
            return dtsA.compareTo((ChronoZonedDateTime<?>)dtsB);
        });
    }

    public double toEpochInMillis() {
        if (this.dateTime != null) {
            return (double)(this.dateTime.toEpochSecond() * 1000L) + (double)this.dateTime.getNano() / 1000000.0;
        }
        return -1.0;
    }

    public boolean hasTimeStamp() {
        return this.timeStamp != -1.0 && !Double.isNaN(this.timeStamp);
    }

    public boolean hasDateTime() {
        return this.dateTime != null;
    }
}

