/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.aggregator;

import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.Collates;
import com.microsoft.gctoolkit.time.DateTimeStamp;

public abstract class Aggregation {
    private DateTimeStamp timeOfFirstEvent = null;
    private DateTimeStamp timeOfTermination = new DateTimeStamp(0.0);

    protected Aggregation() {
    }

    public void timeOfFirstEvent(DateTimeStamp eventTime) {
        this.timeOfFirstEvent = eventTime;
    }

    public DateTimeStamp timeOfFirstEvent() {
        return this.timeOfFirstEvent;
    }

    public void timeOfTerminationEvent(DateTimeStamp eventTime) {
        this.timeOfTermination = eventTime;
    }

    public DateTimeStamp timeOfTerminationEvent() {
        return this.timeOfTermination;
    }

    public DateTimeStamp estimatedStartTime() {
        if (this.timeOfFirstEvent.getTimeStamp() / this.timeOfTermination.getTimeStamp() > 0.25) {
            return this.timeOfFirstEvent;
        }
        if (!this.timeOfFirstEvent.hasDateStamp()) {
            return new DateTimeStamp(0.0);
        }
        return this.timeOfFirstEvent.minus(this.timeOfFirstEvent.getTimeStamp());
    }

    public double estimatedRuntime() {
        return this.timeOfTermination.minus(this.estimatedStartTime());
    }

    public abstract boolean hasWarning();

    public abstract boolean isEmpty();

    public Class<? extends Aggregator<?>> collates() {
        return this.collates(this.getClass());
    }

    private Class<? extends Aggregator<?>> collates(Class<?> clazz) {
        if (clazz != null && clazz != Aggregation.class) {
            Class<?>[] interfaces;
            if (clazz.isAnnotationPresent(Collates.class)) {
                Collates collates = clazz.getAnnotation(Collates.class);
                return collates.value();
            }
            Class<?> superClass = clazz.getSuperclass();
            Class<Aggregator<?>> target = this.collates(superClass);
            if (target != null) {
                return target;
            }
            for (Class<?> iface : interfaces = clazz.getInterfaces()) {
                target = this.collates(iface);
                if (target == null) continue;
                return target;
            }
        }
        return null;
    }
}

