/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.event.g1gc;

import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.StatisticalSummary;
import com.microsoft.gctoolkit.event.UnifiedStatisticalSummary;
import com.microsoft.gctoolkit.event.g1gc.G1RealPause;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;

public class G1Young
extends G1RealPause {
    private double parallelPhaseDuration = -1.0;
    private int gcWorkers;
    private double codeRootFixupDuration = -1.0;
    private double codeRootMigrationDuration = -1.0;
    private double codeRootPurgeDuration = -1.0;
    private double clearCTDuration = -1.0;
    private double expandHeapDuration = -1.0;
    private double stringDedupingDuration = -1.0;
    private int stringDeduppingWorkers;
    private StatisticalSummary queueFixupStatistics;
    private StatisticalSummary tableFixupStatistics;
    private double otherPhaseDurations = -1.0;
    private StatisticalSummary workersStart;
    private StatisticalSummary workersEnd;
    private StatisticalSummary workerOther;
    private StatisticalSummary workerTotal;
    private StatisticalSummary processedBuffersSummary;
    private boolean toSpaceExhausted = false;
    private final Map<String, StatisticalSummary> parallelPhaseSummaries = new ConcurrentHashMap<String, StatisticalSummary>();
    private final Map<String, Double> phaseDurations = new ConcurrentHashMap<String, Double>();
    private final Map<String, Double> preEvacuateCSetPhase = new ConcurrentHashMap<String, Double>(3);
    private final Map<String, UnifiedStatisticalSummary> evacuateCSetPhase = new ConcurrentHashMap<String, UnifiedStatisticalSummary>();
    private final Map<String, Double> postEvacuateCSetPhase = new ConcurrentHashMap<String, Double>();

    public G1Young(DateTimeStamp dateTimeStamp, GarbageCollectionTypes gcType, GCCause gcCause, double pauseTime) {
        super(dateTimeStamp, gcType, gcCause, pauseTime);
    }

    public G1Young(DateTimeStamp dateTimeStamp, GCCause gcCause, double pauseTime) {
        this(dateTimeStamp, GarbageCollectionTypes.Young, gcCause, pauseTime);
    }

    public void toSpaceExhausted() {
        this.toSpaceExhausted = true;
    }

    public boolean isToSpaceExhausted() {
        return this.toSpaceExhausted;
    }

    public void setParallelPhaseDuration(double duration) {
        this.parallelPhaseDuration = duration;
    }

    public void setGcWorkers(int count) {
        this.gcWorkers = count;
    }

    public void setCodeRootFixupDuration(double duration) {
        this.codeRootFixupDuration = duration;
    }

    public void setStringDedupingDuration(double duration, int workers) {
        this.stringDedupingDuration = duration;
        this.stringDeduppingWorkers = workers;
    }

    public void setQueueFixupStatistics(StatisticalSummary summary) {
        this.queueFixupStatistics = summary;
    }

    public void setTableFixupStatistics(StatisticalSummary summary) {
        this.tableFixupStatistics = summary;
    }

    public void setCodeRootMigrationDuration(double duration) {
        this.codeRootMigrationDuration = duration;
    }

    public void setCodeRootPurgeDuration(double duration) {
        this.codeRootPurgeDuration = duration;
    }

    public void setClearCTDuration(double duration) {
        this.clearCTDuration = duration;
    }

    public void setExpandHeapDuration(double duration) {
        this.expandHeapDuration = duration;
    }

    public void setOtherPhaseDurations(double duration) {
        this.otherPhaseDurations = duration;
    }

    public double getParallelPhaseDurationTime() {
        return this.parallelPhaseDuration;
    }

    public int getGcWorkers() {
        return this.gcWorkers;
    }

    public double getCodeRootFixupDuration() {
        return this.codeRootFixupDuration;
    }

    public double getCodeRootMigrationDuration() {
        return this.codeRootMigrationDuration;
    }

    public double getCodeRootPurgeDuration() {
        return this.codeRootPurgeDuration;
    }

    public double getClearCTDuration() {
        return this.clearCTDuration;
    }

    public double getExpandHeapDuration() {
        return this.expandHeapDuration;
    }

    public double getStringDedupingDuration() {
        return this.stringDedupingDuration;
    }

    public int getStringDeduppingWorkers() {
        return this.stringDeduppingWorkers;
    }

    public StatisticalSummary getQueueFixupStatistics() {
        return this.queueFixupStatistics;
    }

    public StatisticalSummary getTableFixupStatistics() {
        return this.tableFixupStatistics;
    }

    public double getOtherPhaseDurations() {
        return this.otherPhaseDurations;
    }

    public void setWorkersStart(StatisticalSummary summary) {
        this.workersStart = summary;
    }

    public StatisticalSummary getWorkersStart() {
        return this.workersStart;
    }

    public void setWorkersEnd(StatisticalSummary summary) {
        this.workersEnd = summary;
    }

    public StatisticalSummary getWorkersEnd() {
        return this.workersEnd;
    }

    public void addProcessedBuffersSummary(StatisticalSummary summary) {
        this.processedBuffersSummary = summary;
    }

    public StatisticalSummary getProcessedBuffersSummary() {
        return this.processedBuffersSummary;
    }

    public void addWorkerActivity(String group, StatisticalSummary statisticalSummary) {
        if (group.endsWith("Other")) {
            this.workerOther = statisticalSummary;
        }
        if (group.endsWith("Total")) {
            this.workerTotal = statisticalSummary;
        }
    }

    public StatisticalSummary getWorkerOther() {
        return this.workerOther;
    }

    public StatisticalSummary getWorkerTotal() {
        return this.workerTotal;
    }

    public void addPhaseDuration(String key, double duration) {
        this.phaseDurations.put(key, duration);
    }

    public Iterator<String> phaseNames() {
        return this.phaseDurations.keySet().iterator();
    }

    public double phaseDurationFor(String phaseName) {
        return this.phaseDurations.get(phaseName);
    }

    public void addParallelPhaseSummary(String key, StatisticalSummary summary) {
        this.parallelPhaseSummaries.put(key, summary);
    }

    public Iterator<String> parallelPhaseNames() {
        return this.parallelPhaseSummaries.keySet().iterator();
    }

    public StatisticalSummary parallelPhaseSummaryFor(String phaseName) {
        return this.parallelPhaseSummaries.get(phaseName);
    }

    public void queueFixupStatistics(StatisticalSummary summary) {
        this.queueFixupStatistics = summary;
    }

    public void tableFixupStatistics(StatisticalSummary summary) {
        this.tableFixupStatistics = summary;
    }

    public void addPreEvacuationCollectionPhase(String name, double duration) {
        this.preEvacuateCSetPhase.put(name, duration);
    }

    public Stream<String> preEvacuateCSetPhaseNames() {
        return this.preEvacuateCSetPhase.keySet().stream();
    }

    public double preEvacuateCSetPhaseDuration(String name) {
        return this.preEvacuateCSetPhase.get(name);
    }

    public void addEvacuationCollectionPhase(String name, UnifiedStatisticalSummary summary) {
        this.evacuateCSetPhase.put(name, summary);
    }

    public Stream<String> evacuateCSetPhaseNames() {
        return this.evacuateCSetPhase.keySet().stream();
    }

    public StatisticalSummary evacuateCSetPhaseDuration(String name) {
        return this.evacuateCSetPhase.get(name);
    }

    public void addPostEvacuationCollectionPhase(String name, double summary) {
        this.postEvacuateCSetPhase.put(name, summary);
    }

    public Stream<String> postEvacuateCSetPhaseNames() {
        return this.postEvacuateCSetPhase.keySet().stream();
    }

    public double postEvacuateCSetPhaseDuration(String name) {
        return this.postEvacuateCSetPhase.get(name);
    }
}

