/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.event.jvm;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.ArrayList;

public class SurvivorRecord
extends JVMEvent {
    private static final int THEORETICAL_MAX_TENURING_THRESHOLD = 15;
    private final long desiredOccupancyAfterCollection;
    private int calculatedTenuringThreshold;
    private int maxTenuringThreshold;
    private ArrayList<Long> bytesAtAge = null;

    public SurvivorRecord(DateTimeStamp timeStamp, long desiredOccupancy, int calculatedTenuringThreshold, int maxTenuringThreshold) {
        super(timeStamp, 0.0);
        this.desiredOccupancyAfterCollection = desiredOccupancy;
        this.setCalculatedThreshold(calculatedTenuringThreshold);
        this.setMaxTenuringThreshold(maxTenuringThreshold);
    }

    private void setMaxTenuringThreshold(int maxTenuringThresholdFromLog) {
        this.maxTenuringThreshold = maxTenuringThresholdFromLog <= 15 ? maxTenuringThresholdFromLog : 15;
    }

    private void setCalculatedThreshold(int calculatedTenuringThresholdFromLog) {
        this.calculatedTenuringThreshold = calculatedTenuringThresholdFromLog <= 15 ? calculatedTenuringThresholdFromLog : 15;
    }

    public long getDesiredOccupancyAfterCollection() {
        return this.desiredOccupancyAfterCollection;
    }

    public int getCalculatedTenuringThreshold() {
        return this.calculatedTenuringThreshold;
    }

    public int getMaxTenuringThreshold() {
        return this.maxTenuringThreshold;
    }

    public long getBytesAtAge(int age) {
        if (this.bytesAtAge == null) {
            return 0L;
        }
        return this.bytesAtAge.get(age);
    }

    public void add(int age, long bytes) {
        if (this.bytesAtAge == null) {
            this.bytesAtAge = new ArrayList();
            this.bytesAtAge.add(0L);
        }
        if (age <= this.maxTenuringThreshold) {
            this.bytesAtAge.add(bytes);
        } else {
            this.bytesAtAge.set(this.maxTenuringThreshold, this.bytesAtAge.get(this.maxTenuringThreshold) + bytes);
        }
    }

    public Long[] getBytesAtEachAge() {
        if (this.bytesAtAge == null) {
            return new Long[0];
        }
        return this.bytesAtAge.toArray(new Long[0]);
    }
}

