/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.io;

import com.microsoft.gctoolkit.io.GCLogFileSegment;
import com.microsoft.gctoolkit.io.GCLogFileZipSegment;
import com.microsoft.gctoolkit.io.LogFileMetadata;
import com.microsoft.gctoolkit.io.LogFileSegment;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RotatingLogFileMetadata
extends LogFileMetadata {
    private static final Logger LOG = Logger.getLogger(RotatingLogFileMetadata.class.getName());
    private List<LogFileSegment> segments;

    public RotatingLogFileMetadata(Path path) throws IOException {
        super(path);
    }

    @Override
    public Stream<LogFileSegment> logFiles() {
        if (this.segments == null) {
            if (this.isPlainText() || this.isDirectory()) {
                this.findSegments();
            } else if (this.isZip()) {
                this.findZIPSegments();
            } else {
                LOG.warning("unknown log file format");
                this.segments = new ArrayList<LogFileSegment>();
            }
        }
        return this.segments.stream();
    }

    private void findZIPSegments() {
        try (ZipFile zipfile = new ZipFile(this.getPath().toFile());){
            this.segments = zipfile.stream().filter(zipEntry -> !zipEntry.isDirectory()).map(ZipEntry::getName).map(name -> new GCLogFileZipSegment(this.getPath(), (String)name)).collect(Collectors.toList());
        }
        catch (IOException ioe) {
            LOG.warning(ioe.getMessage());
        }
        this.orderSegments();
    }

    @Override
    public int getNumberOfFiles() {
        if (this.segments == null) {
            if (this.isZip()) {
                this.findZIPSegments();
            } else {
                this.findSegments();
            }
        }
        return this.segments.size();
    }

    private String getRootPattern() {
        String[] bits = this.isDirectory() ? this.segments.stream().filter(segment -> !segment.getSegmentName().matches(".+\\.\\d+$")).findFirst().get().getSegmentName().split("\\.") : (this.isZip() ? this.segments.get(0).getSegmentName().split("\\.") : this.getPath().getFileName().toString().split("\\."));
        int baseLength = 0;
        baseLength = "current".equals(bits[bits.length - 1]) ? bits.length - 2 : (bits[bits.length - 1].matches("\\d+$") ? bits.length - 1 : bits.length);
        StringBuilder base = new StringBuilder(bits[0]);
        for (int i = 1; i < baseLength; ++i) {
            base.append(".").append(bits[i]);
        }
        return base.toString();
    }

    private void findSegments() {
        this.segments = new ArrayList<LogFileSegment>();
        try {
            if (this.isDirectory()) {
                Files.list(this.getPath()).map(GCLogFileSegment::new).forEach(this.segments::add);
            } else {
                Files.list(this.getPath().getParent()).filter(file -> file.getFileName().toString().startsWith(this.getRootPattern())).map(p -> new GCLogFileSegment((Path)p)).forEach(this.segments::add);
            }
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, "Unable to find log segments.", ioe);
        }
        this.orderSegments();
    }

    private void orderSegments() {
        if (this.segments.size() < 2) {
            return;
        }
        LinkedList<LogFileSegment> orderedList = new LinkedList<LogFileSegment>();
        List<LogFileSegment> workingList = new ArrayList<LogFileSegment>();
        workingList.addAll(this.segments);
        String basePattern = this.getRootPattern();
        LogFileSegment current = workingList.stream().filter(segment -> segment.getSegmentName().endsWith(basePattern) || segment.getSegmentName().endsWith(".current")).findFirst().get();
        orderedList.addFirst(current);
        workingList = this.removeIneligibleSegments(workingList, current);
        while (!workingList.isEmpty()) {
            current = workingList.stream().max(Comparator.comparing(LogFileSegment::getEndTime)).get();
            orderedList.addFirst(current);
            workingList = this.removeIneligibleSegments(workingList, current);
        }
        this.segments = orderedList;
    }

    private List<LogFileSegment> removeIneligibleSegments(List<LogFileSegment> logFileSegments, LogFileSegment current) {
        return logFileSegments.stream().filter(segment -> segment.getEndTime() <= current.getStartTime()).collect(Collectors.toList());
    }
}

