/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.time;

import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DateTimeStamp
implements Comparable<DateTimeStamp> {
    public static final double TIMESTAMP_NOT_SET = Double.NaN;
    private final ZonedDateTime dateTime;
    private double timeStamp;
    public static final Comparator<DateTimeStamp> comparator = DateTimeStamp.getComparator();
    private static final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final String DECIMAL_POINT = "(?:\\.|,)";
    private static final String INTEGER = "\\d+";
    private static final String DATE = "\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}";
    private static final String TIME = "\\d+(?:\\.|,)\\d{3}";
    private static final String DATE_TAG = "\\[\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}\\]";
    private static final String UPTIME_TAG = "\\[(\\d+(?:\\.|,)\\d{3})s\\]";
    private static final String TIMESTAMP = "(\\d+(?:\\.|,)\\d{3}): ";
    private static final String DATE_STAMP = "(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): ";
    private static final String DATE_TIMESTAMP = "^(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): ";
    private static final Pattern PREUNIFIED_DATE_TIMESTAMP = Pattern.compile("^(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): ");
    private static final Pattern UNIFIED_DATE_TIMESTAMP = Pattern.compile("^(\\[\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}\\])?(\\[(\\d+(?:\\.|,)\\d{3})s\\])?");
    private static final DateTimeStamp EMPTY_DATE = new DateTimeStamp(Double.NaN);

    private static ZonedDateTime dateFromString(String iso8601DateTime) {
        if (iso8601DateTime == null) {
            return null;
        }
        return ZonedDateTime.from(formatter.parse(iso8601DateTime));
    }

    private static double ageFromString(String doubleFormat) {
        if (doubleFormat == null) {
            return Double.NaN;
        }
        return Double.parseDouble(doubleFormat.replace(",", "."));
    }

    public static DateTimeStamp fromGCLogLine(String line) {
        Matcher matcher;
        int captureGroup = 2;
        if (line.startsWith("[")) {
            matcher = UNIFIED_DATE_TIMESTAMP.matcher(line);
            captureGroup = 3;
        } else {
            matcher = PREUNIFIED_DATE_TIMESTAMP.matcher(line);
        }
        if (matcher.find()) {
            return new DateTimeStamp(DateTimeStamp.dateFromString(matcher.group(1)), DateTimeStamp.ageFromString(matcher.group(captureGroup)));
        }
        return EMPTY_DATE;
    }

    public DateTimeStamp(String iso8601DateTime) {
        this(DateTimeStamp.dateFromString(iso8601DateTime));
    }

    public DateTimeStamp(ZonedDateTime dateTime) {
        this(dateTime, Double.NaN);
    }

    public DateTimeStamp(String iso8601DateTime, double timeStamp) {
        this(DateTimeStamp.dateFromString(iso8601DateTime), timeStamp);
    }

    public DateTimeStamp(double timeStamp) {
        this((ZonedDateTime)null, timeStamp);
    }

    public DateTimeStamp(ZonedDateTime dateTime, double timeStamp) {
        this.dateTime = dateTime;
        this.timeStamp = timeStamp < 0.0 || Double.isNaN(timeStamp) ? Double.NaN : (double)Math.round(timeStamp * 1000.0) / 1000.0;
    }

    public double getTimeStamp() {
        if (!this.hasTimeStamp()) {
            return this.toEpochInMillis();
        }
        return this.timeStamp;
    }

    public ZonedDateTime getDateTime() {
        return this.dateTime;
    }

    public boolean hasDateStamp() {
        return this.getDateTime() != null;
    }

    public boolean hasTimeStamp() {
        return !Double.isNaN(this.timeStamp);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DateTimeStamp) {
            DateTimeStamp other = (DateTimeStamp)obj;
            if (this.hasDateStamp()) {
                return this.getDateTime().equals(other.getDateTime()) && this.getTimeStamp() == other.getTimeStamp();
            }
            return this.getTimeStamp() == other.getTimeStamp();
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getDateTime(), this.getTimeStamp());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.hasDateStamp()) {
            buffer.append(this.getDateTime().toString());
        }
        if (this.hasTimeStamp()) {
            buffer.append("@").append(String.format(Locale.US, "%.3f", this.getTimeStamp()));
        }
        return buffer.toString();
    }

    public boolean before(DateTimeStamp other) {
        return this.compareTo(other) < 0;
    }

    public boolean after(DateTimeStamp other) {
        return this.compareTo(other) > 0;
    }

    public int compare(ZonedDateTime otherDate) {
        if (this.hasDateStamp() && otherDate != null) {
            if (this.getDateTime().isAfter(otherDate)) {
                return 1;
            }
            if (this.getDateTime().isBefore(otherDate)) {
                return -1;
            }
            return 0;
        }
        throw new IllegalStateException("One or more DateStamp is missing");
    }

    public DateTimeStamp add(double offsetInDecimalSeconds) {
        if (Double.isNaN(offsetInDecimalSeconds)) {
            throw new IllegalArgumentException("Cannot add NaN");
        }
        double adjustedTimeStamp = Double.NaN;
        ZonedDateTime adjustedDateStamp = null;
        if (this.hasTimeStamp()) {
            adjustedTimeStamp = this.getTimeStamp() + offsetInDecimalSeconds;
        }
        if (this.hasDateStamp()) {
            double offset = Double.isNaN(offsetInDecimalSeconds) ? 0.0 : offsetInDecimalSeconds;
            int seconds = (int)offset;
            long nanos = (long)(offset % 1.0 * 1000.0) * 1000000L;
            adjustedDateStamp = this.dateTime.plusSeconds(seconds).plusNanos(nanos);
        }
        return new DateTimeStamp(adjustedDateStamp, adjustedTimeStamp);
    }

    public DateTimeStamp minus(double offsetInDecimalSeconds) {
        return this.add(-offsetInDecimalSeconds);
    }

    public double minus(DateTimeStamp other) {
        if (this.hasTimeStamp() && other.hasTimeStamp()) {
            return this.getTimeStamp() - other.getTimeStamp();
        }
        if (this.hasDateStamp() && other.hasDateStamp()) {
            double thisInSeconds = (double)this.getDateTime().toEpochSecond() + (double)(this.getDateTime().getNano() / 1000000) / 1000.0;
            double otherInSeconds = (double)other.getDateTime().toEpochSecond() + (double)(other.getDateTime().getNano() / 1000000) / 1000.0;
            return thisInSeconds - otherInSeconds;
        }
        return Double.NaN;
    }

    public double timeSpanInMinutes(DateTimeStamp dateTimeStamp) {
        return this.minus(dateTimeStamp) / 60.0;
    }

    @Override
    public int compareTo(DateTimeStamp dateTimeStamp) {
        return comparator.compare(this, dateTimeStamp);
    }

    private static Comparator<DateTimeStamp> getComparator() {
        return Comparator.nullsLast((o1, o2) -> {
            Comparator<DateTimeStamp> dateTimeStampComparator = DateTimeStamp.compareDateTimeStamp(o1, o2);
            return dateTimeStampComparator.compare((DateTimeStamp)o1, (DateTimeStamp)o2);
        });
    }

    private static Comparator<DateTimeStamp> compareDateTimeStamp(DateTimeStamp o1, DateTimeStamp o2) {
        if (o1.hasTimeStamp() && o2.hasTimeStamp()) {
            return Comparator.comparingDouble(DateTimeStamp::getTimeStamp);
        }
        if (o1.hasDateStamp() && o2.hasDateStamp()) {
            return Comparator.comparing(DateTimeStamp::getDateTime, ChronoZonedDateTime::compareTo);
        }
        throw new IllegalStateException("DateTimeStamp parameters cannot be compared as either timestamp or datestamp must be set.");
    }

    public double toEpochInMillis() {
        if (this.dateTime != null) {
            return (double)(this.dateTime.toEpochSecond() * 1000L) + (double)this.dateTime.getNano() / 1000000.0;
        }
        return Double.NaN;
    }
}

