/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.event.jvm;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.time.DateTimeStamp;

public class Safepoint
extends JVMEvent {
    private final String vmOperation;
    private int totalNumberOfApplicationThreads;
    private int initiallyRunning;
    private int waitingToBlock;
    private int spinDuration;
    private int blockDuration;
    private int syncDuration;
    private int cleanupDuration;
    private int vmopDuration;
    private int pageTrapCount;

    public Safepoint(String vmOperationName, DateTimeStamp timeStamp, double duration) {
        super(timeStamp, duration);
        this.vmOperation = vmOperationName;
    }

    public void recordThreadCounts(int totalThreads, int initiallyRunning, int waitingToBlock) {
        this.totalNumberOfApplicationThreads = totalThreads;
        this.initiallyRunning = initiallyRunning;
        this.waitingToBlock = waitingToBlock;
    }

    public void recordDurations(int spinDuration, int blockDuration, int syncDuration, int cleanupDuration, int vmopDuration) {
        this.spinDuration = spinDuration;
        this.blockDuration = blockDuration;
        this.syncDuration = syncDuration;
        this.cleanupDuration = cleanupDuration;
        this.vmopDuration = vmopDuration;
    }

    public void recordPageTrapCount(int pageTrapCount) {
        this.pageTrapCount = pageTrapCount;
    }

    public String getVmOperation() {
        return this.vmOperation;
    }

    public int getTotalNumberOfApplicationThreads() {
        return this.totalNumberOfApplicationThreads;
    }

    public int getInitiallyRunning() {
        return this.initiallyRunning;
    }

    public int getWaitingToBlock() {
        return this.waitingToBlock;
    }

    public int getSpinDuration() {
        return this.spinDuration;
    }

    public int getBlockDuration() {
        return this.blockDuration;
    }

    public int getSyncDuration() {
        return this.syncDuration;
    }

    public int getCleanupDuration() {
        return this.cleanupDuration;
    }

    public int getVmopDuration() {
        return this.vmopDuration;
    }

    public int getPageTrapCount() {
        return this.pageTrapCount;
    }

    @Override
    public String toString() {
        return this.getVmOperation();
    }
}

