/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.aggregator;

import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.Collates;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.online.statistics.WelfordVarianceCalculator;
import com.microsoft.gctoolkit.time.DateTimeStamp;

public abstract class Aggregation {
    private DateTimeStamp timeOfFirstEvent = null;
    private DateTimeStamp timeOfTermination = DateTimeStamp.baseDate();
    private final WelfordVarianceCalculator varianceCalculator = new WelfordVarianceCalculator();
    private DateTimeStamp timeOfLastSeenEvent = null;

    protected Aggregation() {
    }

    public void timeOfFirstEvent(DateTimeStamp eventTime) {
        this.timeOfFirstEvent = eventTime;
    }

    public DateTimeStamp timeOfFirstEvent() {
        return this.timeOfFirstEvent;
    }

    public void timeOfTerminationEvent(DateTimeStamp eventTime) {
        this.timeOfTermination = eventTime;
    }

    public DateTimeStamp timeOfTerminationEvent() {
        return this.timeOfTermination;
    }

    public DateTimeStamp estimatedStartTime() {
        double sd = Math.sqrt(this.varianceCalculator.getValue());
        if (!this.timeOfFirstEvent.hasTimeStamp()) {
            return this.timeOfFirstEvent.minus(sd);
        }
        DateTimeStamp estimatedStartTime = this.timeOfFirstEvent.minus(sd);
        if (!estimatedStartTime.hasTimeStamp()) {
            return this.timeOfFirstEvent;
        }
        return estimatedStartTime;
    }

    public double estimatedRuntime() {
        return this.timeOfTermination.minus(this.estimatedStartTime());
    }

    public abstract boolean hasWarning();

    public abstract boolean isEmpty();

    public Class<? extends Aggregator<?>> collates() {
        return this.collates(this.getClass());
    }

    public void updateEventFrequency(JVMEvent event) {
        DateTimeStamp dateTimeStamp = event.getDateTimeStamp();
        if (this.timeOfLastSeenEvent == null) {
            this.timeOfLastSeenEvent = dateTimeStamp;
            return;
        }
        double timeSpan = dateTimeStamp.minus(this.timeOfLastSeenEvent);
        this.varianceCalculator.update(timeSpan);
    }

    private Class<? extends Aggregator<?>> collates(Class<?> clazz) {
        if (clazz != null && clazz != Aggregation.class) {
            Class<?>[] interfaces;
            if (clazz.isAnnotationPresent(Collates.class)) {
                Collates collates = clazz.getAnnotation(Collates.class);
                return collates.value();
            }
            Class<?> superClass = clazz.getSuperclass();
            Class<Aggregator<?>> target = this.collates(superClass);
            if (target != null) {
                return target;
            }
            for (Class<?> iface : interfaces = clazz.getInterfaces()) {
                target = this.collates(iface);
                if (target == null) continue;
                return target;
            }
        }
        return null;
    }
}

