/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit;

import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.io.DataSource;
import com.microsoft.gctoolkit.io.GCLogFile;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.jvm.JavaVirtualMachine;
import com.microsoft.gctoolkit.message.DataSourceChannel;
import com.microsoft.gctoolkit.message.DataSourceParser;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class GCToolKit {
    private static final Logger LOGGER = Logger.getLogger(GCToolKit.class.getName());
    private static final String GCTOOLKIT_DEBUG = System.getProperty("gctoolkit.debug");
    private static final boolean DEBUGGING = GCTOOLKIT_DEBUG != null;
    private final HashSet<DataSourceParser> registeredDataSourceParsers = new HashSet();
    private List<Aggregation> registeredAggregations;
    private JVMEventChannel jvmEventChannel = null;
    private DataSourceChannel dataSourceChannel = null;
    private List<DataSourceParser> additiveParsers = new ArrayList<DataSourceParser>();

    private static boolean isDebugging(String className) {
        return DEBUGGING && (GCTOOLKIT_DEBUG.isEmpty() || (GCTOOLKIT_DEBUG.contains("all") || GCTOOLKIT_DEBUG.contains(className)) && !GCTOOLKIT_DEBUG.contains("-" + className));
    }

    public static void LOG_DEBUG_MESSAGE(Supplier<String> message) {
        if (DEBUGGING && message != null) {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            String methodName = stackTrace[2].getMethodName();
            String className = stackTrace[2].getClassName();
            String fileName = stackTrace[2].getFileName();
            int lineNumber = stackTrace[2].getLineNumber();
            if (GCToolKit.isDebugging(className)) {
                System.out.println(String.format("DEBUG: %s.%s(%s:%d): %s", className, methodName, fileName, lineNumber, message.get()));
            }
        }
    }

    public GCToolKit() {
        this.registeredAggregations = new ArrayList<Aggregation>();
    }

    public void loadAggregationsFromServiceLoader() {
        try {
            ServiceLoader.load(Aggregation.class).stream().map(ServiceLoader.Provider::get).forEach(aggregation -> {
                this.registeredAggregations.add((Aggregation)aggregation);
                GCToolKit.LOG_DEBUG_MESSAGE(() -> "ServiceLoader provided: " + aggregation.getClass().getName());
            });
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
    }

    public void loadAggregation(Aggregation aggregation) {
        this.registeredAggregations.add(aggregation);
    }

    private JavaVirtualMachine loadJavaVirtualMachine(GCLogFile logFile) {
        return logFile.getJavaVirtualMachine();
    }

    public void loadDataSourceChannel(DataSourceChannel channel) {
        if (this.dataSourceChannel == null) {
            this.dataSourceChannel = channel;
        }
    }

    private void loadDataSourceChannel() {
        if (this.dataSourceChannel == null) {
            ServiceLoader<DataSourceChannel> serviceLoader = ServiceLoader.load(DataSourceChannel.class);
            if (serviceLoader.findFirst().isPresent()) {
                this.loadDataSourceChannel(serviceLoader.stream().map(ServiceLoader.Provider::get).findFirst().orElseThrow(() -> new ServiceConfigurationError("Internal Error - No suitable DataSourceBus implementation found")));
            } else {
                try {
                    Class<?> clazz = Class.forName("com.microsoft.gctoolkit.vertx.VertxDataSourceChannel", true, Thread.currentThread().getContextClassLoader());
                    this.loadDataSourceChannel((DataSourceChannel)clazz.getConstructors()[0].newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new ServiceConfigurationError("Unable to find a suitable DataSourceChannel provider");
                }
            }
        }
    }

    public void loadJVMEventChannel(JVMEventChannel channel) {
        if (this.jvmEventChannel == null) {
            this.jvmEventChannel = channel;
        }
    }

    private void loadJVMEventChannel() {
        if (this.jvmEventChannel == null) {
            ServiceLoader<JVMEventChannel> serviceLoader = ServiceLoader.load(JVMEventChannel.class);
            if (serviceLoader.findFirst().isPresent()) {
                this.loadJVMEventChannel(ServiceLoader.load(JVMEventChannel.class).stream().map(ServiceLoader.Provider::get).findFirst().orElseThrow(() -> new ServiceConfigurationError("Internal Error - No suitable JVMEventBus implementation found")));
            } else {
                try {
                    Class<?> clazz = Class.forName("com.microsoft.gctoolkit.vertx.VertxJVMEventChannel", true, Thread.currentThread().getContextClassLoader());
                    this.loadJVMEventChannel((JVMEventChannel)clazz.getConstructors()[0].newInstance(new Object[0]));
                }
                catch (Exception e) {
                    throw new ServiceConfigurationError("Unable to find a suitable provider to create a JVMEventChannel");
                }
            }
        }
    }

    public void loadDataSourceParser(DataSourceParser dataSourceParser) {
        this.registeredDataSourceParsers.add(dataSourceParser);
    }

    public void addDataSourceParser(DataSourceParser dataSourceParser) {
        this.additiveParsers.add(dataSourceParser);
    }

    private Set<EventSource> loadDataSourceParsers(Diary diary) {
        List<DataSourceParser> dataSourceParsers;
        this.loadDataSourceChannel();
        this.loadJVMEventChannel();
        if (this.registeredDataSourceParsers.isEmpty()) {
            dataSourceParsers = ServiceLoader.load(DataSourceParser.class).stream().map(ServiceLoader.Provider::get).filter(dataSourceParser -> dataSourceParser.accepts(diary)).collect(Collectors.toList());
        } else {
            dataSourceParsers = new ArrayList<DataSourceParser>();
            dataSourceParsers.addAll(this.registeredDataSourceParsers);
        }
        if (dataSourceParsers.isEmpty()) {
            String[] parsers = new String[]{"com.microsoft.gctoolkit.parser.CMSTenuredPoolParser", "com.microsoft.gctoolkit.parser.GenerationalHeapParser", "com.microsoft.gctoolkit.parser.JVMEventParser", "com.microsoft.gctoolkit.parser.PreUnifiedG1GCParser", "com.microsoft.gctoolkit.parser.ShenandoahParser", "com.microsoft.gctoolkit.parser.SurvivorMemoryPoolParser", "com.microsoft.gctoolkit.parser.UnifiedG1GCParser", "com.microsoft.gctoolkit.parser.UnifiedGenerationalParser", "com.microsoft.gctoolkit.parser.UnifiedJVMEventParser", "com.microsoft.gctoolkit.parser.UnifiedSurvivorMemoryPoolParser", "com.microsoft.gctoolkit.parser.ZGCParser"};
            dataSourceParsers = Arrays.stream(parsers).map(parserName -> {
                try {
                    Class<?> clazz = Class.forName(parserName, true, Thread.currentThread().getContextClassLoader());
                    return Optional.of(clazz.getConstructors()[0].newInstance(new Object[0]));
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
                    return Optional.empty();
                }
            }).filter(Optional::isPresent).map(optional -> (DataSourceParser)optional.get()).filter(dataSourceParser -> dataSourceParser.accepts(diary)).collect(Collectors.toList());
        }
        dataSourceParsers.addAll(this.additiveParsers);
        if (dataSourceParsers.isEmpty()) {
            throw new ServiceConfigurationError("Unable to find a suitable provider to create a DataSourceParser");
        }
        for (DataSourceParser dataSourceParser2 : dataSourceParsers) {
            GCToolKit.LOG_DEBUG_MESSAGE(() -> "Registering " + dataSourceParser2.getClass().getName() + " with " + this.dataSourceChannel.getClass().getName());
            dataSourceParser2.diary(diary);
            this.dataSourceChannel.registerListener(dataSourceParser2);
            dataSourceParser2.publishTo(this.jvmEventChannel);
        }
        return dataSourceParsers.stream().map(DataSourceParser::eventsProduced).collect(HashSet::new, Set::addAll, Set::addAll);
    }

    public JavaVirtualMachine analyze(DataSource<?> dataSource) throws IOException {
        GCLogFile logFile = (GCLogFile)dataSource;
        Set<EventSource> events = this.loadDataSourceParsers(logFile.diary());
        JavaVirtualMachine javaVirtualMachine = this.loadJavaVirtualMachine(logFile);
        try {
            List<Aggregator<? extends Aggregation>> filteredAggregators = this.filterAggregations(events);
            long start = System.currentTimeMillis();
            javaVirtualMachine.analyze(filteredAggregators, this.jvmEventChannel, this.dataSourceChannel);
            LOGGER.log(Level.FINE, () -> "Analysis completed in " + (System.currentTimeMillis() - start) + "ms");
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, "Internal Error: Cannot invoke analyze method", t);
        }
        return javaVirtualMachine;
    }

    private List<Aggregator<? extends Aggregation>> filterAggregations(Set<EventSource> events) {
        ArrayList<Aggregator<? extends Aggregation>> aggregators = new ArrayList<Aggregator<? extends Aggregation>>();
        for (Aggregation aggregation : this.registeredAggregations) {
            GCToolKit.LOG_DEBUG_MESSAGE(() -> "Evaluating: " + aggregation.getClass().getName());
            Constructor<Aggregator<?>> constructor = this.constructor(aggregation);
            if (constructor == null) {
                LOGGER.log(Level.WARNING, "Cannot find one of: default constructor or @Collates annotation for " + aggregation.getClass().getName());
                continue;
            }
            Aggregator<?> aggregator = null;
            try {
                aggregator = constructor.newInstance(aggregation);
            }
            catch (IllegalArgumentException iae) {
                Class<?> argumentType;
                LOGGER.log(Level.SEVERE, "Creating a " + constructor.getName() + " requires  a " + constructor.getParameterTypes()[0].getName() + " but was supplied with a " + String.valueOf(argumentType), iae);
                LOGGER.log(Level.SEVERE, "Expanding " + String.valueOf(argumentType));
                for (argumentType = aggregation.getClass(); argumentType != Aggregation.class; argumentType = argumentType.getSuperclass()) {
                    LOGGER.log(Level.SEVERE, "    extends " + argumentType.getName());
                }
                continue;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
                continue;
            }
            if (events.stream().anyMatch(aggregator::aggregates)) {
                GCToolKit.LOG_DEBUG_MESSAGE(() -> "Including : " + aggregation.getClass().getName());
                aggregators.add(aggregator);
                continue;
            }
            GCToolKit.LOG_DEBUG_MESSAGE(() -> "Excluding : " + aggregation.getClass().getName());
        }
        return aggregators;
    }

    private Constructor<? extends Aggregator<?>> constructor(Aggregation aggregation) {
        Class<Aggregator<?>> targetClazz = aggregation.collates();
        if (targetClazz != null) {
            Constructor<?>[] constructors;
            for (Constructor<?> constructor : constructors = targetClazz.getConstructors()) {
                Parameter[] parameters = constructor.getParameters();
                if (parameters.length != 1 || !Aggregation.class.isAssignableFrom(parameters[0].getType())) continue;
                return constructor;
            }
        }
        return null;
    }
}

