/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.io;

import com.microsoft.gctoolkit.io.LogFileSegment;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.regex.Matcher;
import java.util.stream.Stream;

public class GCLogFileSegment
implements LogFileSegment {
    private final Path path;
    private final int segmentIndex;
    private final boolean current;
    private DateTimeStamp endTime = null;
    private DateTimeStamp startTime = null;

    public GCLogFileSegment(Path path) {
        this.path = path;
        String filename = path.getFileName().toString();
        Matcher matcher = ROTATING_LOG_PATTERN.matcher(filename);
        if (matcher.matches()) {
            this.segmentIndex = Integer.parseInt(matcher.group(1));
            this.current = ".current".equals(matcher.group(2));
        } else {
            this.segmentIndex = Integer.MAX_VALUE;
            this.current = true;
        }
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public String getSegmentName() {
        return this.getPath().toFile().getName();
    }

    @Override
    public double getStartTime() {
        try {
            this.ageOfJVMAtLogStart();
            return this.startTime.getTimeStamp();
        }
        catch (NullPointerException ex) {
            return Double.MAX_VALUE;
        }
    }

    @Override
    public double getEndTime() {
        try {
            this.ageOfJVMAtLogEnd();
            return this.endTime.getTimeStamp();
        }
        catch (IOException | NullPointerException ex) {
            return Double.MIN_VALUE;
        }
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    @Override
    public Stream<String> stream() {
        try {
            return Files.lines(this.path);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isCurrent() {
        return this.current;
    }

    private DateTimeStamp ageOfJVMAtLogStart() {
        if (this.startTime == null) {
            this.startTime = this.stream().map(DateTimeStamp::fromGCLogLine).filter(dateTimeStamp -> dateTimeStamp.hasTimeStamp() || dateTimeStamp.hasDateStamp()).findFirst().orElse(new DateTimeStamp(-1.0));
        }
        return this.startTime;
    }

    private DateTimeStamp ageOfJVMAtLogEnd() throws IOException {
        if (this.endTime == null) {
            this.endTime = this.tail(100).stream().map(DateTimeStamp::fromGCLogLine).filter(dateTimeStamp -> dateTimeStamp.hasTimeStamp() || dateTimeStamp.hasDateStamp()).max(Comparator.comparing(dateTimeStamp -> dateTimeStamp != null ? dateTimeStamp.getTimeStamp() : 0.0)).orElse(new DateTimeStamp(-1.0));
        }
        return this.endTime;
    }

    public String toString() {
        return this.getSegmentName();
    }

    private ArrayList<String> tail(int numberOfLines) throws IOException {
        char character;
        char LF = '\n';
        char CR = '\r';
        boolean foundEOL = false;
        char eol = '\u0000';
        RandomAccessFile randomAccessFile = new RandomAccessFile(this.path.toFile(), "r");
        long currentPosition = randomAccessFile.length() - 1L;
        int linesFound = 0;
        while (currentPosition > 0L && !foundEOL) {
            randomAccessFile.seek(currentPosition);
            character = (char)randomAccessFile.readByte();
            if (character == LF) {
                eol = LF;
                randomAccessFile.seek(currentPosition - 1L);
                character = (char)randomAccessFile.readByte();
                if (character == CR) {
                    eol = CR;
                }
                foundEOL = true;
                continue;
            }
            if (character == CR && !foundEOL) {
                eol = CR;
                foundEOL = true;
                continue;
            }
            --currentPosition;
        }
        currentPosition = randomAccessFile.length() - 1L;
        while (currentPosition > 0L && linesFound < numberOfLines) {
            randomAccessFile.seek(--currentPosition);
            character = (char)randomAccessFile.readByte();
            if (eol != character) continue;
            ++linesFound;
        }
        ArrayList<String> lines = new ArrayList<String>();
        if (linesFound > 0) {
            String line;
            while ((line = randomAccessFile.readLine()) != null) {
                lines.add(line);
            }
        }
        return lines;
    }
}

