/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.jvm;

import com.microsoft.gctoolkit.GCToolKit;
import com.microsoft.gctoolkit.aggregator.Aggregation;
import com.microsoft.gctoolkit.aggregator.Aggregator;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.io.DataSource;
import com.microsoft.gctoolkit.io.GCLogFile;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.jvm.JavaVirtualMachine;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.DataSourceChannel;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.message.JVMEventChannelAggregator;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Phaser;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractJavaVirtualMachine
implements JavaVirtualMachine {
    private static final Logger LOGGER = Logger.getLogger(AbstractJavaVirtualMachine.class.getName());
    private static final double LOG_FRAGMENT_THRESHOLD_SECONDS = 60.0;
    private GCLogFile dataSource;
    private Diary diary;
    private DateTimeStamp estimatedStartTime;
    private DateTimeStamp timeOfLastEvent;
    private double logDuration = -1.0;
    private final Map<Class<? extends Aggregation>, Aggregation> aggregatedData = new ConcurrentHashMap<Class<? extends Aggregation>, Aggregation>();

    public void setDataSource(DataSource logFile) throws IOException {
        this.dataSource = (GCLogFile)logFile;
        this.diary = logFile.diary();
    }

    @Override
    public boolean isG1GC() {
        return this.diary.isG1GC();
    }

    @Override
    public boolean isZGC() {
        return this.diary.isZGC();
    }

    @Override
    public boolean isShenandoah() {
        return this.diary.isShenandoah();
    }

    @Override
    public boolean isParallel() {
        return this.diary.isPSYoung();
    }

    @Override
    public boolean isSerial() {
        return this.diary.isSerialFull();
    }

    @Override
    public boolean isCMS() {
        return this.diary.isCMS();
    }

    @Override
    public String getCommandLine() {
        return "";
    }

    @Override
    public DateTimeStamp getTimeOfFirstEvent() {
        return this.diary.getTimeOfFirstEvent();
    }

    @Override
    public DateTimeStamp getEstimatedJVMStartTime() {
        DateTimeStamp startTime = this.diary.getTimeOfFirstEvent();
        if (startTime.getTimeStamp() < 60.0) {
            return startTime.minus(startTime.getTimeStamp());
        }
        return startTime;
    }

    public void setEstimatedJVMStartTime(DateTimeStamp estimatedStartTime) {
        this.estimatedStartTime = estimatedStartTime;
    }

    @Override
    public DateTimeStamp getJVMTerminationTime() {
        return this.timeOfLastEvent;
    }

    private void setJVMTerminationTime(DateTimeStamp terminationTime) {
        this.timeOfLastEvent = terminationTime;
    }

    @Override
    public double getRuntimeDuration() {
        return this.logDuration;
    }

    private void setRuntimeDuration(double duration) {
        this.logDuration = duration;
    }

    @Override
    public <T extends Aggregation> Optional<T> getAggregation(Class<T> aggregationClass) {
        return Optional.ofNullable(this.aggregatedData.get(aggregationClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyze(List<Aggregator<? extends Aggregation>> registeredAggregators, JVMEventChannel eventBus, DataSourceChannel dataSourceBus) {
        Phaser finishLine = new Phaser();
        Set<EventSource> generatedEvents = this.diary.generatesEvents();
        for (Aggregator<? extends Aggregation> aggregator : registeredAggregators) {
            Aggregation aggregation = aggregator.aggregation();
            this.aggregatedData.put(aggregation.getClass(), aggregation);
            generatedEvents.stream().filter(aggregator::aggregates).forEach(eventSource -> {
                GCToolKit.LOG_DEBUG_MESSAGE(() -> "Registering " + aggregator.getClass().getName() + " with " + String.valueOf((Object)eventSource.toChannel()));
                finishLine.register();
                aggregator.onCompletion(finishLine::arriveAndDeregister);
                JVMEventChannelAggregator eventChannelAggregator = new JVMEventChannelAggregator(eventSource.toChannel(), aggregator);
                eventBus.registerListener(eventChannelAggregator);
            });
        }
        try {
            if (finishLine.getRegisteredParties() > 0) {
                this.dataSource.stream().forEach(message -> dataSourceBus.publish(ChannelName.DATA_SOURCE, message));
                finishLine.awaitAdvance(0);
            } else {
                LOGGER.log(Level.INFO, "No Aggregations have been registered, DataSource will not be analysed.");
                LOGGER.log(Level.INFO, "Is there a module containing Aggregation classes on the module-path");
                LOGGER.log(Level.INFO, "Is GCToolKit::loadAggregationsFromServiceLoader() or GCToolKit::loadAggregation(Aggregation) being invoked?");
            }
            Optional<Aggregation> aggregation = this.aggregatedData.values().stream().findFirst();
            aggregation.ifPresent(terminationRecord -> {
                this.setJVMTerminationTime(terminationRecord.timeOfTerminationEvent());
                this.setRuntimeDuration(terminationRecord.estimatedRuntime());
                this.setEstimatedJVMStartTime(terminationRecord.estimatedStartTime());
            });
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.getMessage(), ioe);
        }
        finally {
            dataSourceBus.close();
            eventBus.close();
        }
    }
}

