/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.MalformedEvent;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.ReferenceGCSummary;
import com.microsoft.gctoolkit.event.SurvivorMemoryPoolSummary;
import com.microsoft.gctoolkit.event.UnifiedCountSummary;
import com.microsoft.gctoolkit.event.UnifiedStatisticalSummary;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCleanupForNextMark;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentClearClaimedMarks;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCompleteCleanup;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCreateLiveData;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentScanRootRegion;
import com.microsoft.gctoolkit.event.g1gc.G1Cleanup;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentMark;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentRebuildRememberedSets;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentUndoCycle;
import com.microsoft.gctoolkit.event.g1gc.G1FullGC;
import com.microsoft.gctoolkit.event.g1gc.G1FullGCNES;
import com.microsoft.gctoolkit.event.g1gc.G1GCConcurrentEvent;
import com.microsoft.gctoolkit.event.g1gc.G1GCPauseEvent;
import com.microsoft.gctoolkit.event.g1gc.G1Mixed;
import com.microsoft.gctoolkit.event.g1gc.G1Remark;
import com.microsoft.gctoolkit.event.g1gc.G1SystemGC;
import com.microsoft.gctoolkit.event.g1gc.G1Young;
import com.microsoft.gctoolkit.event.g1gc.G1YoungInitialMark;
import com.microsoft.gctoolkit.parser.ForwardReference;
import com.microsoft.gctoolkit.parser.jvm.Decorators;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class G1GCForwardReference
extends ForwardReference {
    private static final Logger LOGGER = Logger.getLogger(G1GCForwardReference.class.getName());
    private static int heapRegionSize = 0;
    private static long minHeapSize;
    private static long initialHeapSize;
    private static long maxHeapSize;
    private DateTimeStamp concurrentCycleStartTime;
    private GarbageCollectionTypes pausePhaseDuringConcurrentCycle = null;
    private GarbageCollectionTypes gcType = null;
    private GarbageCollectionTypes concurrentPhase;
    private static final int HEAP_OCCUPANCY_BEFORE_COLLECTION = 0;
    private static final int HEAP_OCCUPANCY_AFTER_COLLECTION = 1;
    private static final int HEAP_SIZE_BEFORE_COLLECTION = 2;
    private static final int HEAP_SIZE_AFTER_COLLECTION = 3;
    private static final int EDEN_OCCUPANCY_BEFORE_COLLECTION = 4;
    private static final int EDEN_OCCUPANCY_AFTER_COLLECTION = 5;
    private static final int EDEN_SIZE_BEFORE_COLLECTION = 6;
    private static final int EDEN_SIZE_AFTER_COLLECTION = 7;
    private static final int SURVIVOR_OCCUPANCY_BEFORE_COLLECTION = 8;
    private static final int SURVIVOR_OCCUPANCY_AFTER_COLLECTION = 9;
    private static final int SURVIVOR_SIZE_BEFORE_COLLECTION = 10;
    private static final int SURVIVOR_SIZE_AFTER_COLLECTION = 11;
    private static final int YOUNG_OCCUPANCY_BEFORE_COLLECTION = 12;
    private static final int YOUNG_OCCUPANCY_AFTER_COLLECTION = 13;
    private static final int YOUNG_SIZE_BEFORE_COLLECTION = 14;
    private static final int YOUNG__SIZE_AFTER_COLLECTION = 15;
    private static final int OLD_OCCUPANCY_BEFORE_COLLECTION = 16;
    private static final int OLD_OCCUPANCY_AFTER_COLLECTION = 17;
    private static final int OLD_SIZE_BEFORE_COLLECTION = 18;
    private static final int OLD_SIZE_AFTER_COLLECTION = 19;
    private static final int HUMONGOUS_OCCUPANCY_BEFORE_COLLECTION = 20;
    private static final int HUMONGOUS_OCCUPANCY_AFTER_COLLECTION = 21;
    private static final int HUMONGOUS_SIZE_BEFORE_COLLECTION = 22;
    private static final int HUMONGOUS_SIZE_AFTER_COLLECTION = 23;
    private static final int ARCHIVE_OCCUPANCY_BEFORE_COLLECTION = 24;
    private static final int ARCHIVE_OCCUPANCY_AFTER_COLLECTION = 25;
    private static final int ARCHIVE_SIZE_BEFORE_COLLECTION = 26;
    private static final int ARCHIVE_SIZE_AFTER_COLLECTION = 27;
    private static final int METASPACE_OCCUPANCY_BEFORE_COLLECTION = 28;
    private static final int METASPACE_OCCUPANCY_AFTER_COLLECTION = 29;
    private static final int METASPACE_SIZE_BEFORE_COLLECTION = 30;
    private static final int METASPACE_SIZE_AFTER_COLLECTION = 31;
    private static final int METASPACE_COMMITTED_BEFORE_COLLECTION = 32;
    private static final int METASPACE_COMMITTED_AFTER_COLLECTION = 33;
    private static final int METASPACE_RESERVED_BEFORE_COLLECTION = 34;
    private static final int METASPACE_RESERVED_AFTER_COLLECTION = 35;
    private static final int CLASSSPACE_OCCUPANCY_BEFORE_COLLECTION = 36;
    private static final int CLASSSPACE_OCCUPANCY_AFTER_COLLECTION = 37;
    private static final int CLASSSPACE_SIZE_BEFORE_COLLECTION = 38;
    private static final int CLASSSPACE_SIZE_AFTER_COLLECTION = 39;
    private static final int CLASSSPACE_COMMITTED_BEFORE_COLLECTION = 40;
    private static final int CLASSSPACE_COMMITTED_AFTER_COLLECTION = 41;
    private static final int CLASSSPACE_RESERVED_BEFORE_COLLECTION = 42;
    private static final int CLASSSPACE_RESERVED_AFTER_COLLECTION = 43;
    private final long[] memoryPoolMeasurment = new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L};
    static final int SOFT_REFERENCE = 0;
    static final int WEAK_REFERENCE = 1;
    static final int PHANTOM_REFERENCE = 2;
    static final int FINAL_REFERENCE = 3;
    static final int JNI_WEAK_REFERENCE = 4;
    static final int CLEANER_REFERENCE = 5;
    private double[] referenceProcessingDuarations = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private int[] referenceCounts = new int[]{-1, -1, -1, -1, -1, -1};
    private static final double NOT_SET = -1.0;
    public static final int PRE_EVACUATE_COLLECTION_SET = 0;
    public static final int EVACUATE_COLLECTION_SET = 1;
    public static final int POST_EVACUATE_COLLECTION_SET = 2;
    public static final int OTHER = 3;
    private final double[] youngCollectionPhases = new double[]{-1.0, -1.0, -1.0, -1.0};
    private final Map<String, Double> preEvacuateCSetPhaseDurations = new ConcurrentHashMap<String, Double>(3);
    private final Map<String, UnifiedStatisticalSummary> evacuateCSetPhaseDurations = new ConcurrentHashMap<String, UnifiedStatisticalSummary>();
    private final Map<String, Double> postEvacuateCSetPhaseDurations = new ConcurrentHashMap<String, Double>();
    private UnifiedCountSummary unifiedCountSummary = null;
    private UnifiedCountSummary terminationAttempts = null;
    private boolean toSpaceExhausted = false;
    private int evacuationWorkersUsed = 0;
    private int evacuationWorkersAvailable = 0;
    private int concurrentMarkWorkersUsed = 0;
    private int concurrentMarkWorkersAvailable = 0;
    private double markFromRootsDuration = -1.0;
    private double precleanDuration = -1.0;
    private boolean aborted = false;
    private static final int OCCUPANCY_BEFORE_OFFSET = 0;
    private static final int OCCUPANCY_AFTER_OFFSET = 1;
    private static final int SIZE_BEFORE_OFFSET = 2;
    private static final int SIZE_AFTER_OFFSET = 3;
    private DateTimeStamp pausePhaseDuringConcurrentCycleTime = null;
    private double pausePhaseDuringConcurrentCycleDuration = -1.0;
    private double finalizeMarkingDuration = -1.0;
    private double systemDictionaryUnloadingDuration = -1.0;
    private int stringTableProcessed = -1;
    private int stringTableRemoved = -1;
    private int symbolTableProcessed = -1;
    private int symbolTableRemoved = -1;
    private double parallelUnloadingDuration = -1.0;
    private final Map<String, Double> fullGCInternalPhases = new ConcurrentHashMap<String, Double>();
    private final Map<Integer, String> fullGCInternalPhaseOrder = new ConcurrentHashMap<Integer, String>();

    public static void setHeapRegionSize(int sizeInMegaBytes) {
        heapRegionSize = sizeInMegaBytes;
    }

    public static int getHeapRegionSize() {
        return heapRegionSize;
    }

    public G1GCForwardReference(Decorators decorators, int gcID) {
        super(decorators, gcID);
    }

    public boolean isConcurrentCycle() {
        return this.gcType == GarbageCollectionTypes.Concurrent_Cycle;
    }

    public static void setMinHeapSize(long minHeapSize) {
        G1GCForwardReference.minHeapSize = minHeapSize;
    }

    public static long getMinHeapSize() {
        return minHeapSize;
    }

    public static void setInitialHeapSize(long initialHeapSize) {
        G1GCForwardReference.initialHeapSize = initialHeapSize;
    }

    public static long getInitialHeapSize() {
        return initialHeapSize;
    }

    public static void setMaxHeapSize(long maxHeapSize) {
        G1GCForwardReference.maxHeapSize = maxHeapSize;
    }

    public static long getMaxHeapSize() {
        return maxHeapSize;
    }

    public void setGcType(GarbageCollectionTypes garbageCollectionType) {
        if (this.gcType != null && this.gcType != garbageCollectionType) {
            throw new IllegalArgumentException("attempting to redefine GC Type from" + this.gcType + " to " + garbageCollectionType);
        }
        this.gcType = garbageCollectionType;
    }

    public GarbageCollectionTypes getGcType() {
        return this.gcType;
    }

    public void setConcurrentPhase(GarbageCollectionTypes phase) {
        this.concurrentPhase = phase;
    }

    public GarbageCollectionTypes getConcurrentPhase() {
        return this.concurrentPhase;
    }

    private boolean setMemoryPoolMeasurement(int index, long value) {
        if (this.memoryPoolMeasurment[index] < 0L) {
            this.memoryPoolMeasurment[index] = value;
            return true;
        }
        return false;
    }

    public boolean setHeapOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(0, value);
    }

    public boolean setHeapOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(1, value);
    }

    public boolean setHeapSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(2, value);
    }

    public boolean setHeapSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(3, value);
    }

    public boolean setEdenOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(4, value);
    }

    public boolean setEdenOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(5, value);
    }

    public boolean setEdenSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(6, value);
    }

    public boolean setEdenSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(7, value);
    }

    public boolean setSurvivorOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(8, value);
    }

    public boolean setSurvivorOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(9, value);
    }

    public boolean setSurvivorSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(10, value);
    }

    public boolean setSurvivorSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(11, value);
    }

    public boolean setYoungOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(12, value);
    }

    public boolean setYoungOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(13, value);
    }

    public boolean setYoungSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(14, value);
    }

    public boolean setYoungSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(15, value);
    }

    public boolean setOldOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(16, value);
    }

    public boolean setOldOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(17, value);
    }

    public boolean setOldSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(18, value);
    }

    public boolean setOldSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(19, value);
    }

    public boolean setHumongousOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(20, value);
    }

    public boolean setHumongousOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(21, value);
    }

    public boolean setHumongousSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(22, value);
    }

    public boolean setHumongousSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(23, value);
    }

    public boolean setMetaspaceOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(28, value);
    }

    public boolean setMetaspaceOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(29, value);
    }

    public boolean setMetaspaceSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(30, value);
    }

    public boolean setMetaspaceSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(31, value);
    }

    public boolean setMetaspaceCommittedBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(32, value);
    }

    public boolean setMetaspaceCommittedAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(33, value);
    }

    public boolean setMetaspaceReservedBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(34, value);
    }

    public boolean setMetaspaceReservedAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(35, value);
    }

    public boolean setClassspaceOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(36, value);
    }

    public boolean setClassspaceOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(37, value);
    }

    public boolean setClassspaceSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(38, value);
    }

    public boolean setClassspaceSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(39, value);
    }

    public boolean setClassspaceCommittedBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(40, value);
    }

    public boolean setClassspaceCommittedAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(41, value);
    }

    public boolean setClassspaceReservedBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(42, value);
    }

    public boolean setClassspaceReservedAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(43, value);
    }

    public void setSoftReferenceProcessingDuation(double duration) {
        this.referenceProcessingDuarations[0] = duration;
    }

    public void setWeakReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[1] = duration;
    }

    public void setPhantomReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[2] = duration;
    }

    public void setFinalReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[3] = duration;
    }

    public void setJniWeakReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[4] = duration;
    }

    public void setCleanerReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[5] = duration;
    }

    public void setReferenceCounts(int soft, int weak, int finalReferenceCount, int phantom) {
        this.referenceCounts[1] = weak;
        this.referenceCounts[0] = soft;
        this.referenceCounts[2] = phantom;
        this.referenceCounts[3] = finalReferenceCount;
    }

    private boolean hasReferenceGCSummary() {
        return this.referenceCounts[0] != -1;
    }

    private ReferenceGCSummary generateReferenceGCSummary() {
        ReferenceGCSummary summary = new ReferenceGCSummary();
        summary.addSoftReferences(this.getStartTime(), this.referenceCounts[0], this.referenceProcessingDuarations[0]);
        summary.addWeakReferences(this.getStartTime(), this.referenceCounts[1], this.referenceProcessingDuarations[1]);
        summary.addPhantomReferences(this.getStartTime(), this.referenceCounts[2], this.referenceProcessingDuarations[2]);
        summary.addFinalReferences(this.getStartTime(), this.referenceCounts[3], this.referenceProcessingDuarations[3]);
        summary.addJNIWeakReferences(this.getStartTime(), this.referenceCounts[4], this.referenceProcessingDuarations[4]);
        return summary;
    }

    public void setPreEvacuateCSetDuration(double duration) {
        this.youngCollectionPhases[0] = duration;
    }

    public void recordPreEvacuateCSetPhaseDuration(String phase, double duration) {
        this.preEvacuateCSetPhaseDurations.put(phase, duration);
    }

    public Stream<String> preEvacuateCSetPhaseNames() {
        return this.preEvacuateCSetPhaseDurations.keySet().stream();
    }

    public double preEvacuateCSetPhaseDuration(String phaseName) {
        return this.preEvacuateCSetPhaseDurations.get(phaseName);
    }

    public void setEvacuationCSetDuration(double duration) {
        this.youngCollectionPhases[1] = duration;
    }

    public void recordEvacuateCSetPhaseDuration(String phase, UnifiedStatisticalSummary stats) {
        this.evacuateCSetPhaseDurations.put(phase, stats);
    }

    public Stream<String> evacuateCSetPhaseNames() {
        return this.evacuateCSetPhaseDurations.keySet().stream();
    }

    public UnifiedStatisticalSummary evacuateCSetPhaseDuration(String phaseName) {
        return this.evacuateCSetPhaseDurations.get(phaseName);
    }

    public void setPostEvacuateCSetDuration(double duration) {
        this.youngCollectionPhases[2] = duration;
    }

    public void recordPostEvacuateCSetPhaseDuration(String phase, double duration) {
        this.postEvacuateCSetPhaseDurations.put(phase, duration);
    }

    public Stream<String> postEvacuateCSetPhaseNames() {
        return this.postEvacuateCSetPhaseDurations.keySet().stream();
    }

    public double postEvacuateCSetPhaseDuration(String phaseName) {
        return this.postEvacuateCSetPhaseDurations.get(phaseName);
    }

    public void setOtherDuration(double duration) {
        this.youngCollectionPhases[3] = duration;
    }

    public void setProcessedBuffersSummary(UnifiedCountSummary summary) {
        this.unifiedCountSummary = summary;
    }

    public void setTerminationAttempts(UnifiedCountSummary summary) {
        this.terminationAttempts = summary;
    }

    public void toSpaceExhausted() {
        this.toSpaceExhausted = true;
    }

    public void evacuationWorkers(int workersUsed, int available) {
        this.evacuationWorkersUsed = workersUsed;
        this.evacuationWorkersAvailable = available;
    }

    public void concurrentMarkWorkers(int used, int available) {
        this.concurrentMarkWorkersUsed = used;
        this.concurrentMarkWorkersAvailable = available;
    }

    public void setMarkFromRootsDuration(double duration) {
        this.markFromRootsDuration = duration;
    }

    public void setPrecleanDuration(double duration) {
        this.precleanDuration = duration;
    }

    public void abortConcurrentMark() {
        this.aborted = true;
    }

    private SurvivorMemoryPoolSummary getSurvivorMemoryPoolSummary() {
        if (this.memoryPoolMeasurment[8] == -1L) {
            return null;
        }
        return new SurvivorMemoryPoolSummary(this.memoryPoolMeasurment[8], this.memoryPoolMeasurment[9], this.memoryPoolMeasurment[11]);
    }

    private MemoryPoolSummary getMemoryPoolSummary(int offset) {
        if (this.memoryPoolMeasurment[offset + 0] == -1L) {
            return null;
        }
        long sizeBeforeCollection = this.memoryPoolMeasurment[offset + 2] > -1L ? this.memoryPoolMeasurment[offset + 2] : this.memoryPoolMeasurment[offset + 3];
        return new MemoryPoolSummary(this.memoryPoolMeasurment[offset + 0], sizeBeforeCollection, this.memoryPoolMeasurment[offset + 1], this.memoryPoolMeasurment[offset + 3]);
    }

    private void fillInMemoryPoolStats(G1GCPauseEvent collection) {
        MemoryPoolSummary heap = this.getMemoryPoolSummary(0);
        MemoryPoolSummary young = this.getMemoryPoolSummary(12);
        MemoryPoolSummary eden = this.getMemoryPoolSummary(4);
        SurvivorMemoryPoolSummary survivor = this.getSurvivorMemoryPoolSummary();
        MemoryPoolSummary tenured = this.getMemoryPoolSummary(16);
        MemoryPoolSummary humongous = this.getMemoryPoolSummary(20);
        if (heap != null && eden != null && survivor != null) {
            collection.addMemorySummary(eden, survivor, heap);
        } else if (eden == null && survivor == null && heap != null) {
            collection.addMemorySummary(heap);
        }
    }

    private void fillInMetaspaceStats(G1GCPauseEvent collection) {
        collection.addPermOrMetaSpaceRecord(this.getMemoryPoolSummary(28));
    }

    private void fullInInternalPhases(G1FullGC collection) {
        String key;
        int index = 0;
        while ((key = this.fullGCInternalPhaseOrder.get(++index)) != null) {
            collection.addInternalPhase(key, this.fullGCInternalPhases.get(key));
        }
    }

    private void fillInPhases(G1Young collection) {
        collection.addPhaseDuration("Pre Evacuate Collection", this.youngCollectionPhases[0]);
        collection.addPhaseDuration("Evacuate Collection", this.youngCollectionPhases[1]);
        collection.addPhaseDuration("Post Evacuate Collection Set", this.youngCollectionPhases[2]);
        collection.addPhaseDuration("Other", this.youngCollectionPhases[3]);
        this.preEvacuateCSetPhaseNames().forEach(name -> collection.addPreEvacuationCollectionPhase(name, this.preEvacuateCSetPhaseDuration((String)name)));
        this.evacuateCSetPhaseNames().forEach(name -> collection.addEvacuationCollectionPhase(name, this.evacuateCSetPhaseDuration((String)name)));
        this.postEvacuateCSetPhaseNames().forEach(name -> collection.addPostEvacuationCollectionPhase(name, this.postEvacuateCSetPhaseDuration((String)name)));
    }

    public void pausePhaseDuringConcurrentCycle(GarbageCollectionTypes pausePhase) {
        this.pausePhaseDuringConcurrentCycle = pausePhase;
    }

    public void pausePhaseDuringConcurrentCycleStart(DateTimeStamp clock) {
        this.pausePhaseDuringConcurrentCycleTime = clock;
    }

    public void pausePhaseDuringConcurrentCycleDuration(double duration) {
        this.pausePhaseDuringConcurrentCycleDuration = duration;
    }

    public void finalizeMarkingDuration(double duration) {
        this.finalizeMarkingDuration = duration;
    }

    public void systemDictionaryUnloadingDuration(double duration) {
        this.systemDictionaryUnloadingDuration = duration;
    }

    public void stringTableProcessedAndRemoved(int processed, int removed) {
        this.stringTableProcessed = processed;
        this.stringTableRemoved = removed;
    }

    public void symbolTableProcessedAndRemoved(int processed, int removed) {
        this.symbolTableProcessed = processed;
        this.symbolTableRemoved = removed;
    }

    public void parallelUnloadingDuration(double duration) {
        this.parallelUnloadingDuration = duration;
    }

    public G1GCConcurrentEvent buildConcurrentPhaseEvent() {
        switch (this.getConcurrentPhase()) {
            case ConcurrentClearClaimedMarks: {
                return new ConcurrentClearClaimedMarks(this.getStartTime(), this.getDuration());
            }
            case ConcurrentScanRootRegions: {
                return new ConcurrentScanRootRegion(this.getStartTime(), this.getDuration());
            }
            case Concurrent_Mark: {
                return this.buildConcurrentMark();
            }
            case ConcurrentCompleteCleanup: {
                return new ConcurrentCompleteCleanup(this.getStartTime(), this.getDuration());
            }
            case ConcurrentCreateLiveData: {
                return new ConcurrentCreateLiveData(this.getStartTime(), this.getDuration());
            }
            case ConcurrentCleanupForNextMark: {
                return new ConcurrentCleanupForNextMark(this.getStartTime(), this.getDuration());
            }
            case G1ConcurrentRebuildRememberedSets: {
                return new G1ConcurrentRebuildRememberedSets(this.getStartTime(), this.getDuration());
            }
        }
        LOGGER.warning("Unrecognized Concurrent Event " + this.getConcurrentPhase());
        return null;
    }

    G1GCConcurrentEvent buildConcurrentUndoCycleEvent() {
        return new G1ConcurrentUndoCycle(this.getConcurrentCycleStartTime(), this.getDuration());
    }

    G1GCPauseEvent buildEvent() throws MalformedEvent {
        if (this.gcType == null) {
            throw new MalformedEvent("G1GC Event type is undefined (null): " + this.toString());
        }
        switch (this.gcType) {
            case Young: {
                return this.buildYoung();
            }
            case Initial_Mark: {
                return this.buildInitialMark();
            }
            case Mixed: {
                return this.buildMixed();
            }
            case G1GCFull: {
                return this.buildFull();
            }
            case Concurrent_Cycle: {
                switch (this.pausePhaseDuringConcurrentCycle) {
                    case G1GCRemark: {
                        return this.buildRemark();
                    }
                    case G1GCCleanup: {
                        return this.buildCleanup();
                    }
                }
                throw new MalformedEvent("Unrecognized (mostly) Concurrent Cycle Pause Event " + this.getConcurrentPhase());
            }
            case G1GCConcurrentUndoCycle: {
                return null;
            }
        }
        throw new MalformedEvent("Unrecognized Event " + this.gcType);
    }

    private G1Young buildYoung(G1Young collection) {
        this.fillInMemoryPoolStats((G1GCPauseEvent)collection);
        this.fillInMetaspaceStats((G1GCPauseEvent)collection);
        this.fillInPhases(collection);
        if (this.toSpaceExhausted) {
            collection.toSpaceExhausted();
        }
        if (this.hasReferenceGCSummary()) {
            collection.add(this.generateReferenceGCSummary());
        }
        collection.addCPUSummary(this.getCPUSummary());
        return collection;
    }

    private G1Young buildYoung() {
        return this.buildYoung(new G1Young(this.getStartTime(), this.getGCCause(), this.getDuration()));
    }

    private G1YoungInitialMark buildInitialMark() {
        return (G1YoungInitialMark)this.buildYoung((G1Young)new G1YoungInitialMark(this.getStartTime(), this.getGCCause(), this.getDuration()));
    }

    private G1Mixed buildMixed() {
        return (G1Mixed)this.buildYoung((G1Young)new G1Mixed(this.getStartTime(), this.getGCCause(), this.getDuration()));
    }

    private G1ConcurrentMark buildConcurrentMark() {
        G1ConcurrentMark concurrentMark = new G1ConcurrentMark(this.getStartTime(), this.getDuration());
        if (this.aborted) {
            concurrentMark.abort();
        }
        if (this.markFromRootsDuration > -1.0) {
            concurrentMark.setMarkFromRootsDuration(this.markFromRootsDuration);
            concurrentMark.setActiveWorkerThreads(this.concurrentMarkWorkersUsed);
            concurrentMark.setAvailableWorkerThreads(this.concurrentMarkWorkersAvailable);
        }
        if (this.precleanDuration > -1.0) {
            concurrentMark.setPrecleanDuration(this.precleanDuration);
        }
        return concurrentMark;
    }

    private G1Remark buildRemark() {
        G1Remark remark = new G1Remark(this.pausePhaseDuringConcurrentCycleTime, 0.0, this.pausePhaseDuringConcurrentCycleDuration);
        if (this.hasReferenceGCSummary()) {
            remark.add(this.generateReferenceGCSummary());
        }
        this.fillInMemoryPoolStats((G1GCPauseEvent)remark);
        remark.addCPUSummary(this.getCPUSummary());
        return remark;
    }

    private G1Cleanup buildCleanup() {
        G1Cleanup cleanup = new G1Cleanup(this.pausePhaseDuringConcurrentCycleTime, this.pausePhaseDuringConcurrentCycleDuration);
        this.fillInMemoryPoolStats((G1GCPauseEvent)cleanup);
        cleanup.addCPUSummary(this.getCPUSummary());
        return cleanup;
    }

    private G1FullGC buildFull() {
        Object collection = this.getGCCause() == GCCause.JAVA_LANG_SYSTEM ? new G1SystemGC(this.getStartTime(), this.getDuration()) : new G1FullGCNES(this.getStartTime(), this.getGCCause(), this.getDuration());
        this.fillInMemoryPoolStats((G1GCPauseEvent)collection);
        this.fullInInternalPhases((G1FullGC)collection);
        if (this.hasReferenceGCSummary()) {
            collection.add(this.generateReferenceGCSummary());
        }
        collection.addCPUSummary(this.getCPUSummary());
        return collection;
    }

    public void fullPhase(int integerGroup, String fullGCInternalPhase, double duration) {
        this.fullGCInternalPhaseOrder.put(integerGroup, fullGCInternalPhase);
        this.fullGCInternalPhases.put(fullGCInternalPhase, duration);
    }

    public String toString() {
        return this.getStartTime().toString() + " : " + (this.gcType == null ? "null" : this.gcType.toString()) + " : " + (this.getGCCause() == null ? "null" : this.getGCCause().toString()) + " : " + this.getDuration();
    }

    public boolean setArchiveOccupancyBeforeCollection(int value) {
        return this.setMemoryPoolMeasurement(24, value);
    }

    public boolean setArchiveOccupancyAfterCollection(int value) {
        return this.setMemoryPoolMeasurement(25, value);
    }

    public boolean setArchiveSizeBeforeCollection(int value) {
        return this.setMemoryPoolMeasurement(26, value);
    }

    public boolean setArchiveSizeAfterCollection(int value) {
        return this.setMemoryPoolMeasurement(27, value);
    }

    public void setConcurrentCycleStartTime(DateTimeStamp clock) {
        this.concurrentCycleStartTime = clock;
    }

    public DateTimeStamp getConcurrentCycleStartTime() {
        return this.concurrentCycleStartTime;
    }
}

