/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.CPUSummary;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.ReferenceGCSummary;
import com.microsoft.gctoolkit.event.jvm.MetaspaceRecord;
import com.microsoft.gctoolkit.event.jvm.PermGenSummary;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import com.microsoft.gctoolkit.parser.SharedPatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class GCLogParser
implements SharedPatterns {
    private static final Logger LOGGER = Logger.getLogger(GCLogParser.class.getName());
    public static final String END_OF_DATA_SENTINEL = "END_OF_DATA_SENTINEL";
    public static final GCParseRule GCID_COUNTER = new GCParseRule("GCID_COUNTER", " GC\\((\\d+)\\) ");
    protected final JVMEventConsumer consumer;
    protected Diary diary;
    private DateTimeStamp clock = new DateTimeStamp(0.0);

    public GCLogParser(Diary diary, JVMEventConsumer consumer) {
        this.diary = diary;
        this.consumer = consumer;
    }

    public DateTimeStamp getClock() {
        return this.clock;
    }

    public void setClock(DateTimeStamp newValue) {
        this.clock = newValue;
    }

    public abstract String getName();

    protected abstract void process(String var1);

    abstract void advanceClock(String var1);

    protected final void advanceClock(DateTimeStamp now) {
        if (now == null) {
            return;
        }
        if (now.before(this.getClock()) && !now.equals((Object)this.getClock())) {
            LOGGER.log(Level.WARNING, "Thread: {0}, abort GC log parsing. Time traveled backwards from {1} to {2}", new Object[]{Thread.currentThread().getName(), this.getClock().toString(), now.toString()});
        }
        this.setClock(now);
    }

    public void receive(String trace) {
        if (!trace.equals(END_OF_DATA_SENTINEL)) {
            this.advanceClock(trace);
        }
        this.process(trace);
    }

    boolean isPreJDK17040() {
        return this.diary.isPre70_40();
    }

    boolean hasPrintGCDetails() {
        return this.diary.isPrintGCDetails();
    }

    MemoryPoolSummary getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(GCLogTrace trace, int offset) {
        MemoryPoolSummary summary = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(offset);
        return summary;
    }

    MemoryPoolSummary getTotalOccupancyWithTotalHeapSizeSummary(GCLogTrace trace, int offset) {
        MemoryPoolSummary summary = trace.getOccupancyWithMemoryPoolSizeSummary(offset);
        return summary;
    }

    GCLogTrace extractReferenceBlock(String line, GCParseRule rule) {
        return rule.parse(line);
    }

    ReferenceGCSummary extractPrintReferenceGC(String line) {
        ReferenceGCSummary summary = new ReferenceGCSummary();
        GCLogTrace trace = this.extractReferenceBlock(line, SOFT_REFERENCE);
        if (trace != null) {
            summary.addSoftReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(3), trace.getDuration());
        }
        if ((trace = this.extractReferenceBlock(line, WEAK_REFERENCE)) != null) {
            summary.addWeakReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(3), trace.getDuration());
        }
        if ((trace = this.extractReferenceBlock(line, FINAL_REFERENCE)) != null) {
            summary.addFinalReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(3), trace.getDuration());
        }
        if ((trace = this.extractReferenceBlock(line, PHANTOM_REFERENCE)) != null) {
            if (trace.groupNotNull(4)) {
                summary.addPhantomReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(3), trace.getIntegerGroup(4), trace.getDuration());
            } else {
                summary.addPhantomReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(3), trace.getDuration());
            }
        }
        if ((trace = this.extractReferenceBlock(line, JNI_REFERENCE)) != null) {
            if (trace.groupNotNull(3)) {
                summary.addJNIWeakReferences(trace.getDateTimeStamp(), trace.getIntegerGroup(3), trace.getDuration());
            } else {
                summary.addJNIWeakReferences(trace.getDateTimeStamp(), trace.getDuration());
            }
        }
        return summary;
    }

    MemoryPoolSummary extractPermOrMetaspaceRecord(String line) {
        MemoryPoolSummary metaDataPool = null;
        GCLogTrace trace = PERM_SPACE_RECORD.parse(line);
        if (trace != null) {
            String type = trace.getGroup(1).trim();
            if ("CMS Perm".equals(type)) {
                metaDataPool = this.extractPermGenRecord(trace);
            } else if ("PS Perm".equals(type)) {
                metaDataPool = this.extractPermGenRecord(trace);
            } else if ("PSPermGen".equals(type)) {
                metaDataPool = this.extractPermGenRecord(trace);
            } else if ("Perm".equals(type)) {
                metaDataPool = this.extractPermGenRecord(trace);
            } else if ("Metaspace".equals(type)) {
                metaDataPool = trace.getGroup(2) != null ? new MetaspaceRecord(trace.toKBytes(2), trace.toKBytes(4), trace.toKBytes(6)) : new MetaspaceRecord(trace.toKBytes(4), trace.toKBytes(4), trace.toKBytes(6));
            }
        } else {
            trace = META_SPACE_RECORD.parse(line);
            if (trace != null) {
                int index = trace.getGroup(1) == null ? 1 : 3;
                metaDataPool = new MetaspaceRecord(trace.toKBytes(index), trace.toKBytes(3), trace.toKBytes(5));
            }
        }
        return metaDataPool;
    }

    MemoryPoolSummary extractPermGenRecord(GCLogTrace trace) {
        int index = trace.getGroup(2) == null ? 2 : 4;
        return new PermGenSummary(trace.getLongGroup(index), trace.getLongGroup(4), trace.getLongGroup(6));
    }

    int extractGCID(String line) {
        GCLogTrace trace = GCID_COUNTER.parse(line);
        return trace != null ? trace.getIntegerGroup(1) : -1;
    }

    CPUSummary extractCPUSummary(String line) {
        GCLogTrace trace = CPU_BREAKDOWN.parse(line);
        if (trace != null) {
            return new CPUSummary(trace.getDoubleGroup(1), trace.getDoubleGroup(2), trace.getDoubleGroup(3));
        }
        return null;
    }
}

