/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.CPUSummary;
import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.ReferenceGCSummary;
import com.microsoft.gctoolkit.event.generational.BinaryTreeDictionary;
import com.microsoft.gctoolkit.event.generational.CMSRemark;
import com.microsoft.gctoolkit.event.generational.ConcurrentModeFailure;
import com.microsoft.gctoolkit.event.generational.ConcurrentModeInterrupted;
import com.microsoft.gctoolkit.event.generational.DefNew;
import com.microsoft.gctoolkit.event.generational.FullGC;
import com.microsoft.gctoolkit.event.generational.InitialMark;
import com.microsoft.gctoolkit.event.generational.PSFullGC;
import com.microsoft.gctoolkit.event.generational.PSYoungGen;
import com.microsoft.gctoolkit.event.generational.ParNew;
import com.microsoft.gctoolkit.event.generational.ParNewPromotionFailed;
import com.microsoft.gctoolkit.event.generational.SystemGC;
import com.microsoft.gctoolkit.event.generational.YoungGC;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.ICMSPatterns;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import com.microsoft.gctoolkit.parser.JVMPatterns;
import com.microsoft.gctoolkit.parser.ParallelPatterns;
import com.microsoft.gctoolkit.parser.PreUnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.SerialPatterns;
import com.microsoft.gctoolkit.parser.SimplePatterns;
import com.microsoft.gctoolkit.parser.TenuredPatterns;
import com.microsoft.gctoolkit.parser.collection.MRUQueue;
import com.microsoft.gctoolkit.parser.unified.UnifiedG1GCPatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GenerationalHeapParser
extends PreUnifiedGCLogParser
implements SimplePatterns,
ICMSPatterns,
SerialPatterns,
ParallelPatterns {
    private static final Logger LOGGER = Logger.getLogger(GenerationalHeapParser.class.getName());
    private ParNew parNewForwardReference;
    private GarbageCollectionTypes garbageCollectionTypeForwardReference;
    private GCCause gcCauseForwardReference;
    private DateTimeStamp scavengeTimeStamp;
    private DateTimeStamp fullGCTimeStamp;
    private DateTimeStamp remarkTimeStamp;
    private MemoryPoolSummary youngMemoryPoolSummaryForwardReference;
    private MemoryPoolSummary tenuredForwardReference;
    private MemoryPoolSummary heapForwardReference;
    private MemoryPoolSummary metaSpaceForwardReference;
    private double scavengeDurationForwardReference;
    private ReferenceGCSummary referenceGCForwardReference;
    private CPUSummary scavengeCPUSummaryForwardReference;
    private int[] promotionFailureSizesForwardReference;
    private long totalFreeSpaceForwardReference;
    private long maxChunkSizeForwardReference;
    private int numberOfBlocksForwardReference;
    private long averageBlockSizeForwardReference;
    private int treeHeightForwardReference;
    private final boolean debugging = Boolean.getBoolean("microsoft.debug");
    private boolean expectRemark = false;
    private final MRUQueue<GCParseRule, BiConsumer<GCLogTrace, String>> parseRules = new MRUQueue();
    private final GCParseRule weakReferenceFragmentRule;

    public GenerationalHeapParser(Diary diary, JVMEventConsumer consumer) {
        super(diary, consumer);
        this.parseRules.put(DEFNEW, this::defNew);
        this.parseRules.put(DEFNEW_TENURING, this::defNewWithTenuring);
        this.parseRules.put(SERIAL_FULL, this::serialFull);
        this.parseRules.put(SERIAL_FULL80, this::serialFull80);
        this.parseRules.put(PARNEW, this::parNew);
        this.parseRules.put(PARNEW_TENURING, this::parNewWithTenuring);
        this.parseRules.put(PARNEW_CONCURRENT_MODE_END, this::parNewConcurrentModeEnd);
        this.parseRules.put(PARNEW_CARDTABLE, this::parNewCardTable);
        this.parseRules.put(PARNEW_TO_CMF_PERM, this::parNewToConcurrentModeFailure);
        this.parseRules.put(PARNEW_TO_CMF_META, this::parNewToConcurrentModeFailure);
        this.parseRules.put(PARNEW_REFERENCE, this::parNewReference);
        this.parseRules.put(PARNEW_REFERENCE_SPLIT, this::parNewReferenceSplit);
        this.parseRules.put(JVMPatterns.TLAB_START, this::gcSplitByTLAB);
        this.parseRules.put(PARNEW_REFERENCE_SPLIT_BY_TLAB, this::parNewReferenceSplitByTLAB);
        this.parseRules.put(DEFNEW_REFERENCE, this::defNewReference);
        this.parseRules.put(PARNEW_PROMOTION_FAILED, this::parNewPromotionFailed);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_DETAILS, this::parNewPromotionFailedDetails);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_REFERENCE, this::parNewPromotionFailedReference);
        this.parseRules.put(FLOATING_REFERENCE, this::parNewFloatingReference);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_TENURING, this::parNewPromotionFailedTenuring);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_IN_CMS_PHASE, this::parNewPromotionFailedInConcurrentMarkSweepPhase);
        this.parseRules.put(CMS_BAILING_TO_FOREGROUND, this::concurrentMarkSweepBailingToForeground);
        this.parseRules.put(PROMOTION_FAILED_TO_FULL, this::promotionFailedToFull);
        this.parseRules.put(PARNEW_PLAB, this::parNewPLAB);
        this.parseRules.put(PLAB_ENTRY, this::plabEntry);
        this.parseRules.put(PLAB_SUMMARY, this::plabSummary);
        this.parseRules.put(FULLGC_FLS_BEFORE, this::fullGCFLSBefore);
        this.parseRules.put(PARNEW_FLS_BEFORE, this::parNewFLSBefore);
        this.parseRules.put(PARNEW_FLS_AFTER, this::parNewFLSAfter);
        this.parseRules.put(PARNEW_FLS_BODY, this::parNewFLSBody);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_DETAILS_AFTER, this::parNewConcurrentModeFailureFLSAfter);
        this.parseRules.put(PARNEW_FLS_TIME, this::parNewFLSTime);
        this.parseRules.put(FLS_HEADER, this::parNewFLSHeader);
        this.parseRules.put(FLS_SEPARATOR, this::parNewFLSSeparator);
        this.parseRules.put(FLS_TOTAL_FREE_SPACE, this::parNewFLSTotalFreeSpace);
        this.parseRules.put(FLS_MAX_CHUNK_SIZE, this::parNewFLSMaxChunkSize);
        this.parseRules.put(FLS_NUMBER_OF_BLOCKS, this::parNewFLSNumberOfBlocks);
        this.parseRules.put(FLS_AVERAGE_BLOCK_SIZE, this::parNewFLSAveBlockSize);
        this.parseRules.put(FLS_TREE_HEIGHT, this::parNewFLSTreeHeight);
        this.parseRules.put(FLS_LARGE_BLOCK_PROXIMITY, this::flsLargeBlockProximity);
        this.parseRules.put(FLS_LARGE_BLOCK, this::flsLargeBlock);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_TIME_ABORT_PRECLEAN, this::parNewPromotionFailedTimeAbortPreclean);
        this.parseRules.put(PARNEW_PROMOTION_FAILED_CONCURRENT_PHASE, this::parNewPromotionFailedConcurrentPhase);
        this.parseRules.put(CORRUPTED_PARNEW_CONCURRENT_PHASE, this::corruptedParNewConcurrentPhase);
        this.parseRules.put(CORRUPTED_PARNEW_BODY, this::corruptedParNewBody);
        this.parseRules.put(CONCURRENT_PHASE_START, this::concurrentPhaseStart);
        this.parseRules.put(CONCURRENT_PHASE_END, this::concurrentPhaseEnd);
        this.parseRules.put(ABORT_PRECLEAN_DUE_TO_TIME_CLAUSE, this::abortPrecleanDueToTimeClause);
        this.parseRules.put(INITIAL_MARK, this::initialMark);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK, this::scavengeBeforeRemark);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK_TENURING, this::scavengeBeforeRemarkTenuring);
        this.parseRules.put(PARALLEL_REMARK_WEAK_REF, this::remarkAt12);
        this.parseRules.put(PARALLEL_REMARK_CLASS_UNLOADING, this::remarkAt21);
        this.parseRules.put(REMARK_PARNEW_PROMOTION_FAILED, this::remarkParNewPromotionFailed);
        this.parseRules.put(PARALLEL_REMARK_STRING_SYMBOL, this::parallelRemarkStringSymbolClause);
        this.parseRules.put(PARALLEL_REMARK_WEAK_CLASS_SYMBOL_STRING, this::remarkAt21);
        this.parseRules.put(PARALLEL_REMARK_WEAK_STRING, this::remarkAt15);
        this.parseRules.put(PARALLEL_RESCAN, this::parallelRescan);
        this.parseRules.put(REMARK, this::remarkAt11);
        this.parseRules.put(PARALLEL_RESCAN_V2, this::remarkAt11);
        this.parseRules.put(PARALLEL_RESCAN_WEAK_CLASS_SCRUB, this::remarkAt13);
        this.parseRules.put(REMARK_DETAILS, this::remarkAt1);
        this.parseRules.put(SERIAL_REMARK_SCAN_BREAKDOWNS, this::remarkAt15);
        this.parseRules.put(REMARK_DETAILS, this::remarkAt1);
        this.parseRules.put(SERIAL_REMARK_SCAN_BREAKDOWNS, this::remarkAt15);
        this.parseRules.put(REMARK_REFERENCE_PROCESSING, this::recordRemarkWithReferenceProcessing);
        this.parseRules.put(TENURING_DETAILS, this::tenuringDetails);
        this.parseRules.put(RESCAN_WEAK_CLASS_SYMBOL_STRING, this::remarkAt11);
        this.parseRules.put(CONCURRENT_MODE_FAILURE_DETAILS, this::concurrentModeFailureDetails);
        this.parseRules.put(CONCURRENT_MODE_FAILURE_DETAILS_META, this::concurrentModeFailureDetails);
        this.parseRules.put(PARNEW_DETAILS_CONCURRENT_MODE_FAILURE_PERM, this::parNewDetailsConcurrentModeFailure);
        this.parseRules.put(PARNEW_DETAILS_CONCURRENT_MODE_FAILURE_META, this::parNewDetailsConcurrentModeFailure);
        this.parseRules.put(PARNEW_DETAILS_PROMOTION_FAILED_WITH_CMS_PHASE, this::parNewDetailsPromotionFailedWithConcurrentMarkSweepPhase);
        this.parseRules.put(PARNEW_DETAILS_WITH_CONCURRENT_MODE_FAILURE, this::parNewDetailsWithConcurrentModeFailure);
        this.parseRules.put(CONCURRENT_MODE_FAILURE_REFERENCE, this::concurrentModeFailureReference);
        this.parseRules.put(iCMS_PARNEW_DEFNEW_TENURING_DETAILS, this::iCMSParNewDefNewTenuringDetails);
        this.parseRules.put(iCMS_CONCURRENT_MODE_FAILURE, this::iCMSConcurrentModeFailure);
        this.parseRules.put(iCMS_CONCURRENT_MODE_FAILURE_META, this::iCMSConcurrentModeFailure);
        this.parseRules.put(iCMS_CMF_DUIRNG_PARNEW_DEFNEW_DETAILS, this::iCMSConcurrentModeFailureDuringParNewDefNewDetails);
        this.parseRules.put(FULL_GC_INTERRUPTS_CONCURRENT_PHASE, this::fullGCInterruptsConcurrentPhase);
        this.parseRules.put(FULL_PARNEW_START, this::fullParNewStart);
        this.parseRules.put(FULL_GC_REFERENCE_CMF, this::fullGCReferenceConcurrentModeFailure);
        this.parseRules.put(iCMS_PARNEW, this::iCMSParNew);
        this.parseRules.put(iCMS_PARNEW_PROMOTION_FAILURE_RECORD, this::iCMSParNewPromotionFailureRecord);
        this.parseRules.put(iCMS_PARNEW_PROMOTION_FAILURE, this::iCMSParNewPromotionFailure);
        this.parseRules.put(FULL_GC_ICMS, this::fullGCiCMS);
        this.parseRules.put(iCMS_PARNEW_DEFNEW_TENURING_DETAILS, this::iCMSParNewDefNewTenuringDetails);
        this.parseRules.put(iCMS_FULL, this::iCMSFullGC);
        this.parseRules.put(iCMS_PROMOTION_FAILED, this::iCMSPromotionFailed);
        this.parseRules.put(iCMS_PROMOTION_FAILED_PERM, this::iCMSPromotionFailedPermMeta);
        this.parseRules.put(iCMS_PROMOTION_FAILED_META, this::iCMSPromotionFailedPermMeta);
        this.parseRules.put(iCMS_MISLABELED_FULL, this::iCMSMislabeledFull);
        this.parseRules.put(iCMS_FULL_AFTER_CONCURRENT_MODE_FAILURE, this::iCMSFullAfterConcurrentModeFailure);
        this.parseRules.put(iCMS_FULL_AFTER_CONCURRENT_MODE_FAILURE_META, this::iCMSFullAfterConcurrentModeFailure);
        this.parseRules.put(iCMS_CONCURRENT_MODE_INTERRUPTED, this::iCMSConcurrentModeInterrupted);
        this.parseRules.put(PS_FULL_GC_META, this::psFullGCMeta);
        this.parseRules.put(PS_FULL_GC_V2_META, this::psFullGCV2Meta);
        this.parseRules.put(CMS_FULL_META, this::cmsFullPermOrMeta);
        this.parseRules.put(FULL_PARNEW_CMF_META, this::fullParNewConcurrentModeFailureMeta);
        this.parseRules.put(FULL_PARNEW_CMF_PERM, this::fullParNewConcurrentModeFailurePerm);
        this.parseRules.put(PARNEW_CONCURRENT_MODE_FAILURE_PERM, this::parNewConcurrentModeFailurePerm);
        this.parseRules.put(PARNEW_CONCURRENT_MODE_FAILURE_META, this::parNewConcurrentModeFailureMeta);
        this.parseRules.put(PS_FULL_GC_V2_PERM, this::psFullGCV2Perm);
        this.parseRules.put(PS_FULL_GC_PERM, this::psFullGCPerm);
        this.parseRules.put(CMS_FULL_PERM, this::cmsFullPermOrMeta);
        this.parseRules.put(CMS_FULL_PERM_META_REFERENCE, this::cmsFullPermOrMeta);
        this.parseRules.put(PARNEW_NO_DETAILS, this::parNewNoDetails);
        this.parseRules.put(YOUNG_NO_DETAILS, this::youngNoDetails);
        this.parseRules.put(CMS_NO_DETAILS, this::cmsNoDetails);
        this.parseRules.put(FULL_NO_GC_DETAILS, this::fullNoGCDetails);
        this.parseRules.put(PARNEW_START, this::parNewStart);
        this.parseRules.put(GC_START, this::gcStart);
        this.parseRules.put(YOUNG_SPLIT_NO_DETAILS, this::youngSplitNoDetails);
        this.parseRules.put(CMF_SIMPLE, this::cmfSimple);
        this.parseRules.put(DEFNEW_DETAILS, this::defNewDetails);
        this.parseRules.put(PRECLEAN_REFERENCE_PAR_NEW_REFERENCE, this::preCleanReferenceParNewReference);
        this.parseRules.put(PSYOUNGGEN, this::psYoungGen);
        this.parseRules.put(PSYOUNGGEN_PROMOTION_FAILED, this::psYoungGen);
        this.parseRules.put(PSFULL, this::psFull);
        this.parseRules.put(PSYOUNGGEN_NO_DETAILS, this::psYoungNoDetails);
        this.parseRules.put(PSYOUNGGEN_REFERENCE_SPLIT, this::psYoungGenReferenceProcessingSplit);
        this.parseRules.put(PSYOUNGGEN_REFERENCE, this::psYoungGenReferenceProcessing);
        this.parseRules.put(PS_TENURING_START, this::psTenuringStart);
        this.parseRules.put(PSFULL_SPLIT, this::psFullSPlit);
        this.parseRules.put(PS_FULL_REFERENCE_SPLIT, this::psFullReferenceSplit);
        this.parseRules.put(PS_FULL_REFERENCE, this::psFullReference);
        this.parseRules.put(PS_DETAILS_WITH_TENURING, this::psDetailsWithTenuring);
        this.parseRules.put(PS_FAILURE, this::psFailure);
        this.parseRules.put(PSYOUNG_ADAPTIVE_SIZE_POLICY, this::psYoungAdaptiveSizePolicy);
        this.parseRules.put(PSOLD_ADAPTIVE_SIZE_POLICY, this::psFullAdaptiveSizePolicy);
        this.parseRules.put(PSYOUNG_DETAILS_FLOATING, this::psYoungDetailsFloating);
        this.parseRules.put(PSFULL_ADAPTIVE_SIZE, this::psFullAdaptiveSize);
        this.parseRules.put(PS_FULL_BODY_FLOATING, this::psFullBodyFloating);
        this.parseRules.put(FULL_REFERENCE_ADAPTIVE_SIZE, this::psFullReferenceAdaptiveSize);
        this.parseRules.put(PS_PROMOTION_FAILED, this::psPromotionFailed);
        this.parseRules.put(RESCAN_SPLIT_UNLOADING_STRING, this::rescanSplitUnloadingString);
        this.parseRules.put(PARNEW_CONCURRENT_PHASE_CARDS, this::parNewConcurrentPhaseCards);
        this.parseRules.put(CONC_PHASE_YIELDS, this::concurrentPhaseYields);
        this.parseRules.put(PRECLEAN_TIMED_OUT_WITH_CARDS, this::precleanTimedoutWithCards);
        this.parseRules.put(PARNEW_SHOULD_CONCURRENT_COLLECT, this::parNewShouldConcurrentCollect);
        this.parseRules.put(SHOULD_CONCURRENT_COLLECT, this::shouldCollectConcurrent);
        this.parseRules.put(REMARK_SPLIT_BY_DEBUG, this::remarkSplitByDebug);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK_PRINT_HEAP_AT_GC, this::scavengeBeforeRemarkPrintHeapAtGC);
        this.parseRules.put(SPLIT_REMARK_REFERENCE_BUG, this::splitRemarkReferenceWithWeakReferenceSplitBug);
        this.parseRules.put(SPLIT_REMARK_REFERENCE, this::splitRemarkReference);
        this.parseRules.put(PSYOUNG_ADAPTIVE_SIZE_POLICY_START, this::psYoungAdaptivePolicySizeStart);
        this.parseRules.put(PS_ADAPTIVE_SIZE_POLICY_BODY, this::psYoungAdaptivePolicySizeBody);
        this.parseRules.put(ADAPTIVE_SIZE_POLICY_BODY, this::adaptivePolicySizeBody);
        this.parseRules.put(ADAPTIVE_SIZE_POLICY_STOP, this::adaptiveSizePolicyStop);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK_REFERENCE, this::scavengeBeforeRemarkReference);
        this.parseRules.put(SCAVENGE_BEFORE_REMARK_REFERENCE_SPLIT, this::scavengeBeforeRemarkReferenceSplit);
        this.parseRules.put(PARNEW_TO_CONCURRENT_MODE_FAILURE, this::parNewToPsudoConcurrentModeFailure);
        this.parseRules.put(SERIAL_FULL_REFERENCE, this::serialFullReference);
        this.parseRules.put(PSFULL_ERGONOMICS_PHASES, this::psFullErgonomicsPhases);
        this.parseRules.put(PSFULL_REFERENCE_PHASE, this::psFullReferencePhase);
        this.parseRules.put(SPLIT_PARNEW_PROMOTION_FAILED_IN_CMS_PHASE, this::parNewPromotionFailedInConcurrentMarkSweepPhase);
        this.parseRules.put(FULL_SPLIT_BY_CONCURRENT_PHASE, this::fullSplitByConcurrentPhase);
        this.parseRules.put(CMF_LARGE_BLOCK, this::concurrentModeFailureSplitByLargeBlock);
        this.parseRules.put(UnifiedG1GCPatterns.WEAK_PROCESSING, this::noop);
        this.parseRules.put(new GCParseRule("END_OF_DATA_SENTINEL", "END_OF_DATA_SENTINEL"), this::endOfFile);
        this.weakReferenceFragmentRule = new GCParseRule("weakReferenceFragmentRule", "\\], (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms)");
    }

    @Override
    public String getName() {
        return "GenerationalHeapParser";
    }

    @Override
    protected void process(String line) {
        if (this.ignoreFrequentButUnwantedEntries(line)) {
            return;
        }
        try {
            Optional<AbstractMap.SimpleEntry> optional = this.parseRules.keys().stream().map(rule -> new AbstractMap.SimpleEntry<GCParseRule, GCLogTrace>((GCParseRule)rule, rule.parse(line))).filter(tuple -> tuple.getValue() != null).findFirst();
            if (optional.isPresent()) {
                AbstractMap.SimpleEntry ruleAndTrace = optional.get();
                this.parseRules.get(ruleAndTrace.getKey()).accept((GCLogTrace)ruleAndTrace.getValue(), line);
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.throwing(this.getName(), "process", t);
        }
        this.log(line);
    }

    private boolean ignoreFrequentButUnwantedEntries(String line) {
        if (JVMPatterns.APPLICATION_TIME.parse(line) != null) {
            return true;
        }
        if (JVMPatterns.SIMPLE_APPLICATION_TIME.parse(line) != null) {
            return true;
        }
        if (JVMPatterns.APPLICATION_STOP_TIME.parse(line) != null) {
            return true;
        }
        if (JVMPatterns.APPLICATION_STOP_TIME_WITH_STOPPING_TIME.parse(line) != null) {
            return true;
        }
        if (JVMPatterns.SIMPLE_APPLICATION_STOP_TIME.parse(line) != null) {
            return true;
        }
        if (TenuredPatterns.TENURING_SUMMARY.parse(line) != null) {
            return true;
        }
        if (TenuredPatterns.TENURING_AGE_BREAKDOWN.parse(line) != null) {
            return true;
        }
        if (line.startsWith("TLAB: gc thread: ")) {
            return true;
        }
        if (line.startsWith("TLAB totals: thrds: ")) {
            return true;
        }
        if (line.startsWith("{Heap before")) {
            return true;
        }
        if (line.equals("}")) {
            return true;
        }
        if (line.startsWith("Heap after")) {
            return true;
        }
        if (line.startsWith("PSYoungGen")) {
            return true;
        }
        if (line.startsWith("ParOldGen")) {
            return true;
        }
        if (line.startsWith("PSOldGen")) {
            return true;
        }
        if (line.startsWith("PSPermGen")) {
            return true;
        }
        if (line.startsWith("object space")) {
            return true;
        }
        if (line.startsWith("eden space")) {
            return true;
        }
        if (line.startsWith("from space")) {
            return true;
        }
        if (line.startsWith("to   space")) {
            return true;
        }
        if (!line.contains("[0xffff") || line.endsWith("000)")) {
            // empty if block
        }
        if (line.startsWith("Finished ")) {
            return true;
        }
        if (line.startsWith("GC locker: Trying a full collection because scavenge failed")) {
            return true;
        }
        if (line.startsWith("Java HotSpot(TM)")) {
            return true;
        }
        if (line.startsWith("OpenJDK 64")) {
            return true;
        }
        if (line.startsWith("Memory: ")) {
            return true;
        }
        if (line.startsWith("CommandLine flags: ")) {
            return true;
        }
        if (line.startsWith("/proc/meminfo")) {
            return true;
        }
        return line.startsWith("avg_survived_padded_avg");
    }

    public void endOfFile(GCLogTrace trace, String line) {
        this.record((JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
    }

    public void defNew(GCLogTrace trace, String line) {
        DefNew defNew = new DefNew(this.getClock(), trace.gcCause(), trace.getDuration());
        defNew.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(7), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 14));
        defNew.add(this.extractCPUSummary(line));
        this.record((JVMEvent)defNew);
    }

    public void defNewDetails(GCLogTrace trace, String line) {
        DefNew defNew = new DefNew(this.getClock(), trace.gcCause(), trace.getDuration());
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 37);
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(30);
        defNew.add(young, heap.minus(young), heap);
        defNew.add(this.extractCPUSummary(line));
        defNew.add(this.extractPrintReferenceGC(line));
        this.record((JVMEvent)defNew);
    }

    public void defNewWithTenuring(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.DefNew;
    }

    public void serialFull(GCLogTrace trace, String line) {
        FullGC collection = new FullGC(this.getClock(), trace.gcCause(), trace.getDuration());
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 12);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void serialFull80(GCLogTrace trace, String line) {
        FullGC collection = new FullGC(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 12);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void parNew(GCLogTrace trace, String line) {
        ParNew collection = new ParNew(this.getClock(), trace.gcCause(1), trace.getDoubleGroup(20));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(7), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 14));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    private void parNewWithTenuring(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
    }

    private void fullGCFLSBefore(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.FullGC;
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    private void parNewFLSBefore(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    private void parNewFLSAfter(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(3);
        this.heapForwardReference = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 10);
    }

    private void parNewFLSBody(GCLogTrace trace, String line) {
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.heapForwardReference = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
    }

    private void parNewConcurrentModeFailureFLSAfter(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == null) {
            this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ConcurrentModeFailure;
        }
        if (this.gcCauseForwardReference == null) {
            this.gcCauseForwardReference = GCCause.LAST_GC_CAUSE;
        }
        this.tenuredForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.heapForwardReference = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        this.metaSpaceForwardReference = this.extractPermOrMetaspaceRecord(line);
    }

    private void parNewFLSTime(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNewPromotionFailed) {
            ParNewPromotionFailed parNew = new ParNewPromotionFailed(this.getClock(), this.gcCauseForwardReference, this.scavengeDurationForwardReference);
            MemoryPoolSummary heap = new MemoryPoolSummary(this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection());
            parNew.add(this.youngMemoryPoolSummaryForwardReference, heap);
            parNew.add(this.scavengeCPUSummaryForwardReference);
            ConcurrentModeFailure cmf = new ConcurrentModeFailure(this.getClock().add(this.scavengeDurationForwardReference), GCCause.CMS_FAILURE, trace.getDuration());
            cmf.add(this.heapForwardReference.minus(this.tenuredForwardReference), this.tenuredForwardReference, this.heapForwardReference);
            cmf.add(this.extractCPUSummary(line));
            cmf.addBinaryTreeDictionary(new BinaryTreeDictionary(this.totalFreeSpaceForwardReference, this.maxChunkSizeForwardReference, this.numberOfBlocksForwardReference, this.averageBlockSizeForwardReference, this.treeHeightForwardReference));
            this.record((JVMEvent)parNew);
            this.record((JVMEvent)cmf);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getPauseTime());
            collection.add(this.youngMemoryPoolSummaryForwardReference, this.heapForwardReference);
            collection.add(this.extractCPUSummary(line));
            collection.addBinaryTreeDictionary(new BinaryTreeDictionary(this.totalFreeSpaceForwardReference, this.maxChunkSizeForwardReference, this.numberOfBlocksForwardReference, this.averageBlockSizeForwardReference, this.treeHeightForwardReference));
            this.record((JVMEvent)collection);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ConcurrentModeFailure) {
            MemoryPoolSummary heap = new MemoryPoolSummary(this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection(), this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection());
            double portionOfPauseToSubtract = this.parNewForwardReference == null ? 0.0 : this.parNewForwardReference.getDuration();
            ConcurrentModeFailure concurrentModeFailure = new ConcurrentModeFailure(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getPauseTime() - portionOfPauseToSubtract);
            concurrentModeFailure.add(this.heapForwardReference.minus(this.tenuredForwardReference), this.tenuredForwardReference, this.heapForwardReference);
            concurrentModeFailure.add(this.extractCPUSummary(line));
            concurrentModeFailure.add(this.metaSpaceForwardReference);
            concurrentModeFailure.addBinaryTreeDictionary(new BinaryTreeDictionary(this.totalFreeSpaceForwardReference, this.maxChunkSizeForwardReference, this.numberOfBlocksForwardReference, this.averageBlockSizeForwardReference, this.treeHeightForwardReference));
            if (this.parNewForwardReference != null) {
                this.parNewForwardReference.add(this.youngMemoryPoolSummaryForwardReference, heap.minus(this.youngMemoryPoolSummaryForwardReference), heap);
                this.record((JVMEvent)this.parNewForwardReference);
            }
            this.record((JVMEvent)concurrentModeFailure);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC) {
            MemoryPoolSummary heap = new MemoryPoolSummary(this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection(), this.heapForwardReference.getOccupancyBeforeCollection(), this.heapForwardReference.getSizeAfterCollection());
            FullGC fullGc = new FullGC(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDuration());
            fullGc.add(heap);
            this.record((JVMEvent)fullGc);
        } else {
            trace.notYetImplemented();
        }
    }

    private void parNewFLSHeader(GCLogTrace trace, String line) {
    }

    private void parNewFLSSeparator(GCLogTrace trace, String line) {
    }

    private void parNewFLSTotalFreeSpace(GCLogTrace trace, String line) {
        this.totalFreeSpaceForwardReference = trace.getLongGroup(1);
    }

    private void parNewFLSMaxChunkSize(GCLogTrace trace, String line) {
        this.maxChunkSizeForwardReference = trace.getLongGroup(1);
    }

    private void parNewFLSNumberOfBlocks(GCLogTrace trace, String line) {
        this.numberOfBlocksForwardReference = trace.getIntegerGroup(1);
    }

    private void parNewFLSAveBlockSize(GCLogTrace trace, String line) {
        this.averageBlockSizeForwardReference = trace.getLongGroup(1);
    }

    private void parNewFLSTreeHeight(GCLogTrace trace, String line) {
        this.treeHeightForwardReference = trace.getIntegerGroup(1);
    }

    private void flsLargeBlockProximity(GCLogTrace trace, String line) {
    }

    private void flsLargeBlock(GCLogTrace trace, String line) {
    }

    private void noop(GCLogTrace trace, String line) {
    }

    public void parNewConcurrentModeEnd(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.scavengeDurationForwardReference = trace.getDoubleGroup(12);
        this.parNewForwardReference = new ParNew(this.scavengeTimeStamp, this.garbageCollectionTypeForwardReference, this.gcCauseForwardReference, this.scavengeDurationForwardReference);
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
    }

    public void parNewCardTable(GCLogTrace trace, String line) {
        trace.notYetImplemented();
    }

    public void parNewToConcurrentModeFailure(GCLogTrace trace, String line) {
        ConcurrentModeFailure collection = new ConcurrentModeFailure(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6), trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(15), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 22));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void parNewToPsudoConcurrentModeFailure(GCLogTrace trace, String line) {
        ConcurrentModeFailure collection = new ConcurrentModeFailure(this.scavengeTimeStamp, GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void parNewReference(GCLogTrace trace, String line) {
        ParNew gcEvent = new ParNew(trace.getDateTimeStamp(), trace.gcCause(), trace.getDuration());
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(30);
        MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(37);
        gcEvent.add(young, heap.minus(young), heap);
        gcEvent.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        gcEvent.add(this.extractCPUSummary(line));
        this.record((JVMEvent)gcEvent);
    }

    public void parNewReferenceSplit(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void gcSplitByTLAB(GCLogTrace trace, String line) {
        if (line.contains("[GC[YG occupancy")) {
            this.remarkTimeStamp = this.getClock();
        }
        this.scavengeTimeStamp = this.getClock();
    }

    public void parNewReferenceSplitByTLAB(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void defNewReference(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.DefNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void parNewPromotionFailed(GCLogTrace trace, String line) {
        ParNewPromotionFailed collection = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 13);
        collection.add(young, heap);
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void parNewPromotionFailedDetails(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNewPromotionFailed;
        this.gcCauseForwardReference = GCCause.PROMOTION_FAILED;
        ArrayList<Integer> blocks = new ArrayList<Integer>();
        GCLogTrace block = PARNEW_PROMOTION_FAILURE_SIZE_BLOCK.parse(line);
        do {
            blocks.add(block.getIntegerGroup(1));
        } while (block.hasNext());
        this.promotionFailureSizesForwardReference = new int[blocks.size()];
        for (int index = 0; index < blocks.size(); ++index) {
            this.promotionFailureSizesForwardReference[index] = (Integer)blocks.get(index);
        }
        GCLogTrace memorySummary = BEFORE_AFTER_CONFIGURED_PAUSE_RULE.parse(line);
        this.youngMemoryPoolSummaryForwardReference = memorySummary.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.scavengeDurationForwardReference = memorySummary.getDuration();
    }

    public void parNewPromotionFailedReference(GCLogTrace trace, String line) {
        this.parNewForwardReference = new ParNew(trace.getDateTimeStamp(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(35));
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyWithMemoryPoolSizeSummary(29);
        this.parNewForwardReference.add(this.extractPrintReferenceGC(line));
    }

    public void parNewFloatingReference(GCLogTrace trace, String line) {
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void parNewPromotionFailedTenuring(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNewPromotionFailed;
        this.gcCauseForwardReference = GCCause.PROMOTION_FAILED;
    }

    public void parNewPromotionFailedInConcurrentMarkSweepPhase(GCLogTrace trace, String line) {
        int offset = trace.groupCount() == 16 ? 2 : 0;
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNewPromotionFailed;
        this.gcCauseForwardReference = GCCause.PROMOTION_FAILED;
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5 - offset);
        this.scavengeDurationForwardReference = trace.getDoubleGroup(11 - offset);
        this.scavengeCPUSummaryForwardReference = this.extractCPUSummary(line);
    }

    public void concurrentMarkSweepBailingToForeground(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
        this.scavengeDurationForwardReference = trace.getDoubleGroup(trace.groupCount() - 1);
    }

    public void promotionFailedToFull(GCLogTrace trace, String line) {
        ParNewPromotionFailed youngCollection = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(12));
        MemoryPoolSummary youngGen = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(15);
        MemoryPoolSummary totalHeap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 22);
        youngCollection.add(youngGen, new MemoryPoolSummary(tenured.getOccupancyBeforeCollection(), tenured.getOccupancyBeforeCollection(), tenured.getSizeAfterCollection()), new MemoryPoolSummary(youngGen.getOccupancyBeforeCollection() + tenured.getOccupancyBeforeCollection(), youngGen.getOccupancyAfterCollection() + tenured.getOccupancyBeforeCollection(), youngGen.getSizeAfterCollection() + tenured.getSizeAfterCollection()));
        FullGC collection = trace.getGroup(13) != null ? new FullGC(new DateTimeStamp(trace.getGroup(13), trace.getDoubleGroup(14)), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount())) : new FullGC(new DateTimeStamp(trace.getDoubleGroup(14)), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
        collection.add(totalHeap.minus(tenured), tenured, totalHeap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void parNewPLAB(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void plabEntry(GCLogTrace trace, String line) {
    }

    public void plabSummary(GCLogTrace trace, String line) {
    }

    public void parNewPromotionFailedTimeAbortPreclean(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNewPromotionFailed;
        this.gcCauseForwardReference = GCCause.PROMOTION_FAILED;
        this.fullGCTimeStamp = this.getClock();
        this.scavengeTimeStamp = trace.getDateTimeStamp(2);
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
        this.scavengeDurationForwardReference = trace.getDoubleGroup(12);
    }

    public void parNewPromotionFailedConcurrentPhase(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = trace.getDateTimeStamp();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.gcCauseForwardReference = trace.gcCause();
        this.scavengeDurationForwardReference = trace.getDoubleGroup(12);
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
    }

    public void corruptedParNewConcurrentPhase(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = trace.getDateTimeStamp();
        this.gcCauseForwardReference = trace.gcCause();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
    }

    public void corruptedParNewBody(GCLogTrace trace, String line) {
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.scavengeTimeStamp, GCCause.PROMOTION_FAILED, trace.getPauseTime() - trace.getDoubleGroup(16));
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 17);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(10);
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary parNewHeap = new MemoryPoolSummary(heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection(), heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection());
        parNewPromotionFailed.add(young, parNewHeap.minus(young), parNewHeap);
        ConcurrentModeFailure concurrentModeFailure = new ConcurrentModeFailure(this.scavengeTimeStamp.add(trace.getDoubleGroup(9) - this.scavengeTimeStamp.getTimeStamp()), GCCause.LAST_GC_CAUSE, trace.getDoubleGroup(16));
        concurrentModeFailure.add(heap.minus(tenured), tenured, heap);
        concurrentModeFailure.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        concurrentModeFailure.add(this.extractCPUSummary(line));
        this.record((JVMEvent)parNewPromotionFailed);
        this.record((JVMEvent)concurrentModeFailure);
    }

    public void concurrentPhaseStart(GCLogTrace trace, String line) {
    }

    public void concurrentPhaseEnd(GCLogTrace trace, String line) {
    }

    public void abortPrecleanDueToTimeClause(GCLogTrace trace, String line) {
    }

    public void initialMark(GCLogTrace trace, String line) {
        InitialMark initialMark = new InitialMark(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        initialMark.add(trace.getOccupancyWithMemoryPoolSizeSummary(4), this.getTotalOccupancyWithTotalHeapSizeSummary(trace, 8));
        initialMark.add(this.extractCPUSummary(line));
        this.record((JVMEvent)initialMark);
    }

    public void scavengeBeforeRemark(GCLogTrace trace, String line) {
        ParNew parNew = new ParNew(new DateTimeStamp(trace.getGroup(6), trace.getDoubleGroup(7)), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(11);
        MemoryPoolSummary tenured = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 18);
        parNew.add(young, tenured.minus(young), tenured);
        parNew.add(this.extractCPUSummary(line));
        this.parNewForwardReference = parNew;
    }

    public void scavengeBeforeRemarkTenuring(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = new DateTimeStamp(trace.getGroup(6), trace.getDoubleGroup(7));
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
    }

    public void remarkAt21(GCLogTrace trace, String line) {
        this.recordRemark(trace, line, 21, trace.gcCause());
    }

    public void parallelRemarkStringSymbolClause(GCLogTrace trace, String line) {
        this.recordRemark(trace, line, 18, trace.gcCause());
    }

    public void remarkAt15(GCLogTrace trace, String line) {
        this.recordRemark(trace, line, 15, trace.gcCause());
    }

    public void parallelRescan(GCLogTrace trace, String line) {
        CMSRemark collection;
        if (this.remarkTimeStamp != null) {
            collection = new CMSRemark(this.remarkTimeStamp, GCCause.CMS_FINAL_REMARK, trace.getDoubleGroup(trace.groupCount()));
            this.remarkTimeStamp = null;
        } else {
            collection = new CMSRemark(this.getClock(), GCCause.CMS_FINAL_REMARK, trace.getDoubleGroup(trace.groupCount()));
        }
        MemoryPoolSummary tenured = trace.getOccupancyWithMemoryPoolSizeSummary(10);
        MemoryPoolSummary heap = this.getTotalOccupancyWithTotalHeapSizeSummary(trace, 14);
        collection.add(heap.minus(tenured), tenured, heap);
        this.recordRescanStepTimes(collection, line);
        collection.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
        if (this.parNewForwardReference != null) {
            this.record((JVMEvent)this.parNewForwardReference);
            this.parNewForwardReference = null;
        }
    }

    public void remarkAt12(GCLogTrace trace, String line) {
        this.recordRemark(trace, line, 12, trace.gcCause());
    }

    public void remarkAt11(GCLogTrace trace, String line) {
        this.recordRemark(trace, line, 11, trace.gcCause(2));
    }

    public void remarkAt13(GCLogTrace trace, String line) {
        this.recordRemark(trace, line, 13, trace.gcCause());
    }

    public void remarkAt1(GCLogTrace trace, String line) {
        this.recordRemark(trace, line, 1, trace.gcCause());
    }

    public void remarkParNewPromotionFailed(GCLogTrace trace, String line) {
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(11);
        MemoryPoolSummary tenured = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 18);
        parNewPromotionFailed.add(young, tenured.minus(young), tenured);
        parNewPromotionFailed.add(this.extractCPUSummary(line));
        this.record((JVMEvent)parNewPromotionFailed);
    }

    public void tenuringDetails(GCLogTrace trace, String line) {
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(14));
            collection.add(young, heap);
            collection.add(this.referenceGCForwardReference);
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.DefNew) {
            DefNew collection = new DefNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(14));
            collection.add(young, heap);
            collection.add(this.referenceGCForwardReference);
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection);
        }
    }

    public void concurrentModeFailureDetails(GCLogTrace trace, String line) {
        Object failure;
        MemoryPoolSummary tenuredPoolSummary = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heapSummary = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, this.scavengeDurationForwardReference);
            collection.add(this.youngMemoryPoolSummaryForwardReference, new MemoryPoolSummary(tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeBeforeCollection(), tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeAfterCollection()), new MemoryPoolSummary(heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeBeforeCollection(), heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeAfterCollection()));
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection, false);
            failure = new ConcurrentModeFailure(this.getClock(), this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            this.youngMemoryPoolSummaryForwardReference = heapSummary.minus(tenuredPoolSummary);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.DefNew) {
            DefNew collection = new DefNew(this.scavengeTimeStamp, this.gcCauseForwardReference, this.scavengeDurationForwardReference);
            collection.add(this.youngMemoryPoolSummaryForwardReference, new MemoryPoolSummary(tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeBeforeCollection(), tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeAfterCollection()), new MemoryPoolSummary(heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeBeforeCollection(), heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeAfterCollection()));
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection, false);
            failure = new ConcurrentModeFailure(this.getClock(), this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            this.youngMemoryPoolSummaryForwardReference = heapSummary.minus(tenuredPoolSummary);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNewPromotionFailed) {
            ParNewPromotionFailed collection = new ParNewPromotionFailed(this.scavengeTimeStamp, this.gcCauseForwardReference, this.scavengeDurationForwardReference);
            collection.add(this.youngMemoryPoolSummaryForwardReference, new MemoryPoolSummary(tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeBeforeCollection(), tenuredPoolSummary.getOccupancyBeforeCollection(), tenuredPoolSummary.getSizeAfterCollection()), new MemoryPoolSummary(heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeBeforeCollection(), heapSummary.getOccupancyBeforeCollection(), heapSummary.getSizeAfterCollection()));
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection, false);
            failure = new ConcurrentModeFailure(this.getClock(), this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            this.youngMemoryPoolSummaryForwardReference = heapSummary.minus(tenuredPoolSummary);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ConcurrentModeFailure || this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC) {
            failure = line.contains("interrupted") ? new ConcurrentModeInterrupted(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount())) : new ConcurrentModeFailure(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            if (this.youngMemoryPoolSummaryForwardReference == null) {
                this.youngMemoryPoolSummaryForwardReference = heapSummary.minus(tenuredPoolSummary);
            }
        } else {
            trace.notYetImplemented();
            return;
        }
        failure.add(this.youngMemoryPoolSummaryForwardReference, tenuredPoolSummary, heapSummary);
        failure.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        failure.add(this.extractCPUSummary(line));
        this.record((JVMEvent)failure);
    }

    public void parNewDetailsConcurrentModeFailure(GCLogTrace trace, String line) {
        ParNew parNew = new ParNew(this.scavengeTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(7));
        MemoryPoolSummary summary = new MemoryPoolSummary(trace.toKBytes(24), trace.toKBytes(28), trace.toKBytes(24), trace.toKBytes(28));
        parNew.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1), summary);
        parNew.add(this.extractCPUSummary(line));
        this.record((JVMEvent)parNew, false);
        ConcurrentModeFailure collection = new ConcurrentModeFailure(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
        collection.add(new MemoryPoolSummary(trace.toKBytes(3), trace.toKBytes(5), 0L, trace.toKBytes(28) - trace.toKBytes(21)), trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(17), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 24));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void parNewDetailsPromotionFailedWithConcurrentMarkSweepPhase(GCLogTrace trace, String line) {
        this.youngMemoryPoolSummaryForwardReference = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.scavengeDurationForwardReference = trace.getDoubleGroup(7);
    }

    public void parNewDetailsWithConcurrentModeFailure(GCLogTrace trace, String line) {
        ParNewPromotionFailed collection = new ParNewPromotionFailed(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(7));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(17), trace.toKBytes(21), trace.toKBytes(17), trace.toKBytes(21));
        MemoryPoolSummary tenured = heap.minus(young);
        collection.add(young, tenured, heap);
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection, false);
        ConcurrentModeFailure fullCollection = new ConcurrentModeFailure(this.getClock(), this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
        tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(10);
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 17);
        young = heap.minus(tenured);
        fullCollection.add(young, tenured, heap);
        fullCollection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        fullCollection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)fullCollection);
    }

    public void concurrentModeFailureReference(GCLogTrace trace, String line) {
        FullGC collection;
        GCLogTrace memoryPoolSummary = POOL_OCCUPANCY_HEAP_OCCUPANCY_BLOCK.parse(line);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(memoryPoolSummary, 8);
        MemoryPoolSummary tenured = memoryPoolSummary.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        if (this.fullGCTimeStamp == null) {
            this.fullGCTimeStamp = this.getClock().add(this.parNewForwardReference.getDuration());
            MemoryPoolSummary parNewHeap = new MemoryPoolSummary(heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection(), heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection());
            MemoryPoolSummary parNewTenured = parNewHeap.minus(this.youngMemoryPoolSummaryForwardReference);
            this.parNewForwardReference.add(this.youngMemoryPoolSummaryForwardReference, parNewTenured, parNewHeap);
            this.record((JVMEvent)this.parNewForwardReference, false);
            collection = new ConcurrentModeFailure(this.fullGCTimeStamp, GCCause.CMS_FAILURE, trace.getDoubleGroup(trace.groupCount()));
        } else {
            collection = new FullGC(this.fullGCTimeStamp, GCCause.CMS_FAILURE, trace.getDoubleGroup(trace.groupCount()));
        }
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractPrintReferenceGC(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void iCMSConcurrentModeFailureDuringParNewDefNewTenuringDetails(GCLogTrace trace, String line) {
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        int dutyCycle = trace.getIntegerGroup(14);
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(dutyCycle);
            collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC) {
            SystemGC collection = new SystemGC(this.fullGCTimeStamp, GCCause.JAVA_LANG_SYSTEM, trace.getDoubleGroup(trace.groupCount()));
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(dutyCycle);
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNewPromotionFailed) {
            ParNewPromotionFailed collection = new ParNewPromotionFailed(this.scavengeTimeStamp, GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(dutyCycle);
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection);
        } else {
            LOGGER.log(Level.WARNING, "@" + this.scavengeTimeStamp + ". ParNew details not preceded by a ParNew: " + this.garbageCollectionTypeForwardReference);
        }
    }

    public void iCMSConcurrentModeFailure(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC || this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ConcurrentModeFailure) {
            ConcurrentModeFailure failure = new ConcurrentModeFailure(this.fullGCTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
            failure.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8));
            failure.recordDutyCycle(trace.getIntegerGroup(21));
            failure.add(this.extractCPUSummary(line));
            this.record((JVMEvent)failure);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew || this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNewPromotionFailed) {
            Object collection = this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew ? new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount())) : new ParNewPromotionFailed(this.scavengeTimeStamp, trace.getDoubleGroup(trace.groupCount()) - trace.getDoubleGroup(7));
            collection.add(this.youngMemoryPoolSummaryForwardReference, new MemoryPoolSummary(trace.getLongGroup(8), trace.getLongGroup(12), trace.getLongGroup(8), trace.getLongGroup(12)));
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection, false);
            if (this.fullGCTimeStamp == null) {
                this.fullGCTimeStamp = this.scavengeTimeStamp.add(trace.getDoubleGroup(7));
            }
            ConcurrentModeFailure failure = new ConcurrentModeFailure(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(7));
            MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
            MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            failure.add(heap.minus(tenured), tenured, heap);
            failure.recordDutyCycle(trace.getIntegerGroup(21));
            failure.add(this.extractCPUSummary(line));
            this.record((JVMEvent)failure);
        } else {
            trace.notYetImplemented();
        }
    }

    public void iCMSConcurrentModeFailureDuringParNewDefNewDetails(GCLogTrace trace, String line) {
        ParNewPromotionFailed collection = new ParNewPromotionFailed(this.scavengeTimeStamp, trace.getDoubleGroup(7));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(17), trace.toKBytes(21), trace.toKBytes(17), trace.toKBytes(21));
        collection.add(young, heap.minus(young), heap);
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
        collection = new ConcurrentModeFailure(this.getClock(), GCCause.CMS_FAILURE, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(10);
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 17);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.recordDutyCycle(trace.getIntegerGroup(23));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void fullGCInterruptsConcurrentPhase(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.FullGC;
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void fullGCReferenceConcurrentModeFailure(GCLogTrace trace, String line) {
        ConcurrentModeFailure collection = new ConcurrentModeFailure(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        GCLogTrace memorySummary = MEMORY_SUMMARY_RULE.parse(line);
        MemoryPoolSummary tenured = memorySummary.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(memorySummary.next(), 1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(memorySummary.next(), 1);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void fullParNewStart(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.scavengeTimeStamp = trace.getDateTimeStamp(2);
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.FullGC;
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void iCMSParNew(GCLogTrace trace, String line) {
        ParNew parNew = new ParNew(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        parNew.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 13));
        parNew.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        parNew.add(this.extractCPUSummary(line));
        this.record((JVMEvent)parNew);
    }

    public void iCMSParNewPromotionFailureRecord(GCLogTrace trace, String line) {
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(13));
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(23), trace.toKBytes(27), trace.toKBytes(23), trace.toKBytes(27));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(7);
        MemoryPoolSummary tenured = heap.minus(young);
        parNewPromotionFailed.add(young, tenured, heap);
        parNewPromotionFailed.recordDutyCycle(trace.getIntegerGroup(36));
        this.record((JVMEvent)parNewPromotionFailed);
        DateTimeStamp fullGCStart = trace.getDateTimeStamp(3);
        fullGCStart = this.getClock().add(fullGCStart.getTimeStamp() - this.getClock().getTimeStamp());
        FullGC fullGC = new FullGC(fullGCStart, GCCause.PROMOTION_FAILED, trace.getDoubleGroup(22));
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 23);
        tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(16);
        young = new MemoryPoolSummary(0L, trace.toKBytes(11), 0L, trace.toKBytes(11));
        fullGC.add(young, tenured, heap);
        fullGC.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        fullGC.recordDutyCycle(trace.getIntegerGroup(36));
        this.record((JVMEvent)fullGC);
    }

    public void iCMSParNewPromotionFailure(GCLogTrace trace, String line) {
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(12));
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(22), trace.toKBytes(26), trace.toKBytes(22), trace.toKBytes(26));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
        MemoryPoolSummary tenured = heap.minus(young);
        parNewPromotionFailed.add(young, tenured, heap);
        parNewPromotionFailed.recordDutyCycle(trace.getIntegerGroup(35));
        this.record((JVMEvent)parNewPromotionFailed);
        DateTimeStamp fullGCStart = trace.getDateTimeStamp(3);
        ConcurrentModeFailure fullGC = new ConcurrentModeFailure(fullGCStart, GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount() - 1));
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 22);
        tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(15);
        young = new MemoryPoolSummary(0L, trace.toKBytes(10), 0L, trace.toKBytes(10));
        fullGC.add(young, tenured, heap);
        fullGC.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        fullGC.recordDutyCycle(trace.getIntegerGroup(35));
        this.record((JVMEvent)fullGC);
    }

    public void fullGCiCMS(GCLogTrace trace, String line) {
        Object collection = trace.gcCause() == GCCause.JAVA_LANG_SYSTEM ? new SystemGC(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount())) : new FullGC(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 12);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.recordDutyCycle(trace.getIntegerGroup(25));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void iCMSParNewDefNewTenuringDetails(GCLogTrace trace, String line) {
        if (GarbageCollectionTypes.ParNew == this.garbageCollectionTypeForwardReference) {
            ParNew collection = new ParNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8));
            collection.recordDutyCycle(trace.getIntegerGroup(14));
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection);
        } else if (GarbageCollectionTypes.ParNewPromotionFailed == this.garbageCollectionTypeForwardReference) {
            ParNewPromotionFailed collection = new ParNewPromotionFailed(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
            this.record((JVMEvent)collection);
        } else if (GarbageCollectionTypes.FullGC == this.garbageCollectionTypeForwardReference) {
            FullGC collection = new FullGC(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
            MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
            collection.add(young, heap.minus(young), heap);
            collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
            this.record((JVMEvent)collection);
        } else {
            LOGGER.warning("Not reported: " + line);
        }
    }

    public void iCMSPromotionFailed(GCLogTrace trace, String line) {
        ParNewPromotionFailed collection = new ParNewPromotionFailed(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 12);
        collection.add(young, heap.minus(young), heap);
        collection.recordDutyCycle(trace.getIntegerGroup(18));
        this.record((JVMEvent)collection);
    }

    private void iCMSFullGC(GCLogTrace trace, String line) {
        SystemGC collection;
        GCCause cause = trace.gcCause();
        if (cause == GCCause.JAVA_LANG_SYSTEM) {
            collection = new SystemGC(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
        } else if (cause == GCCause.UNKNOWN_GCCAUSE || cause == GCCause.GCCAUSE_NOT_SET) {
            collection = new FullGC(this.getClock(), cause, trace.getDoubleGroup(trace.groupCount()));
        } else {
            trace.notYetImplemented();
            return;
        }
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 13);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        this.record((JVMEvent)collection);
    }

    public void iCMSPromotionFailedPermMeta(GCLogTrace trace, String line) {
        double gcDuration = trace.getDoubleGroup(20);
        double parNewDuration = trace.getDoubleGroup(11);
        ParNewPromotionFailed parNew = new ParNewPromotionFailed(trace.getDateTimeStamp(), GCCause.UNKNOWN_GCCAUSE, parNewDuration);
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(14);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 21);
        parNew.add(young, new MemoryPoolSummary(tenured.getOccupancyBeforeCollection(), tenured.getSizeAfterCollection(), tenured.getOccupancyBeforeCollection(), tenured.getSizeAfterCollection()), new MemoryPoolSummary(heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection(), heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection()));
        parNew.add(this.extractCPUSummary(line));
        this.record((JVMEvent)parNew);
        FullGC full = new FullGC(trace.getDateTimeStamp(3), GCCause.PROMOTION_FAILED, gcDuration);
        full.add(heap.minus(tenured), tenured, heap);
        full.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        full.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        full.add(this.extractCPUSummary(line));
        this.record((JVMEvent)full);
    }

    public void iCMSMislabeledFull(GCLogTrace trace, String line) {
        double gcDuration = trace.getDoubleGroup(trace.groupCount());
        double parNewDuration = trace.getDoubleGroup(12);
        ParNew parNew = new ParNew(trace.getDateTimeStamp(2), trace.gcCause(), parNewDuration);
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(15);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 22);
        parNew.add(young, new MemoryPoolSummary(tenured.getOccupancyBeforeCollection(), tenured.getSizeAfterCollection(), tenured.getOccupancyBeforeCollection(), tenured.getSizeAfterCollection()), new MemoryPoolSummary(heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection(), heap.getOccupancyBeforeCollection(), heap.getSizeAfterCollection()));
        parNew.add(young, tenured, heap);
        this.record((JVMEvent)parNew);
        FullGC full = new FullGC(trace.getDateTimeStamp(3), trace.gcCause(), gcDuration);
        full.add(heap.minus(tenured), tenured, heap);
        full.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        full.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        full.add(this.extractCPUSummary(line));
        this.record((JVMEvent)full);
    }

    public void iCMSFullAfterConcurrentModeFailure(GCLogTrace trace, String line) {
        ConcurrentModeFailure failure = new ConcurrentModeFailure(this.getClock(), GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
        failure.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 13));
        failure.recordDutyCycle(trace.getIntegerGroup(26));
        failure.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        failure.add(this.extractCPUSummary(line));
        this.record((JVMEvent)failure);
    }

    public void iCMSConcurrentModeInterrupted(GCLogTrace trace, String line) {
        if (this.fullGCTimeStamp == null) {
            this.fullGCTimeStamp = this.getClock();
            this.logMissedFirstRecordForEvent(line);
        }
        ConcurrentModeInterrupted collection = new ConcurrentModeInterrupted(this.fullGCTimeStamp, this.garbageCollectionTypeForwardReference, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.recordDutyCycle(trace.getIntegerGroup(trace.groupCount() - 1));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void psFullGCMeta(GCLogTrace trace, String line) {
        GCCause cause = trace.gcCause();
        Object collection = cause == GCCause.JAVA_LANG_SYSTEM || cause == GCCause.HEAP_DUMP ? new SystemGC(this.getClock(), cause, trace.getDoubleGroup(trace.groupCount())) : new PSFullGC(this.getClock(), cause, trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5), trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(11), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 17));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void psFullGCV2Meta(GCLogTrace trace, String line) {
        SystemGC collection = new SystemGC(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 12);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void parNewConcurrentModeFailurePerm(GCLogTrace trace, String line) {
        double totalPause = trace.getPauseTime();
        double concurrentModeFailurePause = trace.getDoubleGroup(20);
        double startTimeGap = trace.getDoubleGroup(13) - this.getClock().getTimeStamp();
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.getClock(), trace.gcCause(), totalPause - concurrentModeFailurePause);
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(21), trace.toKBytes(25), trace.toKBytes(21), trace.toKBytes(25));
        MemoryPoolSummary tenured = new MemoryPoolSummary(trace.toKBytes(14), trace.toKBytes(18), trace.toKBytes(14), trace.toKBytes(18));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(6);
        parNewPromotionFailed.add(young, tenured, heap);
        this.record((JVMEvent)parNewPromotionFailed);
        ConcurrentModeFailure concurrentModeFailure = new ConcurrentModeFailure(this.getClock().add(startTimeGap), GCCause.PROMOTION_FAILED, concurrentModeFailurePause);
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 21);
        tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(14);
        concurrentModeFailure.add(heap.minus(tenured), tenured, heap);
        concurrentModeFailure.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        concurrentModeFailure.add(this.extractCPUSummary(line));
        this.record((JVMEvent)concurrentModeFailure);
    }

    public void parNewConcurrentModeFailureMeta(GCLogTrace trace, String line) {
        double totalPause = trace.getPauseTime();
        double concurrentModeFailurePause = trace.getDoubleGroup(19);
        double startTimeGap = trace.getDoubleGroup(12) - this.getClock().getTimeStamp();
        ParNewPromotionFailed parNewPromotionFailed = new ParNewPromotionFailed(this.getClock(), trace.gcCause(), totalPause - concurrentModeFailurePause);
        MemoryPoolSummary heap = new MemoryPoolSummary(trace.toKBytes(20), trace.toKBytes(24), trace.toKBytes(20), trace.toKBytes(24));
        MemoryPoolSummary tenured = new MemoryPoolSummary(trace.toKBytes(13), trace.toKBytes(17), trace.toKBytes(13), trace.toKBytes(17));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        parNewPromotionFailed.add(young, tenured, heap);
        this.record((JVMEvent)parNewPromotionFailed);
        ConcurrentModeFailure concurrentModeFailure = new ConcurrentModeFailure(this.getClock().add(startTimeGap), GCCause.PROMOTION_FAILED, concurrentModeFailurePause);
        heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 20);
        tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(13);
        concurrentModeFailure.add(heap.minus(tenured), tenured, heap);
        concurrentModeFailure.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        concurrentModeFailure.add(this.extractCPUSummary(line));
        this.record((JVMEvent)concurrentModeFailure);
    }

    public void fullSplitByConcurrentPhase(GCLogTrace trace, String line) {
    }

    public void concurrentModeFailureSplitByLargeBlock(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.FullGC) {
            this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ConcurrentModeFailure;
        }
    }

    public void fullParNewConcurrentModeFailurePerm(GCLogTrace trace, String line) {
        this.extractPermOrMetaspaceRecord(line);
    }

    public void fullParNewConcurrentModeFailureMeta(GCLogTrace trace, String line) {
        this.extractPermOrMetaspaceRecord(line);
    }

    public void psFullGCV2Perm(GCLogTrace trace, String line) {
        SystemGC collection = new SystemGC(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 12);
        collection.add(heap.minus(tenured), tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void psFullGCPerm(GCLogTrace trace, String line) {
        GCCause cause = trace.gcCause();
        Object collection = cause == GCCause.JAVA_LANG_SYSTEM || cause == GCCause.HEAP_DUMP ? new SystemGC(this.getClock(), cause, trace.getDoubleGroup(trace.groupCount())) : new PSFullGC(this.getClock(), cause, trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5), trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(11), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 17));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void cmsFullPermOrMeta(GCLogTrace trace, String line) {
        try {
            GCCause cause = trace.gcCause();
            Object collection = cause == GCCause.JAVA_LANG_SYSTEM || cause == GCCause.HEAP_DUMP ? new SystemGC(this.getClock(), cause, trace.getDoubleGroup(trace.groupCount())) : new FullGC(this.getClock(), cause, trace.getDoubleGroup(trace.groupCount()));
            GCLogTrace memorySummary = MEMORY_SUMMARY_RULE.parse(line);
            MemoryPoolSummary tenuredPoolSummary = memorySummary.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            MemoryPoolSummary heapSummary = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(memorySummary.next(), 1);
            collection.add(heapSummary.minus(tenuredPoolSummary), tenuredPoolSummary, heapSummary);
            collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
            collection.add(this.extractPrintReferenceGC(line));
            collection.add(this.extractCPUSummary(line));
            this.record((JVMEvent)collection);
        }
        catch (Throwable t) {
            LOGGER.log(Level.SEVERE, this.getClock().getTimeStamp() + " : parsing record resulted in an exception", t);
        }
    }

    public void parNewNoDetails(GCLogTrace trace, String line) {
        ParNew parNew = new ParNew(this.getClock(), GarbageCollectionTypes.Young, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
        parNew.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 3));
        parNew.add(this.extractCPUSummary(line));
        this.record((JVMEvent)parNew);
    }

    public void youngNoDetails(GCLogTrace trace, String line) {
        YoungGC youngGC = new YoungGC(this.getClock(), GarbageCollectionTypes.Young, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
        youngGC.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 3));
        youngGC.add(this.extractCPUSummary(line));
        this.record((JVMEvent)youngGC);
    }

    public void cmsNoDetails(GCLogTrace trace, String line) {
        if (this.expectRemark) {
            this.expectRemark = false;
            CMSRemark remark = new CMSRemark(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
            remark.add(this.getTotalOccupancyWithTotalHeapSizeSummary(trace, 3));
            remark.add(this.extractCPUSummary(line));
            this.record((JVMEvent)remark);
        } else {
            this.expectRemark = true;
            InitialMark initialMark = new InitialMark(this.getClock(), trace.getDoubleGroup(trace.groupCount()));
            initialMark.add(this.getTotalOccupancyWithTotalHeapSizeSummary(trace, 3));
            initialMark.add(this.extractCPUSummary(line));
            this.record((JVMEvent)initialMark);
        }
    }

    public void fullNoGCDetails(GCLogTrace trace, String line) {
        this.expectRemark = false;
        FullGC fullGC = new FullGC(this.getClock(), GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
        fullGC.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 3));
        this.record((JVMEvent)fullGC);
    }

    public void parNewStart(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        if (this.gcCauseForwardReference == null) {
            this.gcCauseForwardReference = GCCause.UNKNOWN_GCCAUSE;
        }
        this.scavengeTimeStamp = this.getClock();
    }

    public void gcStart(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.Young;
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void youngSplitNoDetails(GCLogTrace trace, String line) {
        if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.ParNew) {
            ParNew parNew = new ParNew(this.scavengeTimeStamp, GarbageCollectionTypes.ParNew, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
            parNew.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 1));
            parNew.add(this.extractCPUSummary(line));
            this.record((JVMEvent)parNew);
        } else if (this.garbageCollectionTypeForwardReference == GarbageCollectionTypes.Young) {
            YoungGC youngGC = new YoungGC(this.scavengeTimeStamp, GarbageCollectionTypes.Young, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount()));
            youngGC.add(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 1));
            youngGC.add(this.extractCPUSummary(line));
            this.record((JVMEvent)youngGC);
        }
    }

    public void cmfSimple(GCLogTrace trace, String line) {
        ConcurrentModeFailure concurrentModeFailure = new ConcurrentModeFailure(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        concurrentModeFailure.add(this.extractCPUSummary(line));
        this.record((JVMEvent)concurrentModeFailure);
    }

    public void psYoungGen(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.getClock(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 11));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void psFull(GCLogTrace trace, String line) {
        GCCause cause = trace.gcCause();
        Object collection = cause == GCCause.JAVA_LANG_SYSTEM || cause == GCCause.HEAP_DUMP || cause == GCCause.HEAP_INSPECTION ? new SystemGC(trace.getDateTimeStamp(), cause, trace.getDuration()) : new FullGC(trace.getDateTimeStamp(), cause, trace.getDuration());
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(4));
        this.record((JVMEvent)collection);
    }

    public void psYoungNoDetails(GCLogTrace trace, String line) {
        GCCause cause = trace.gcCause();
        if (GCCause.JAVA_LANG_SYSTEM == cause) {
            SystemGC collection = new SystemGC(trace.getDateTimeStamp(), GCCause.JAVA_LANG_SYSTEM, trace.getDuration());
            collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(4));
            this.record((JVMEvent)collection);
        } else {
            PSYoungGen collection = new PSYoungGen(trace.getDateTimeStamp(), cause, trace.getDuration());
            collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(4));
            this.record((JVMEvent)collection);
        }
    }

    public void psYoungGenReferenceProcessingSplit(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void psYoungGenReferenceProcessing(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.getClock(), trace.gcCause(), trace.getDuration());
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(28), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 34));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void psTenuringStart(GCLogTrace trace, String line) {
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void psFullSPlit(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.garbageCollectionTypeForwardReference = this.gcCauseForwardReference == GCCause.JAVA_LANG_SYSTEM ? GarbageCollectionTypes.SystemGC : GarbageCollectionTypes.PSFull;
    }

    public void psFullReferenceSplit(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.garbageCollectionTypeForwardReference = this.gcCauseForwardReference == GCCause.JAVA_LANG_SYSTEM ? GarbageCollectionTypes.SystemGC : (this.gcCauseForwardReference == GCCause.HEAP_DUMP ? GarbageCollectionTypes.SystemGC : GarbageCollectionTypes.PSFull);
    }

    public void psFullReference(GCLogTrace trace, String line) {
        Object collection = trace.gcCause() == GCCause.JAVA_LANG_SYSTEM ? new SystemGC(trace.getDateTimeStamp(), trace.gcCause(), trace.getPauseTime()) : new PSFullGC(trace.getDateTimeStamp(), trace.gcCause(), trace.getPauseTime());
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(29);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(35);
        MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(41);
        collection.add(young, tenured, heap);
        collection.add(this.extractPrintReferenceGC(line));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void psFullReferenceJDK8(GCLogTrace trace, String line) {
        FullGC fullGC = new FullGC(this.getClock(), GarbageCollectionTypes.FullGC, trace.gcCause(), trace.getDuration());
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(30);
        MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(37);
        fullGC.add(heap.minus(tenured), tenured, heap);
        fullGC.add(this.extractPrintReferenceGC(line));
        fullGC.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        fullGC.add(this.extractCPUSummary(line));
        this.record((JVMEvent)fullGC);
    }

    public void serialFullReference(GCLogTrace trace, String line) {
        SystemGC collection = trace.gcCause().equals((Object)GCCause.JAVA_LANG_SYSTEM) ? new SystemGC(trace.getDateTimeStamp(), trace.gcCause(), trace.getDuration()) : new FullGC(trace.getDateTimeStamp(), trace.gcCause(), trace.getDuration());
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(30);
        MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(37);
        MemoryPoolSummary young = new MemoryPoolSummary(heap.getOccupancyBeforeCollection() - tenured.getOccupancyBeforeCollection(), 0L, heap.getSizeAfterCollection() - tenured.getSizeAfterCollection());
        collection.add(young, tenured, heap);
        collection.add(this.extractPrintReferenceGC(line));
        collection.add(this.extractCPUSummary(line));
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        this.record((JVMEvent)collection);
    }

    public void psFullErgonomicsPhases(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.garbageCollectionTypeForwardReference = this.gcCauseForwardReference != GCCause.JAVA_LANG_SYSTEM ? GarbageCollectionTypes.FullGC : GarbageCollectionTypes.SystemGC;
    }

    public void psFullReferencePhase(GCLogTrace trace, String line) {
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void psDetailsWithTenuring(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(2), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 8));
        if (this.referenceGCForwardReference != null) {
            collection.add(this.referenceGCForwardReference);
        }
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void psFailure(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.getClock(), GCCause.PROMOTION_FAILED, trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(5), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 11));
    }

    public void psYoungAdaptiveSizePolicy(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.PSYoungGen;
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        if (line.contains("SoftReference")) {
            this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
        }
    }

    public void psFullAdaptiveSizePolicy(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.PSFull;
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void psYoungDetailsFloating(GCLogTrace trace, String line) {
        PSYoungGen collection = new PSYoungGen(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
        collection.add(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1), this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 7));
        this.record((JVMEvent)collection);
    }

    public void psFullAdaptiveSize(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void psFullBodyFloating(GCLogTrace trace, String line) {
        Object collection = this.gcCauseForwardReference == GCCause.JAVA_LANG_SYSTEM || this.gcCauseForwardReference == GCCause.HEAP_DUMP ? new SystemGC(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount())) : new PSFullGC(this.fullGCTimeStamp, this.gcCauseForwardReference, trace.getPauseTime());
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(2);
        MemoryPoolSummary tenured = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(9);
        MemoryPoolSummary heap = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 15);
        collection.add(young, tenured, heap);
        collection.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        if (this.referenceGCForwardReference != null) {
            collection.add(this.referenceGCForwardReference);
        }
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    public void psFullReferenceAdaptiveSize(GCLogTrace trace, String line) {
        this.fullGCTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void psPromotionFailed(GCLogTrace trace, String line) {
        if (GarbageCollectionTypes.DefNew == this.garbageCollectionTypeForwardReference) {
            DefNew youngGC = new DefNew(this.scavengeTimeStamp, this.gcCauseForwardReference, trace.getDoubleGroup(7));
            MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
            MemoryPoolSummary heap = new MemoryPoolSummary(young.getOccupancyBeforeCollection() + trace.toKBytes(9), trace.toKBytes(20), trace.toKBytes(16), trace.toKBytes(20));
            youngGC.add(young, heap);
            double cpuBreakDownRatio = trace.getDoubleGroup(7) / trace.getDoubleGroup(trace.groupCount());
            CPUSummary cpuSummary = this.extractCPUSummary(line);
            if (cpuSummary != null) {
                double user = cpuSummary.getUser();
                double kernel = cpuSummary.getKernel();
                double real = cpuSummary.getWallClock();
                youngGC.add(new CPUSummary(user * cpuBreakDownRatio, kernel * cpuBreakDownRatio, real * cpuBreakDownRatio));
                cpuBreakDownRatio = 1.0 - cpuBreakDownRatio;
                cpuSummary = new CPUSummary(user * cpuBreakDownRatio, kernel * cpuBreakDownRatio, real * cpuBreakDownRatio);
            }
            this.record((JVMEvent)youngGC, false);
            DateTimeStamp timeOfFullCollection = new DateTimeStamp(trace.getDoubleGroup(8));
            FullGC fullGC = new FullGC(timeOfFullCollection, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()) - trace.getDoubleGroup(7));
            young = new MemoryPoolSummary(young.getOccupancyAfterCollection(), young.getSizeAfterCollection(), 0L, young.getSizeAfterCollection());
            fullGC.add(young, trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(16));
            fullGC.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
            fullGC.add(cpuSummary);
            this.record((JVMEvent)fullGC);
        } else {
            trace.notYetImplemented();
        }
        this.scavengeTimeStamp = this.getClock();
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.DefNew;
    }

    public void rescanSplitUnloadingString(GCLogTrace trace, String line) {
        trace.notYetImplemented();
    }

    public void parNewConcurrentPhaseCards(GCLogTrace trace, String line) {
        trace.notYetImplemented();
    }

    public void concurrentPhaseYields(GCLogTrace trace, String line) {
    }

    private void precleanTimedoutWithCards(GCLogTrace trace, String line) {
    }

    private void shouldCollectConcurrent(GCLogTrace trace, String line) {
    }

    public void parNewShouldConcurrentCollect(GCLogTrace trace, String line) {
        trace.notYetImplemented();
    }

    private void psYoungAdaptivePolicySizeStart(GCLogTrace trace, String line) {
    }

    private void psYoungAdaptivePolicySizeBody(GCLogTrace trace, String line) {
    }

    private void adaptivePolicySizeBody(GCLogTrace trace, String line) {
    }

    public void remarkSplitByDebug(GCLogTrace trace, String line) {
        long youngOccupancy = trace.getLongGroup(4);
        long youngConfiguredSize = trace.getLongGroup(5);
        this.youngMemoryPoolSummaryForwardReference = new MemoryPoolSummary(youngOccupancy, youngConfiguredSize, youngOccupancy, youngConfiguredSize);
    }

    public void scavengeBeforeRemarkReference(GCLogTrace trace, String line) {
        this.parNewForwardReference = new ParNew(new DateTimeStamp(trace.getGroup(6), trace.getDoubleGroup(7)), trace.gcCause(5), trace.getDoubleGroup(48));
        MemoryPoolSummary young = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(35);
        MemoryPoolSummary tenured = this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 42);
        this.parNewForwardReference.add(young, tenured.minus(young), tenured);
        this.parNewForwardReference.add(this.extractPrintReferenceGC(line));
        this.parNewForwardReference.add(this.extractCPUSummary(line));
        this.record((JVMEvent)this.parNewForwardReference, false);
    }

    public void preCleanReferenceParNewReference(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause(16);
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void scavengeBeforeRemarkReferenceSplit(GCLogTrace trace, String line) {
        this.garbageCollectionTypeForwardReference = GarbageCollectionTypes.ParNew;
        this.remarkTimeStamp = this.getClock();
        this.scavengeTimeStamp = this.getClock();
        this.gcCauseForwardReference = GCCause.CMS_FINAL_REMARK;
        this.referenceGCForwardReference = this.extractPrintReferenceGC(line);
    }

    public void scavengeBeforeRemarkPrintHeapAtGC(GCLogTrace trace, String line) {
        this.remarkTimeStamp = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
    }

    public void splitRemarkReference(GCLogTrace trace, String line) {
        CMSRemark remark = new CMSRemark(this.getClock(), this.gcCauseForwardReference, trace.getPauseTime());
        GCLogTrace remarkClause = REMARK_CLAUSE.parse(line);
        MemoryPoolSummary tenured = this.getTotalOccupancyWithTotalHeapSizeSummary(remarkClause, 1);
        MemoryPoolSummary heap = this.getTotalOccupancyWithTotalHeapSizeSummary(remarkClause, 5);
        remark.add(heap.minus(tenured), tenured, heap);
        this.recordRescanStepTimes(remark, line);
        remark.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        remark.add(this.extractCPUSummary(line));
        this.record((JVMEvent)remark);
        this.remarkTimeStamp = null;
    }

    public void splitRemarkReferenceWithWeakReferenceSplitBug(GCLogTrace trace, String line) {
        GCLogTrace remarkTrace = REMARK_CLAUSE.parse(line);
        Pattern durationGroupPattern = Pattern.compile(".* (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms)");
        Matcher matcher = durationGroupPattern.matcher(line);
        double duration = 0.0;
        if (matcher.find()) {
            duration = Double.parseDouble(matcher.group(matcher.groupCount()));
        }
        CMSRemark collection = new CMSRemark(this.getClock(), GCCause.CMS_FINAL_REMARK, duration);
        MemoryPoolSummary tenured = this.getTotalOccupancyWithTotalHeapSizeSummary(remarkTrace, 1);
        MemoryPoolSummary heap = this.getTotalOccupancyWithTotalHeapSizeSummary(remarkTrace, 5);
        collection.add(heap.minus(tenured), tenured, heap);
        this.recordRescanStepTimes(collection, line);
        collection.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        GCLogTrace weakReferenceFragment = this.weakReferenceFragmentRule.parse(line);
        if (weakReferenceFragment != null) {
            collection.getReferenceGCSummary().addWeakReferences(trace.getDateTimeStamp(4), 0, weakReferenceFragment.getPauseTime());
        }
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
        this.remarkTimeStamp = null;
    }

    public void adaptiveSizePolicyStop(GCLogTrace trace, String line) {
    }

    private void recordRemark(GCLogTrace trace, String line, int offset, GCCause gcCause) {
        CMSRemark collection = gcCause == GCCause.UNKNOWN_GCCAUSE ? new CMSRemark(this.getClock(), trace.getDoubleGroup(trace.groupCount())) : new CMSRemark(this.getClock(), gcCause, trace.getDoubleGroup(trace.groupCount()));
        MemoryPoolSummary tenured = trace.getOccupancyWithMemoryPoolSizeSummary(offset);
        MemoryPoolSummary heap = this.getTotalOccupancyWithTotalHeapSizeSummary(trace, offset + 4);
        collection.add(heap.minus(tenured), tenured, heap);
        this.recordRescanStepTimes(collection, line);
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    private void recordRemarkWithReferenceProcessing(GCLogTrace trace, String line) {
        GCCause gcCause = trace.gcCause();
        if (gcCause == GCCause.UNKNOWN_GCCAUSE) {
            gcCause = GCCause.CMS_FINAL_REMARK;
        }
        CMSRemark collection = new CMSRemark(this.getClock(), gcCause, trace.getDoubleGroup(trace.groupCount()));
        GCLogTrace memorySummary = OCCUPANCY_CONFIGURED_RULE.parse(line);
        MemoryPoolSummary tenured = memorySummary.getOccupancyWithMemoryPoolSizeSummary(1);
        MemoryPoolSummary heap = this.getTotalOccupancyWithTotalHeapSizeSummary(memorySummary.next(), 1);
        collection.add(heap.minus(tenured), tenured, heap);
        this.recordRescanStepTimes(collection, line);
        collection.addReferenceGCSummary(this.extractPrintReferenceGC(line));
        collection.add(this.extractCPUSummary(line));
        this.record((JVMEvent)collection);
    }

    private void log(String line) {
        if (CONCURRENT_PHASE_START.parse(line) != null) {
            return;
        }
        if (CONCURRENT_PHASE_END.parse(line) != null) {
            return;
        }
        if (ABORT_PRECLEAN_DUE_TO_TIME_CLAUSE.parse(line) != null) {
            return;
        }
        if (PRECLEAN_REFERENCE.parse(line) != null) {
            return;
        }
        if (line.startsWith("Missed: GC locker: Trying a full collection because scavenge failed")) {
            return;
        }
        if (line.startsWith("PSYoungGen")) {
            return;
        }
        if (line.startsWith("eden space")) {
            return;
        }
        if (line.startsWith("to")) {
            return;
        }
        if (line.startsWith("from")) {
            return;
        }
        if (line.startsWith("ParOldGen")) {
            return;
        }
        if (line.startsWith("PSOldGen")) {
            return;
        }
        if (line.startsWith("space")) {
            return;
        }
        if (line.startsWith("object space")) {
            return;
        }
        if (line.startsWith("PSPermGen")) {
            return;
        }
        if (line.startsWith("{Heap")) {
            return;
        }
        if (line.startsWith("}")) {
            return;
        }
        if (line.startsWith("Heap")) {
            return;
        }
        if (line.startsWith("[Times: user")) {
            return;
        }
        if (line.startsWith("par new generation   total")) {
            return;
        }
        if (line.startsWith("concurrent mark-sweep generation total")) {
            return;
        }
        if (line.startsWith("concurrent-mark-sweep perm gen total")) {
            return;
        }
        if (line.startsWith("(cardTable: ")) {
            return;
        }
        if (line.contains("CMS-concurrent-abortable-preclean")) {
            return;
        }
        if (line.contains("committed")) {
            return;
        }
        if (line.startsWith("def new generation   total")) {
            return;
        }
        if (line.startsWith("Before GC:")) {
            return;
        }
        if (line.startsWith("After GC:")) {
            return;
        }
        if (line.contains("GC log file created")) {
            return;
        }
        if (line.contains("GC log file has reached the maximum size")) {
            return;
        }
        if (line.contains("Large block")) {
            return;
        }
        if (this.debugging) {
            LOGGER.fine("GenerationalHeapParser missed: " + line);
        }
        LOGGER.log(Level.WARNING, "Missed: {0}", line);
    }

    public void logMissedFirstRecordForEvent(String line) {
        LOGGER.log(Level.WARNING, "Missing initial record for: {0}", line);
    }

    public void record(JVMEvent event, boolean clear) {
        this.consumer.record(event);
        if (clear) {
            this.garbageCollectionTypeForwardReference = null;
            this.gcCauseForwardReference = GCCause.UNKNOWN_GCCAUSE;
            this.fullGCTimeStamp = null;
            this.scavengeTimeStamp = null;
            this.youngMemoryPoolSummaryForwardReference = null;
            this.tenuredForwardReference = null;
            this.heapForwardReference = null;
            this.scavengeDurationForwardReference = 0.0;
            this.scavengeCPUSummaryForwardReference = null;
            this.referenceGCForwardReference = null;
            this.totalFreeSpaceForwardReference = 0L;
            this.maxChunkSizeForwardReference = 0L;
            this.numberOfBlocksForwardReference = 0;
            this.averageBlockSizeForwardReference = 0L;
            this.treeHeightForwardReference = 0;
        }
    }

    public void record(JVMEvent event) {
        this.record(event, true);
    }
}

