/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.CPUSummary;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.generational.CMSRemark;
import com.microsoft.gctoolkit.event.jvm.PermGenSummary;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.CMSPatterns;
import com.microsoft.gctoolkit.parser.GCLogParser;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class PreUnifiedGCLogParser
extends GCLogParser {
    private static final Logger LOGGER = Logger.getLogger(PreUnifiedGCLogParser.class.getName());
    private final GCParseRule TIMESTAMP_BLOCK = new GCParseRule("TIMESTAMP_BLOCK", "^(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): ");

    public PreUnifiedGCLogParser(Diary diary, JVMEventConsumer consumer) {
        super(diary, consumer);
    }

    @Override
    void advanceClock(String record) {
        try {
            GCLogTrace trace = this.TIMESTAMP_BLOCK.parse(record);
            if (trace == null && (trace = CMSPatterns.ABORT_PRECLEAN_DUE_TO_TIME_CLAUSE.parse(record)) == null) {
                return;
            }
            super.advanceClock(trace.getDateTimeStamp());
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, "[PARSING ERROR] " + record, t);
        }
    }

    @Override
    MemoryPoolSummary getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(GCLogTrace trace, int offset) {
        MemoryPoolSummary summary = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(offset);
        return summary;
    }

    @Override
    MemoryPoolSummary getTotalOccupancyWithTotalHeapSizeSummary(GCLogTrace trace, int offset) {
        MemoryPoolSummary summary = trace.getOccupancyWithMemoryPoolSizeSummary(offset);
        return summary;
    }

    @Override
    GCLogTrace extractReferenceBlock(String line, GCParseRule rule) {
        return rule.parse(line);
    }

    @Override
    MemoryPoolSummary extractPermGenRecord(GCLogTrace trace) {
        int index = trace.getGroup(2) == null ? 2 : 4;
        return new PermGenSummary(trace.getLongGroup(index), trace.getLongGroup(4), trace.getLongGroup(6));
    }

    void recordRescanStepTimes(CMSRemark collection, String line) {
        double unloading = 0.0;
        double symbolTable = 0.0;
        double stringTable = 0.0;
        double stringAndSymbolTable = 0.0;
        GCLogTrace clause = CLASS_UNLOADING.parse(line);
        if (clause != null) {
            unloading = clause.getDoubleGroup(2);
        }
        if ((clause = SYMBOL_TABLE_SCRUB.parse(line)) != null) {
            symbolTable = clause.getDoubleGroup(2);
        }
        if ((clause = STRING_TABLE_SCRUB.parse(line)) != null) {
            stringTable = clause.getDoubleGroup(2);
        }
        if ((clause = STRING_AND_SYMBOL_SCRUB.parse(line)) != null) {
            stringAndSymbolTable = clause.getDoubleGroup(2);
        }
        collection.addClassUnloadingAndStringTableProcessingDurations(unloading, symbolTable, stringTable, stringAndSymbolTable);
    }

    @Override
    CPUSummary extractCPUSummary(String line) {
        GCLogTrace trace = CPU_BREAKDOWN.parse(line);
        if (trace != null) {
            return new CPUSummary(trace.getDoubleGroup(1), trace.getDoubleGroup(2), trace.getDoubleGroup(3));
        }
        return null;
    }
}

