/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import com.microsoft.gctoolkit.parser.UnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.collection.MRUQueue;
import com.microsoft.gctoolkit.parser.unified.ShenandoahPatterns;
import java.util.AbstractMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShenandoahParser
extends UnifiedGCLogParser
implements ShenandoahPatterns {
    private static final Logger LOGGER = Logger.getLogger(ShenandoahParser.class.getName());
    private final boolean debugging = Boolean.getBoolean("microsoft.debug");
    private final MRUQueue<GCParseRule, BiConsumer<GCLogTrace, String>> parseRules = new MRUQueue();
    private ShenandoahForwardReference forwardReference;

    public ShenandoahParser(Diary diary, JVMEventConsumer consumer) {
        super(diary, consumer);
        this.parseRules.put(END_OF_FILE, this::endOfFile);
    }

    @Override
    public String getName() {
        return "Shenandoah Parser";
    }

    @Override
    protected void process(String line) {
        if (this.ignoreFrequentButUnwantedEntries(line)) {
            return;
        }
        try {
            Optional<AbstractMap.SimpleEntry> optional = this.parseRules.keys().stream().map(rule -> new AbstractMap.SimpleEntry<GCParseRule, GCLogTrace>((GCParseRule)rule, rule.parse(line))).filter(tuple -> tuple.getValue() != null).findFirst();
            if (optional.isPresent()) {
                AbstractMap.SimpleEntry ruleAndTrace = optional.get();
                this.parseRules.get(ruleAndTrace.getKey()).accept((GCLogTrace)ruleAndTrace.getValue(), line);
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.throwing(this.getName(), "process", t);
        }
        this.log(line);
    }

    private boolean ignoreFrequentButUnwantedEntries(String line) {
        return false;
    }

    public void endOfFile(GCLogTrace trace, String line) {
        this.record((JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
    }

    private void log(String line) {
        if (this.debugging) {
            LOGGER.log(Level.FINE, "ZGCHeapParser missed: {0}", line);
        }
        LOGGER.log(Level.WARNING, "Missed: {0}", line);
    }

    public void record() {
        this.record(this.forwardReference.toShenandoahCycle());
    }

    public void record(JVMEvent event) {
        this.consumer.record(event);
        this.forwardReference = null;
    }

    private class ShenandoahForwardReference {
        private ShenandoahForwardReference() {
        }

        JVMEvent toShenandoahCycle() {
            return null;
        }
    }
}

