/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.event.jvm.SurvivorRecord;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import com.microsoft.gctoolkit.parser.PreUnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.TenuredPatterns;
import com.microsoft.gctoolkit.parser.unified.UnifiedPatterns;

public class SurvivorMemoryPoolParser
extends PreUnifiedGCLogParser
implements TenuredPatterns {
    private SurvivorRecord forwardReference = null;

    public SurvivorMemoryPoolParser(Diary diary, JVMEventConsumer consumer) {
        super(diary, consumer);
    }

    @Override
    public String getName() {
        return "SurvivorMemoryPoolParser";
    }

    @Override
    protected void process(String entry) {
        GCLogTrace trace = TENURING_SUMMARY.parse(entry);
        if (trace != null) {
            this.forwardReference = new SurvivorRecord(this.getClock(), trace.getLongGroup(1), trace.getIntegerGroup(2), trace.getIntegerGroup(3));
        } else {
            trace = TENURING_AGE_BREAKDOWN.parse(entry);
            if (trace != null) {
                this.forwardReference.add(trace.getIntegerGroup(1), trace.getLongGroup(2));
            } else if (entry.equals("END_OF_DATA_SENTINEL") || UnifiedPatterns.JVM_EXIT.parse(entry) != null) {
                if (this.forwardReference != null) {
                    this.consumer.record((JVMEvent)this.forwardReference);
                }
                this.consumer.record((JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
            } else if (this.forwardReference != null) {
                this.consumer.record((JVMEvent)this.forwardReference);
                this.forwardReference = null;
            }
        }
    }
}

