/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.GCLogParser;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import com.microsoft.gctoolkit.parser.jvm.Decorators;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class UnifiedGCLogParser
extends GCLogParser {
    private static final Logger LOGGER = Logger.getLogger(UnifiedGCLogParser.class.getName());
    private static final boolean DEBUG = Boolean.getBoolean("microsoft.debug");

    UnifiedGCLogParser(Diary diary, JVMEventConsumer consumer) {
        super(diary, consumer);
    }

    @Override
    void advanceClock(String record) {
        try {
            DateTimeStamp now = new Decorators(record).getDateTimeStamp();
            super.advanceClock(now);
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, "[PARSING ERROR] " + record, t);
        }
    }

    void notYetImplemented(GCLogTrace trace, String line) {
        trace.notYetImplemented();
    }

    void noop() {
        if (DEBUG) {
            System.out.println("noop");
        }
    }
}

