/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.jvm.ApplicationConcurrentTime;
import com.microsoft.gctoolkit.event.jvm.ApplicationStoppedTime;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import com.microsoft.gctoolkit.parser.JVMPatterns;
import com.microsoft.gctoolkit.parser.UnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.unified.UnifiedPatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnifiedJVMEventParser
extends UnifiedGCLogParser
implements JVMPatterns {
    private static final Logger LOGGER = Logger.getLogger(UnifiedJVMEventParser.class.getName());
    private DateTimeStamp timeStamp = new DateTimeStamp(0.0);
    private ApplicationStoppedTime.VMOperations safePointReason = null;
    private boolean gcPause = false;

    public UnifiedJVMEventParser(Diary diary, JVMEventConsumer consumer) {
        super(diary, consumer);
    }

    @Override
    public String getName() {
        return "JavaEventParser";
    }

    @Override
    protected void process(String line) {
        GCLogTrace trace = null;
        try {
            trace = UNIFIED_LOGGING_APPLICATION_STOP_TIME_WITH_STOPPING_TIME.parse(line);
            if (trace != null) {
                if (this.safePointReason != null) {
                    this.consumer.record((JVMEvent)new ApplicationStoppedTime(this.timeStamp, trace.getDoubleGroup(1), trace.getDoubleGroup(2), this.safePointReason));
                } else {
                    this.consumer.record((JVMEvent)new ApplicationStoppedTime(this.timeStamp, trace.getDoubleGroup(1), trace.getDoubleGroup(2), this.gcPause));
                }
                this.safePointReason = null;
                this.gcPause = false;
            } else if (GC_PAUSE_CLAUSE.parse(line) != null) {
                this.gcPause = true;
            } else {
                trace = SAFEPOINT_REGION.parse(line);
                if (trace != null) {
                    this.timeStamp = this.getClock();
                    this.safePointReason = ApplicationStoppedTime.VMOperations.valueOf((String)trace.getGroup(1));
                } else {
                    trace = LEAVING_SAFEPOINT.parse(line);
                    if (trace == null) {
                        trace = UNIFIED_LOGGING_APPLICATION_TIME.parse(line);
                        if (trace != null) {
                            this.consumer.record((JVMEvent)new ApplicationConcurrentTime(this.getClock(), trace.getDoubleGroup(1)));
                        } else if (line.equals("END_OF_DATA_SENTINEL") || UnifiedPatterns.JVM_EXIT.parse(line) != null) {
                            this.consumer.record((JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
                        } else if (this.getClock().getTimeStamp() > this.timeStamp.getTimeStamp()) {
                            if (this.isGCPause(line)) {
                                this.gcPause = true;
                            }
                            this.timeStamp = this.getClock();
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, "Missed: {0}", line);
        }
    }

    private boolean isGCPause(String line) {
        return line.contains(" Pause Initial Mark") || line.contains(" Remark ") || line.contains(" Pause Young ") || line.contains(" Full ");
    }
}

