/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.event.jvm.SurvivorRecord;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import com.microsoft.gctoolkit.parser.TenuredPatterns;
import com.microsoft.gctoolkit.parser.UnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.jvm.Decorators;
import com.microsoft.gctoolkit.parser.unified.UnifiedPatterns;

public class UnifiedSurvivorMemoryPoolParser
extends UnifiedGCLogParser
implements TenuredPatterns {
    private GCParseRule DESIRED_SURVIVOR_SIZE = new GCParseRule("DESIRED_SURVIVOR_SIZE", "Desired survivor size (\\d+) bytes, new threshold (\\d+) \\(max threshold (\\d+)\\)");
    private GCParseRule AGE_TABLE_HEADER = new GCParseRule("AGE_TABLE_HEADER", "Age table with threshold (\\d+) \\(max threshold (\\d+)\\)");
    private GCParseRule AGE_RECORD = new GCParseRule("AGE_RECORD", "- age\\s+(\\d+):\\s+(\\d+) bytes,\\s+(\\d+) total");
    private SurvivorRecord forwardReference = null;
    private boolean ageDataCollected = false;

    public UnifiedSurvivorMemoryPoolParser(Diary diary, JVMEventConsumer consumer) {
        super(diary, consumer);
    }

    @Override
    public String getName() {
        return "SurvivorMemoryPoolParser";
    }

    @Override
    protected void process(String entry) {
        GCLogTrace trace = this.DESIRED_SURVIVOR_SIZE.parse(entry);
        if (trace != null) {
            this.forwardReference = new SurvivorRecord(new Decorators(entry).getDateTimeStamp(), trace.getLongGroup(1), trace.getIntegerGroup(2), trace.getIntegerGroup(3));
        } else {
            trace = this.AGE_TABLE_HEADER.parse(entry);
            if (trace == null) {
                trace = this.AGE_RECORD.parse(entry);
                if (trace != null) {
                    this.forwardReference.add(trace.getIntegerGroup(1), trace.getLongGroup(2));
                    this.ageDataCollected = true;
                } else if (entry.equals("END_OF_DATA_SENTINEL") || UnifiedPatterns.JVM_EXIT.parse(entry) != null) {
                    if (this.forwardReference != null) {
                        this.consumer.record((JVMEvent)this.forwardReference);
                    }
                    this.consumer.record((JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
                } else if (this.forwardReference != null && this.ageDataCollected) {
                    this.consumer.record((JVMEvent)this.forwardReference);
                    this.forwardReference = null;
                    this.ageDataCollected = false;
                } else if (UnifiedPatterns.CPU_BREAKOUT.parse(entry) != null && this.forwardReference != null) {
                    this.consumer.record((JVMEvent)this.forwardReference);
                    this.forwardReference = null;
                    this.ageDataCollected = false;
                }
            }
        }
    }
}

