/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.event.zgc.OccupancySummary;
import com.microsoft.gctoolkit.event.zgc.ReclaimSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCCycle;
import com.microsoft.gctoolkit.event.zgc.ZGCMemoryPoolSummary;
import com.microsoft.gctoolkit.event.zgc.ZGCMetaspaceSummary;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.JVMEventConsumer;
import com.microsoft.gctoolkit.parser.UnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.collection.MRUQueue;
import com.microsoft.gctoolkit.parser.unified.ZGCPatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.AbstractMap;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ZGCParser
extends UnifiedGCLogParser
implements ZGCPatterns {
    private static final Logger LOGGER = Logger.getLogger(ZGCParser.class.getName());
    private final boolean debugging = Boolean.getBoolean("microsoft.debug");
    private final boolean develop = Boolean.getBoolean("microsoft.develop");
    private ZGCForwardReference forwardReference;
    private final long[] markStart = new long[3];
    private final long[] markEnd = new long[3];
    private final long[] relocateStart = new long[3];
    private final long[] relocateEnd = new long[3];
    private final MRUQueue<GCParseRule, BiConsumer<GCLogTrace, String>> parseRules = new MRUQueue();

    public ZGCParser(Diary diary, JVMEventConsumer consumer) {
        super(diary, consumer);
        this.parseRules.put(CYCLE_START, this::cycleStart);
        this.parseRules.put(PAUSE_PHASE, this::pausePhase);
        this.parseRules.put(CONCURRENT_PHASE, this::concurrentPhase);
        this.parseRules.put(LOAD, this::load);
        this.parseRules.put(MMU, this::mmu);
        this.parseRules.put(MARK_SUMMARY, this::markSummary);
        this.parseRules.put(RELOCATION_SUMMARY, this::relocationSummary);
        this.parseRules.put(NMETHODS, this::nMethods);
        this.parseRules.put(METASPACE, this::metaspace);
        this.parseRules.put(REFERENCE_PROCESSING, this::referenceProcessing);
        this.parseRules.put(CAPACITY, this::capacity);
        this.parseRules.put(MEMORY_TABLE_ENTRY_SIZE, this::sizeEntry);
        this.parseRules.put(MEMORY_TABLE_ENTRY_OCCUPANCY, this::occupancyEntry);
        this.parseRules.put(MEMORY_TABLE_ENTRY_RECLAIMED, this::reclaimed);
        this.parseRules.put(MEMORY_SUMMARY, this::memorySummary);
        this.parseRules.put(END_OF_FILE, this::endOfFile);
    }

    @Override
    public String getName() {
        return "ZGC Parser";
    }

    @Override
    protected void process(String line) {
        if (this.ignoreFrequentButUnwantedEntries(line)) {
            return;
        }
        try {
            Optional<AbstractMap.SimpleEntry> optional = this.parseRules.keys().stream().map(rule -> new AbstractMap.SimpleEntry<GCParseRule, GCLogTrace>((GCParseRule)rule, rule.parse(line))).filter(tuple -> tuple.getValue() != null).findFirst();
            if (optional.isPresent()) {
                AbstractMap.SimpleEntry ruleAndTrace = optional.get();
                this.parseRules.get(ruleAndTrace.getKey()).accept((GCLogTrace)ruleAndTrace.getValue(), line);
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.throwing(this.getName(), "process", t);
        }
        this.log(line);
    }

    private boolean ignoreFrequentButUnwantedEntries(String line) {
        return MEMORY_TABLE_HEADER.parse(line) != null;
    }

    public void endOfFile(GCLogTrace trace, String line) {
        this.record((JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
    }

    private void cycleStart(GCLogTrace trace, String s) {
        this.forwardReference = new ZGCForwardReference(this.getClock(), trace.getLongGroup(1), trace.gcCause(1, 1));
    }

    private void pausePhase(GCLogTrace trace, String s) {
        DateTimeStamp startTime = this.getClock().minus(trace.getDuration() / 1000.0);
        if ("Mark Start".equals(trace.getGroup(1))) {
            this.forwardReference.setPauseMarkStartDuration(trace.getDuration());
            this.forwardReference.setPauseMarkStart(startTime);
        } else if ("Mark End".equals(trace.getGroup(1))) {
            this.forwardReference.setPauseMarkEndDuration(trace.getDuration());
            this.forwardReference.setPauseMarkEndStart(startTime);
        } else if ("Relocate Start".equals(trace.getGroup(1))) {
            this.forwardReference.setPauseRelocateStartDuration(trace.getDuration());
            this.forwardReference.setPauseRelocateStart(startTime);
        } else {
            trace.notYetImplemented();
        }
    }

    private void concurrentPhase(GCLogTrace trace, String s) {
        DateTimeStamp startTime = this.getClock().minus(trace.getDuration() / 1000.0);
        if ("Mark".equals(trace.getGroup(1))) {
            this.forwardReference.setConcurrentMarkDuration(trace.getDuration());
            this.forwardReference.setConcurrentMarkStart(startTime);
        } else if ("Mark Free".equals(trace.getGroup(1))) {
            this.forwardReference.setConcurrentMarkFreeDuration(trace.getDuration());
            this.forwardReference.setConcurrentMarkFreeStart(startTime);
        } else if ("Process Non-Strong References".equals(trace.getGroup(1))) {
            this.forwardReference.setConcurrentProcessNonStrongReferencesDuration(trace.getDuration());
            this.forwardReference.setConcurrentProcessNonStringReferencesStart(startTime);
        } else if ("Reset Relocation Set".equals(trace.getGroup(1))) {
            this.forwardReference.setConcurrentResetRelocationSetDuration(trace.getDuration());
            this.forwardReference.setConcurrentResetRelocationSetStart(startTime);
        } else if ("Select Relocation Set".equals(trace.getGroup(1))) {
            this.forwardReference.setConcurrentSelectRelocationSetDuration(trace.getDuration());
            this.forwardReference.setConcurrentSelectRelocationSetStart(startTime);
        } else if ("Relocate".equals(trace.getGroup(1))) {
            this.forwardReference.setConcurrentSelectRelocateStart(startTime);
            this.forwardReference.setConcurrentSelectRelocateDuration(trace.getDuration());
        } else {
            trace.notYetImplemented();
        }
    }

    private void load(GCLogTrace trace, String s) {
        double[] load = new double[]{trace.getDoubleGroup(1), trace.getDoubleGroup(2), trace.getDoubleGroup(3)};
        this.forwardReference.setLoad(load);
    }

    private void mmu(GCLogTrace trace, String s) {
        double[] mmu = new double[]{trace.getDoubleGroup(1), trace.getDoubleGroup(2), trace.getDoubleGroup(3), trace.getDoubleGroup(4), trace.getDoubleGroup(5), trace.getDoubleGroup(6)};
        this.forwardReference.setMMU(mmu);
    }

    private void markSummary(GCLogTrace trace, String s) {
    }

    private void relocationSummary(GCLogTrace trace, String s) {
    }

    private void nMethods(GCLogTrace trace, String s) {
    }

    private void metaspace(GCLogTrace trace, String s) {
        ZGCMetaspaceSummary summary = new ZGCMetaspaceSummary(trace.toKBytes(1), trace.toKBytes(3), trace.toKBytes(5));
        this.forwardReference.setMetaspace(summary);
    }

    private void referenceProcessing(GCLogTrace trace, String s) {
    }

    private void capacity(GCLogTrace trace, String s) {
    }

    private void captureAtIndex(GCLogTrace trace, int index) {
        this.markStart[index] = trace.toKBytes(2);
        this.markEnd[index] = trace.toKBytes(5);
        this.relocateStart[index] = trace.toKBytes(8);
        this.relocateEnd[index] = trace.toKBytes(11);
    }

    private void sizeEntry(GCLogTrace trace, String s) {
        switch (trace.getGroup(1)) {
            case "Capacity": {
                this.captureAtIndex(trace, 0);
                break;
            }
            case "Free": {
                this.captureAtIndex(trace, 1);
                break;
            }
            case "Used": {
                this.forwardReference.setMarkStart(new ZGCMemoryPoolSummary(this.markStart[0], this.markStart[1], trace.toKBytes(2)));
                this.forwardReference.setMarkEnd(new ZGCMemoryPoolSummary(this.markEnd[0], this.markEnd[1], trace.toKBytes(5)));
                this.forwardReference.setRelocateStart(new ZGCMemoryPoolSummary(this.relocateStart[0], this.relocateStart[1], trace.toKBytes(8)));
                this.forwardReference.setRelocateEnd(new ZGCMemoryPoolSummary(this.relocateEnd[0], this.relocateEnd[1], trace.toKBytes(11)));
                break;
            }
            default: {
                LOGGER.warning(trace.getGroup(1) + "not recognized, Heap Occupancy/size is is ignored. Please report this with the GC log");
            }
        }
    }

    private void occupancyEntry(GCLogTrace trace, String s) {
        OccupancySummary summary = new OccupancySummary(trace.toKBytes(2), trace.toKBytes(5), trace.toKBytes(8));
        if ("Live".equals(trace.getGroup(1))) {
            this.forwardReference.setMarkedLive(summary);
        } else if ("Allocated".equals(trace.getGroup(1))) {
            this.forwardReference.setAllocated(summary);
        } else if ("Garbage".equals(trace.getGroup(1))) {
            this.forwardReference.setGarbage(summary);
        } else {
            trace.notYetImplemented();
        }
    }

    private void reclaimed(GCLogTrace trace, String s) {
        this.forwardReference.setReclaimed(new ReclaimSummary(trace.toKBytes(1), trace.toKBytes(4)));
    }

    private void memorySummary(GCLogTrace trace, String s) {
        this.forwardReference.setMemorySummary(new ReclaimSummary(trace.toKBytes(2), trace.toKBytes(5)));
        this.record();
    }

    private void log(String line) {
        if (this.debugging) {
            LOGGER.log(Level.FINE, "ZGCHeapParser missed: {0}", line);
        }
        LOGGER.log(Level.WARNING, "Missed: {0}", line);
    }

    public void logMissedFirstRecordForEvent(String line) {
        LOGGER.log(Level.WARNING, "Missing initial record for: {0}", line);
    }

    public void record() {
        this.record((JVMEvent)this.forwardReference.toZGCCycle(this.getClock()));
    }

    public void record(JVMEvent event) {
        this.consumer.record(event);
        this.forwardReference = null;
    }

    private class ZGCForwardReference {
        private final DateTimeStamp startTimeStamp;
        private final GCCause gcCause;
        private final long gcId;
        private DateTimeStamp pauseMarkStart;
        private double pauseMarkStartDuration;
        private DateTimeStamp pauseMarkEndStart;
        private double pauseMarkEndDuration;
        private DateTimeStamp pauseRelocateStart;
        private double pauseRelocateStartDuration;
        private DateTimeStamp concurrentMarkStart;
        private double concurrentMarkDuration;
        private double concurrentMarkFreeDuration;
        private DateTimeStamp concurrentMarkFreeStart;
        private DateTimeStamp concurrentProcessNonStringReferencesStart;
        private double concurrentProcessNonStrongReferencesDuration;
        private DateTimeStamp concurrentResetRelocationSetStart;
        private double concurrentResetRelocationSetDuration;
        private DateTimeStamp concurrentSelectRelocationSetStart;
        private double concurrentSelectRelocationSetDuration;
        private DateTimeStamp concurrentSelectRelocateStart;
        private double concurrentSelectRelocateDuration;
        private ZGCMemoryPoolSummary markStart;
        private ZGCMemoryPoolSummary markEnd;
        private ZGCMemoryPoolSummary relocatedStart;
        private ZGCMemoryPoolSummary relocateEnd;
        private OccupancySummary markedLive;
        private OccupancySummary allocated;
        private OccupancySummary garbage;
        private ReclaimSummary reclaimed;
        private ReclaimSummary memorySummary;
        private ZGCMetaspaceSummary metaspace;
        private double[] load = new double[3];
        private double[] mmu = new double[6];

        public ZGCForwardReference(DateTimeStamp dateTimeStamp, long gcId, GCCause cause) {
            this.startTimeStamp = dateTimeStamp;
            this.gcId = gcId;
            this.gcCause = cause;
        }

        ZGCCycle toZGCCycle(DateTimeStamp endTime) {
            ZGCCycle cycle = new ZGCCycle(this.startTimeStamp, this.gcCause, endTime.minus(this.startTimeStamp));
            cycle.setGcId(this.gcId);
            cycle.setPauseMarkStart(this.pauseMarkStart, this.pauseMarkStartDuration);
            cycle.setConcurrentMark(this.concurrentMarkStart, this.concurrentMarkDuration);
            cycle.setConcurrentMarkFree(this.concurrentMarkFreeStart, this.concurrentMarkFreeDuration);
            cycle.setPauseMarkEnd(this.pauseMarkEndStart, this.pauseMarkEndDuration);
            cycle.setConcurrentProcessNonStrongReferences(this.concurrentProcessNonStringReferencesStart, this.concurrentProcessNonStrongReferencesDuration);
            cycle.setConcurrentResetRelocationSet(this.concurrentResetRelocationSetStart, this.concurrentResetRelocationSetDuration);
            cycle.setConcurrentSelectRelocationSet(this.concurrentSelectRelocationSetStart, this.concurrentSelectRelocationSetDuration);
            cycle.setPauseRelocateStart(this.pauseRelocateStart, this.pauseRelocateStartDuration);
            cycle.setConcurrentRelocate(this.concurrentSelectRelocateStart, this.concurrentSelectRelocateDuration);
            cycle.setMarkStart(this.markStart);
            cycle.setMarkEnd(this.markEnd);
            cycle.setRelocateStart(this.relocatedStart);
            cycle.setRelocateEnd(this.relocateEnd);
            cycle.setLive(this.markedLive);
            cycle.setAllocated(this.allocated);
            cycle.setGarbage(this.garbage);
            cycle.setReclaimed(this.reclaimed);
            cycle.setMemorySummary(this.memorySummary);
            cycle.setMetaspace(this.metaspace);
            cycle.setLoadAverages(this.load);
            cycle.setMMU(this.mmu);
            return cycle;
        }

        public void setPauseMarkStart(DateTimeStamp pauseMarkStart) {
            this.pauseMarkStart = pauseMarkStart;
        }

        public void setPauseMarkStartDuration(double pauseMarkStartDuration) {
            this.pauseMarkStartDuration = pauseMarkStartDuration;
        }

        public void setPauseMarkEndStart(DateTimeStamp pauseMarkEndStart) {
            this.pauseMarkEndStart = pauseMarkEndStart;
        }

        public void setPauseMarkEndDuration(double pauseMarkEndDuration) {
            this.pauseMarkEndDuration = pauseMarkEndDuration;
        }

        public void setPauseRelocateStart(DateTimeStamp pauseRelocateStart) {
            this.pauseRelocateStart = pauseRelocateStart;
        }

        public void setPauseRelocateStartDuration(double pauseRelocateStartDuration) {
            this.pauseRelocateStartDuration = pauseRelocateStartDuration;
        }

        public void setConcurrentMarkStart(DateTimeStamp concurrentMarkStart) {
            this.concurrentMarkStart = concurrentMarkStart;
        }

        public void setConcurrentMarkDuration(double concurrentMarkDuration) {
            this.concurrentMarkDuration = concurrentMarkDuration;
        }

        public void setConcurrentMarkFreeStart(DateTimeStamp concurrentMarkFreeStart) {
            this.concurrentMarkFreeStart = concurrentMarkFreeStart;
        }

        public void setConcurrentMarkFreeDuration(double concurrentMarkFreeDuration) {
            this.concurrentMarkFreeDuration = concurrentMarkFreeDuration;
        }

        public void setConcurrentProcessNonStringReferencesStart(DateTimeStamp concurrentProcessNonStringReferencesStart) {
            this.concurrentProcessNonStringReferencesStart = concurrentProcessNonStringReferencesStart;
        }

        public void setConcurrentProcessNonStrongReferencesDuration(double concurrentProcessNonStrongReferencesDuration) {
            this.concurrentProcessNonStrongReferencesDuration = concurrentProcessNonStrongReferencesDuration;
        }

        public void setConcurrentResetRelocationSetStart(DateTimeStamp concurrentResetRelocationSetStart) {
            this.concurrentResetRelocationSetStart = concurrentResetRelocationSetStart;
        }

        public void setConcurrentResetRelocationSetDuration(double concurrentResetRelocationSetDuration) {
            this.concurrentResetRelocationSetDuration = concurrentResetRelocationSetDuration;
        }

        public void setConcurrentSelectRelocationSetStart(DateTimeStamp concurrentSelectRelocationSetStart) {
            this.concurrentSelectRelocationSetStart = concurrentSelectRelocationSetStart;
        }

        public void setConcurrentSelectRelocationSetDuration(double concurrentSelectRelocationSetDuration) {
            this.concurrentSelectRelocationSetDuration = concurrentSelectRelocationSetDuration;
        }

        public void setConcurrentSelectRelocateStart(DateTimeStamp concurrentSelectRelocateStart) {
            this.concurrentSelectRelocateStart = concurrentSelectRelocateStart;
        }

        public void setConcurrentSelectRelocateDuration(double concurrentSelectRelocateDuration) {
            this.concurrentSelectRelocateDuration = concurrentSelectRelocateDuration;
        }

        public void setMarkStart(ZGCMemoryPoolSummary summary) {
            this.markStart = summary;
        }

        public void setMarkEnd(ZGCMemoryPoolSummary summary) {
            this.markEnd = summary;
        }

        public void setRelocateStart(ZGCMemoryPoolSummary summary) {
            this.relocatedStart = summary;
        }

        public void setRelocateEnd(ZGCMemoryPoolSummary summary) {
            this.relocateEnd = summary;
        }

        public void setMarkedLive(OccupancySummary summary) {
            this.markedLive = summary;
        }

        public void setAllocated(OccupancySummary summary) {
            this.allocated = summary;
        }

        public void setGarbage(OccupancySummary summary) {
            this.garbage = summary;
        }

        public void setReclaimed(ReclaimSummary summary) {
            this.reclaimed = summary;
        }

        public void setMemorySummary(ReclaimSummary summary) {
            this.memorySummary = summary;
        }

        public void setMetaspace(ZGCMetaspaceSummary summary) {
            this.metaspace = summary;
        }

        public void setLoad(double[] load) {
            this.load = load;
        }

        public void setMMU(double[] mmu) {
            this.mmu = mmu;
        }
    }
}

