/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser.jvm;

import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GCCauses;
import com.microsoft.gctoolkit.jvm.Diarizer;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.jvm.SupportedFlags;
import com.microsoft.gctoolkit.parser.CMSPatterns;
import com.microsoft.gctoolkit.parser.G1GCPatterns;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.JVMPatterns;
import com.microsoft.gctoolkit.parser.ParallelPatterns;
import com.microsoft.gctoolkit.parser.PreUnifiedTokens;
import com.microsoft.gctoolkit.parser.SerialPatterns;
import com.microsoft.gctoolkit.parser.SharedPatterns;
import com.microsoft.gctoolkit.parser.SimplePatterns;
import com.microsoft.gctoolkit.parser.TenuredPatterns;
import com.microsoft.gctoolkit.parser.jvm.CommandLineFlag;
import com.microsoft.gctoolkit.parser.jvm.GarbageCollectorFlag;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PreUnifiedDiarizer
implements Diarizer {
    private static final Logger LOGGER = Logger.getLogger(PreUnifiedDiarizer.class.getName());
    private int lineCount = 10000;
    private static final GCParseRule TENURED_BLOCK = new GCParseRule("TENURED_BLOCK", "\\[Tenured: \\d+K->\\d+K\\(\\d+K\\), \\d+[.|,]\\d{7} secs\\]");
    private static final GCParseRule PREFIX = new GCParseRule("PREFIX", "(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): (?:#\\d+: )?\\[GC ?(\\([a-zA-Z\\. 1]+?\\(?\\){1,2})?\\s*");
    private static final GCParseRule FULL_PREFIX = new GCParseRule("FULL_PREFIX", "(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): (?:#\\d+: )?\\[Full GC ?(\\([a-zA-Z\\. 1]+?\\(?\\){1,2})?\\s*");
    private static final GCParseRule G1GC_PREFIX = new GCParseRule("G1GC_PREFIX", "(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): \\[GC pause (\\([a-zA-Z\\. 1]+?\\(?\\){1,2})?\\s*");
    private static final GCParseRule REFERENCE_PROCESSING_BLOCK = new GCParseRule("REFERENCE_PROCESSING_BLOCK", "(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): \\[(Soft|Weak|Final)Reference, (\\d+) refs, (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms)\\](?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): \\[(Soft|Weak|Final)Reference, (\\d+) refs, (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms)\\](?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): \\[(Soft|Weak|Final)Reference, (\\d+) refs, (-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms)\\](?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): \\[PhantomReference, (\\d+) refs, (?:(\\d+) refs, )?(-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms)\\](?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): \\[JNI Weak Reference, (?:(\\d+) refs, )?(-?\\d+(?:\\.|,)\\d+)\\s?(?:secs?|ms)\\]");
    private static final Pattern excludeG1Ergonomics = Pattern.compile("^\\d+(\\.|,)\\d+: \\[G1Ergonomics");
    private final Diary diary = new Diary();
    private boolean firstCMSCycle = false;
    private int youngCountAfterFirstCMSCycle = 0;
    private int collectionCount = 0;
    private int youngCollectionCount = 0;
    private int tenuringSummary = 0;
    private boolean ageTableDetected = false;
    private int maxTenuringThreshold = 15;
    private int setGCFlags = 0;
    private DateTimeStamp timeOfFirstEvent = null;
    private boolean simpleParallelOrParNewDetected;
    private boolean simpleFullGCDetected;
    private boolean simpleCMSCycleDetected;
    private static final Pattern VERSION = Pattern.compile("(1)\\.([6-9])\\.0(_\\d*)?");

    public PreUnifiedDiarizer() {
        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.UNIFIED_LOGGING, SupportedFlags.ZGC, SupportedFlags.SHENANDOAH});
        this.simpleParallelOrParNewDetected = false;
        this.simpleFullGCDetected = false;
        this.simpleCMSCycleDetected = false;
    }

    public Diary getDiary() {
        return this.diary;
    }

    public boolean isUnified() {
        return false;
    }

    public String getCommandLine() {
        return "";
    }

    public int getMaxTenuringThreshold() {
        return this.maxTenuringThreshold;
    }

    public boolean hasJVMEvents() {
        return this.getDiary().isApplicationStoppedTime() || this.getDiary().isApplicationRunningTime() || this.getDiary().isApplicationRunningTime() || this.getDiary().isTLABData();
    }

    private boolean versionIsKnown() {
        return this.getDiary().isStateKnown(SupportedFlags.JDK80) && this.getDiary().isStateKnown(SupportedFlags.JDK70) && this.getDiary().isStateKnown(SupportedFlags.PRE_JDK70_40);
    }

    public boolean completed() {
        return this.getDiary().isComplete() || this.lineCount < 1 || this.simpleCMSCycleDetected && (this.simpleCMSCycleDetected || this.simpleFullGCDetected);
    }

    public void fillInKnowns() {
        if (this.simpleCMSCycleDetected) {
            this.getDiary().setTrue(SupportedFlags.CMS);
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.SERIAL, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.GC_CAUSE, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.RSET_STATS, SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK80});
            if (this.youngCollectionCount == 0 || this.ageTableDetected || !this.getDiary().isTenuringDistribution()) {
                this.getDiary().setTrue(SupportedFlags.PARNEW);
                this.getDiary().setFalse(SupportedFlags.DEFNEW);
            } else {
                this.getDiary().setTrue(SupportedFlags.DEFNEW);
                this.getDiary().setFalse(SupportedFlags.PARNEW);
            }
        } else if (this.simpleFullGCDetected) {
            if (this.ageTableDetected) {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.SERIAL});
            } else {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
            }
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.SERIAL, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.GC_CAUSE, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.RSET_STATS, SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK80});
        } else if (this.simpleParallelOrParNewDetected) {
            if (this.ageTableDetected) {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
            } else {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS});
            }
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.GC_CAUSE, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.RSET_STATS, SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK80});
        }
        this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION, SupportedFlags.PRINT_PROMOTION_FAILURE, SupportedFlags.PRINT_FLS_STATISTICS});
    }

    public boolean diarize(String line) {
        this.timeOfFirstEvent(line);
        --this.lineCount;
        if (line.startsWith("Java HotSpot(TM)") || line.startsWith("OpenJDK")) {
            this.parseJVMVersion(line);
        } else if (line.startsWith("CommandLine ")) {
            this.evaluateCommandLineFlags(line.split(" "));
            this.lineCount = 25;
            this.collectionCount = 3;
        } else if (!this.jvmActivityFlag(line)) {
            this.collector(line);
            this.version(line);
            this.details(line);
        }
        return this.completed();
    }

    public DateTimeStamp getTimeOfFirstEvent() {
        if (this.timeOfFirstEvent == null) {
            this.timeOfFirstEvent = new DateTimeStamp(0.0);
        }
        return this.timeOfFirstEvent;
    }

    private void timeOfFirstEvent(String line) {
        if (this.timeOfFirstEvent == null) {
            Matcher matcher = excludeG1Ergonomics.matcher(line);
            if (matcher.find()) {
                return;
            }
            GCLogTrace trace = PreUnifiedTokens.DATE_TIMESTAMP_RECORD.parse(line);
            if (trace != null) {
                this.timeOfFirstEvent = trace.getDateTimeStamp();
                this.diary.setTimeOfFirstEvent(this.timeOfFirstEvent);
            }
        }
    }

    private boolean jvmActivityFlag(String line) {
        if (this.getDiary().isStateKnown(new SupportedFlags[]{SupportedFlags.APPLICATION_STOPPED_TIME, SupportedFlags.APPLICATION_CONCURRENT_TIME, SupportedFlags.TLAB_DATA})) {
            return false;
        }
        if (JVMPatterns.APPLICATION_STOP_TIME.parse(line) != null || JVMPatterns.SIMPLE_APPLICATION_STOP_TIME.parse(line) != null || JVMPatterns.APPLICATION_STOP_TIME_WITH_STOPPING_TIME.parse(line) != null) {
            this.getDiary().setTrue(SupportedFlags.APPLICATION_STOPPED_TIME);
            return true;
        }
        if (JVMPatterns.APPLICATION_TIME.parse(line) != null || JVMPatterns.SIMPLE_APPLICATION_TIME.parse(line) != null) {
            this.getDiary().setTrue(SupportedFlags.APPLICATION_CONCURRENT_TIME);
            return true;
        }
        if (JVMPatterns.TLAB_CONT.parse(line) != null) {
            this.getDiary().setTrue(SupportedFlags.TLAB_DATA);
            return true;
        }
        if (this.collectionCount > 1) {
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.APPLICATION_STOPPED_TIME, SupportedFlags.APPLICATION_CONCURRENT_TIME, SupportedFlags.TLAB_DATA});
        }
        return false;
    }

    private void collector(String line) {
        GCLogTrace trace;
        if (!this.getDiary().isStateKnown(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.DEFNEW, SupportedFlags.PARALLELGC, SupportedFlags.G1GC}) || !this.getDiary().isStateKnown(SupportedFlags.GC_DETAILS) || this.collectionCount < 3) {
            if (line.contains("[PSYoungGen:")) {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION, SupportedFlags.RSET_STATS});
                ++this.collectionCount;
                ++this.youngCollectionCount;
                trace = ParallelPatterns.PSYOUNGGEN.parse(line);
                if (trace != null) {
                    this.getDiary().setTrue(SupportedFlags.GC_DETAILS);
                    this.getDiary().setFalse(SupportedFlags.TENURING_DISTRIBUTION);
                    this.getDiary().setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
                    this.setGCCause(trace.getGroup(3));
                } else if (ParallelPatterns.PS_DETAILS_WITH_TENURING.parse(line) != null) {
                    this.getDiary().setTrue(SupportedFlags.GC_DETAILS);
                    this.getDiary().setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
                }
            } else if (line.contains("ParNew")) {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                ++this.collectionCount;
                ++this.youngCollectionCount;
                trace = CMSPatterns.PARNEW.parse(line);
                if (trace != null) {
                    this.getDiary().setTrue(SupportedFlags.GC_DETAILS);
                    this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                    this.setGCCause(trace.getGroup(4));
                } else {
                    trace = CMSPatterns.PARNEW_TENURING.parse(line);
                    if (trace != null) {
                        this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION});
                        this.getDiary().setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
                        this.setGCCause(trace.getGroup(3));
                    } else {
                        trace = SimplePatterns.PARNEW_NO_DETAILS.parse(line);
                        if (trace != null) {
                            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                            this.setGCCause(trace.getGroup(3));
                        } else {
                            trace = SimplePatterns.PARNEW_START.parse(line);
                            if (trace != null) {
                                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.GC_DETAILS, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC});
                                this.setGCCause(trace.groupCount() > 2 ? trace.getGroup(3) : null);
                            } else {
                                trace = CMSPatterns.PARNEW_REFERENCE_SPLIT.parse(line);
                                if (trace != null) {
                                    this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.PRINT_REFERENCE_GC});
                                    this.setGCCause(trace.getGroup(3));
                                }
                            }
                        }
                    }
                }
            } else {
                trace = SerialPatterns.DEFNEW.parse(line);
                if (trace != null) {
                    ++this.collectionCount;
                    ++this.youngCollectionCount;
                    this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.GC_DETAILS});
                    this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.PARNEW, SupportedFlags.G1GC, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.RSET_STATS, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                    this.setGCCause(trace.getGroup(3));
                } else {
                    trace = SerialPatterns.DEFNEW_TENURING.parse(line);
                    if (trace != null) {
                        ++this.collectionCount;
                        ++this.youngCollectionCount;
                        this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION});
                        this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                        this.setGCCause(trace.getGroup(3));
                    } else if (SimplePatterns.PARNEW_NO_DETAILS.parse(line) != null) {
                        ++this.collectionCount;
                        ++this.youngCollectionCount;
                        this.getDiary().setTrue(SupportedFlags.PARNEW);
                        this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.GC_CAUSE, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.RSET_STATS, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                    } else if (SimplePatterns.YOUNG_NO_DETAILS.parse(line) != null) {
                        ++this.collectionCount;
                        ++this.youngCollectionCount;
                        this.simpleParallelOrParNewDetected = true;
                    } else if (SimplePatterns.FULL_NO_GC_DETAILS.parse(line) != null) {
                        ++this.collectionCount;
                        this.simpleFullGCDetected = true;
                        this.simpleParallelOrParNewDetected = true;
                    } else {
                        trace = SimplePatterns.GC_START.parse(line);
                        if (trace != null) {
                            ++this.collectionCount;
                            this.simpleParallelOrParNewDetected = true;
                            ++this.youngCollectionCount;
                            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                            this.setGCCause(trace.getGroup(3));
                        } else if (SimplePatterns.CMS_NO_DETAILS.parse(line) != null) {
                            ++this.collectionCount;
                            this.simpleParallelOrParNewDetected = true;
                            this.simpleCMSCycleDetected = true;
                            this.firstCMSCycle = true;
                        } else {
                            trace = G1GCPatterns.G1_YOUNG_SPLIT_START.parse(line);
                            if (trace != null) {
                                ++this.collectionCount;
                                ++this.youngCollectionCount;
                                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
                                this.getDiary().setTrue(SupportedFlags.G1GC);
                                this.getDiary().setTrue(SupportedFlags.GC_DETAILS);
                                if (trace.gcCause() == GCCause.GCCAUSE_NOT_SET) {
                                    this.getDiary().setFalse(SupportedFlags.GC_CAUSE);
                                } else if (trace.gcCause() == GCCause.METADATA_GENERATION_THRESHOLD) {
                                    this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
                                    this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
                                } else if (trace.gcCause() == GCCause.G1_EVACUATION_PAUSE || trace.gcCause(3, 0) == GCCause.G1_HUMONGOUS_ALLOCATION) {
                                    this.getDiary().setTrue(SupportedFlags.GC_CAUSE);
                                    this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
                                }
                            } else {
                                trace = G1GCPatterns.G1_DETAILS.parse(line);
                                if (trace != null) {
                                    ++this.collectionCount;
                                    ++this.youngCollectionCount;
                                    this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.GC_DETAILS});
                                    this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                                    if (trace.gcCause(3, 0) == GCCause.GCCAUSE_NOT_SET) {
                                        this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
                                        this.getDiary().setTrue(SupportedFlags.JDK70);
                                    } else {
                                        this.getDiary().setFalse(SupportedFlags.GC_CAUSE);
                                        this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
                                    }
                                } else {
                                    trace = G1GCPatterns.YOUNG.parse(line);
                                    if (trace != null) {
                                        ++this.collectionCount;
                                        ++this.youngCollectionCount;
                                        this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.GC_DETAILS, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                                        this.getDiary().setTrue(SupportedFlags.G1GC);
                                        this.checkForGCCause(trace);
                                    } else {
                                        trace = G1GCPatterns.G1_DETAILS_REFERENCE_GC.parse(line);
                                        if (trace != null) {
                                            ++this.collectionCount;
                                            ++this.youngCollectionCount;
                                            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                                            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.PRINT_REFERENCE_GC});
                                            if (trace.getGroup(3) != null) {
                                                this.getDiary().setTrue(SupportedFlags.GC_CAUSE);
                                            } else {
                                                this.getDiary().setFalse(SupportedFlags.GC_CAUSE);
                                            }
                                        } else if (G1GCPatterns.G1_INITIAL_MARK.parse(line) != null) {
                                            ++this.collectionCount;
                                            ++this.youngCollectionCount;
                                            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
                                            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.GC_DETAILS, SupportedFlags.GC_CAUSE, SupportedFlags.TENURING_DISTRIBUTION});
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (this.getDiary().isTrue(SupportedFlags.ADAPTIVE_SIZING) && (trace = G1GCPatterns.YOUNG_SPLIT_BY_G1ERGONOMICS.parse(line)) != null) {
            ++this.collectionCount;
            ++this.youngCollectionCount;
            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.GC_DETAILS});
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
            this.checkForGCCause(trace);
        }
        if (ParallelPatterns.PS_FULL_GC_PERM.parse(line) != null) {
            ++this.collectionCount;
            this.getDiary().setTrue(SupportedFlags.JDK70);
            this.getDiary().setFalse(SupportedFlags.JDK80);
            if (line.contains(" [PSYoungGen: ")) {
                this.getDiary().setTrue(SupportedFlags.PARALLELGC);
            }
            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARALLELOLDGC, SupportedFlags.GC_DETAILS});
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.G1GC});
            this.getDiary().setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
            this.getDiary().setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
        } else if (ParallelPatterns.PS_FULL_GC_META.parse(line) != null) {
            ++this.collectionCount;
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
            this.getDiary().setTrue(SupportedFlags.JDK80);
            if (line.contains(" [PSYoungGen: ")) {
                this.getDiary().setTrue(SupportedFlags.PARALLELGC);
            }
            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARALLELOLDGC, SupportedFlags.GC_DETAILS});
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.SERIAL, SupportedFlags.ICMS, SupportedFlags.G1GC});
            this.getDiary().setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
            this.getDiary().setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
        } else if (line.contains("CMS-initial-mark")) {
            ++this.collectionCount;
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC});
            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.CMS, SupportedFlags.GC_DETAILS});
        } else if (CMSPatterns.SERIAL_FULL.parse(line) != null) {
            ++this.collectionCount;
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.G1GC});
            this.getDiary().setTrue(SupportedFlags.SERIAL);
            this.getDiary().setTrue(SupportedFlags.GC_DETAILS);
            this.getDiary().setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
            if (line.contains("Metaspace")) {
                this.getDiary().setFalse(SupportedFlags.JDK70);
            }
            if (line.contains("Tenured")) {
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.CMS, SupportedFlags.ICMS});
                this.getDiary().setTrue(SupportedFlags.SERIAL);
            } else if (line.contains("CMS")) {
                this.getDiary().setFalse(SupportedFlags.SERIAL);
                this.getDiary().setTrue(SupportedFlags.CMS);
            }
        } else if (CMSPatterns.SERIAL_FULL80.parse(line) != null) {
            ++this.collectionCount;
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.JDK70});
            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.SERIAL, SupportedFlags.GC_DETAILS, SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
        } else if (TENURED_BLOCK.parse(line) != null) {
            ++this.collectionCount;
            this.getDiary().setFalse(SupportedFlags.CMS);
            this.getDiary().setFalse(SupportedFlags.ICMS);
            this.getDiary().setTrue(SupportedFlags.SERIAL);
            this.getDiary().setFalse(SupportedFlags.G1GC);
        }
        if (this.getDiary().isTrue(SupportedFlags.CMS) && !this.getDiary().isStateKnown(SupportedFlags.ICMS)) {
            if (this.firstCMSCycle) {
                if (line.contains("ParNew") || line.contains("DefNew")) {
                    ++this.youngCountAfterFirstCMSCycle;
                }
                if (line.contains("icms_dc")) {
                    this.getDiary().setTrue(SupportedFlags.ICMS);
                } else if (this.youngCountAfterFirstCMSCycle > 1) {
                    this.getDiary().setFalse(SupportedFlags.ICMS);
                }
            }
            if (line.contains("concurrent-reset")) {
                this.firstCMSCycle = true;
            }
        } else if (this.getDiary().isTrue(SupportedFlags.G1GC) && G1GCPatterns.G1_MEMORY_SUMMARY.parse(line) != null) {
            if (line.contains("Metaspace")) {
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
                this.getDiary().setTrue(SupportedFlags.JDK80);
            } else {
                this.getDiary().setTrue(SupportedFlags.JDK70);
                this.getDiary().setFalse(SupportedFlags.JDK80);
            }
        }
    }

    private void checkForGCCause(GCLogTrace trace) {
        if (trace.gcCause(3, 0) == GCCause.METADATA_GENERATION_THRESHOLD) {
            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
        } else if (trace.gcCause(3, 0) == GCCause.G1_EVACUATION_PAUSE || trace.gcCause(3, 0) == GCCause.G1_HUMONGOUS_ALLOCATION) {
            this.getDiary().setTrue(SupportedFlags.GC_CAUSE);
        }
    }

    private void version(String line) {
        if (this.versionIsKnown()) {
            return;
        }
        GCLogTrace trace = ParallelPatterns.PERM_SPACE_RECORD.parse(line);
        if (trace != null) {
            String value = trace.getGroup(1).trim();
            if ("CMS Perm".equals(value)) {
                this.getDiary().setTrue(SupportedFlags.JDK70);
                this.getDiary().setFalse(SupportedFlags.JDK80);
            } else if ("PS Perm".equals(value)) {
                this.getDiary().setTrue(SupportedFlags.JDK70);
                this.getDiary().setFalse(SupportedFlags.JDK80);
            } else if ("Perm".equals(value)) {
                this.getDiary().setTrue(SupportedFlags.JDK70);
                this.getDiary().setFalse(SupportedFlags.JDK80);
            } else if ("PSPermGen".equals(value)) {
                this.getDiary().setTrue(SupportedFlags.JDK70);
                this.getDiary().setFalse(SupportedFlags.JDK80);
            } else if ("Metaspace".equals(value)) {
                this.getDiary().setTrue(SupportedFlags.JDK80);
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
            }
        } else if (SharedPatterns.META_SPACE_RECORD.parse(line) != null) {
            this.getDiary().setTrue(SupportedFlags.JDK80);
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
        }
        if (line.contains("(System)")) {
            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
        } else if (line.contains("(System.gc()")) {
            this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
            this.getDiary().setTrue(SupportedFlags.GC_CAUSE);
        } else if (this.getDiary().isGenerationalKnown() && this.getDiary().isGenerational()) {
            trace = PREFIX.parse(line);
            if (trace != null) {
                if (trace.getGroup(3) == null && this.getDiary().isTrue(SupportedFlags.GC_DETAILS)) {
                    this.getDiary().setTrue(SupportedFlags.JDK70);
                    this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.JDK80, SupportedFlags.GC_CAUSE});
                } else if (trace.gcCause(3, 0) != GCCause.GCCAUSE_NOT_SET) {
                    this.getDiary().setTrue(SupportedFlags.GC_CAUSE);
                    this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
                }
            } else {
                trace = FULL_PREFIX.parse(line);
                if (trace != null) {
                    if (trace.getGroup(3) == null && this.getDiary().isTrue(SupportedFlags.GC_DETAILS)) {
                        this.getDiary().setTrue(SupportedFlags.JDK70);
                        this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
                    } else if (trace.gcCause(3, 0) != GCCause.GCCAUSE_NOT_SET) {
                        this.getDiary().setTrue(SupportedFlags.GC_CAUSE);
                        this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
                    }
                }
            }
        } else if (this.getDiary().isG1GCKnown() && this.getDiary().isG1GC() && (trace = G1GC_PREFIX.parse(line)) != null) {
            if (this.getDiary().isTrue(SupportedFlags.GC_DETAILS) && trace.gcCause() == GCCause.GCCAUSE_NOT_SET) {
                this.getDiary().setTrue(SupportedFlags.JDK70);
                this.getDiary().setFalse(SupportedFlags.JDK80);
            } else {
                this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
            }
        }
    }

    private void details(String line) {
        GCLogTrace gcLogTrace;
        GCLogTrace trace = PREFIX.parse(line);
        if (trace != null) {
            String cause = trace.getGroup(3);
            if (cause != null) {
                this.getDiary().setTrue(SupportedFlags.GC_CAUSE);
                if ("(System)".equals(cause)) {
                    this.getDiary().setFalse(SupportedFlags.JDK80);
                    this.getDiary().setTrue(SupportedFlags.JDK70);
                    this.getDiary().setTrue(SupportedFlags.PRE_JDK70_40);
                } else if ("(System.gc())".equals(cause)) {
                    this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
                } else {
                    this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
                }
            } else {
                trace = G1GC_PREFIX.parse(line);
                if (trace != null) {
                    cause = trace.getGroup(3);
                    if (cause == null) {
                        this.getDiary().setTrue(SupportedFlags.PRE_JDK70_40);
                    } else {
                        this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
                    }
                } else {
                    this.getDiary().setFalse(SupportedFlags.GC_CAUSE);
                }
            }
            this.getDiary().setFalse(SupportedFlags.GC_CAUSE);
        } else if (line.contains("promotion failure size =")) {
            this.getDiary().setTrue(SupportedFlags.PRINT_PROMOTION_FAILURE);
        } else if (CMSPatterns.FLS_HEADER.parse(line) != null) {
            this.getDiary().setTrue(SupportedFlags.PRINT_FLS_STATISTICS);
        }
        if (this.getDiary().isG1GC()) {
            if (line.startsWith("[GC Worker Start (ms): ")) {
                if (line.startsWith("[GC Worker Start (ms): Min: ")) {
                    this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
                } else {
                    this.getDiary().setTrue(SupportedFlags.PRE_JDK70_40);
                }
            }
        } else if (line.contains("AdaptiveSizePolicy::")) {
            this.getDiary().setTrue(SupportedFlags.ADAPTIVE_SIZING);
        }
        if (this.youngCollectionCount > 1 && !this.getDiary().isStateKnown(SupportedFlags.PRINT_REFERENCE_GC)) {
            this.getDiary().setFalse(SupportedFlags.PRINT_REFERENCE_GC);
        }
        if ((gcLogTrace = SharedPatterns.MEMORY_SUMMARY_RULE.parse(line)) != null && gcLogTrace.next() != null) {
            this.getDiary().setTrue(SupportedFlags.GC_DETAILS);
        }
        if (line.startsWith("{Heap before GC invocations=")) {
            this.getDiary().setTrue(SupportedFlags.PRINT_HEAP_AT_GC);
        } else if (this.collectionCount > 1) {
            this.getDiary().setFalse(SupportedFlags.PRINT_HEAP_AT_GC);
        }
        trace = TenuredPatterns.TENURING_SUMMARY.parse(line);
        if (trace != null) {
            if (this.tenuringSummary > 0 && !this.ageTableDetected) {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.CMS_DEBUG_LEVEL_1});
            } else {
                this.getDiary().setTrue(SupportedFlags.TENURING_DISTRIBUTION);
            }
            if (trace.getIntegerGroup(2) > 0) {
                ++this.tenuringSummary;
            }
            if (trace.getIntegerGroup(3) > 15) {
                this.maxTenuringThreshold = trace.getIntegerGroup(3);
                this.getDiary().setTrue(SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION);
            } else {
                this.getDiary().setFalse(SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION);
            }
        } else if (TenuredPatterns.TENURING_AGE_BREAKDOWN.parse(line) != null) {
            this.ageTableDetected = true;
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
        } else if (this.getDiary().isTenuringDistributionKnown() && this.collectionCount > 1 && this.youngCollectionCount > 1) {
            this.getDiary().setFalse(SupportedFlags.TENURING_DISTRIBUTION);
        }
        if (line.contains("G1Ergonomics") && (line.contains("CSet Construction") || line.contains("Heap Sizing"))) {
            ++this.collectionCount;
            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.ADAPTIVE_SIZING});
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
        }
        if (REFERENCE_PROCESSING_BLOCK.parse(line) != null) {
            this.getDiary().setTrue(SupportedFlags.PRINT_REFERENCE_GC);
        }
        if (line.startsWith("Concurrent RS processed")) {
            ++this.collectionCount;
            this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
        } else if (line.contains(" (cardTable: ")) {
            this.getDiary().setTrue(SupportedFlags.CMS_DEBUG_LEVEL_1);
        }
        if (this.collectionCount > 1) {
            if (!this.getDiary().isCMSDebugLevel1Known()) {
                this.getDiary().setFalse(SupportedFlags.CMS_DEBUG_LEVEL_1);
            }
            if (!this.getDiary().isAdaptiveSizingKnown()) {
                this.getDiary().setFalse(SupportedFlags.ADAPTIVE_SIZING);
            }
            if (!this.getDiary().isRSetStatsKnown()) {
                this.getDiary().setFalse(SupportedFlags.RSET_STATS);
            }
        }
    }

    private void evaluateCommandLineFlags(String[] commandLineFlags) {
        block22: for (String rawFlag : commandLineFlags) {
            String flag = this.processRawFlag(rawFlag);
            boolean flagTurnedOn = this.isSetToTrue(rawFlag);
            CommandLineFlag supportedFlag = CommandLineFlag.fromString(flag);
            if (supportedFlag != null) {
                switch (supportedFlag) {
                    case PrintGCApplicationStoppedTime: {
                        this.getDiary().setState(SupportedFlags.APPLICATION_STOPPED_TIME, flagTurnedOn);
                        break;
                    }
                    case PrintGCApplicationConcurrentTime: {
                        this.getDiary().setState(SupportedFlags.APPLICATION_CONCURRENT_TIME, flagTurnedOn);
                        break;
                    }
                    case PrintGCTimeStamps: {
                        break;
                    }
                    case PrintGCDetails: {
                        this.getDiary().setState(SupportedFlags.GC_DETAILS, flagTurnedOn);
                        if (!flagTurnedOn || !this.getDiary().isJDK80() && !this.getDiary().isUnifiedLogging()) continue block22;
                        this.getDiary().setTrue(SupportedFlags.GC_CAUSE);
                        break;
                    }
                    case PrintGCCause: {
                        this.getDiary().setState(SupportedFlags.GC_CAUSE, flagTurnedOn);
                        break;
                    }
                    case PrintTenuringDistribution: {
                        this.getDiary().setState(SupportedFlags.TENURING_DISTRIBUTION, flagTurnedOn);
                        break;
                    }
                    case PrintAdaptiveSizePolicy: {
                        this.getDiary().setState(SupportedFlags.ADAPTIVE_SIZING, flagTurnedOn);
                        break;
                    }
                    case PrintReferenceGC: {
                        this.getDiary().setState(SupportedFlags.PRINT_REFERENCE_GC, flagTurnedOn);
                        break;
                    }
                    case PrintHeapAtGC: {
                        this.getDiary().setState(SupportedFlags.PRINT_HEAP_AT_GC, flagTurnedOn);
                        break;
                    }
                    case PrintPromotionFailure: {
                        this.getDiary().setTrue(SupportedFlags.PRINT_PROMOTION_FAILURE);
                    }
                    case PrintFLSStatistics: {
                        this.getDiary().setTrue(SupportedFlags.PRINT_FLS_STATISTICS);
                    }
                }
                continue;
            }
            GarbageCollectorFlag gcFlag = GarbageCollectorFlag.fromString(flag);
            if (gcFlag == null) continue;
            switch (gcFlag) {
                case UseSerialGC: {
                    this.setGCFlags |= flagTurnedOn ? 1 : 256;
                    continue block22;
                }
                case UseParallelGC: {
                    this.setGCFlags |= flagTurnedOn ? 2 : 512;
                    continue block22;
                }
                case UseParallelOldGC: {
                    this.setGCFlags |= flagTurnedOn ? 4 : 1024;
                    continue block22;
                }
                case UseParNewGC: {
                    this.setGCFlags |= flagTurnedOn ? 8 : 2048;
                    continue block22;
                }
                case UseConcMarkSweepGC: {
                    this.setGCFlags |= flagTurnedOn ? 16 : 4096;
                    continue block22;
                }
                case CMSIncrementialMode: {
                    this.setGCFlags |= flagTurnedOn ? 32 : 0;
                    continue block22;
                }
                case UseG1GC: {
                    this.setGCFlags |= flagTurnedOn ? 64 : 16384;
                    continue block22;
                }
            }
        }
        this.evaluateGCLogFlags();
        this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.APPLICATION_STOPPED_TIME, SupportedFlags.APPLICATION_CONCURRENT_TIME, SupportedFlags.GC_DETAILS, SupportedFlags.GC_CAUSE, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.PRINT_REFERENCE_GC, SupportedFlags.PRINT_HEAP_AT_GC, SupportedFlags.PRINT_PROMOTION_FAILURE, SupportedFlags.PRINT_FLS_STATISTICS});
    }

    private String processRawFlag(String rawFlag) {
        int equalsPosition;
        String processedFlag = "";
        if (rawFlag.startsWith("-XX:") && (equalsPosition = (processedFlag = rawFlag.charAt(4) == '+' || rawFlag.charAt(4) == '-' ? rawFlag.substring(5) : rawFlag.substring(4)).indexOf("=")) > 0) {
            processedFlag = processedFlag.substring(0, equalsPosition);
        }
        return processedFlag;
    }

    private boolean isSetToTrue(String flag) {
        return flag.startsWith("-XX:+");
    }

    private void parseJVMVersion(String versionString) {
        Matcher matcher = VERSION.matcher(versionString);
        if (matcher.find()) {
            switch (matcher.group(2).charAt(0)) {
                case '7': {
                    this.getDiary().setTrue(SupportedFlags.JDK70);
                    this.getDiary().setFalse(SupportedFlags.JDK80);
                    if (matcher.group(3) == null) {
                        this.getDiary().setTrue(SupportedFlags.PRE_JDK70_40);
                    }
                    try {
                        int minorVersion = Integer.parseInt(matcher.group(3).substring(1));
                        if (minorVersion < 41) {
                            this.getDiary().setTrue(SupportedFlags.PRE_JDK70_40);
                            break;
                        }
                        this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
                    }
                    catch (NumberFormatException nfe) {
                        this.getDiary().setTrue(SupportedFlags.PRE_JDK70_40);
                    }
                    break;
                }
                case '8': {
                    this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40});
                    this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.JDK80, SupportedFlags.GC_CAUSE});
                    break;
                }
                case '9': {
                    this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK80});
                    break;
                }
            }
        }
    }

    private void evaluateGCLogFlags() {
        switch (this.setGCFlags) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 256: 
            case 258: 
            case 260: 
            case 518: 
            case 2050: 
            case 4354: 
            case 6146: 
            case 16384: {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 1024: 
            case 1026: {
                this.getDiary().setTrue(SupportedFlags.PARALLELGC);
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 1: {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 8: 
            case 4101: {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.SERIAL});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 16: 
            case 24: 
            case 272: {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                break;
            }
            case 2064: {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.CMS});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                break;
            }
            case 48: 
            case 56: {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                break;
            }
            case 2096: {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.CMS, SupportedFlags.ICMS});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.G1GC, SupportedFlags.RSET_STATS});
                break;
            }
            case 64: 
            case 6208: {
                this.getDiary().setTrue(SupportedFlags.G1GC);
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 4096: {
                this.getDiary().setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC});
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            case 4160: {
                this.getDiary().setTrue(SupportedFlags.G1GC);
                this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.DEFNEW, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.SERIAL, SupportedFlags.CMS_DEBUG_LEVEL_1});
                break;
            }
            default: {
                LOGGER.severe("Illegal internal state: GCToolKit was unable to properly identify this log. Results will be corrupted.");
            }
        }
    }

    private void setGCCause(String gcCause) {
        if (gcCause == null && this.getDiary().isPrintGCDetails()) {
            this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
        } else if (gcCause != null) {
            if (GCCauses.get((String)gcCause) == GCCause.GCCAUSE_NOT_SET) {
                if (this.getDiary().isPrintGCDetailsKnown() && this.getDiary().isPrintGCDetails()) {
                    this.getDiary().setFalse(new SupportedFlags[]{SupportedFlags.GC_CAUSE, SupportedFlags.JDK80});
                    this.getDiary().setTrue(SupportedFlags.JDK70);
                }
            } else if (gcCause.contains("System.gc()") || !gcCause.contains("System")) {
                this.getDiary().setTrue(SupportedFlags.GC_CAUSE);
                this.getDiary().setFalse(SupportedFlags.PRE_JDK70_40);
            } else {
                this.getDiary().setTrue(SupportedFlags.PRE_JDK70_40);
                this.getDiary().setTrue(SupportedFlags.JDK70);
            }
        }
    }
}

