/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractLogTrace {
    private static final String US_FORMAT_SEPARATOR = ".";
    private static final String EUROPEAN_FORMAT_SEPARATOR = ",";
    private static final double MISSING_TIMESTAMP_SENTINEL = -1.0;
    private static final Pattern TIMES_STAMP_RULE = Pattern.compile("(\\d+(?:\\.|,)\\d{3}): ");
    private static final Pattern DATE_TIME_STAMP_RULE = Pattern.compile("(?:(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[\\+|\\-]\\d{4}): )?(\\d+(?:\\.|,)\\d{3}): ");
    protected final Matcher trace;

    public AbstractLogTrace(Matcher matcher) {
        this.trace = matcher;
    }

    public int length() {
        return this.trace.group(0).length();
    }

    public int groupCount() {
        return this.trace.groupCount();
    }

    public boolean groupNotNull(int index) {
        return this.getGroup(index) != null;
    }

    public long getLongGroup(int index) {
        return Long.parseLong(this.trace.group(index));
    }

    public int getIntegerGroup(int index) {
        return Integer.parseInt(this.trace.group(index));
    }

    public String getGroup(int index) {
        return this.trace.group(index);
    }

    public double getDoubleGroup(int index) {
        return this.convertToDouble(this.trace.group(index));
    }

    protected double convertToDouble(String value) {
        return Double.parseDouble(value.replaceAll(EUROPEAN_FORMAT_SEPARATOR, US_FORMAT_SEPARATOR));
    }

    public double getPercentageGroup(int i) {
        String value = this.getGroup(i);
        return this.convertToDouble(value.substring(0, value.length() - 1));
    }

    public double getTimeStamp() {
        Matcher matcher = TIMES_STAMP_RULE.matcher(this.trace.group(0));
        if (!matcher.find()) {
            return -1.0;
        }
        return this.getDoubleGroup(2);
    }

    public String getDateStamp() {
        Matcher matcher = DATE_TIME_STAMP_RULE.matcher(this.trace.group(0));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public DateTimeStamp getDateTimeStamp() {
        return this.getDateTimeStamp(1);
    }

    public DateTimeStamp getDateTimeStamp(int index) {
        Matcher matcher = DATE_TIME_STAMP_RULE.matcher(this.trace.group(0));
        for (int i = 0; i < index - 1 && matcher.find(); ++i) {
        }
        if (matcher.find()) {
            if (matcher.group(2) == null) {
                return new DateTimeStamp(matcher.group(1));
            }
            return new DateTimeStamp(matcher.group(1), this.convertToDouble(matcher.group(2)));
        }
        return new DateTimeStamp(-1.0);
    }

    public GCLogTrace next() {
        if (this.trace.find()) {
            return new GCLogTrace(this.trace);
        }
        return null;
    }
}

