/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.CPUSummary;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.generational.AbortablePreClean;
import com.microsoft.gctoolkit.event.generational.CMSConcurrentEvent;
import com.microsoft.gctoolkit.event.generational.CMSRemark;
import com.microsoft.gctoolkit.event.generational.ConcurrentMark;
import com.microsoft.gctoolkit.event.generational.ConcurrentModeFailure;
import com.microsoft.gctoolkit.event.generational.ConcurrentPreClean;
import com.microsoft.gctoolkit.event.generational.ConcurrentReset;
import com.microsoft.gctoolkit.event.generational.ConcurrentSweep;
import com.microsoft.gctoolkit.event.generational.DefNew;
import com.microsoft.gctoolkit.event.generational.FullGC;
import com.microsoft.gctoolkit.event.generational.GenerationalGCEvent;
import com.microsoft.gctoolkit.event.generational.GenerationalGCPauseEvent;
import com.microsoft.gctoolkit.event.generational.InitialMark;
import com.microsoft.gctoolkit.event.generational.PSFullGC;
import com.microsoft.gctoolkit.event.generational.PSYoungGen;
import com.microsoft.gctoolkit.event.generational.ParNew;
import com.microsoft.gctoolkit.event.generational.YoungGC;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.GenerationalForwardReference;
import com.microsoft.gctoolkit.parser.UnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.collection.RuleSet;
import com.microsoft.gctoolkit.parser.jvm.Decorators;
import com.microsoft.gctoolkit.parser.unified.UnifiedGenerationalPatterns;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UnifiedGenerationalParser
extends UnifiedGCLogParser
implements UnifiedGenerationalPatterns {
    private static final Logger LOGGER = Logger.getLogger(UnifiedGenerationalParser.class.getName());
    private final RuleSet<GCParseRule, BiConsumer<GCLogTrace, String>> parseRules = new RuleSet();
    private final Map<String, GarbageCollectionTypes> concurrentPhases;
    private GenerationalForwardReference pauseEvent;
    private GenerationalForwardReference concurrentCyclePauseEvent;
    private GenerationalForwardReference concurrentEvent;
    private boolean inConcurrentPhase;
    private double preCompactPhaseDuration;
    private ArrayList<GenerationalGCPauseEvent> cache;

    public UnifiedGenerationalParser() {
        this.parseRules.put(CMS_TAG, this::tag);
        this.parseRules.put(PARALLEL_TAG, this::tag);
        this.parseRules.put(SERIAL_TAG, this::tag);
        this.parseRules.put(YOUNG_HEADER, this::youngHeader);
        this.parseRules.put(GENERATIONAL_MEMORY_SUMMARY, this::generationalMemorySummary);
        this.parseRules.put(GENERATIONAL_MEMORY_SUMMARY_EXTENDED, this::extendedGenerationalMemorySummary);
        this.parseRules.put(UNIFIED_META_DATA, this::metaSpaceSummary);
        this.parseRules.put(YOUNG_DETAILS, this::youngDetails);
        this.parseRules.put(CPU_BREAKOUT, this::cpuBreakout);
        this.parseRules.put(INITIAL_MARK, this::initialMark);
        this.parseRules.put(INITIAL_MARK_SUMMARY, this::initialMarkSummary);
        this.parseRules.put(CONCURRENT_PHASE_START, this::concurrentPhaseStart);
        this.parseRules.put(CONCURRENT_PHASE_END, this::concurrentPhaseEnd);
        this.parseRules.put(WORKER_THREADS, this::workerThreads);
        this.parseRules.put(REMARK, this::remark);
        this.parseRules.put(REMARK_SUMMARY, this::remarkSummary);
        this.parseRules.put(GC_PHASE, this::remarkPhase);
        this.parseRules.put(OLD_SUMMARY, this::oldSummary);
        this.parseRules.put(PROMOTION_FAILED, this::promotionFailed);
        this.parseRules.put(FULL_GC, this::fullGC);
        this.parseRules.put(FULL_GC_SUMMARY, this::fullGCSummary);
        this.parseRules.put(FULL_GC_PHASE_START, this::fullGCPhase);
        this.parseRules.put(FULL_GC_PHASE_END, this::fullGCPhaseEnd);
        this.parseRules.put(PRE_COMPACT, this::preCompact);
        this.parseRules.put(PARALLEL_PHASE, this::parallelPhase);
        this.parseRules.put(PARALLEL_PHASE_SUMMARY, this::parallelPhaseSummary);
        this.parseRules.put(JVM_EXIT, this::jvmExit);
        this.parseRules.put(END_OF_FILE, this::jvmExit);
        this.parseRules.put(METASPACE_DETAILED, this::metaSpaceDetails);
        this.concurrentPhases = Map.of("Mark", GarbageCollectionTypes.Concurrent_Mark, "Preclean", GarbageCollectionTypes.Concurrent_Preclean, "Abortable Preclean", GarbageCollectionTypes.Abortable_Preclean, "Sweep", GarbageCollectionTypes.Concurrent_Sweep, "Reset", GarbageCollectionTypes.Concurrent_Reset);
        this.pauseEvent = null;
        this.concurrentCyclePauseEvent = null;
        this.concurrentEvent = null;
        this.inConcurrentPhase = false;
        this.preCompactPhaseDuration = -1.0;
        this.cache = new ArrayList();
    }

    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.GENERATIONAL);
    }

    @Override
    public String getName() {
        return "UnifiedGenerationalParser";
    }

    @Override
    protected void process(String line) {
        if (this.ignoreFrequentlySeenButUnwantedLines(line)) {
            return;
        }
        Optional<AbstractMap.SimpleEntry> ruleToApply = this.parseRules.keys().stream().map(rule -> new AbstractMap.SimpleEntry<GCParseRule, GCLogTrace>((GCParseRule)rule, rule.parse(line))).filter(tuple -> tuple.getValue() != null).findFirst();
        try {
            if (ruleToApply.isPresent()) {
                this.parseRules.get(ruleToApply.get().getKey()).accept((GCLogTrace)ruleToApply.get().getValue(), line);
            } else {
                LOGGER.log(Level.FINE, "Missed: {0}", line);
            }
        }
        catch (Throwable t) {
            LOGGER.throwing(this.getName(), "process", t);
        }
    }

    private void tag(GCLogTrace trace, String line) {
        this.noop();
    }

    private void youngHeader(GCLogTrace trace, String line) {
        if (this.pauseEvent != null) {
            LOGGER.warning("Young pause event not recorded: " + this.pauseEvent.getGcID());
        }
        if (this.diary.isCMS()) {
            this.pauseEvent = new GenerationalForwardReference(GarbageCollectionTypes.ParNew, new Decorators(line), UnifiedGCLogParser.GCID_COUNTER.parse(line).getIntegerGroup(1));
        } else if (this.diary.isPSYoung()) {
            this.pauseEvent = new GenerationalForwardReference(GarbageCollectionTypes.PSYoungGen, new Decorators(line), UnifiedGCLogParser.GCID_COUNTER.parse(line).getIntegerGroup(1));
        } else if (this.diary.isSerialFull()) {
            this.pauseEvent = new GenerationalForwardReference(GarbageCollectionTypes.DefNew, new Decorators(line), UnifiedGCLogParser.GCID_COUNTER.parse(line).getIntegerGroup(1));
        } else {
            LOGGER.warning("Unrecognized collection phase -> " + line);
            return;
        }
        this.pauseEvent.setStartTime(this.getClock());
        this.pauseEvent.setGCCause(trace.gcCause(1, 0));
    }

    private void generationalMemorySummary(GCLogTrace trace, String line) {
        switch (trace.getGroup(1)) {
            case "ParNew": 
            case "PSYoungGen": 
            case "DefNew": {
                this.pauseEvent.setYoung(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(2));
                break;
            }
            case "CMS": 
            case "ParOldGen": 
            case "Tenured": {
                this.pauseEvent.setTenured(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(2));
                break;
            }
            default: {
                trace.notYetImplemented();
            }
        }
    }

    private void extendedGenerationalMemorySummary(GCLogTrace trace, String line) {
        switch (trace.getGroup(1)) {
            case "ParNew": 
            case "PSYoungGen": 
            case "DefNew": {
                this.pauseEvent.setYoung((MemoryPoolSummary)trace.getEnlargedMemoryPoolRecord(2));
                break;
            }
            case "CMS": 
            case "ParOldGen": 
            case "Tenured": {
                this.pauseEvent.setTenured((MemoryPoolSummary)trace.getEnlargedMemoryPoolRecord(2));
                break;
            }
            default: {
                trace.notYetImplemented();
            }
        }
    }

    private void metaSpaceSummary(GCLogTrace trace, String line) {
        this.pauseEvent.setMetaspace(trace.getMetaSpaceRecord(1));
    }

    private void metaSpaceDetails(GCLogTrace trace, String line) {
        this.pauseEvent.setMetaspace(trace.getEnlargedMetaSpaceRecord(1));
        this.pauseEvent.setNonClassspace(trace.getEnlargedMetaSpaceRecord(9));
        this.pauseEvent.setClassspace(trace.getEnlargedMetaSpaceRecord(17));
    }

    private void youngDetails(GCLogTrace trace, String line) {
        this.pauseEvent.setDuration(trace.getDuration() / 1000.0);
        this.pauseEvent.setHeap(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(2));
    }

    private void initialMark(GCLogTrace trace, String line) {
        if (this.concurrentCyclePauseEvent != null) {
            LOGGER.warning("Pause event not completely recorded: " + this.pauseEvent.getGcID());
        }
        this.concurrentCyclePauseEvent = new GenerationalForwardReference(GarbageCollectionTypes.InitialMark, new Decorators(line), GCID_COUNTER.parse(line).getIntegerGroup(1));
        this.concurrentCyclePauseEvent.setStartTime(this.getClock());
    }

    private void initialMarkSummary(GCLogTrace trace, String line) {
        this.concurrentCyclePauseEvent.setHeap(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1));
        this.concurrentCyclePauseEvent.setDuration(trace.getDuration() / 1000.0);
    }

    private void concurrentPhaseStart(GCLogTrace trace, String line) {
        GarbageCollectionTypes gcType;
        if (this.concurrentEvent != null) {
            LOGGER.warning("Concurrent phase not completely recorded: " + this.concurrentEvent.getGcID());
        }
        if ((gcType = this.concurrentPhases.get(trace.getGroup(1))) == null) {
            LOGGER.warning("Unknown concurrent phase: " + line);
            return;
        }
        this.concurrentEvent = new GenerationalForwardReference(gcType, new Decorators(line), GCID_COUNTER.parse(line).getIntegerGroup(1));
        this.concurrentEvent.setStartTime(this.getClock());
        this.inConcurrentPhase = true;
    }

    private void concurrentPhaseEnd(GCLogTrace trace, String line) {
        this.concurrentEvent.setDuration(trace.getDuration() / 1000.0);
    }

    private void workerThreads(GCLogTrace trace, String line) {
        this.notYetImplemented(trace, line);
    }

    private void remark(GCLogTrace trace, String line) {
        if (this.concurrentCyclePauseEvent != null) {
            LOGGER.warning("Pause event not recorded and is about to be lost: " + this.pauseEvent.getGcID());
        }
        this.concurrentCyclePauseEvent = new GenerationalForwardReference(GarbageCollectionTypes.Remark, new Decorators(line), GCID_COUNTER.parse(line).getIntegerGroup(1));
        this.concurrentCyclePauseEvent.setStartTime(this.getClock());
    }

    private void remarkSummary(GCLogTrace trace, String line) {
        this.concurrentCyclePauseEvent.setHeap(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1));
        this.concurrentCyclePauseEvent.setDuration(trace.getDuration() / 1000.0);
    }

    private void remarkPhase(GCLogTrace trace, String line) {
        this.concurrentCyclePauseEvent.addCMSRemarkPhase(trace.getGroup(1), trace.getDuration() / 1000.0);
    }

    private void oldSummary(GCLogTrace trace, String line) {
    }

    private void promotionFailed(GCLogTrace trace, String line) {
        if (this.pauseEvent != null) {
            this.pauseEvent.convertToConcurrentModeFailure();
        }
    }

    private void fullGC(GCLogTrace trace, String line) {
        if (this.pauseEvent == null) {
            this.pauseEvent = this.diary.isPSOldGen() ? new GenerationalForwardReference(GarbageCollectionTypes.PSFull, new Decorators(line), UnifiedGCLogParser.GCID_COUNTER.parse(line).getIntegerGroup(1)) : new GenerationalForwardReference(GarbageCollectionTypes.FullGC, new Decorators(line), UnifiedGCLogParser.GCID_COUNTER.parse(line).getIntegerGroup(1));
            this.pauseEvent.setStartTime(this.getClock());
        } else if (this.pauseEvent.getGarbageCollectionType() == GarbageCollectionTypes.ParNew) {
            this.pauseEvent.convertToConcurrentModeFailure();
        } else if (this.pauseEvent.getGarbageCollectionType() == GarbageCollectionTypes.DefNew) {
            this.pauseEvent.convertToSerialFull();
        } else if (this.pauseEvent.getGarbageCollectionType() != GarbageCollectionTypes.ConcurrentModeFailure) {
            LOGGER.warning("Maybe Full Pause event not recorded: " + this.pauseEvent.getGcID());
            this.pauseEvent = new GenerationalForwardReference(GarbageCollectionTypes.FullGC, new Decorators(line), UnifiedGCLogParser.GCID_COUNTER.parse(line).getIntegerGroup(1));
            this.pauseEvent.setStartTime(this.getClock());
        }
        this.pauseEvent.setGCCause(trace.gcCause(1, 0));
    }

    private void fullGCSummary(GCLogTrace trace, String line) {
        this.pauseEvent.setHeap(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(2));
        this.pauseEvent.setDuration(trace.getDuration() / 1000.0);
    }

    private void fullGCPhase(GCLogTrace trace, String line) {
    }

    private void fullGCPhaseEnd(GCLogTrace trace, String line) {
        this.pauseEvent.addFullGCPhase(trace.getGroup(2), trace.getDuration() / 1000.0);
    }

    private void preCompact(GCLogTrace trace, String line) {
        this.preCompactPhaseDuration = trace.getDuration() / 1000.0;
    }

    private void parallelPhase(GCLogTrace trace, String line) {
    }

    private void parallelPhaseSummary(GCLogTrace trace, String line) {
        this.pauseEvent.addFullGCPhase(trace.getGroup(1), trace.getDuration() / 1000.0);
    }

    private void jvmExit(GCLogTrace trace, String line) {
        super.publish(ChannelName.GENERATIONAL_HEAP_PARSER_OUTBOX, (JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
    }

    private void cpuBreakout(GCLogTrace trace, String line) {
        GCLogTrace gcidTrace = GCID_COUNTER.parse(line);
        if (gcidTrace != null) {
            CPUSummary cpuSummary = new CPUSummary(trace.getDoubleGroup(1), trace.getDoubleGroup(2), trace.getDoubleGroup(3));
            int gcid = gcidTrace.getIntegerGroup(1);
            if (this.pauseEvent != null && this.pauseEvent.getGcID() == gcid) {
                this.pauseEvent.add(cpuSummary);
                if (this.inConcurrentPhase) {
                    this.cache.add(this.buildPauseEvent(this.pauseEvent));
                } else {
                    this.publish((GenerationalGCEvent)this.buildPauseEvent(this.pauseEvent));
                }
                this.pauseEvent = null;
            } else if (this.concurrentCyclePauseEvent != null && this.concurrentCyclePauseEvent.getGcID() == gcid) {
                this.concurrentCyclePauseEvent.add(cpuSummary);
                this.publish((GenerationalGCEvent)this.buildPauseEvent(this.concurrentCyclePauseEvent));
                this.concurrentCyclePauseEvent = null;
            } else if (this.concurrentEvent != null && this.concurrentEvent.getGcID() == gcid) {
                this.concurrentEvent.add(cpuSummary);
                this.publish((GenerationalGCEvent)this.buildConcurrentPhase(this.concurrentEvent));
                this.concurrentEvent = null;
                this.inConcurrentPhase = false;
                this.cache.forEach(this::publish);
                this.cache.clear();
            }
        }
    }

    private void fillOutMetaspaceData(GenerationalGCPauseEvent event, GenerationalForwardReference forwardReference) {
        if (forwardReference.getMetaspace() != null) {
            event.addPermOrMetaSpaceRecord((MemoryPoolSummary)forwardReference.getMetaspace());
        }
        if (forwardReference.getClassspace() != null) {
            event.addClassspace((MemoryPoolSummary)forwardReference.getClassspace());
        }
        if (forwardReference.getNonClassspace() != null) {
            event.addNonClassspace((MemoryPoolSummary)forwardReference.getNonClassspace());
        }
    }

    private void fillOutMemoryPoolData(GenerationalGCPauseEvent event, GenerationalForwardReference values) {
        int map = 0;
        map |= values.getHeap() != null ? 1 : 0;
        map |= values.getYoung() != null ? 2 : 0;
        switch (map |= values.getTenured() != null ? 4 : 0) {
            default: {
                break;
            }
            case 1: {
                event.add(values.getHeap());
                break;
            }
            case 3: {
                event.add(values.getYoung(), values.getHeap());
                break;
            }
            case 5: {
                event.add(values.getHeap().minus(values.getTenured()), values.getTenured(), values.getHeap());
                break;
            }
            case 6: {
                event.add(values.getYoung(), values.getTenured(), values.getYoung().add(values.getTenured()));
                break;
            }
            case 7: {
                event.add(values.getYoung(), values.getTenured(), values.getHeap());
            }
        }
    }

    private GenerationalGCPauseEvent buildYoungEvent(GenerationalForwardReference forwardReference) {
        DefNew youngCollection = null;
        switch (forwardReference.getGarbageCollectionType()) {
            case DefNew: {
                youngCollection = new DefNew(forwardReference.getStartTime(), forwardReference.getGCCause(), forwardReference.getDuration());
                break;
            }
            case ParNew: {
                youngCollection = new ParNew(forwardReference.getStartTime(), forwardReference.getGCCause(), forwardReference.getDuration());
                break;
            }
            case Young: {
                youngCollection = new YoungGC(forwardReference.getStartTime(), forwardReference.getGCCause(), forwardReference.getDuration());
                break;
            }
            case PSYoungGen: {
                youngCollection = new PSYoungGen(forwardReference.getStartTime(), forwardReference.getGCCause(), forwardReference.getDuration());
                break;
            }
            default: {
                LOGGER.warning(forwardReference.getGarbageCollectionType() + " not recognized");
            }
        }
        this.fillOutMemoryPoolData((GenerationalGCPauseEvent)youngCollection, forwardReference);
        this.fillOutMetaspaceData((GenerationalGCPauseEvent)youngCollection, forwardReference);
        youngCollection.add(forwardReference.getCPUSummary());
        return youngCollection;
    }

    public InitialMark buildInitialMark(GenerationalForwardReference values) {
        InitialMark collection = new InitialMark(values.getStartTime(), values.getGCCause(), values.getDuration());
        collection.add(values.getHeap());
        collection.add(values.getCPUSummary());
        return collection;
    }

    private CMSRemark buildRemark(GenerationalForwardReference values) {
        CMSRemark remark = new CMSRemark(values.getStartTime(), values.getGCCause(), values.getDuration());
        remark.add(values.getHeap());
        remark.add(values.getCPUSummary());
        return remark;
    }

    private FullGC fillOutFullGC(FullGC event, GenerationalForwardReference values) {
        this.fillOutMemoryPoolData((GenerationalGCPauseEvent)event, values);
        this.fillOutMetaspaceData((GenerationalGCPauseEvent)event, values);
        event.add(values.getCPUSummary());
        return event;
    }

    private FullGC buildFullGC(GenerationalForwardReference forwardReference) {
        switch (forwardReference.getGarbageCollectionType()) {
            case PSFull: {
                return this.fillOutFullGC((FullGC)new PSFullGC(forwardReference.getStartTime(), forwardReference.getGCCause(), forwardReference.getDuration()), forwardReference);
            }
            case FullGC: 
            case Full: {
                return this.fillOutFullGC(new FullGC(forwardReference.getStartTime(), forwardReference.getGCCause(), forwardReference.getDuration()), forwardReference);
            }
        }
        LOGGER.warning(forwardReference.getGarbageCollectionType() + " is unrecognized");
        return null;
    }

    private ConcurrentModeFailure buildConcurrentModeFailure(GenerationalForwardReference forwardReference) {
        return (ConcurrentModeFailure)this.fillOutFullGC((FullGC)new ConcurrentModeFailure(forwardReference.getStartTime(), forwardReference.getGCCause(), forwardReference.getDuration()), forwardReference);
    }

    private GenerationalGCPauseEvent buildPauseEvent(GenerationalForwardReference forwardReference) {
        switch (forwardReference.getGarbageCollectionType()) {
            case DefNew: 
            case ParNew: 
            case Young: 
            case PSYoungGen: {
                return this.buildYoungEvent(forwardReference);
            }
            case InitialMark: {
                return this.buildInitialMark(forwardReference);
            }
            case Remark: {
                return this.buildRemark(forwardReference);
            }
            case PSFull: 
            case FullGC: 
            case Full: {
                return this.buildFullGC(forwardReference);
            }
            case ConcurrentModeFailure: {
                return this.buildConcurrentModeFailure(forwardReference);
            }
        }
        LOGGER.warning(forwardReference.getGarbageCollectionType() + " is unrecognized");
        this.notYetImplemented();
        return null;
    }

    private CMSConcurrentEvent buildConcurrentPhase(GenerationalForwardReference values) {
        switch (values.getGarbageCollectionType()) {
            case Concurrent_Mark: {
                return new ConcurrentMark(values.getStartTime(), values.getDuration(), values.getCPUSummary().getKernel() + values.getCPUSummary().getUser(), values.getCPUSummary().getWallClock());
            }
            case Concurrent_Preclean: {
                return new ConcurrentPreClean(values.getStartTime(), values.getDuration(), values.getCPUSummary().getKernel() + values.getCPUSummary().getUser(), values.getCPUSummary().getWallClock());
            }
            case Abortable_Preclean: {
                return new AbortablePreClean(values.getStartTime(), values.getDuration(), values.getCPUSummary().getKernel() + values.getCPUSummary().getUser(), values.getCPUSummary().getWallClock(), false);
            }
            case Concurrent_Sweep: {
                return new ConcurrentSweep(values.getStartTime(), values.getDuration(), values.getCPUSummary().getKernel() + values.getCPUSummary().getUser(), values.getCPUSummary().getWallClock());
            }
            case Concurrent_Reset: {
                return new ConcurrentReset(values.getStartTime(), values.getDuration(), values.getCPUSummary().getKernel() + values.getCPUSummary().getUser(), values.getCPUSummary().getWallClock());
            }
        }
        LOGGER.warning(values.getGarbageCollectionType() + " is unrecognized");
        return null;
    }

    private void notYetImplemented() {
    }

    private void notImplemented(GCLogTrace trace, String line) {
        trace.notYetImplemented();
    }

    private boolean ignoreFrequentlySeenButUnwantedLines(String line) {
        if (line.contains("application threads")) {
            return true;
        }
        if (line.contains("Application time")) {
            return true;
        }
        if (line.contains("exit") && line.contains("used")) {
            return true;
        }
        if (line.contains("workers")) {
            return true;
        }
        if (line.contains("Heap address")) {
            return true;
        }
        return line.contains("Desired") || line.contains("Age table") || line.contains("- age ");
    }

    public boolean accepts(Diary diary) {
        return (diary.isGenerational() || diary.isCMS()) && diary.isUnifiedLogging();
    }

    @Override
    public void publishTo(JVMEventChannel bus) {
        super.publishTo(bus);
    }

    private void publish(GenerationalGCEvent event) {
        super.publish(ChannelName.GENERATIONAL_HEAP_PARSER_OUTBOX, (JVMEvent)event);
    }
}

