/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.jvm.ApplicationConcurrentTime;
import com.microsoft.gctoolkit.event.jvm.ApplicationStoppedTime;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.JVMPatterns;
import com.microsoft.gctoolkit.parser.PreUnifiedGCLogParser;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class JVMEventParser
extends PreUnifiedGCLogParser
implements JVMPatterns {
    private static final double GCPAUSE_TIME_NOT_SET = -1.0;
    private static final Logger LOGGER = Logger.getLogger(JVMEventParser.class.getName());
    private final Collection<SafePointData> safePoints = new ArrayList<SafePointData>();
    private DateTimeStamp timeStamp = new DateTimeStamp(0.0);
    private boolean lastEventWasGC = false;
    private double gcPauseTime = -1.0;

    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.JVM);
    }

    @Override
    public String getName() {
        return "JVMEventParser";
    }

    @Override
    protected void process(String line) {
        GCLogTrace trace = null;
        try {
            trace = APPLICATION_STOP_TIME.parse(line);
            if (trace != null) {
                if (this.lastEventWasGC) {
                    double duration = trace.getDoubleGroup(3);
                    this.publish((JVMEvent)new ApplicationStoppedTime(trace.getDateTimeStamp(), duration, duration - this.gcPauseTime, this.lastEventWasGC));
                    this.lastEventWasGC = false;
                    this.gcPauseTime = -1.0;
                } else {
                    this.publish((JVMEvent)new ApplicationStoppedTime(trace.getDateTimeStamp(), trace.getDoubleGroup(3), this.lastEventWasGC));
                }
            } else {
                trace = APPLICATION_STOP_TIME_WITH_STOPPING_TIME.parse(line);
                if (trace != null) {
                    this.publish((JVMEvent)new ApplicationStoppedTime(trace.getDateTimeStamp(), trace.getDoubleGroup(3), trace.getDoubleGroup(4), this.lastEventWasGC));
                    this.lastEventWasGC = false;
                    this.gcPauseTime = -1.0;
                } else {
                    trace = APPLICATION_TIME.parse(line);
                    if (trace != null) {
                        this.publish((JVMEvent)new ApplicationConcurrentTime(trace.getDateTimeStamp(), trace.getDoubleGroup(3)));
                        this.lastEventWasGC = false;
                    } else {
                        trace = SIMPLE_APPLICATION_STOP_TIME.parse(line);
                        if (trace != null) {
                            this.safePoints.add(new StoppedTime(trace.getDoubleGroup(1), this.safePoints.isEmpty()));
                        } else {
                            trace = SIMPLE_APPLICATION_TIME.parse(line);
                            if (trace != null) {
                                this.safePoints.add(new ConcurrentTime(trace.getDoubleGroup(3)));
                            } else {
                                trace = GC_PAUSE_CLAUSE.parse(line);
                                if (trace != null) {
                                    this.gcPauseTime = trace.getPauseTime();
                                    this.lastEventWasGC = true;
                                } else {
                                    trace = TLAB_START.parse(line);
                                    if (trace != null) {
                                        this.extractTLAB(trace, 2);
                                    } else {
                                        trace = TLAB_CONT.parse(line);
                                        if (trace != null) {
                                            this.extractTLAB(trace, 0);
                                        } else {
                                            trace = TLAB_TOTALS.parse(line);
                                            if (trace != null) {
                                                this.extractTLABSummary(trace);
                                            } else if (line.equals("END_OF_DATA_SENTINEL")) {
                                                this.drainSafePoints();
                                                this.publish((JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
                                            } else if (this.getClock().getTimeStamp() > this.timeStamp.getTimeStamp()) {
                                                this.drainSafePoints();
                                                this.timeStamp = this.getClock();
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Throwable t) {
            LOGGER.log(Level.FINE, "Missed: {0}", line);
        }
    }

    private void extractTLABSummary(GCLogTrace trace) {
        trace.notYetImplemented();
    }

    private void extractTLAB(GCLogTrace trace, int offset) {
        String gcThreadId = trace.getGroup(1 + offset);
        int id = trace.getIntegerGroup(2 + offset);
        int desiredSize = trace.getIntegerGroup(3 + offset);
        int slowAllocs = trace.getIntegerGroup(4 + offset);
        int refillWaste = trace.getIntegerGroup(5 + offset);
        double allocFraction = trace.getDoubleGroup(6 + offset);
        int unknownKBField = trace.getIntegerGroup(7 + offset);
        int refills = trace.getIntegerGroup(8 + offset);
        double wastePercent = trace.getDoubleGroup(9 + offset);
        int gcUknownField = trace.getIntegerGroup(10 + offset);
        int slowUnknown = trace.getIntegerGroup(11 + offset);
        int fastUnknown = trace.getIntegerGroup(12 + offset);
    }

    private void drainSafePoints() {
        double interval = (this.getClock().getTimeStamp() - this.timeStamp.getTimeStamp()) / (double)(this.safePoints.size() + 1);
        double timeValue = this.getClock().getTimeStamp() + interval;
        for (SafePointData safePointData : this.safePoints) {
            this.publish(safePointData.complete(new DateTimeStamp(timeValue)));
            timeValue += interval;
        }
        this.safePoints.clear();
    }

    public boolean accepts(Diary diary) {
        return (diary.isTLABData() || diary.isApplicationStoppedTime() || diary.isApplicationRunningTime()) && !diary.isUnifiedLogging();
    }

    @Override
    public void publishTo(JVMEventChannel bus) {
        super.publishTo(bus);
    }

    private void publish(JVMEvent event) {
        super.publish(ChannelName.JVM_EVENT_PARSER_OUTBOX, event);
    }

    private static class ConcurrentTime
    extends SafePointData {
        ConcurrentTime(double timing) {
            this.duration = timing;
        }

        @Override
        JVMEvent complete(DateTimeStamp dateTimeStamp) {
            return new ApplicationConcurrentTime(dateTimeStamp, this.duration);
        }
    }

    private static class StoppedTime
    extends SafePointData {
        boolean gcInduced;

        StoppedTime(double timing, boolean gc) {
            this.duration = timing;
            this.gcInduced = gc;
        }

        @Override
        JVMEvent complete(DateTimeStamp dateTimeStamp) {
            return new ApplicationStoppedTime(dateTimeStamp, this.duration, this.gcInduced);
        }
    }

    private static abstract class SafePointData {
        double duration;

        private SafePointData() {
        }

        abstract JVMEvent complete(DateTimeStamp var1);
    }
}

