/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.GCToolKit;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.CPUSummary;
import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.ReferenceGCSummary;
import com.microsoft.gctoolkit.event.StatisticalSummary;
import com.microsoft.gctoolkit.event.SurvivorMemoryPoolSummary;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentScanRootRegion;
import com.microsoft.gctoolkit.event.g1gc.G1Cleanup;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentCleanup;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentMark;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentMarkResetForOverflow;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentStringDeduplication;
import com.microsoft.gctoolkit.event.g1gc.G1FullGCNES;
import com.microsoft.gctoolkit.event.g1gc.G1GCConcurrentEvent;
import com.microsoft.gctoolkit.event.g1gc.G1GCPauseEvent;
import com.microsoft.gctoolkit.event.g1gc.G1Mixed;
import com.microsoft.gctoolkit.event.g1gc.G1Remark;
import com.microsoft.gctoolkit.event.g1gc.G1SystemGC;
import com.microsoft.gctoolkit.event.g1gc.G1Trap;
import com.microsoft.gctoolkit.event.g1gc.G1Young;
import com.microsoft.gctoolkit.event.g1gc.G1YoungInitialMark;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.G1GCPatterns;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.PreUnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.collection.MRUQueue;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.AbstractMap;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PreUnifiedG1GCParser
extends PreUnifiedGCLogParser
implements G1GCPatterns {
    private static final Logger LOGGER = Logger.getLogger(PreUnifiedG1GCParser.class.getName());
    private long heapTotal;
    private long heapUsed;
    private long regionSize;
    private long metaSpaceUsed;
    private long metaCapacity;
    private long metaCommitted;
    private long metaReserved;
    private long classSpaceUsed;
    private long classSpaceCapacity;
    private long classSpaceCommitted;
    private long classSpaceReserved;
    private final G1GCPauseEvent trap;
    private G1GCPauseEvent forwardReference;
    private DateTimeStamp timeStampForwardReference;
    private GCCause gcCauseForwardReference;
    private GarbageCollectionTypes collectionTypeForwardReference;
    private ReferenceGCSummary referenceGCForwardReferenceSummary;
    private DateTimeStamp concurrentPhaseStartTimeStamp;
    private GarbageCollectionTypes concurrentCollectionTypeForwardReference;
    private final ConcurrentLinkedQueue<JVMEvent> backlog;
    private final MRUQueue<GCParseRule, BiConsumer<GCLogTrace, String>> parseRules;
    private final GCParseRule corruptedApplicationTime;

    public PreUnifiedG1GCParser() {
        this.forwardReference = this.trap = new G1Trap();
        this.backlog = new ConcurrentLinkedQueue();
        this.parseRules = new MRUQueue();
        this.parseRules.put(CPU_BREAKDOWN, this::recordCPUSummary);
        this.parseRules.put(G1_DETAILS, this::processYoungGenCollection);
        this.parseRules.put(YOUNG, this::processYoung);
        this.parseRules.put(FULL_GC, this::g1gcFullGC);
        this.parseRules.put(G1_MEMORY_SUMMARY, this::processMemorySummary);
        this.parseRules.put(G1_NO_DETAILS_MEMORY_SUMMARY, this::processNoDetailsMemorySummary);
        this.parseRules.put(G1_PARALLEL_PHASE_SUMMARY, this::processParallelPhaseSummary);
        this.parseRules.put(G1_SOLARIS_PARALLEL_PHASE, this::processParallelPhase);
        this.parseRules.put(TERMINATION_ATTEMPTS, this::ignore);
        this.parseRules.put(PROCESSED_BUFFERS, this::processedBuffers);
        this.parseRules.put(PROCESSED_BUFFER, this::processedBuffer);
        this.parseRules.put(SOLARIS_WORKER_PARALLEL_BLOCK, this::solarisWorkerParallelBlock);
        this.parseRules.put(SOLARIS_WORKER_PARALLEL_ACTIVITY, this::ignore);
        this.parseRules.put(G1GC_PHASE_DETAIL_CLAUSE, this::processPhaseDetailClause);
        this.parseRules.put(G1GC_PHASE, this::processG1GCPhase);
        this.parseRules.put(CONCURRENT_STRING_DEDUP, this::concurrentStringDedup);
        this.parseRules.put(STRING_DEDUP_FIXUP, this::stringDedupFixup);
        this.parseRules.put(QUEUE_FIXUP, this::recordQueueFixup);
        this.parseRules.put(TABLE_FIXUP, this::recordTableFixup);
        this.parseRules.put(WORKER_ACTIVITY, this::workerActivity);
        this.parseRules.put(PARALLEL_TIME, this::parallelTime);
        this.parseRules.put(WORKER_PARALLEL_BLOCK, this::workerParallelBlock);
        this.parseRules.put(G1_FUll, this::g1gcDetailedFullGC);
        this.parseRules.put(G1_FULL_INTERRUPTS_CONCURRENT_CYCLE, this::g1FullInterruptsConcurrentCycle);
        this.parseRules.put(FULL_WITH_CONCURRENT_PHASE_START, this::g1FullWithConcurrentPhaseStart);
        this.parseRules.put(FULL_WITH_CONCURRENT_PHASE_CORRUPTED, this::g1FullWithConcurrentPhaseCorrupted);
        this.parseRules.put(FULL_MISSING_TIMESTAMP_CONCURRENT_START, this::fullMissingTimeStampWithConcurrentStart);
        this.parseRules.put(FULL_WITH_CONCURRENT_PHASE_INTERLEAVED, this::g1FullWIthConcurrentPhaseInterleaved);
        this.parseRules.put(FULL_WITH_CONCURRENT_END, this::fullWithConcurrentEnd);
        this.parseRules.put(FULL_GC_FRAGMENT, this::fullGCFragment);
        this.parseRules.put(CONCURRENT_START_V3, this::concurrentStartV3);
        this.parseRules.put(CONCURRENT_START_V4, this::concurrentStartV4);
        this.parseRules.put(CONCURRENT_START_V5, this::concurrentStartV3);
        this.parseRules.put(CORRUPTED_CONCURRENT_START, this::corruptedConcurrentStart);
        this.parseRules.put(CORRUPTED_CONCURRENT_START_V2, this::corruptedConcurrentStartV2);
        this.parseRules.put(CORRUPTED_CONCURRENT_START_V3, this::corruptedConcurrentStartV3);
        this.parseRules.put(CORRUPTED_CONCURRENT_START_V4, this::corruptedConcurrentStartV4);
        this.parseRules.put(CORRUPTED_CONCURRENT_START_V5, this::corruptedConcurrentStartV5);
        this.parseRules.put(CORRUPTED_CONCURRENT_START_V7, this::corruptedConcurrentStartV7);
        this.parseRules.put(CORRUPTED_CONCURRENT_START_V8, this::corruptedConcurrentStartV8);
        this.parseRules.put(CORRUPTED_CONCURRENT_START_V9, this::corruptedConcurrentStartV9);
        this.parseRules.put(YOUNG_WITH_CONCURRENT_END, this::youngWithConcurrentEnd);
        this.parseRules.put(YOUNG_SPLIT_AT_DATESTAMP, this::youngSplitAtDatestamp);
        this.parseRules.put(YOUNG_SPLIT_AT_TIMESTAMP, this::youngSplitAtTimestamp);
        this.parseRules.put(FREE_FLOATING_YOUNG_BLOCK, this::freeFloatingYoungBlock);
        this.parseRules.put(FULLGC_WITH_CONCURRENT_PHASE, this::fullGCWithConcurrentPhase);
        this.parseRules.put(G1_YOUNG_SPLIT_START, this::g1YoungSplitStart);
        this.parseRules.put(G1_YOUNG_SPLIT_END, this::g1YoungSplitEnd);
        this.parseRules.put(G1_INITIAL_MARK, this::g1InitialMark);
        this.parseRules.put(FREE_FLOATING_OCCUPANCY_SUMMARY, this::freeFloatingOccupancySummary);
        this.parseRules.put(G1_CONCURRENT_START, this::g1ConcurrentStart);
        this.parseRules.put(G1_CONCURRENT_START_WITHOUT_PREFIX, this::g1ConcurrentStartWithoutPrefix);
        this.parseRules.put(G1_CONCURRENT_END, this::g1ConcurrentEnd);
        this.parseRules.put(G1_REMARK, this::g1Remark);
        this.parseRules.put(G1_180_REMARK, this::g1180Remark);
        this.parseRules.put(G1_180_REMARK_REF_DETAILS, this::g1180RemarkRefDetails);
        this.parseRules.put(G1_CLEANUP, this::g1Cleanup);
        this.parseRules.put(G1_CLEANUP_NO_MEMORY, this::g1CleanupNoMemory);
        this.parseRules.put(G1_CONCURRENT_ABORT, this::g1ConcurrentAbort);
        this.parseRules.put(CONCURRENT_MARK_OVERFLOW, this::concurrentMarkOverflow);
        this.parseRules.put(G1_CORRUPTED_CONCURRENT_END, this::g1CorruptedConcurrentEnd);
        this.parseRules.put(G1_CORRUPTED_CONCURRENT_ROOT_REGION_SCAN_END, this::g1ConcurrentEndCorruptedByApplicationTime);
        this.parseRules.put(G1_FLOATING_CONCURRENT_PHASE_START, this::g1FloatingConcurrentPhaseStart);
        this.parseRules.put(SPLIT_CLEANUP, this::splitCleanup);
        this.parseRules.put(YOUNG_SPLIT_BY_G1ERGONOMICS, this::youngSplitByG1Ergonomics);
        this.parseRules.put(G1_INITIAL_MARK_ERGONOMICS, this::g1InitialMarkErgonomics);
        this.parseRules.put(G1_YOUNG_RS_SUMMARY, this::ignore);
        this.parseRules.put(RSET_HEADER, this::ignore);
        this.parseRules.put(RSET_CONCONCURRENT_HEADER, this::ignore);
        this.parseRules.put(RSET_CONCURRENT_RS_Threads, this::ignore);
        this.parseRules.put(RSET_CONCURRENT_MUTATOR, this::ignore);
        this.parseRules.put(RSET_CONCURRENT_TIMES_HEADER, this::ignore);
        this.parseRules.put(RSET_RS_SIZE, this::ignore);
        this.parseRules.put(RSET_THREAD_TIMES, this::ignore);
        this.parseRules.put(RSET_RS_STATIC_STRUCTURES, this::ignore);
        this.parseRules.put(RSET_RS_OCCUPIED_CARDS, this::ignore);
        this.parseRules.put(RSET_MAX_REGION_SIZE, this::ignore);
        this.parseRules.put(RSET_COARSENINGS, this::ignore);
        this.parseRules.put(new GCParseRule("Heap tag", "^Heap$"), this::ignore);
        this.parseRules.put(GARBAGE_FIRST_HEAP, this::garbageFirstHeap);
        this.parseRules.put(REGION_SIZE, this::regionSize);
        this.parseRules.put(METASPACE_FINAL, this::metaspaceFinal);
        this.parseRules.put(CLASSPACE_FINAL, this::classspaceFinal);
        this.parseRules.put(G1_DETAILS_REFERENCE_GC, this::g1DetailsReferenceGC);
        this.parseRules.put(G1_REMARK_REFERENCE_GC, this::g1RemarkReferenceGC);
        this.parseRules.put(G1_FULL_DETAILS_REFERENCE_GC, this::g1FullDetailsReferenceGC);
        this.parseRules.put(G1_DETAILS_REFERENCE_INITIAL_MARK, this::g1DetailsReferenceInitialMark);
        this.parseRules.put(FREE_FLOATING_REFERENCE_RECORDS, this::freeFloatingReferenceRecords);
        this.parseRules.put(FLOATING_REFERENCE_WITH_ADAPTIVE_SIZING, this::floatingReferenceWithAdaptiveSizing);
        this.parseRules.put(YOUNG_REFERENCE_WITH_CONCURRENT_END, this::youngReferenceWIthConcurrentEnd);
        this.parseRules.put(G1_FULL_INTERRUPTS_CONCURRENT_WITH_REFERENCES, this::g1FullInterruptsConcurrentWithReferences);
        this.parseRules.put(G1_FULL_MEMORY_SPLIT_BY_CONCURRENT, this::g1FullMemorySplitByConcurrent);
        this.parseRules.put(G1_FULL_ADAPTIVE_SIZING, this::g1FullAdaptiveSizing);
        this.parseRules.put(G1_YOUNG_WITH_CSET_CONSTRUCTION_START, this::notYetDefined);
        this.parseRules.put(G1_CSET_CONSTRUCTION_START, this::notYetDefined);
        this.parseRules.put(CSET_CONSTRUCTION, this::csetConstruction);
        this.parseRules.put(CSET_CONSTRUCTION_END, this::notYetDefined);
        this.parseRules.put(HEAP_SHRINK, this::notYetDefined);
        this.parseRules.put(HEAP_EXPAND, this::notYetDefined);
        this.parseRules.put(ATTEMPT_HEAP_EXPANSION_ALLOC_FAILURE, this::notYetDefined);
        this.parseRules.put(ATTEMPT_HEAP_EXPANSION_OVERHEAD, this::notYetDefined);
        this.parseRules.put(HEAP_SHRINKING_FAILED, this::notYetDefined);
        this.parseRules.put(HIGH_OCCUPANCY_TRIGGERS_CONC, this::notYetDefined);
        this.parseRules.put(INITIATE_CONC_CYCLE, this::notYetDefined);
        this.parseRules.put(DO_NOT_REQUEST_CONC_CYCLE, this::notYetDefined);
        this.parseRules.put(START_MIXED_GC, this::notYetDefined);
        this.parseRules.put(DELAY_MIXED_GC, this::notYetDefined);
        this.parseRules.put(CSET_FINISH, this::notYetDefined);
        this.parseRules.put(CSET_ADDING, this::notYetDefined);
        this.parseRules.put(new GCParseRule("END_OF_DATA_SENTINEL", "END_OF_DATA_SENTINEL"), this::endOfFile);
        this.corruptedApplicationTime = new GCParseRule("corruptedApplicationTime", "((\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): (\\d+(?:\\.|,)\\d{3}): |(\\d+(?:\\.|,)\\d{3}): |(\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}\\.\\d{3}[+|-]\\d{4}): )(\\d+(?:\\.|,)\\d{3}): ");
        this.forwardReference = this.trap;
    }

    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.G1GC);
    }

    @Override
    public String getName() {
        return "PreUnifiedG1GCParser";
    }

    @Override
    protected void process(String line) {
        if (this.ignoreFrequentlySeenButUnwantedLines(line)) {
            return;
        }
        try {
            this.parseRules.keys().stream().map(rule -> new AbstractMap.SimpleEntry<GCParseRule, GCLogTrace>((GCParseRule)rule, rule.parse(line))).filter(tuple -> tuple.getValue() != null).findFirst().ifPresentOrElse(rulesAndTrace -> this.parseRules.get(rulesAndTrace.getKey()).accept((GCLogTrace)rulesAndTrace.getValue(), line), () -> this.log(line));
        }
        catch (Throwable t) {
            LOGGER.throwing(this.getName(), "deriveConfiguration", t);
        }
    }

    void notYetDefined(GCLogTrace trace, String line) {
        if (System.getProperty("microsoft.develop.ergonomics") != null) {
            trace.notYetImplemented();
        }
    }

    public void endOfFile(GCLogTrace trace, String line) {
        super.publish(ChannelName.G1GC_PARSER_OUTBOX, (JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
    }

    void csetConstruction(GCLogTrace trace, String line) {
        if (System.getProperty("microsoft.develop.ergonomics") != null) {
            trace.notYetImplemented();
        }
    }

    void g1FullAdaptiveSizing(GCLogTrace trace, String line) {
        this.timeStampForwardReference = this.getClock();
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
    }

    private void g1YoungSplitStart(GCLogTrace trace, String line) {
        this.timeStampForwardReference = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.collectionTypeForwardReference = "(young)".equals(trace.getGroup(7)) ? GarbageCollectionTypes.Young : GarbageCollectionTypes.Mixed;
    }

    private void stringDedupFixup(GCLogTrace trace, String line) {
        ((G1Young)this.forwardReference).setStringDedupingDuration(trace.getDoubleGroup(1), trace.getIntegerGroup(2));
    }

    private void recordQueueFixup(GCLogTrace trace, String line) {
        StatisticalSummary summary = this.extractCounterSummary(trace, 0);
        ((G1Young)this.forwardReference).queueFixupStatistics(summary);
    }

    private void recordTableFixup(GCLogTrace trace, String line) {
        StatisticalSummary summary = this.extractCounterSummary(trace, 0);
        ((G1Young)this.forwardReference).tableFixupStatistics(summary);
    }

    private boolean ignoreFrequentlySeenButUnwantedLines(String line) {
        if (line.contains("- age ")) {
            return true;
        }
        if (line.contains("Total time for which application threads were stopped")) {
            return true;
        }
        if (line.contains("Application time: ")) {
            if (this.corruptedApplicationTime.parse(line) != null) {
                this.concurrentPhaseStartTimeStamp = this.getClock();
            }
            return true;
        }
        if (line.contains("Termination Attempts:")) {
            return true;
        }
        if (line.contains("Desired survivor size")) {
            return true;
        }
        if (line.startsWith("{Heap before GC invocations")) {
            return true;
        }
        if (line.startsWith("region size ")) {
            return true;
        }
        if (line.startsWith("compacting perm gen  total ")) {
            return true;
        }
        if (line.startsWith("the space ")) {
            return true;
        }
        if (line.startsWith("No shared spaces configured.")) {
            return true;
        }
        if (line.startsWith("Heap after GC invocations=")) {
            return true;
        }
        if (line.startsWith("OpenJDK")) {
            return true;
        }
        if (line.equals("}")) {
            return true;
        }
        if (line.startsWith("Java HotSpot(TM)")) {
            return true;
        }
        if (line.startsWith("CommandLine")) {
            return true;
        }
        if (line.startsWith("Memory: ")) {
            return true;
        }
        return line.contains("Allocation failed. Thread");
    }

    private void ignore(GCLogTrace trace, String line) {
    }

    private void processYoungGenCollection(GCLogTrace trace, String line) {
        boolean initialMark = trace.contains(8, "initial-mark");
        boolean tospaceExhausted = trace.contains(trace.groupCount() - 2, "to-space");
        if (trace.contains(7, "young")) {
            this.forwardReference = initialMark ? new G1YoungInitialMark(trace.getDateTimeStamp(), trace.gcCause(3, 0), trace.getDoubleGroup(trace.groupCount())) : new G1Young(trace.getDateTimeStamp(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
            if (tospaceExhausted) {
                ((G1Young)this.forwardReference).toSpaceExhausted();
            }
        } else if (trace.contains(7, "mixed")) {
            this.forwardReference = new G1Mixed(trace.getDateTimeStamp(), trace.gcCause(), trace.getDoubleGroup(trace.groupCount()));
            if (tospaceExhausted) {
                ((G1Mixed)this.forwardReference).toSpaceExhausted();
            }
        } else {
            trace.notYetImplemented();
        }
    }

    private void processYoung(GCLogTrace trace, String line) {
        MemoryPoolSummary summary = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(9);
        if ("young".equals(trace.getGroup(4))) {
            G1Young collection = null;
            if (trace.getGroup(6) != null) {
                trace.notYetImplemented();
                return;
            }
            collection = new G1Young(this.getClock(), trace.gcCause(), trace.getPauseTime());
            collection.addMemorySummary(summary);
            this.publish((G1GCPauseEvent)collection);
        } else if ("mixed".equals(trace.getGroup(4))) {
            G1Mixed collection = new G1Mixed(this.getClock(), trace.gcCause(), trace.getPauseTime());
            collection.addMemorySummary(summary);
            this.publish((G1GCPauseEvent)collection);
        } else {
            trace.notYetImplemented();
        }
    }

    private void processMemorySummary(GCLogTrace trace, String line) {
        MemoryPoolSummary edenSummary = this.extractPoolSummary(trace, 1);
        MemoryPoolSummary heap = this.extractPoolSummary(trace, 13);
        SurvivorMemoryPoolSummary survivor = this.extractSurvivorPoolSummary(trace, 9);
        this.forwardReference.addMemorySummary(edenSummary, survivor, heap);
        this.forwardReference.addPermOrMetaSpaceRecord(this.extractPermOrMetaspaceRecord(line));
        if (this.diary != null && !this.diary.isPrintGCDetails()) {
            this.publish(this.forwardReference);
        }
    }

    private void processNoDetailsMemorySummary(GCLogTrace trace, String line) {
        MemoryPoolSummary summary = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1);
        if (this.collectionTypeForwardReference == GarbageCollectionTypes.Young) {
            this.forwardReference = new G1Young(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
            this.forwardReference.addMemorySummary(summary);
            this.publish(this.forwardReference);
        } else if (this.collectionTypeForwardReference == GarbageCollectionTypes.Mixed) {
            this.forwardReference = new G1Mixed(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
            this.forwardReference.addMemorySummary(summary);
            this.publish(this.forwardReference);
        } else if (this.collectionTypeForwardReference == GarbageCollectionTypes.G1GCYoungInitialMark) {
            this.forwardReference = new G1YoungInitialMark(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
            this.forwardReference.addMemorySummary(summary);
            this.publish(this.forwardReference);
        } else if (this.collectionTypeForwardReference == GarbageCollectionTypes.Full) {
            this.forwardReference = new G1FullGCNES(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
            if (!this.hasPrintGCDetails()) {
                this.forwardReference.addMemorySummary(summary);
                this.publish(this.forwardReference);
            }
        } else if (this.collectionTypeForwardReference == GarbageCollectionTypes.G1GCCleanup) {
            G1Cleanup cleanup = new G1Cleanup(this.timeStampForwardReference, trace.getDuration());
            cleanup.addMemorySummary(summary);
            this.publish((G1GCPauseEvent)cleanup);
        } else {
            trace.notYetImplemented();
        }
    }

    private void processParallelPhaseSummary(GCLogTrace trace, String line) {
        ((G1Young)this.forwardReference).addParallelPhaseSummary(trace.getGroup(1), this.extractStatisticalSummaryWithSum(trace, 1));
    }

    private void processParallelPhase(GCLogTrace trace, String line) {
        double count = trace.getDoubleGroup(2);
        ((G1Young)this.forwardReference).addParallelPhaseSummary(trace.getGroup(1), new StatisticalSummary(count, count, count, 0.0, count));
    }

    private void processPhaseDetailClause(GCLogTrace trace, String line) {
        ((G1Young)this.forwardReference).addPhaseDuration(trace.getGroup(1), trace.getDoubleGroup(2));
    }

    private void processG1GCPhase(GCLogTrace trace, String line) {
        String phase = trace.getGroup(1);
        if ("Code Root Fixup".equals(phase)) {
            ((G1Young)this.forwardReference).setCodeRootFixupDuration(trace.getDoubleGroup(2));
        } else if ("Code Root Migration".equals(phase)) {
            ((G1Young)this.forwardReference).setCodeRootMigrationDuration(trace.getDoubleGroup(2));
        } else if ("Code Root Purge".equals(phase)) {
            ((G1Young)this.forwardReference).setCodeRootPurgeDuration(trace.getDoubleGroup(2));
        } else if ("Clear CT".equals(phase)) {
            ((G1Young)this.forwardReference).setClearCTDuration(trace.getDoubleGroup(2));
        } else if ("Other".equals(phase)) {
            ((G1Young)this.forwardReference).setOtherPhaseDurations(trace.getDoubleGroup(2));
        } else if ("Expand Heap".equals(phase)) {
            ((G1Young)this.forwardReference).setExpandHeapDuration(trace.getDoubleGroup(2));
        } else {
            trace.notYetImplemented();
        }
    }

    private void workerActivity(GCLogTrace trace, String line) {
        ((G1Young)this.forwardReference).addWorkerActivity(trace.getGroup(1), this.extractStatisticalSummaryWithSum(trace, 1));
    }

    private void parallelTime(GCLogTrace trace, String line) {
        ((G1Young)this.forwardReference).setParallelPhaseDuration(trace.getDoubleGroup(1));
        ((G1Young)this.forwardReference).setGcWorkers(trace.getIntegerGroup(2));
    }

    private void workerParallelBlock(GCLogTrace trace, String line) {
        if (line.contains("Start")) {
            ((G1Young)this.forwardReference).setWorkersStart(this.extractStatisticalSummary(trace, 1));
        } else if (line.contains("End")) {
            ((G1Young)this.forwardReference).setWorkersEnd(this.extractStatisticalSummary(trace, 1));
        }
    }

    private void solarisWorkerParallelBlock(GCLogTrace trace, String line) {
        double time = trace.getDoubleGroup(2);
        StatisticalSummary summary = new StatisticalSummary(time, time, time, 0.0, time);
        if (line.contains("Start")) {
            ((G1Young)this.forwardReference).setWorkersStart(summary);
        } else if (line.contains("End")) {
            ((G1Young)this.forwardReference).setWorkersEnd(summary);
        }
    }

    private void processedBuffers(GCLogTrace trace, String line) {
        ((G1Young)this.forwardReference).addProcessedBuffersSummary(this.extractCounterSummary(trace, 1));
    }

    private void processedBuffer(GCLogTrace trace, String line) {
        int count = trace.getIntegerGroup(1);
        ((G1Young)this.forwardReference).addProcessedBuffersSummary(new StatisticalSummary((double)count, (double)count, (double)count, 0.0, (double)count));
    }

    private void g1gcDetailedFullGC(GCLogTrace trace, String line) {
        this.forwardReference = new G1FullGCNES(trace.getDateTimeStamp(), trace.gcCause(), trace.getPauseTime());
    }

    private void g1FullInterruptsConcurrentCycle(GCLogTrace trace, String line) {
        this.collectionTypeForwardReference = trace.gcCause() == GCCause.JAVA_LANG_SYSTEM ? GarbageCollectionTypes.SystemGC : GarbageCollectionTypes.Full;
        this.timeStampForwardReference = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        if ("root-region-scan".equals(trace.getGroup(7))) {
            this.publish((G1GCConcurrentEvent)new ConcurrentScanRootRegion(this.concurrentPhaseStartTimeStamp, trace.getPauseTime()));
        } else if ("mark".equals(trace.getGroup(7))) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentMark(this.concurrentPhaseStartTimeStamp, trace.getPauseTime()));
        } else if ("cleanup".equals(trace.getGroup(7))) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentCleanup(this.concurrentPhaseStartTimeStamp, trace.getPauseTime()));
        } else {
            trace.notYetImplemented();
        }
    }

    private boolean setGarbageCollectionTypeForwardReference(String gcType) {
        this.concurrentCollectionTypeForwardReference = "root-region-scan".equals(gcType) ? GarbageCollectionTypes.ConcurrentRootRegionScan : ("mark".equals(gcType) ? GarbageCollectionTypes.G1GCConcurrentMark : ("cleanup".equals(gcType) ? GarbageCollectionTypes.G1GCCleanup : null));
        return this.concurrentCollectionTypeForwardReference != null;
    }

    private void g1FullWithConcurrentPhaseStart(GCLogTrace trace, String line) {
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.timeStampForwardReference = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.concurrentPhaseStartTimeStamp = trace.getDateTimeStamp(2);
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(13))) {
            trace.notYetImplemented();
        }
    }

    private void g1FullWithConcurrentPhaseCorrupted(GCLogTrace trace, String line) {
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.timeStampForwardReference = trace.getDateTimeStamp(1);
        this.gcCauseForwardReference = trace.gcCause(2);
        this.concurrentPhaseStartTimeStamp = this.timeStampForwardReference;
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(6))) {
            trace.notYetImplemented();
        }
    }

    private void g1FullWIthConcurrentPhaseInterleaved(GCLogTrace trace, String line) {
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.timeStampForwardReference = this.getClock();
        this.gcCauseForwardReference = trace.gcCause(1);
        this.concurrentPhaseStartTimeStamp = this.timeStampForwardReference;
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(6))) {
            trace.notYetImplemented();
        }
    }

    private void fullMissingTimeStampWithConcurrentStart(GCLogTrace trace, String line) {
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(4))) {
            trace.notYetImplemented();
        }
        this.timeStampForwardReference = trace.getDateTimeStamp(1);
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.gcCauseForwardReference = trace.gcCause(0, 1);
    }

    private void fullWithConcurrentEnd(GCLogTrace trace, String line) {
        if (!this.recordConcurrentPhase(trace.getGroup(5), trace.getDuration())) {
            trace.notYetImplemented();
        }
        this.timeStampForwardReference = new DateTimeStamp(trace.getGroup(2), trace.getDoubleGroup(3));
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.gcCauseForwardReference = trace.gcCause(0, 1);
    }

    private void fullGCFragment(GCLogTrace trace, String line) {
        this.timeStampForwardReference = trace.getDateTimeStamp();
        this.gcCauseForwardReference = trace.gcCause();
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
    }

    private void concurrentStartV3(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = new DateTimeStamp(trace.getGroup(1), trace.getDoubleGroup(3));
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(4))) {
            trace.notYetImplemented();
        }
    }

    private void concurrentStartV4(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = new DateTimeStamp(trace.getGroup(1), trace.getDoubleGroup(2));
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(3))) {
            trace.notYetImplemented();
        }
    }

    private void corruptedConcurrentStart(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = new DateTimeStamp(trace.getDateStamp(), trace.getDoubleGroup(3));
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(4))) {
            trace.notYetImplemented();
        }
    }

    private void corruptedConcurrentStartV2(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = new DateTimeStamp(trace.getGroup(1), trace.getDoubleGroup(2));
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(5))) {
            trace.notYetImplemented();
        }
    }

    private void corruptedConcurrentStartV3(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = new DateTimeStamp(trace.getDateStamp(), trace.getDoubleGroup(2));
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(6))) {
            trace.notYetImplemented();
        }
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.gcCauseForwardReference = trace.gcCause(1);
        this.timeStampForwardReference = new DateTimeStamp(trace.getDateStamp(), trace.getDoubleGroup(2));
    }

    private void corruptedConcurrentStartV4(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = trace.getDateTimeStamp();
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(8))) {
            trace.notYetImplemented();
        }
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.gcCauseForwardReference = trace.gcCause(1);
        this.timeStampForwardReference = trace.getDateTimeStamp();
    }

    private void corruptedConcurrentStartV5(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = new DateTimeStamp(trace.getDateStamp(), trace.getDoubleGroup(3));
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(8))) {
            trace.notYetImplemented();
        }
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.gcCauseForwardReference = trace.gcCause(1);
        this.timeStampForwardReference = trace.getDateTimeStamp();
    }

    private void corruptedConcurrentStartV7(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = new DateTimeStamp(trace.getGroup(1), trace.getDoubleGroup(3));
        this.setGarbageCollectionTypeForwardReference(trace.getGroup(5));
        if (this.concurrentCollectionTypeForwardReference == null) {
            trace.notYetImplemented();
        }
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.gcCauseForwardReference = trace.gcCause(4);
        this.timeStampForwardReference = this.concurrentPhaseStartTimeStamp;
    }

    private void corruptedConcurrentStartV8(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = new DateTimeStamp(trace.getGroup(1), trace.getDoubleGroup(2));
        this.setGarbageCollectionTypeForwardReference(trace.getGroup(5));
        if (this.concurrentCollectionTypeForwardReference == null) {
            trace.notYetImplemented();
        }
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.gcCauseForwardReference = trace.gcCause(4);
        this.timeStampForwardReference = this.concurrentPhaseStartTimeStamp;
    }

    private void corruptedConcurrentStartV9(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = new DateTimeStamp(trace.getGroup(1), trace.getDoubleGroup(3));
        if (!this.setGarbageCollectionTypeForwardReference(trace.getGroup(6))) {
            trace.notYetImplemented();
        }
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.gcCauseForwardReference = trace.gcCause(2);
        this.timeStampForwardReference = this.concurrentPhaseStartTimeStamp;
    }

    private void g1gcFullGC(GCLogTrace trace, String line) {
        this.forwardReference = trace.gcCause() == GCCause.JAVA_LANG_SYSTEM ? new G1SystemGC(trace.getDateTimeStamp(), trace.getPauseTime()) : new G1FullGCNES(trace.getDateTimeStamp(), trace.gcCause(), trace.getPauseTime());
        this.forwardReference.addMemorySummary(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(7));
        if (this.diary != null && !this.diary.isPrintGCDetails()) {
            this.publish(this.forwardReference);
        }
    }

    private boolean recordConcurrentPhase(String phaseName, double duration) {
        switch (phaseName) {
            default: {
                return false;
            }
            case "root-region-scan": {
                this.publish((G1GCConcurrentEvent)new ConcurrentScanRootRegion(this.concurrentPhaseStartTimeStamp, duration));
            }
            case "mark": {
                this.publish((G1GCConcurrentEvent)new G1ConcurrentMark(this.concurrentPhaseStartTimeStamp, duration));
            }
            case "cleanup": 
        }
        this.publish((G1GCConcurrentEvent)new G1ConcurrentCleanup(this.concurrentPhaseStartTimeStamp, duration));
        return true;
    }

    private void youngWithConcurrentEnd(GCLogTrace trace, String line) {
        if (!this.recordConcurrentPhase(trace.getGroup(8), trace.getDuration())) {
            trace.notYetImplemented();
        }
        this.gcCauseForwardReference = trace.gcCause(3, 0);
        this.timeStampForwardReference = this.getClock();
        if ("young".equals(trace.getGroup(4))) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.Young;
        } else if ("mixed".equals(trace.getGroup(4))) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.Mixed;
        } else {
            trace.notYetImplemented();
        }
    }

    private void youngSplitAtDatestamp(GCLogTrace trace, String line) {
        this.timeStampForwardReference = new DateTimeStamp(trace.getGroup(1), trace.getDoubleGroup(3));
    }

    private void youngSplitAtTimestamp(GCLogTrace trace, String line) {
        this.timeStampForwardReference = new DateTimeStamp(trace.getGroup(1));
        if (!this.recordConcurrentPhase(trace.getGroup(8), trace.getDuration())) {
            trace.notYetImplemented();
        }
    }

    private void freeFloatingYoungBlock(GCLogTrace trace, String line) {
        boolean initialMark = false;
        if (trace.getGroup(3) != null) {
            initialMark = trace.contains(3, "initial-mark");
        }
        if (trace.contains(2, "young")) {
            this.forwardReference = initialMark ? new G1YoungInitialMark(trace.getDateTimeStamp(), trace.gcCause(3, -2), trace.getPauseTime()) : new G1Young(trace.getDateTimeStamp(), trace.gcCause(3, -2), trace.getPauseTime());
        } else if (trace.getGroup(2).contains("mixed")) {
            this.forwardReference = new G1Mixed(trace.getDateTimeStamp(), trace.gcCause(3, -2), trace.getPauseTime());
        }
    }

    private void fullGCWithConcurrentPhase(GCLogTrace trace, String line) {
        this.timeStampForwardReference = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.concurrentPhaseStartTimeStamp = trace.getDateTimeStamp(2);
    }

    private void g1YoungSplitEnd(GCLogTrace trace, String line) {
        if (this.collectionTypeForwardReference == GarbageCollectionTypes.Young) {
            this.forwardReference = new G1Young(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
        } else if (this.collectionTypeForwardReference == GarbageCollectionTypes.Mixed) {
            this.forwardReference = new G1Mixed(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
        } else if (this.collectionTypeForwardReference == GarbageCollectionTypes.G1GCYoungInitialMark) {
            this.forwardReference = new G1YoungInitialMark(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getDoubleGroup(trace.groupCount()));
        } else {
            LOGGER.log(Level.WARNING, trace.toString());
            return;
        }
        if (this.referenceGCForwardReferenceSummary != null) {
            this.forwardReference.add(this.referenceGCForwardReferenceSummary);
        }
        if (trace.contains(1, "to-space")) {
            ((G1Young)this.forwardReference).toSpaceExhausted();
        }
    }

    private void g1InitialMark(GCLogTrace trace, String line) {
        this.timeStampForwardReference = this.getClock();
        this.gcCauseForwardReference = trace.gcCause();
        if ("young".equals(trace.getGroup(7))) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.G1GCYoungInitialMark;
        } else if (trace.contains(7, "mixed")) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.G1GCMixedInitialMark;
        } else {
            trace.notYetImplemented();
        }
    }

    private void freeFloatingOccupancySummary(GCLogTrace trace, String line) {
        if (this.collectionTypeForwardReference == GarbageCollectionTypes.Full) {
            this.forwardReference = new G1FullGCNES(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
            this.publish(this.forwardReference);
            this.collectionTypeForwardReference = GarbageCollectionTypes.Unknown;
            this.timeStampForwardReference = null;
            this.gcCauseForwardReference = GCCause.UNKNOWN_GCCAUSE;
        } else if (this.collectionTypeForwardReference == GarbageCollectionTypes.SystemGC) {
            this.forwardReference = new G1SystemGC(this.timeStampForwardReference, trace.getPauseTime());
            this.collectionTypeForwardReference = GarbageCollectionTypes.Unknown;
            this.timeStampForwardReference = null;
            this.gcCauseForwardReference = GCCause.UNKNOWN_GCCAUSE;
        } else {
            trace.notYetImplemented();
        }
    }

    private void g1ConcurrentStartWithoutPrefix(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = this.getClock();
    }

    private void g1ConcurrentStart(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = trace.getDateTimeStamp();
    }

    private void concurrentStringDedup(GCLogTrace trace, String line) {
        double startingStringVolume = trace.toKBytes(4);
        double endingStringValue = trace.toKBytes(6);
        double reduction = trace.toKBytes(8);
        double percentReduction = trace.getDoubleGroup(10);
        this.publish((G1GCConcurrentEvent)new G1ConcurrentStringDeduplication(this.getClock(), trace.gcCause(), startingStringVolume, endingStringValue, reduction, percentReduction, trace.getDoubleGroup(trace.groupCount())));
    }

    private void g1Remark(GCLogTrace trace, String line) {
        this.publish((G1GCPauseEvent)new G1Remark(trace.getDateTimeStamp(), trace.getGroup(13) != null ? trace.getDoubleGroup(13) : 0.0, trace.getDoubleGroup(trace.groupCount())));
    }

    private void g1180Remark(GCLogTrace trace, String line) {
        G1Remark remark = new G1Remark(trace.getDateTimeStamp(), trace.getDoubleGroup(17), trace.getDoubleGroup(11), trace.getDoubleGroup(23), trace.getDoubleGroup(trace.groupCount()));
        this.publish((G1GCPauseEvent)remark);
    }

    private void g1180RemarkRefDetails(GCLogTrace trace, String line) {
        G1Remark remark = new G1Remark(trace.getDateTimeStamp(), trace.getDoubleGroup(56), trace.getDoubleGroup(11), trace.getDoubleGroup(trace.groupCount() - 1), trace.getDuration());
        remark.add(this.extractPrintReferenceGC(line));
        this.publish((G1GCPauseEvent)remark);
    }

    private void g1Cleanup(GCLogTrace trace, String line) {
        G1Cleanup cleanup = new G1Cleanup(trace.getDateTimeStamp(), trace.getPauseTime());
        cleanup.addMemorySummary(this.getTotalOccupancyBeforeAfterWithTotalHeapPoolSizeSummary(trace, 7));
        this.publish((G1GCPauseEvent)cleanup);
    }

    private void g1CleanupNoMemory(GCLogTrace trace, String line) {
        G1Cleanup cleanup = new G1Cleanup(trace.getDateTimeStamp(), trace.getPauseTime());
        this.publish((G1GCPauseEvent)cleanup);
    }

    private void splitCleanup(GCLogTrace trace, String line) {
        this.timeStampForwardReference = this.getClock();
        this.collectionTypeForwardReference = GarbageCollectionTypes.G1GCCleanup;
    }

    private void g1ConcurrentAbort(GCLogTrace trace, String line) {
        if (this.concurrentPhaseStartTimeStamp != null) {
            G1ConcurrentMark concurrentMark = new G1ConcurrentMark(this.concurrentPhaseStartTimeStamp, trace.gcCause(), trace.getTimeStamp() - this.concurrentPhaseStartTimeStamp.getTimeStamp());
            concurrentMark.abort();
            this.publish((G1GCConcurrentEvent)concurrentMark);
        }
    }

    private void concurrentMarkOverflow(GCLogTrace trace, String line) {
        this.publish((G1GCConcurrentEvent)new G1ConcurrentMarkResetForOverflow(this.getClock()));
    }

    private void g1CorruptedConcurrentEnd(GCLogTrace trace, String line) {
        if (this.concurrentPhaseStartTimeStamp == null) {
            this.concurrentPhaseStartTimeStamp = this.getClock();
        }
        if ("root-region-scan".equals(trace.getGroup(1))) {
            this.publish((G1GCConcurrentEvent)new ConcurrentScanRootRegion(this.concurrentPhaseStartTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount())));
        } else if ("mark".equals(trace.getGroup(1))) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentMark(this.concurrentPhaseStartTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount())));
        } else if ("cleanup".equals(trace.getGroup(1))) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentCleanup(this.concurrentPhaseStartTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getDoubleGroup(trace.groupCount())));
        } else {
            trace.notYetImplemented();
        }
    }

    public void g1ConcurrentEndCorruptedByApplicationTime(GCLogTrace trace, String line) {
        if (this.concurrentPhaseStartTimeStamp == null) {
            this.concurrentPhaseStartTimeStamp = this.getClock();
        }
        if ("root-region-scan".equals(trace.getGroup(4))) {
            this.publish((G1GCConcurrentEvent)new ConcurrentScanRootRegion(this.concurrentPhaseStartTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getPauseTime()));
        } else if ("mark".equals(trace.getGroup(4))) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentMark(this.concurrentPhaseStartTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getPauseTime()));
        } else if ("cleanup".equals(trace.getGroup(4))) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentCleanup(this.concurrentPhaseStartTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getPauseTime()));
        }
    }

    public void g1FloatingConcurrentPhaseStart(GCLogTrace trace, String line) {
        this.concurrentPhaseStartTimeStamp = this.getClock();
    }

    private void g1DetailsReferenceGC(GCLogTrace trace, String line) {
        this.processYoungGenCollection(trace, line);
        this.forwardReference.add(this.extractPrintReferenceGC(line));
        if (trace.contains(trace.groupCount() - 2, "to-space")) {
            ((G1Young)this.forwardReference).toSpaceExhausted();
        }
    }

    private void g1RemarkReferenceGC(GCLogTrace trace, String line) {
        ReferenceGCSummary summary = this.extractPrintReferenceGC(line);
        double totalReferenceProcessingTime = summary.getSoftReferencePauseTime() + summary.getWeakReferencePauseTime() + summary.getFinalReferencePauseTime() + summary.getPhantomReferencePauseTime() + summary.getJniWeakReferencePauseTime();
        G1Remark remark = new G1Remark(this.getClock(), totalReferenceProcessingTime, trace.getPauseTime());
        remark.add(summary);
        this.publish((G1GCPauseEvent)remark);
    }

    private void g1FullDetailsReferenceGC(GCLogTrace trace, String line) {
        this.forwardReference = new G1FullGCNES(this.getClock(), trace.gcCause(), trace.getPauseTime());
        this.forwardReference.add(this.extractPrintReferenceGC(line));
        if (this.diary != null && this.isPreJDK17040()) {
            MemoryPoolSummary heap = trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(27);
            this.forwardReference.addMemorySummary(heap);
            this.publish(this.forwardReference);
        }
    }

    private void g1DetailsReferenceInitialMark(GCLogTrace trace, String line) {
        this.forwardReference = new G1YoungInitialMark(this.getClock(), trace.gcCause(), trace.getPauseTime());
        ReferenceGCSummary summary = this.extractPrintReferenceGC(line);
        this.forwardReference.add(summary);
        if (trace.contains(24, "to-space ")) {
            ((G1YoungInitialMark)this.forwardReference).toSpaceExhausted();
        }
    }

    private void freeFloatingReferenceRecords(GCLogTrace trace, String line) {
        if (this.collectionTypeForwardReference == GarbageCollectionTypes.Young) {
            this.forwardReference = new G1Young(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
        } else if (this.collectionTypeForwardReference == GarbageCollectionTypes.Mixed) {
            this.forwardReference = new G1Mixed(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
        } else if (this.collectionTypeForwardReference == GarbageCollectionTypes.G1GCYoungInitialMark) {
            this.forwardReference = new G1YoungInitialMark(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
        }
        this.forwardReference.add(this.extractPrintReferenceGC(line));
        if (trace.contains("to-space")) {
            ((G1Young)this.forwardReference).toSpaceExhausted();
        }
    }

    private void floatingReferenceWithAdaptiveSizing(GCLogTrace trace, String line) {
        this.referenceGCForwardReferenceSummary = this.extractPrintReferenceGC(line);
    }

    private void youngReferenceWIthConcurrentEnd(GCLogTrace trace, String line) {
        String concurrentPhase = trace.getGroup(32);
        if ("root-region-scan".equals(concurrentPhase)) {
            this.publish((G1GCConcurrentEvent)new ConcurrentScanRootRegion(this.concurrentPhaseStartTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getPauseTime()));
        } else if ("mark".equals(concurrentPhase)) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentMark(this.concurrentPhaseStartTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getPauseTime()));
        } else if ("cleanup".equals(concurrentPhase)) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentCleanup(this.concurrentPhaseStartTimeStamp, GCCause.UNKNOWN_GCCAUSE, trace.getPauseTime()));
        } else {
            trace.notYetImplemented();
        }
        this.timeStampForwardReference = trace.getDateTimeStamp();
        this.gcCauseForwardReference = trace.gcCause();
        if ("young".equals(trace.getGroup(4))) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.Young;
        } else if ("mixed".equals(trace.getGroup(4))) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.Mixed;
        } else {
            trace.notYetImplemented();
        }
        this.referenceGCForwardReferenceSummary = this.extractPrintReferenceGC(line);
    }

    private void g1FullInterruptsConcurrentWithReferences(GCLogTrace trace, String line) {
        String concurrentPhase = trace.getGroup(30);
        if ("root-region-scan".equals(concurrentPhase)) {
            this.publish((G1GCConcurrentEvent)new ConcurrentScanRootRegion(this.concurrentPhaseStartTimeStamp, trace.gcCause(22), trace.getPauseTime()));
        } else if ("mark".equals(concurrentPhase)) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentMark(this.concurrentPhaseStartTimeStamp, trace.gcCause(22), trace.getPauseTime()));
        } else if ("cleanup".equals(concurrentPhase)) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentCleanup(this.concurrentPhaseStartTimeStamp, trace.gcCause(22), trace.getPauseTime()));
        } else {
            trace.notYetImplemented();
        }
        this.collectionTypeForwardReference = GarbageCollectionTypes.Full;
        this.gcCauseForwardReference = trace.gcCause();
        this.timeStampForwardReference = trace.getDateTimeStamp();
        this.referenceGCForwardReferenceSummary = this.extractPrintReferenceGC(line);
    }

    private void g1FullMemorySplitByConcurrent(GCLogTrace trace, String line) {
        if (this.collectionTypeForwardReference == GarbageCollectionTypes.Full) {
            G1FullGCNES full = new G1FullGCNES(this.timeStampForwardReference, this.gcCauseForwardReference, trace.getPauseTime());
            full.addMemorySummary(trace.getOccupancyBeforeAfterWithMemoryPoolSizeSummary(1));
            this.publish((G1GCPauseEvent)full);
        } else {
            trace.notYetImplemented();
        }
    }

    private void youngSplitByG1Ergonomics(GCLogTrace trace, String line) {
        this.timeStampForwardReference = this.getClock();
        this.gcCauseForwardReference = trace.gcCause(3, 0);
        if ("young".equals(trace.getGroup(4))) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.Young;
        } else if ("mixed".equals(trace.getGroup(4))) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.Mixed;
        } else {
            trace.notYetImplemented();
        }
    }

    private void g1InitialMarkErgonomics(GCLogTrace trace, String line) {
        this.timeStampForwardReference = this.getClock();
        this.gcCauseForwardReference = trace.gcCause(3, 0);
        if ("young".equals(trace.getGroup(4))) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.G1GCYoungInitialMark;
        } else if ("mixed".equals(trace.getGroup(4))) {
            this.collectionTypeForwardReference = GarbageCollectionTypes.G1GCYoungInitialMark;
        } else {
            trace.notYetImplemented();
        }
    }

    private void garbageFirstHeap(GCLogTrace trace, String line) {
    }

    private void regionSize(GCLogTrace trace, String line) {
        this.regionSize = trace.getLongGroup(1);
    }

    private void metaspaceFinal(GCLogTrace trace, String line) {
        this.metaSpaceUsed = trace.toKBytes(1);
        this.metaCapacity = trace.toKBytes(3);
        this.metaCommitted = trace.toKBytes(5);
        this.metaReserved = trace.toKBytes(7);
    }

    private void classspaceFinal(GCLogTrace trace, String line) {
        this.classSpaceUsed = trace.toKBytes(1);
        this.classSpaceCapacity = trace.toKBytes(3);
        this.classSpaceCommitted = trace.toKBytes(5);
        this.classSpaceReserved = trace.toKBytes(7);
    }

    private void g1Pre17040Summary(GCLogTrace trace, String line) {
        try {
            MemoryPoolSummary edenSummary = this.extractPoolSummary(trace, 1);
            MemoryPoolSummary heap = this.extractPoolSummary(trace, 13);
            SurvivorMemoryPoolSummary survivor = this.extractSurvivorPoolSummary(trace, 9);
            this.forwardReference.addMemorySummary(edenSummary, survivor, heap);
            this.publish(this.forwardReference);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void g1ConcurrentEnd(GCLogTrace trace, String line) {
        if (this.concurrentPhaseStartTimeStamp == null) {
            this.concurrentPhaseStartTimeStamp = this.getClock();
        }
        if ("root-region-scan".equals(trace.getGroup(7))) {
            this.publish((G1GCConcurrentEvent)new ConcurrentScanRootRegion(this.concurrentPhaseStartTimeStamp, trace.getDuration()));
        } else if ("mark".equals(trace.getGroup(7))) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentMark(this.concurrentPhaseStartTimeStamp, trace.getDuration()));
        } else if ("cleanup".equals(trace.getGroup(7))) {
            this.publish((G1GCConcurrentEvent)new G1ConcurrentCleanup(this.concurrentPhaseStartTimeStamp, trace.getDuration()));
        } else {
            trace.notYetImplemented();
        }
    }

    private StatisticalSummary extractStatisticalSummary(GCLogTrace trace, int offset) {
        return new StatisticalSummary(trace.getDoubleGroup(1 + offset), trace.getDoubleGroup(2 + offset), trace.getDoubleGroup(3 + offset), trace.getDoubleGroup(4 + offset), -1.0);
    }

    private StatisticalSummary extractStatisticalSummaryWithSum(GCLogTrace trace, int offset) {
        return new StatisticalSummary(trace.getDoubleGroup(1 + offset), trace.getDoubleGroup(2 + offset), trace.getDoubleGroup(3 + offset), trace.getDoubleGroup(4 + offset), trace.getDoubleGroup(5 + offset));
    }

    private StatisticalSummary extractCounterSummary(GCLogTrace trace, int offset) {
        return new StatisticalSummary((double)trace.getIntegerGroup(offset), trace.getDoubleGroup(1 + offset), (double)trace.getIntegerGroup(2 + offset), (double)trace.getIntegerGroup(3 + offset), (double)trace.getIntegerGroup(4 + offset));
    }

    private MemoryPoolSummary extractPoolSummary(GCLogTrace trace, int offset) {
        long occupancyBefore = trace.doubleToKBytes(offset);
        long sizeBefore = trace.doubleToKBytes(offset + 2);
        long occupancyAfter = trace.doubleToKBytes(offset + 4);
        long size = trace.doubleToKBytes(offset + 6);
        return new MemoryPoolSummary(occupancyBefore, sizeBefore, occupancyAfter, size);
    }

    private SurvivorMemoryPoolSummary extractSurvivorPoolSummary(GCLogTrace trace, int offset) {
        long occupancyBefore = trace.doubleToKBytes(offset);
        long occupancyAfter = trace.doubleToKBytes(offset + 2);
        return new SurvivorMemoryPoolSummary(occupancyBefore, occupancyAfter);
    }

    private void drainBacklog() {
        if (this.backlog.size() > 0) {
            for (JVMEvent event : this.backlog) {
                super.publish(ChannelName.G1GC_PARSER_OUTBOX, event);
            }
        }
    }

    public void publish(G1GCConcurrentEvent concurrentEvent) {
        super.publish(ChannelName.G1GC_PARSER_OUTBOX, (JVMEvent)concurrentEvent);
        this.drainBacklog();
    }

    private void recordCPUSummary(GCLogTrace trace, String line) {
        this.forwardReference.addCPUSummary(new CPUSummary(trace.getDoubleGroup(1), trace.getDoubleGroup(2), trace.getDoubleGroup(3)));
        this.publish(this.forwardReference);
    }

    public void publish(G1GCPauseEvent collection) {
        if (collection == this.trap) {
            LOGGER.warning("Parsing Error: Attempt to record Trap @" + this.getClock().getTimeStamp());
            return;
        }
        if (collection.getCpuSummary() == null && (this.diary == null || this.diary.isPrintGCDetails())) {
            this.forwardReference = collection;
        } else {
            super.publish(ChannelName.G1GC_PARSER_OUTBOX, (JVMEvent)collection);
            this.forwardReference = this.trap;
            this.collectionTypeForwardReference = null;
            this.referenceGCForwardReferenceSummary = null;
        }
    }

    private void log(String line) {
        if (line.startsWith("Java HotSpot(TM)")) {
            return;
        }
        if (line.startsWith("Memory: ")) {
            return;
        }
        if (line.startsWith("CommandLine flags: ")) {
            return;
        }
        GCToolKit.LOG_DEBUG_MESSAGE(() -> "Missed: " + line);
        LOGGER.log(Level.FINE, "Missed: {0}", line);
    }

    public boolean accepts(Diary diary) {
        return diary.isG1GC() && !diary.isUnifiedLogging();
    }

    @Override
    public void publishTo(JVMEventChannel bus) {
        super.publishTo(bus);
    }
}

