/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.GCToolKit;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.UnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.collection.MRUQueue;
import com.microsoft.gctoolkit.parser.unified.ShenandoahPatterns;
import java.util.AbstractMap;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ShenandoahParser
extends UnifiedGCLogParser
implements ShenandoahPatterns {
    private static final Logger LOGGER = Logger.getLogger(ShenandoahParser.class.getName());
    private final MRUQueue<GCParseRule, BiConsumer<GCLogTrace, String>> parseRules = new MRUQueue();
    private ShenandoahForwardReference forwardReference;

    public ShenandoahParser() {
        this.parseRules.put(END_OF_FILE, this::endOfFile);
    }

    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.SHENANDOAH);
    }

    @Override
    public String getName() {
        return "Shenandoah Parser";
    }

    @Override
    protected void process(String line) {
        if (this.ignoreFrequentButUnwantedEntries(line)) {
            return;
        }
        try {
            Optional<AbstractMap.SimpleEntry> optional = this.parseRules.keys().stream().map(rule -> new AbstractMap.SimpleEntry<GCParseRule, GCLogTrace>((GCParseRule)rule, rule.parse(line))).filter(tuple -> tuple.getValue() != null).findFirst();
            if (optional.isPresent()) {
                AbstractMap.SimpleEntry ruleAndTrace = optional.get();
                this.parseRules.get(ruleAndTrace.getKey()).accept((GCLogTrace)ruleAndTrace.getValue(), line);
                return;
            }
        }
        catch (Throwable t) {
            LOGGER.throwing(this.getName(), "process", t);
        }
        this.log(line);
    }

    private boolean ignoreFrequentButUnwantedEntries(String line) {
        return false;
    }

    public void endOfFile(GCLogTrace trace, String line) {
        this.publish((JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
    }

    private void log(String line) {
        GCToolKit.LOG_DEBUG_MESSAGE(() -> "ZGCHeapParser missed: " + line);
        LOGGER.log(Level.WARNING, "Missed: {0}", line);
    }

    public void publish() {
        this.publish(this.forwardReference.toShenandoahCycle());
    }

    public void publish(JVMEvent event) {
        super.publish(ChannelName.SHENANDOAH_PARSER_OUTBOX, event);
        this.forwardReference = null;
    }

    public boolean accepts(Diary diary) {
        return diary.isShenandoah();
    }

    @Override
    public void publishTo(JVMEventChannel bus) {
        super.publishTo(bus);
    }

    private class ShenandoahForwardReference {
        private ShenandoahForwardReference() {
        }

        JVMEvent toShenandoahCycle() {
            return null;
        }
    }
}

