/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.event.jvm.SurvivorRecord;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.PreUnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.TenuredPatterns;
import com.microsoft.gctoolkit.parser.unified.UnifiedPatterns;
import java.util.Set;

public class SurvivorMemoryPoolParser
extends PreUnifiedGCLogParser
implements TenuredPatterns {
    private SurvivorRecord forwardReference = null;

    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.SURVIVOR);
    }

    @Override
    public String getName() {
        return "SurvivorMemoryPoolParser";
    }

    @Override
    protected void process(String entry) {
        GCLogTrace trace = TENURING_SUMMARY.parse(entry);
        if (trace != null) {
            this.forwardReference = new SurvivorRecord(this.getClock(), trace.getLongGroup(1), trace.getIntegerGroup(2), trace.getIntegerGroup(3));
        } else {
            trace = TENURING_AGE_BREAKDOWN.parse(entry);
            if (trace != null) {
                this.forwardReference.add(trace.getIntegerGroup(1), trace.getLongGroup(2));
            } else if (entry.equals("END_OF_DATA_SENTINEL") || UnifiedPatterns.JVM_EXIT.parse(entry) != null) {
                if (this.forwardReference != null) {
                    super.publish(ChannelName.SURVIVOR_MEMORY_POOL_PARSER_OUTBOX, (JVMEvent)this.forwardReference);
                }
                super.publish(ChannelName.SURVIVOR_MEMORY_POOL_PARSER_OUTBOX, (JVMEvent)new JVMTermination(this.getClock(), this.diary.getTimeOfFirstEvent()));
            } else if (this.forwardReference != null) {
                super.publish(ChannelName.SURVIVOR_MEMORY_POOL_PARSER_OUTBOX, (JVMEvent)this.forwardReference);
                this.forwardReference = null;
            }
        }
    }

    public boolean accepts(Diary diary) {
        return diary.isTenuringDistribution() && !diary.isUnifiedLogging();
    }

    @Override
    public void publishTo(JVMEventChannel channel) {
        super.publishTo(channel);
    }
}

