/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.GCToolKit;
import com.microsoft.gctoolkit.aggregator.EventSource;
import com.microsoft.gctoolkit.event.CPUSummary;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.MalformedEvent;
import com.microsoft.gctoolkit.event.RegionSummary;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentUndoCycle;
import com.microsoft.gctoolkit.event.g1gc.G1GCConcurrentEvent;
import com.microsoft.gctoolkit.event.g1gc.G1GCEvent;
import com.microsoft.gctoolkit.event.g1gc.G1GCPauseEvent;
import com.microsoft.gctoolkit.event.jvm.JVMEvent;
import com.microsoft.gctoolkit.event.jvm.JVMTermination;
import com.microsoft.gctoolkit.event.jvm.MetaspaceRecord;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.message.ChannelName;
import com.microsoft.gctoolkit.message.JVMEventChannel;
import com.microsoft.gctoolkit.parser.G1GCForwardReference;
import com.microsoft.gctoolkit.parser.GCLogParser;
import com.microsoft.gctoolkit.parser.GCLogTrace;
import com.microsoft.gctoolkit.parser.GCParseRule;
import com.microsoft.gctoolkit.parser.UnifiedGCLogParser;
import com.microsoft.gctoolkit.parser.collection.RuleSet;
import com.microsoft.gctoolkit.parser.jvm.Decorators;
import com.microsoft.gctoolkit.parser.unified.UnifiedG1GCPatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnifiedG1GCParser
extends UnifiedGCLogParser
implements UnifiedG1GCPatterns {
    private static final Logger LOGGER = Logger.getLogger(UnifiedG1GCParser.class.getName());
    private final Map<Integer, G1GCForwardReference> collectionsUnderway = new ConcurrentHashMap<Integer, G1GCForwardReference>();
    private boolean before = false;
    private int gcInvocations = 0;
    private int fullGCInvocations = 0;
    private DateTimeStamp jvmTerminationEventTime = new DateTimeStamp(-1.0);
    private G1GCForwardReference forwardReference;
    private boolean concurrentPhaseActive = false;
    private final RuleSet<GCParseRule, BiConsumer<GCLogTrace, String>> parseRules = new RuleSet();
    private static final Pattern gcIdPattern = GCLogParser.GCID_COUNTER.pattern();
    private int regionSize;
    private long minHeapSize;
    private long initialHeapSize;
    private long maxHeapSize;
    private final Queue<G1GCEvent> eventQueue;

    public UnifiedG1GCParser() {
        this.parseRules.put(G1_COLLECTION, this::g1Collection);
        this.parseRules.put(CPU_BREAKOUT, this::cpuBreakout);
        this.parseRules.put(HEAP_BEFORE_AFTER_GC_INVOCATION_COUNT, this::heapBeforeAfterGCInvocationCount);
        this.parseRules.put(HEAP_SUMMARY, this::heapSummary);
        this.parseRules.put(REGION_DISBURSEMENT, this::youngRegionAllotment);
        this.parseRules.put(META_CLASS_SPACE, this::metaClassSpace);
        this.parseRules.put(WORKER_SUMMARY, this::workSummary);
        this.parseRules.put(REFERENCES, this::references);
        this.parseRules.put(REFERENCE_COUNTS, this::referenceCounts);
        this.parseRules.put(PRE_EVACUATE_COLLECTION_SET, this::evacuateCollectionSetTime);
        this.parseRules.put(PRE_EVACUATION_SUBPHASE, this::preEvacuateCSetPhaseDuration);
        this.parseRules.put(EVACUATION_PHASE, this::evacuateCSetPhase);
        this.parseRules.put(PARALLEL_COUNT, this::parallelCount);
        this.parseRules.put(POST_EVACUATE_PHASE, this::postEvacuatePhaseDuration);
        this.parseRules.put(REFERENCE_PROCESSING, this::postEvacuatePhaseDuration);
        this.parseRules.put(TO_SPACE_EXHAUSTED, this::toSpaceExhausted);
        this.parseRules.put(OTHER, this::other);
        this.parseRules.put(REGION_SUMMARY, this::regionSummary);
        this.parseRules.put(UNIFIED_META_DATA, this::unifiedMetaData);
        this.parseRules.put(YOUNG_DETAILS, this::youngDetails);
        this.parseRules.put(META_SPACE_BREAKOUT, this::metaNonClassClassSpace);
        this.parseRules.put(HEAP_REGION_SIZE, this::heapRegionSize);
        this.parseRules.put(HEAP_SIZE, this::heapSize);
        this.parseRules.put(G1_TAG, this::ignore);
        this.parseRules.put(CONCURRENT_CYCLE_START, this::concurrentCycleStart);
        this.parseRules.put(CONCURRENT_CYCLE_END, this::concurrentCycleEnd);
        this.parseRules.put(CONCURRENT_UNDO_CYCLE_START, this::concurrentUndoCycleStart);
        this.parseRules.put(CONCURRENT_UNDO_CYCLE_END, this::concurrentUndoCycleEnd);
        this.parseRules.put(CONCURRENT_PHASE, this::concurrentPhase);
        this.parseRules.put(CONCURRENT_PHASE_DURATION, this::concurrentPhaseDuration);
        this.parseRules.put(CONCURRENT_MARK_PHASE, this::concurrentMarkInternalPhases);
        this.parseRules.put(CONCURRENT_MARK_PHASE_DURATION, this::concurrentMarkInternalPhaseDuration);
        this.parseRules.put(CONCURRENT_MARK_START, this::concurrentPhase);
        this.parseRules.put(CONCURRENT_MARK_WORKERS, this::concurrentMarkWorkers);
        this.parseRules.put(CONCURRENT_MARK_ABORTED, this::concurrentMarkAborted);
        this.parseRules.put(CONCURRENT_MARK_END, this::concurrentMarkEnd);
        this.parseRules.put(PAUSE_REMARK_START, this::remarkStart);
        this.parseRules.put(FINALIZE_MARKING, this::finalizeMarking);
        this.parseRules.put(SYSTEM_DICTIONARY_UNLOADING, this::systemDictionaryUnloading);
        this.parseRules.put(STRING_SYMBOL_TABLE, this::stringSymbolTableCleaning);
        this.parseRules.put(PARALLEL_UNLOADING, this::parallelUnloading);
        this.parseRules.put(PAUSE_REMARK_END, this::pausePhaseDuringConcurrentCycleDurationEnd);
        this.parseRules.put(CLEANUP_START, this::cleanupStart);
        this.parseRules.put(CLEANUP__FINALIZE_CONC_MARK, this::noop);
        this.parseRules.put(CLEANUP_END, this::pausePhaseDuringConcurrentCycleDurationEnd);
        this.parseRules.put(FULL_PHASE, this::fullPhase);
        this.parseRules.put(FULL_CLASS_UNLOADING, this::fullClassUnloading);
        this.parseRules.put(FULL_STRING_SYMBOL_TABLE, this::fullStringSymbolTable);
        this.parseRules.put(JVM_EXIT, this::jvmExit);
        this.parseRules.put(new GCParseRule("END_OF_DATA_SENTINEL", "END_OF_DATA_SENTINEL"), this::endOfFile);
        this.parseRules.put(CONCATENATE_DIRTY_CARD_LOGS, this::noop);
        this.parseRules.put(REGION_REGISTER, this::noop);
        this.parseRules.put(HEAP_ROOTS, this::noop);
        this.parseRules.put(EAGER_RECLAIM, this::noop);
        this.parseRules.put(REMEMBERED_SETS, this::noop);
        this.parseRules.put(EAGER_RECLAIM_STEP, this::noop);
        this.parseRules.put(CARDS, this::noop);
        this.parseRules.put(HOT_CARD_CACHE, this::noop);
        this.parseRules.put(LOG_BUFFERS, this::noop);
        this.parseRules.put(SCAN_HEAP_ROOTS, this::noop);
        this.parseRules.put(SCANS, this::noop);
        this.parseRules.put(CLAIMED_CHUNKS, this::noop);
        this.parseRules.put(CODE_ROOT_SCAN, this::noop);
        this.parseRules.put(STRING_DEDUP, this::noop);
        this.parseRules.put(WEAK_JFR_SAMPLES, this::noop);
        this.parseRules.put(POST_EVAC_CLEANUP, this::noop);
        this.parseRules.put(MERGE_THREAD_STATE, this::noop);
        this.parseRules.put(COPIED_BYTES, this::noop);
        this.parseRules.put(LAB, this::noop);
        this.parseRules.put(CLEAR_LOGGED_CARDS, this::noop);
        this.parseRules.put(RECALC_USED_MEM, this::noop);
        this.parseRules.put(PURGE_CODE_ROOTS, this::noop);
        this.parseRules.put(UPDATE_DERIVED_POINTERS, this::noop);
        this.parseRules.put(EAGER_HUMONGOUS_RECLAIM, this::noop);
        this.parseRules.put(HUMONGOUS, this::noop);
        this.parseRules.put(REDIRTY_CARDS, this::noop);
        this.parseRules.put(REDIRTIED_CARDS, this::noop);
        this.parseRules.put(FREE_CSET, this::noop);
        this.parseRules.put(REBUILD_FREELIST, this::noop);
        this.parseRules.put(NEW_CSET, this::noop);
        this.parseRules.put(RESIZE_TLAB, this::noop);
        this.regionSize = 0;
        this.minHeapSize = 0L;
        this.initialHeapSize = 0L;
        this.maxHeapSize = 0L;
        this.eventQueue = new LinkedList<G1GCEvent>();
    }

    public Set<EventSource> eventsProduced() {
        return Set.of(EventSource.G1GC);
    }

    @Override
    public String getName() {
        return "UnifiedG1GCParser";
    }

    @Override
    protected void process(String line) {
        if (!this.ignoreFrequentlySeenButUnwantedLines(line)) {
            this.parse(line);
        }
    }

    private void parse(String line) {
        int end;
        int gcid;
        Matcher gcIdMatcher = gcIdPattern.matcher(line);
        if (gcIdMatcher.find()) {
            gcid = Integer.parseInt(gcIdMatcher.group(1));
            end = gcIdMatcher.end();
        } else {
            gcid = -1;
            end = 0;
        }
        String lineAfterGcId = line.substring(end);
        this.parseRules.stream().map(Map.Entry::getKey).map(rule -> new AbstractMap.SimpleEntry<GCParseRule, GCLogTrace>((GCParseRule)rule, rule.parse(lineAfterGcId))).filter(tuple -> tuple.getValue() != null).findAny().ifPresentOrElse(tuple -> {
            this.setForwardReference(gcid, end > 0 ? line.substring(0, end) : line);
            this.applyRule((GCParseRule)tuple.getKey(), (GCLogTrace)tuple.getValue(), line);
        }, () -> this.log(line));
    }

    private void applyRule(GCParseRule ruleToApply, GCLogTrace trace, String line) {
        try {
            this.parseRules.select(ruleToApply).accept(trace, line);
        }
        catch (Throwable t) {
            LOGGER.throwing(this.getName(), "process", t);
        }
    }

    private void setForwardReference(int gcid, String line) {
        if (gcid != -1) {
            this.forwardReference = this.collectionsUnderway.computeIfAbsent(gcid, k -> new G1GCForwardReference(new Decorators(line), gcid));
            this.forwardReference.setHeapRegionSize(this.regionSize);
            this.forwardReference.setMaxHeapSize(this.maxHeapSize);
            this.forwardReference.setMinHeapSize(this.minHeapSize);
            this.forwardReference.setInitialHeapSize(this.initialHeapSize);
        }
    }

    private void removeForwardReference(G1GCForwardReference forwardReference) {
        this.collectionsUnderway.remove(forwardReference.getGcID());
    }

    private void noop(GCLogTrace trace, String line) {
    }

    private void cpuBreakout(GCLogTrace trace, String line) {
        CPUSummary cpuSummary = new CPUSummary(trace.getDoubleGroup(1), trace.getDoubleGroup(2), trace.getDoubleGroup(3));
        this.forwardReference.setCPUSummary(cpuSummary);
        try {
            this.publishPauseEvent(this.forwardReference.buildEvent());
        }
        catch (MalformedEvent malformedEvent) {
            LOGGER.warning(malformedEvent.getMessage());
        }
    }

    public void endOfFile(GCLogTrace trace, String line) {
        this.publish((JVMEvent)new JVMTermination(this.jvmTerminationEventTime.hasTimeStamp() ? this.jvmTerminationEventTime : this.getClock(), this.diary.getTimeOfFirstEvent()));
    }

    private void heapBeforeAfterGCInvocationCount(GCLogTrace trace, String line) {
        if ("before".equals(trace.getGroup(1))) {
            this.before = true;
        } else if ("after".equals(trace.getGroup(1))) {
            this.before = false;
        }
        this.gcInvocations = trace.getIntegerGroup(2);
        this.fullGCInvocations = trace.getIntegerGroup(3);
    }

    private void heapSummary(GCLogTrace trace, String line) {
    }

    public void heapSize(GCLogTrace trace, String line) {
        this.minHeapSize = trace.getLongGroup(1);
        this.initialHeapSize = trace.getLongGroup(2);
        this.maxHeapSize = trace.getLongGroup(3);
    }

    public void heapRegionSize(GCLogTrace trace, String line) {
        this.regionSize = trace.getIntegerGroup(1);
    }

    private void youngRegionAllotment(GCLogTrace trace, String line) {
        this.forwardReference.setHeapRegionSize(trace.getIntegerGroup(1) / 1024);
        if (this.before) {
            this.forwardReference.setYoungOccupancyBeforeCollection(trace.getLongGroup(3));
            this.forwardReference.setSurvivorOccupancyBeforeCollection(trace.getLongGroup(5));
            this.forwardReference.setEdenOccupancyBeforeCollection(trace.getLongGroup(3) - trace.getLongGroup(5));
            this.forwardReference.setYoungSizeBeforeCollection(trace.getLongGroup(3));
        } else {
            this.forwardReference.setYoungOccupancyAfterCollection(trace.getLongGroup(5));
            this.forwardReference.setSurvivorOccupancyAfterCollection(trace.getLongGroup(5));
            this.forwardReference.setEdenOccupancyAfterCollection(0L);
            this.forwardReference.setYoungSizeAfterCollection(trace.getLongGroup(3));
        }
    }

    private void metaClassSpace(GCLogTrace trace, String line) {
        if (this.before) {
            if (trace.getGroup(1).equals("Metaspace")) {
                this.forwardReference.setMetaspaceOccupancyBeforeCollection(trace.getLongGroup(2));
                this.forwardReference.setMetaspaceSizeBeforeCollection(trace.getLongGroup(3));
                this.forwardReference.setMetaspaceCommittedBeforeCollection(trace.getLongGroup(4));
                this.forwardReference.setMetaspaceReservedBeforeCollection(trace.getLongGroup(5));
            } else if (trace.getGroup(1).equals("class space")) {
                this.forwardReference.setClassspaceOccupancyBeforeCollection(trace.getLongGroup(2));
                this.forwardReference.setClassspaceSizeBeforeCollection(trace.getLongGroup(3));
                this.forwardReference.setClassspaceCommittedBeforeCollection(trace.getLongGroup(4));
                this.forwardReference.setClassspaceReservedBeforeCollection(trace.getLongGroup(5));
            } else {
                trace.notYetImplemented();
            }
        } else if (trace.getGroup(1).equals("Metaspace")) {
            this.forwardReference.setMetaspaceOccupancyAfterCollection(trace.getLongGroup(2));
            this.forwardReference.setMetaspaceSizeAfterCollection(trace.getLongGroup(3));
            this.forwardReference.setMetaspaceCommittedAfterCollection(trace.getLongGroup(4));
            this.forwardReference.setMetaspaceReservedAfterCollection(trace.getLongGroup(5));
        } else if (trace.getGroup(1).equals("class space")) {
            this.forwardReference.setClassspaceOccupancyAfterCollection(trace.getLongGroup(2));
            this.forwardReference.setClassspaceSizeAfterCollection(trace.getLongGroup(3));
            this.forwardReference.setClassspaceCommittedAfterCollection(trace.getLongGroup(4));
            this.forwardReference.setClassspaceReservedAfterCollection(trace.getLongGroup(5));
        } else {
            trace.notYetImplemented();
        }
    }

    private void g1Collection(GCLogTrace trace, String line) {
        GarbageCollectionTypes gcType;
        String gcSubtype = trace.getGroup(3);
        if (gcSubtype == null) {
            gcType = GarbageCollectionTypes.fromLabel((String)trace.getGroup(1));
        } else {
            switch (gcSubtype) {
                default: {
                    LOGGER.warning("GC Type not recognized: " + line);
                }
                case "Prepare Mixed": 
                case "Normal": {
                    gcType = GarbageCollectionTypes.fromLabel((String)trace.getGroup(1));
                    break;
                }
                case "Mixed": {
                    gcType = GarbageCollectionTypes.fromLabel((String)trace.getGroup(3));
                    break;
                }
                case "Concurrent End": 
                case "Concurrent Start": {
                    gcType = GarbageCollectionTypes.Initial_Mark;
                }
            }
        }
        this.forwardReference.setGcType(gcType);
        this.forwardReference.setGCCause(trace.gcCause(-2));
        this.forwardReference.setStartTime(this.getClock());
    }

    private void workSummary(GCLogTrace trace, String line) {
        this.forwardReference.evacuationWorkers(trace.getIntegerGroup(1), trace.getIntegerGroup(2));
    }

    private void references(GCLogTrace trace, String line) {
        if (trace.getGroup(1) != null) {
            return;
        }
        switch (trace.getGroup(2)) {
            case "SoftReference": {
                this.forwardReference.setSoftReferenceProcessingDuation(trace.getDurationInSeconds());
                break;
            }
            case "WeakReference": {
                this.forwardReference.setWeakReferenceProcessingDuration(trace.getDurationInSeconds());
                break;
            }
            case "FinalReference": {
                this.forwardReference.setFinalReferenceProcessingDuration(trace.getDurationInSeconds());
                break;
            }
            case "PhantomReference": {
                this.forwardReference.setPhantomReferenceProcessingDuration(trace.getDurationInSeconds());
                break;
            }
            case "JNI Weak Reference": {
                this.forwardReference.setJniWeakReferenceProcessingDuration(trace.getDurationInSeconds());
                break;
            }
            default: {
                trace.notYetImplemented();
            }
        }
    }

    private void referenceCounts(GCLogTrace trace, String line) {
        this.forwardReference.setReferenceCounts(trace.getIntegerGroup(1), trace.getIntegerGroup(2), trace.getIntegerGroup(3), trace.getIntegerGroup(4));
    }

    private void evacuateCollectionSetTime(GCLogTrace trace, String line) {
        if (trace.getGroup(1) == null) {
            this.forwardReference.setEvacuationCSetDuration(trace.getDurationInSeconds());
        } else if ("Pre".equals(trace.getGroup(1))) {
            this.forwardReference.setPreEvacuateCSetDuration(trace.getDurationInSeconds());
        } else if ("Post".equals(trace.getGroup(1))) {
            this.forwardReference.setPostEvacuateCSetDuration(trace.getDurationInSeconds());
        } else {
            LOGGER.warning("Not recognized: " + line);
        }
    }

    public void other(GCLogTrace trace, String line) {
        this.forwardReference.setOtherDuration(trace.getDurationInSeconds());
    }

    private void preEvacuateCSetPhaseDuration(GCLogTrace trace, String line) {
        this.forwardReference.postPreEvacuateCSetPhaseDuration(trace.getGroup(1), trace.getDurationInSeconds());
    }

    public void evacuateCSetPhase(GCLogTrace trace, String line) {
        this.forwardReference.postEvacuateCSetPhaseDuration(trace.getGroup(1), trace.getUnifiedStatisticalSummary());
    }

    public void postEvacuatePhaseDuration(GCLogTrace trace, String line) {
        this.forwardReference.postPostEvacuateCSetPhaseDuration(trace.getGroup(1), trace.getDurationInSeconds());
    }

    public void toSpaceExhausted(GCLogTrace trace, String line) {
        this.forwardReference.toSpaceExhausted();
    }

    public void parallelCount(GCLogTrace trace, String line) {
        switch (trace.getGroup(1)) {
            case "Processed Buffers": {
                this.forwardReference.setProcessedBuffersSummary(trace.countSummary());
                break;
            }
            case "Termination Attempts": {
                this.forwardReference.setTerminationAttempts(trace.countSummary());
                break;
            }
            default: {
                trace.notYetImplemented();
            }
        }
    }

    public void regionSummary(GCLogTrace trace, String line) {
        RegionSummary summary = trace.regionSummary();
        switch (trace.getGroup(1)) {
            case "Eden": {
                this.forwardReference.setEdenRegionSummary(summary);
                break;
            }
            case "Survivor": {
                this.forwardReference.setSurvivorRegionSummary(summary);
                break;
            }
            case "Old": {
                this.forwardReference.setOldRegionSummary(summary);
                break;
            }
            case "Humongous": {
                this.forwardReference.setHumongousRegionSummary(summary);
                break;
            }
            case "Archive": {
                this.forwardReference.setArchiveRegionSummary(summary);
                break;
            }
            default: {
                this.notYetImplemented(trace, line);
            }
        }
    }

    public void unifiedMetaData(GCLogTrace trace, String line) {
        if (this.forwardReference.setMetaspaceOccupancyBeforeCollection(trace.toKBytes(1))) {
            this.forwardReference.setMetaspaceOccupancyAfterCollection(trace.toKBytes(3));
            this.forwardReference.setMetaspaceSizeAfterCollection(trace.toKBytes(5));
        }
    }

    public void youngDetails(GCLogTrace trace, String line) {
        this.forwardReference.setHeapOccupancyBeforeCollection(trace.toKBytes(5));
        this.forwardReference.setHeapOccupancyAfterCollection(trace.toKBytes(7));
        this.forwardReference.setHeapSizeAfterCollection(trace.toKBytes(9));
        this.forwardReference.setDuration(trace.getDurationInSeconds());
    }

    public void metaNonClassClassSpace(GCLogTrace trace, String line) {
        MetaspaceRecord metaspace = trace.getEnlargedMetaSpaceRecord(1);
        this.forwardReference.setMetaspaceOccupancyBeforeCollection(metaspace.getOccupancyBeforeCollection());
        this.forwardReference.setMetaspaceOccupancyAfterCollection(metaspace.getOccupancyAfterCollection());
        this.forwardReference.setMetaspaceSizeAfterCollection(metaspace.getSizeAfterCollection());
        MetaspaceRecord classSpace = trace.getEnlargedMetaSpaceRecord(17);
        this.forwardReference.setClassspaceOccupancyBeforeCollection(classSpace.getOccupancyBeforeCollection());
        this.forwardReference.setClassspaceCommittedAfterCollection(classSpace.getOccupancyAfterCollection());
        this.forwardReference.setClassspaceSizeAfterCollection(classSpace.getSizeAfterCollection());
    }

    private void concurrentCycleStart(GCLogTrace trace, String line) {
        this.forwardReference.setConcurrentCycleStartTime(this.getClock());
        this.forwardReference.setGcType(GarbageCollectionTypes.Concurrent_Cycle);
    }

    private void concurrentCycleEnd(GCLogTrace trace, String line) {
        this.removeForwardReference(this.forwardReference);
    }

    private void concurrentUndoCycleStart(GCLogTrace trace, String line) {
        this.forwardReference.setConcurrentCycleStartTime(this.getClock());
        this.forwardReference.setGcType(GarbageCollectionTypes.G1GCConcurrentUndoCycle);
    }

    private void concurrentUndoCycleEnd(GCLogTrace trace, String line) {
        this.forwardReference.setDuration(trace.getDurationInSeconds());
        this.publishUndoCycle((G1ConcurrentUndoCycle)this.forwardReference.buildConcurrentUndoCycleEvent());
        this.removeForwardReference(this.forwardReference);
    }

    private void concurrentPhase(GCLogTrace trace, String line) {
        this.forwardReference.setConcurrentPhase(GarbageCollectionTypes.fromLabel((String)trace.getGroup(1)));
        this.forwardReference.setStartTime(this.getClock());
        this.concurrentPhaseActive = true;
    }

    private void concurrentMarkEnd(GCLogTrace trace, String line) {
        this.forwardReference.setDuration(trace.getDurationInSeconds());
        this.publishConcurrentEvent(this.forwardReference.buildConcurrentPhaseEvent());
    }

    private void concurrentPhaseDuration(GCLogTrace trace, String line) {
        this.forwardReference.setDuration(trace.getDurationInSeconds());
        this.publishConcurrentEvent(this.forwardReference.buildConcurrentPhaseEvent());
    }

    private void concurrentMarkInternalPhases(GCLogTrace trace, String line) {
    }

    private void concurrentMarkInternalPhaseDuration(GCLogTrace trace, String line) {
        switch (trace.getGroup(1)) {
            case "Mark From Roots": {
                this.forwardReference.setMarkFromRootsDuration(trace.getDurationInSeconds());
                break;
            }
            case "Preclean": {
                this.forwardReference.setPrecleanDuration(trace.getDurationInSeconds());
                break;
            }
            default: {
                LOGGER.warning("unknown Concurrent Mark phase : " + line);
            }
        }
    }

    private void concurrentMarkWorkers(GCLogTrace trace, String line) {
        this.forwardReference.concurrentMarkWorkers(trace.getIntegerGroup(1), trace.getIntegerGroup(2));
    }

    private void concurrentMarkAborted(GCLogTrace trace, String line) {
        this.forwardReference.abortConcurrentMark();
        this.publishConcurrentEvent(this.forwardReference.buildConcurrentPhaseEvent());
    }

    private void remarkStart(GCLogTrace trace, String line) {
        this.forwardReference.pausePhaseDuringConcurrentCycle(GarbageCollectionTypes.G1GCRemark);
        this.forwardReference.pausePhaseDuringConcurrentCycleStart(this.getClock());
    }

    private void cleanupStart(GCLogTrace trace, String line) {
        this.forwardReference.pausePhaseDuringConcurrentCycle(GarbageCollectionTypes.G1GCCleanup);
        this.forwardReference.pausePhaseDuringConcurrentCycleStart(this.getClock());
    }

    private void finalizeMarking(GCLogTrace trace, String line) {
        this.forwardReference.finalizeMarkingDuration(trace.getDurationInSeconds());
    }

    private void systemDictionaryUnloading(GCLogTrace trace, String line) {
        this.forwardReference.systemDictionaryUnloadingDuration(trace.getDurationInSeconds());
    }

    private void stringSymbolTableCleaning(GCLogTrace trace, String s) {
        this.forwardReference.stringTableProcessedAndRemoved(trace.getIntegerGroup(1), trace.getIntegerGroup(2));
        this.forwardReference.symbolTableProcessedAndRemoved(trace.getIntegerGroup(3), trace.getIntegerGroup(4));
    }

    private void parallelUnloading(GCLogTrace trace, String line) {
        this.forwardReference.parallelUnloadingDuration(trace.getDurationInSeconds());
    }

    private void pausePhaseDuringConcurrentCycleDurationEnd(GCLogTrace trace, String line) {
        this.forwardReference.pausePhaseDuringConcurrentCycleDuration(trace.getDurationInSeconds());
        this.forwardReference.setHeapOccupancyBeforeCollection(trace.toKBytes(1));
        this.forwardReference.setHeapSizeBeforeCollection(trace.toKBytes(5));
        this.forwardReference.setHeapOccupancyAfterCollection(trace.toKBytes(3));
        this.forwardReference.setHeapSizeAfterCollection(trace.toKBytes(5));
    }

    private void fullPhase(GCLogTrace trace, String line) {
        if (trace.getGroup(3) != null) {
            this.forwardReference.fullPhase(trace.getIntegerGroup(1), trace.getGroup(2), trace.getDurationInSeconds());
        }
    }

    private void fullClassUnloading(GCLogTrace trace, String line) {
    }

    private void fullStringSymbolTable(GCLogTrace trace, String line) {
    }

    private void publishConcurrentEvent(G1GCConcurrentEvent event) {
        if (event == null) {
            return;
        }
        if (this.forwardReference.getGcType() != GarbageCollectionTypes.G1GCConcurrentUndoCycle) {
            this.publish((JVMEvent)event);
            this.concurrentPhaseActive = false;
            this.eventQueue.stream().forEach(this::publish);
            this.eventQueue.clear();
        } else {
            this.eventQueue.add((G1GCEvent)event);
        }
    }

    private void publishUndoCycle(G1ConcurrentUndoCycle cycle) {
        this.concurrentPhaseActive = false;
        this.publish((JVMEvent)cycle);
        this.eventQueue.stream().forEach(this::publish);
        this.eventQueue.clear();
    }

    private void publishPauseEvent(G1GCPauseEvent event) {
        if (event == null) {
            return;
        }
        if (this.concurrentPhaseActive) {
            this.eventQueue.add((G1GCEvent)event);
            this.removeForwardReference(this.forwardReference);
        } else {
            this.publish((JVMEvent)event);
            if (!this.forwardReference.isConcurrentCycle()) {
                this.removeForwardReference(this.forwardReference);
            }
        }
    }

    private void jvmExit(GCLogTrace trace, String s) {
        this.jvmTerminationEventTime = this.getClock();
    }

    private boolean ignoreFrequentlySeenButUnwantedLines(String line) {
        if (line.contains("Desired survivor size")) {
            return true;
        }
        if (line.contains("Age table with threshold")) {
            return true;
        }
        if (line.contains("safepoint")) {
            return true;
        }
        if (line.contains(") Skipped phase ")) {
            return true;
        }
        if (line.contains(" Total                          Min: ")) {
            return true;
        }
        if (line.contains(" Dead                           Min: ")) {
            return true;
        }
        if (line.contains(" VM Weak                        Min")) {
            return true;
        }
        if (line.contains(" ObjectSynchronizer Weak        Min:")) {
            return true;
        }
        if (line.contains(" JVMTI Tag Weak OopStorage      Min:")) {
            return true;
        }
        if (line.contains(" StringTable Weak               Min:")) {
            return true;
        }
        if (line.contains(" ResolvedMethodTable Weak       Min:")) {
            return true;
        }
        if (line.contains(" JNI Weak                       Min:")) {
            return true;
        }
        return line.contains(" - age ");
    }

    private void ignore(GCLogTrace trace, String line) {
    }

    private void log(String line) {
        if (!this.ignoreFrequentlySeenButUnwantedLines(line)) {
            GCToolKit.LOG_DEBUG_MESSAGE(() -> "Missed: " + line);
            LOGGER.log(Level.FINE, "Missed: {0}", line);
        }
    }

    public boolean accepts(Diary diary) {
        return diary.isG1GC() && diary.isUnifiedLogging();
    }

    @Override
    public void publishTo(JVMEventChannel bus) {
        super.publishTo(bus);
    }

    private void publish(JVMEvent event) {
        super.publish(ChannelName.G1GC_PARSER_OUTBOX, event);
    }
}

