/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser.collection;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;

public class RuleSet<K, V>
implements Map<K, V>,
Iterable<K> {
    private Node<K, V> head;
    private final HashMap<K, Node<K, V>> entries = new HashMap();

    @Override
    public V get(Object key) {
        if (key != null) {
            Node<K, V> node = this.entries.get(key);
            return node.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsKey(Object key) {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return false;
    }

    @Override
    public V put(K key, V value) {
        Node<K, V> node = new Node<K, V>(key, value);
        if (this.head == null) {
            this.head = node;
        } else {
            node.next = this.head;
            this.head.prev = node;
            this.head = node;
        }
        this.entries.put(key, node);
        return value;
    }

    @Override
    public V remove(Object key) {
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
    }

    @Override
    public void clear() {
    }

    @Override
    public Set<K> keySet() {
        return this.entries.keySet();
    }

    @Override
    public Collection<V> values() {
        LinkedList values = new LinkedList();
        Node<K, V> node = this.head;
        while (node != null) {
            values.add(node.getValue());
            node = node.next;
        }
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> entrySet = new HashSet<Map.Entry<K, V>>();
        Node<K, V> node = this.head;
        while (node != null) {
            entrySet.add(node);
            node = node.next;
        }
        return entrySet;
    }

    public Stream<Map.Entry<K, V>> stream() {
        return Stream.iterate(this.head, Objects::nonNull, node -> ((Node)node).next);
    }

    @Override
    public Iterator<K> iterator() {
        return new KeyIterator();
    }

    public V select(K key) {
        Node<K, V> selected = this.entries.get(key);
        if (selected != this.head) {
            if (selected.next != null) {
                Node next = selected.next;
                next.prev = selected.prev;
            }
            if (selected.prev != null) {
                Node prev = selected.prev;
                prev.next = selected.next;
            }
            this.head.prev = selected;
            selected.next = this.head;
            this.head = selected;
        }
        return selected.getValue();
    }

    private class KeyIterator
    implements Iterator<K> {
        private Node<K, V> node;

        public KeyIterator() {
            this.node = RuleSet.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.node != null;
        }

        @Override
        public K next() {
            if (this.node == null) {
                throw new NoSuchElementException();
            }
            Node current = this.node;
            this.node = this.node.next;
            return current.getKey();
        }
    }

    private static class Node<K, V>
    extends AbstractMap.SimpleImmutableEntry<K, V> {
        private Node<K, V> next;
        private Node<K, V> prev;

        public Node(K key, V value) {
            super(key, value);
        }
    }
}

