/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser.jvm;

import com.microsoft.gctoolkit.jvm.Diarizer;
import com.microsoft.gctoolkit.jvm.Diary;
import com.microsoft.gctoolkit.jvm.SupportedFlags;
import com.microsoft.gctoolkit.parser.jvm.Decorators;
import com.microsoft.gctoolkit.parser.unified.ShenandoahPatterns;
import com.microsoft.gctoolkit.parser.unified.UnifiedG1GCPatterns;
import com.microsoft.gctoolkit.parser.unified.UnifiedGenerationalPatterns;
import com.microsoft.gctoolkit.parser.unified.UnifiedLoggingLevel;
import com.microsoft.gctoolkit.parser.unified.UnifiedPatterns;
import com.microsoft.gctoolkit.parser.unified.ZGCPatterns;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.TreeSet;

public class UnifiedDiarizer
implements Diarizer {
    private static final int CYCLES_TO_EXAMINE_BEFORE_GIVING_UP = 10;
    private static final int CYCLES_TO_EXAMINE_FOR_SAFEPOINT = 2;
    private int lineCount = 10000;
    private final Diary diary;
    private final TreeSet<String> tagsAndLevels = new TreeSet();
    private int stopTheWorldEvents = 0;

    public UnifiedDiarizer() {
        this.diary = new Diary();
        this.diary.setTrue(SupportedFlags.UNIFIED_LOGGING);
        this.diary.setFalse(new SupportedFlags[]{SupportedFlags.ICMS, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK70, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK80, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION});
    }

    public Diary getDiary() {
        this.fillInKnowns();
        return this.diary;
    }

    public boolean isUnified() {
        return true;
    }

    public String getCommandLine() {
        return "";
    }

    public int getMaxTenuringThreshold() {
        return 0;
    }

    public boolean hasJVMEvents() {
        return this.diary.isApplicationStoppedTime() || this.diary.isApplicationRunningTime() || this.diary.isTLABData();
    }

    private void fillInKnowns() {
        this.diary.setFalse(SupportedFlags.ADAPTIVE_SIZING);
    }

    public boolean completed() {
        return this.diary.isComplete() || this.lineCount < 1;
    }

    public boolean diarize(String line) {
        if (!this.completed()) {
            if (!line.startsWith("[")) {
                return false;
            }
            --this.lineCount;
            this.extractDecorators(line);
            if (!this.diary.isCollectorKnown()) {
                this.discoverCollector(line);
            }
            if (!this.diary.isDetailsKnown()) {
                this.discoverDetails(line);
            }
            if (!this.diary.isJVMEventsKnown()) {
                this.discoverJVMEvents(line);
            }
            if (UnifiedPatterns.CPU_BREAKOUT.parse(line) != null || line.contains("gc,start")) {
                ++this.stopTheWorldEvents;
            }
        }
        return this.completed();
    }

    private void extractDecorators(String line) {
        Decorators decorators = new Decorators(line);
        this.timeOfFirstEvent(decorators);
        this.extractTagsAndLevels(decorators);
        if (decorators.getLogLevel().isPresent()) {
            UnifiedLoggingLevel logLevel = decorators.getLogLevel().get();
            if (decorators.tagsContain("gc,age")) {
                this.diary.setTrue(SupportedFlags.TENURING_DISTRIBUTION);
            } else if (decorators.tagsContain("ref") && logLevel.isGreaterThanOrEqualTo(UnifiedLoggingLevel.debug)) {
                this.diary.setTrue(SupportedFlags.PRINT_REFERENCE_GC);
            } else if (decorators.tagsContain("gc,phases") && logLevel.isGreaterThanOrEqualTo(UnifiedLoggingLevel.debug)) {
                this.diary.setTrue(SupportedFlags.GC_DETAILS);
            } else if (decorators.tagsContain("gc,ergo")) {
                this.diary.setTrue(SupportedFlags.ADAPTIVE_SIZING);
            }
            if (decorators.tagsContain("safepoint")) {
                this.diary.setTrue(new SupportedFlags[]{SupportedFlags.APPLICATION_STOPPED_TIME, SupportedFlags.APPLICATION_CONCURRENT_TIME});
            }
            if (this.diary.isZGC()) {
                if (decorators.tagsContain("task")) {
                    this.diary.setTrue(SupportedFlags.GC_DETAILS);
                } else if (decorators.tagsContain("heap")) {
                    this.diary.setTrue(SupportedFlags.PRINT_HEAP_AT_GC);
                } else if (decorators.tagsContain("tlab")) {
                    this.diary.setTrue(SupportedFlags.TLAB_DATA);
                } else if (decorators.tagsContain("gc,start") && line.contains("Garbage Collection (")) {
                    this.diary.setTrue(SupportedFlags.GC_CAUSE);
                } else if (decorators.tagsContain("gc,heap")) {
                    if (line.contains("Heap before GC")) {
                        this.diary.setTrue(SupportedFlags.PRINT_HEAP_AT_GC);
                    }
                    this.diary.setTrue(SupportedFlags.GC_DETAILS);
                } else if (decorators.tagsContain("gc,ref")) {
                    this.diary.setTrue(SupportedFlags.PRINT_REFERENCE_GC);
                } else if (decorators.tagsContain("gc,heap") && decorators.getLogLevel().get() == UnifiedLoggingLevel.debug) {
                    this.diary.setTrue(SupportedFlags.PRINT_HEAP_AT_GC);
                }
            } else if (this.diary.isShenandoah()) {
                if (decorators.tagsContain("gc,task") || decorators.tagsContain("gc,start")) {
                    this.diary.setTrue(SupportedFlags.GC_DETAILS);
                } else if (decorators.tagsContain("gc,ergo")) {
                    this.diary.setTrue(SupportedFlags.ADAPTIVE_SIZING);
                } else if (decorators.tagsContain("gc") && line.contains("Trigger")) {
                    this.diary.setTrue(SupportedFlags.GC_CAUSE);
                }
            }
        }
    }

    private void timeOfFirstEvent(Decorators decorator) {
        if (!this.diary.hasTimeOfFirstEvent()) {
            this.diary.setTimeOfFirstEvent(decorator.getDateTimeStamp());
        }
    }

    private void extractTagsAndLevels(Decorators decorators) {
        this.tagsAndLevels.add(decorators.getLogLevel() + ":" + decorators.getTags());
    }

    private void discoverCollector(String line) {
        if (ZGCPatterns.ZGC_TAG.parse(line) != null || ZGCPatterns.CYCLE_START.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.ZGC);
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.SHENANDOAH, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK70, SupportedFlags.JDK80, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION, SupportedFlags.TLAB_DATA, SupportedFlags.PRINT_PROMOTION_FAILURE, SupportedFlags.PRINT_FLS_STATISTICS});
            return;
        }
        if (ShenandoahPatterns.SHENANDOAH_TAG.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.SHENANDOAH);
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.G1GC, SupportedFlags.RSET_STATS, SupportedFlags.ZGC, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK70, SupportedFlags.JDK80, SupportedFlags.TENURING_DISTRIBUTION, SupportedFlags.MAX_TENURING_THRESHOLD_VIOLATION, SupportedFlags.TLAB_DATA, SupportedFlags.PRINT_PROMOTION_FAILURE, SupportedFlags.PRINT_FLS_STATISTICS, SupportedFlags.PRINT_HEAP_AT_GC});
            return;
        }
        if (UnifiedG1GCPatterns.G1_TAG.parse(line) != null || line.contains("G1 Evacuation Pause") || line.contains("Humongous regions: ")) {
            this.diary.setTrue(SupportedFlags.G1GC);
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.ZGC, SupportedFlags.SHENANDOAH, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK70, SupportedFlags.JDK80, SupportedFlags.TLAB_DATA, SupportedFlags.PRINT_PROMOTION_FAILURE, SupportedFlags.PRINT_FLS_STATISTICS});
            return;
        }
        if (UnifiedGenerationalPatterns.CMS_TAG.parse(line) != null || UnifiedGenerationalPatterns.PARNEW_TAG.parse(line) != null || line.contains("ParNew")) {
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARNEW, SupportedFlags.CMS});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL, SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.ICMS, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.G1GC, SupportedFlags.ZGC, SupportedFlags.SHENANDOAH, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK70, SupportedFlags.JDK80, SupportedFlags.RSET_STATS});
            return;
        }
        if (UnifiedGenerationalPatterns.PARALLEL_TAG.parse(line) != null || line.contains("ParOldGen") || line.contains("PSYoungGen")) {
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.GC_CAUSE});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.G1GC, SupportedFlags.ZGC, SupportedFlags.SHENANDOAH, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK70, SupportedFlags.JDK80, SupportedFlags.RSET_STATS});
            return;
        }
        if (UnifiedGenerationalPatterns.SERIAL_TAG.parse(line) != null || line.contains("DefNew")) {
            this.diary.setTrue(new SupportedFlags[]{SupportedFlags.DEFNEW, SupportedFlags.SERIAL, SupportedFlags.GC_CAUSE});
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.PARALLELGC, SupportedFlags.PARALLELOLDGC, SupportedFlags.PARNEW, SupportedFlags.CMS, SupportedFlags.ICMS, SupportedFlags.CMS_DEBUG_LEVEL_1, SupportedFlags.G1GC, SupportedFlags.ZGC, SupportedFlags.SHENANDOAH, SupportedFlags.PRE_JDK70_40, SupportedFlags.JDK70, SupportedFlags.JDK80, SupportedFlags.RSET_STATS});
            return;
        }
    }

    private void discoverDetails(String line) {
        if (UnifiedG1GCPatterns.G1_COLLECTION.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.GC_CAUSE);
        } else if (ZGCPatterns.CYCLE_START.parse(line) != null) {
            this.diary.setTrue(SupportedFlags.GC_CAUSE);
        }
        if (this.stopTheWorldEvents > 10) {
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.ADAPTIVE_SIZING, SupportedFlags.GC_CAUSE, SupportedFlags.TLAB_DATA, SupportedFlags.PRINT_REFERENCE_GC, SupportedFlags.PRINT_PROMOTION_FAILURE, SupportedFlags.PRINT_FLS_STATISTICS, SupportedFlags.RSET_STATS, SupportedFlags.PRINT_HEAP_AT_GC});
        }
    }

    private void discoverJVMEvents(String line) {
        if (this.stopTheWorldEvents > 2) {
            this.diary.setFalse(new SupportedFlags[]{SupportedFlags.APPLICATION_STOPPED_TIME, SupportedFlags.APPLICATION_CONCURRENT_TIME});
        }
    }

    public DateTimeStamp getTimeOfFirstEvent() {
        return this.diary.getTimeOfFirstEvent();
    }
}

