/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.gctoolkit.parser;

import com.microsoft.gctoolkit.event.GCCause;
import com.microsoft.gctoolkit.event.GarbageCollectionTypes;
import com.microsoft.gctoolkit.event.MalformedEvent;
import com.microsoft.gctoolkit.event.MemoryPoolSummary;
import com.microsoft.gctoolkit.event.ReferenceGCSummary;
import com.microsoft.gctoolkit.event.RegionSummary;
import com.microsoft.gctoolkit.event.SurvivorMemoryPoolSummary;
import com.microsoft.gctoolkit.event.UnifiedCountSummary;
import com.microsoft.gctoolkit.event.UnifiedStatisticalSummary;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCleanupForNextMark;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentClearClaimedMarks;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCompleteCleanup;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentCreateLiveData;
import com.microsoft.gctoolkit.event.g1gc.ConcurrentScanRootRegion;
import com.microsoft.gctoolkit.event.g1gc.G1Cleanup;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentMark;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentRebuildRememberedSets;
import com.microsoft.gctoolkit.event.g1gc.G1ConcurrentUndoCycle;
import com.microsoft.gctoolkit.event.g1gc.G1FullGC;
import com.microsoft.gctoolkit.event.g1gc.G1FullGCNES;
import com.microsoft.gctoolkit.event.g1gc.G1GCConcurrentEvent;
import com.microsoft.gctoolkit.event.g1gc.G1GCPauseEvent;
import com.microsoft.gctoolkit.event.g1gc.G1Mixed;
import com.microsoft.gctoolkit.event.g1gc.G1Remark;
import com.microsoft.gctoolkit.event.g1gc.G1SystemGC;
import com.microsoft.gctoolkit.event.g1gc.G1Young;
import com.microsoft.gctoolkit.event.g1gc.G1YoungInitialMark;
import com.microsoft.gctoolkit.parser.ForwardReference;
import com.microsoft.gctoolkit.parser.jvm.Decorators;
import com.microsoft.gctoolkit.time.DateTimeStamp;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import java.util.stream.Stream;

class G1GCForwardReference
extends ForwardReference {
    private static final Logger LOGGER = Logger.getLogger(G1GCForwardReference.class.getName());
    private int heapRegionSize = 0;
    private long minHeapSize;
    private long initialHeapSize;
    private long maxHeapSize;
    private DateTimeStamp concurrentCycleStartTime;
    private GarbageCollectionTypes pausePhaseDuringConcurrentCycle = null;
    private GarbageCollectionTypes gcType = null;
    private GarbageCollectionTypes concurrentPhase;
    private static final int HEAP_OCCUPANCY_BEFORE_COLLECTION = 0;
    private static final int HEAP_OCCUPANCY_AFTER_COLLECTION = 1;
    private static final int HEAP_SIZE_BEFORE_COLLECTION = 2;
    private static final int HEAP_SIZE_AFTER_COLLECTION = 3;
    private static final int EDEN_OCCUPANCY_BEFORE_COLLECTION = 4;
    private static final int EDEN_OCCUPANCY_AFTER_COLLECTION = 5;
    private static final int EDEN_SIZE_BEFORE_COLLECTION = 6;
    private static final int EDEN_SIZE_AFTER_COLLECTION = 7;
    private static final int SURVIVOR_OCCUPANCY_BEFORE_COLLECTION = 8;
    private static final int SURVIVOR_OCCUPANCY_AFTER_COLLECTION = 9;
    private static final int SURVIVOR_SIZE_BEFORE_COLLECTION = 10;
    private static final int SURVIVOR_SIZE_AFTER_COLLECTION = 11;
    private static final int YOUNG_OCCUPANCY_BEFORE_COLLECTION = 12;
    private static final int YOUNG_OCCUPANCY_AFTER_COLLECTION = 13;
    private static final int YOUNG_SIZE_BEFORE_COLLECTION = 14;
    private static final int YOUNG_SIZE_AFTER_COLLECTION = 15;
    private static final int OLD_OCCUPANCY_BEFORE_COLLECTION = 16;
    private static final int OLD_OCCUPANCY_AFTER_COLLECTION = 17;
    private static final int OLD_SIZE_BEFORE_COLLECTION = 18;
    private static final int OLD_SIZE_AFTER_COLLECTION = 19;
    private static final int HUMONGOUS_OCCUPANCY_BEFORE_COLLECTION = 20;
    private static final int HUMONGOUS_OCCUPANCY_AFTER_COLLECTION = 21;
    private static final int HUMONGOUS_SIZE_BEFORE_COLLECTION = 22;
    private static final int HUMONGOUS_SIZE_AFTER_COLLECTION = 23;
    private static final int ARCHIVE_OCCUPANCY_BEFORE_COLLECTION = 24;
    private static final int ARCHIVE_OCCUPANCY_AFTER_COLLECTION = 25;
    private static final int ARCHIVE_SIZE_BEFORE_COLLECTION = 26;
    private static final int ARCHIVE_SIZE_AFTER_COLLECTION = 27;
    private static final int METASPACE_OCCUPANCY_BEFORE_COLLECTION = 28;
    private static final int METASPACE_OCCUPANCY_AFTER_COLLECTION = 29;
    private static final int METASPACE_SIZE_BEFORE_COLLECTION = 30;
    private static final int METASPACE_SIZE_AFTER_COLLECTION = 31;
    private static final int METASPACE_COMMITTED_BEFORE_COLLECTION = 32;
    private static final int METASPACE_COMMITTED_AFTER_COLLECTION = 33;
    private static final int METASPACE_RESERVED_BEFORE_COLLECTION = 34;
    private static final int METASPACE_RESERVED_AFTER_COLLECTION = 35;
    private static final int CLASSSPACE_OCCUPANCY_BEFORE_COLLECTION = 36;
    private static final int CLASSSPACE_OCCUPANCY_AFTER_COLLECTION = 37;
    private static final int CLASSSPACE_SIZE_BEFORE_COLLECTION = 38;
    private static final int CLASSSPACE_SIZE_AFTER_COLLECTION = 39;
    private static final int CLASSSPACE_COMMITTED_BEFORE_COLLECTION = 40;
    private static final int CLASSSPACE_COMMITTED_AFTER_COLLECTION = 41;
    private static final int CLASSSPACE_RESERVED_BEFORE_COLLECTION = 42;
    private static final int CLASSSPACE_RESERVED_AFTER_COLLECTION = 43;
    private final long[] memoryPoolMeasurment = new long[]{-1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L, -1L};
    private static final int SOFT_REFERENCE = 0;
    private static final int WEAK_REFERENCE = 1;
    private static final int PHANTOM_REFERENCE = 2;
    private static final int FINAL_REFERENCE = 3;
    private static final int JNI_WEAK_REFERENCE = 4;
    private static final int CLEANER_REFERENCE = 5;
    private double[] referenceProcessingDuarations = new double[]{-1.0, -1.0, -1.0, -1.0, -1.0, -1.0};
    private int[] referenceCounts = new int[]{-1, -1, -1, -1, -1, -1};
    private static final double NOT_SET = -1.0;
    static final int PRE_EVACUATE_COLLECTION_SET = 0;
    static final int EVACUATE_COLLECTION_SET = 1;
    static final int POST_EVACUATE_COLLECTION_SET = 2;
    static final int OTHER = 3;
    private final double[] youngCollectionPhases = new double[]{-1.0, -1.0, -1.0, -1.0};
    private final Map<String, Double> preEvacuateCSetPhaseDurations = new ConcurrentHashMap<String, Double>(3);
    private final Map<String, UnifiedStatisticalSummary> evacuateCSetPhaseDurations = new ConcurrentHashMap<String, UnifiedStatisticalSummary>();
    private final Map<String, Double> postEvacuateCSetPhaseDurations = new ConcurrentHashMap<String, Double>();
    private UnifiedCountSummary unifiedCountSummary = null;
    private UnifiedCountSummary terminationAttempts = null;
    private boolean toSpaceExhausted = false;
    private int evacuationWorkersUsed = 0;
    private int evacuationWorkersAvailable = 0;
    private int concurrentMarkWorkersUsed = 0;
    private int concurrentMarkWorkersAvailable = 0;
    private double markFromRootsDuration = -1.0;
    private double precleanDuration = -1.0;
    private boolean aborted = false;
    private static final int OCCUPANCY_BEFORE_OFFSET = 0;
    private static final int OCCUPANCY_AFTER_OFFSET = 1;
    private static final int SIZE_BEFORE_OFFSET = 2;
    private static final int SIZE_AFTER_OFFSET = 3;
    private final RegionSummary[] regionSummaries = new RegionSummary[REGIONS.values().length];
    private DateTimeStamp pausePhaseDuringConcurrentCycleTime = null;
    private double pausePhaseDuringConcurrentCycleDuration = -1.0;
    private double finalizeMarkingDuration = -1.0;
    private double systemDictionaryUnloadingDuration = -1.0;
    private int stringTableProcessed = -1;
    private int stringTableRemoved = -1;
    private int symbolTableProcessed = -1;
    private int symbolTableRemoved = -1;
    private double parallelUnloadingDuration = -1.0;
    private final Map<String, Double> fullGCInternalPhases = new ConcurrentHashMap<String, Double>();
    private final Map<Integer, String> fullGCInternalPhaseOrder = new ConcurrentHashMap<Integer, String>();

    void setHeapRegionSize(int sizeInMegaBytes) {
        this.heapRegionSize = sizeInMegaBytes;
    }

    int getHeapRegionSize() {
        return this.heapRegionSize;
    }

    G1GCForwardReference(Decorators decorators, int gcID) {
        super(decorators, gcID);
    }

    boolean isConcurrentCycle() {
        return this.gcType == GarbageCollectionTypes.Concurrent_Cycle;
    }

    void setMinHeapSize(long minHeapSize) {
        this.minHeapSize = minHeapSize;
    }

    long getMinHeapSize() {
        return this.minHeapSize;
    }

    void setInitialHeapSize(long initialHeapSize) {
        this.initialHeapSize = initialHeapSize;
    }

    long getInitialHeapSize() {
        return this.initialHeapSize;
    }

    void setMaxHeapSize(long maxHeapSize) {
        this.maxHeapSize = maxHeapSize;
    }

    long getMaxHeapSize() {
        return this.maxHeapSize;
    }

    void setGcType(GarbageCollectionTypes garbageCollectionType) {
        if (this.gcType != null && this.gcType != garbageCollectionType) {
            throw new IllegalArgumentException("attempting to redefine GC Type from" + String.valueOf(this.gcType) + " to " + String.valueOf(garbageCollectionType));
        }
        this.gcType = garbageCollectionType;
    }

    GarbageCollectionTypes getGcType() {
        return this.gcType;
    }

    void setConcurrentPhase(GarbageCollectionTypes phase) {
        this.concurrentPhase = phase;
    }

    GarbageCollectionTypes getConcurrentPhase() {
        return this.concurrentPhase;
    }

    private boolean setMemoryPoolMeasurement(int index, long value) {
        if (this.memoryPoolMeasurment[index] < 0L) {
            this.memoryPoolMeasurment[index] = value;
            return true;
        }
        return false;
    }

    boolean setHeapOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(0, value);
    }

    boolean setHeapOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(1, value);
    }

    boolean setHeapSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(2, value);
    }

    boolean setHeapSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(3, value);
    }

    boolean setEdenOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(4, value);
    }

    boolean setEdenOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(5, value);
    }

    boolean setEdenSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(6, value);
    }

    boolean setEdenSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(7, value);
    }

    boolean setSurvivorOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(8, value);
    }

    boolean setSurvivorOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(9, value);
    }

    boolean setSurvivorSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(10, value);
    }

    boolean setSurvivorSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(11, value);
    }

    boolean setYoungOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(12, value);
    }

    boolean setYoungOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(13, value);
    }

    boolean setYoungSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(14, value);
    }

    boolean setYoungSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(15, value);
    }

    boolean setOldOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(16, value);
    }

    boolean setOldOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(17, value);
    }

    boolean setOldSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(18, value);
    }

    boolean setOldSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(19, value);
    }

    boolean setHumongousOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(20, value);
    }

    boolean setHumongousOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(21, value);
    }

    boolean setHumongousSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(22, value);
    }

    boolean setHumongousSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(23, value);
    }

    boolean setMetaspaceOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(28, value);
    }

    boolean setMetaspaceOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(29, value);
    }

    boolean setMetaspaceSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(30, value);
    }

    boolean setMetaspaceSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(31, value);
    }

    boolean setMetaspaceCommittedBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(32, value);
    }

    boolean setMetaspaceCommittedAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(33, value);
    }

    boolean setMetaspaceReservedBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(34, value);
    }

    boolean setMetaspaceReservedAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(35, value);
    }

    boolean setClassspaceOccupancyBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(36, value);
    }

    boolean setClassspaceOccupancyAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(37, value);
    }

    boolean setClassspaceSizeBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(38, value);
    }

    boolean setClassspaceSizeAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(39, value);
    }

    boolean setClassspaceCommittedBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(40, value);
    }

    boolean setClassspaceCommittedAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(41, value);
    }

    boolean setClassspaceReservedBeforeCollection(long value) {
        return this.setMemoryPoolMeasurement(42, value);
    }

    boolean setClassspaceReservedAfterCollection(long value) {
        return this.setMemoryPoolMeasurement(43, value);
    }

    void setSoftReferenceProcessingDuation(double duration) {
        this.referenceProcessingDuarations[0] = duration;
    }

    void setWeakReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[1] = duration;
    }

    void setPhantomReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[2] = duration;
    }

    void setFinalReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[3] = duration;
    }

    void setJniWeakReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[4] = duration;
    }

    void setCleanerReferenceProcessingDuration(double duration) {
        this.referenceProcessingDuarations[5] = duration;
    }

    void setReferenceCounts(int soft, int weak, int finalReferenceCount, int phantom) {
        this.referenceCounts[1] = weak;
        this.referenceCounts[0] = soft;
        this.referenceCounts[2] = phantom;
        this.referenceCounts[3] = finalReferenceCount;
    }

    private boolean hasReferenceGCSummary() {
        return this.referenceCounts[0] != -1;
    }

    private ReferenceGCSummary generateReferenceGCSummary() {
        ReferenceGCSummary summary = new ReferenceGCSummary();
        summary.addSoftReferences(this.getStartTime(), this.referenceCounts[0], this.referenceProcessingDuarations[0]);
        summary.addWeakReferences(this.getStartTime(), this.referenceCounts[1], this.referenceProcessingDuarations[1]);
        summary.addPhantomReferences(this.getStartTime(), this.referenceCounts[2], this.referenceProcessingDuarations[2]);
        summary.addFinalReferences(this.getStartTime(), this.referenceCounts[3], this.referenceProcessingDuarations[3]);
        summary.addJNIWeakReferences(this.getStartTime(), this.referenceCounts[4], this.referenceProcessingDuarations[4]);
        return summary;
    }

    void setPreEvacuateCSetDuration(double duration) {
        this.youngCollectionPhases[0] = duration;
    }

    void postPreEvacuateCSetPhaseDuration(String phase, double duration) {
        this.preEvacuateCSetPhaseDurations.put(phase, duration);
    }

    Stream<String> preEvacuateCSetPhaseNames() {
        return this.preEvacuateCSetPhaseDurations.keySet().stream();
    }

    double preEvacuateCSetPhaseDuration(String phaseName) {
        return this.preEvacuateCSetPhaseDurations.get(phaseName);
    }

    void setEvacuationCSetDuration(double duration) {
        this.youngCollectionPhases[1] = duration;
    }

    void postEvacuateCSetPhaseDuration(String phase, UnifiedStatisticalSummary stats) {
        this.evacuateCSetPhaseDurations.put(phase, stats);
    }

    Stream<String> evacuateCSetPhaseNames() {
        return this.evacuateCSetPhaseDurations.keySet().stream();
    }

    UnifiedStatisticalSummary evacuateCSetPhaseDuration(String phaseName) {
        return this.evacuateCSetPhaseDurations.get(phaseName);
    }

    void setPostEvacuateCSetDuration(double duration) {
        this.youngCollectionPhases[2] = duration;
    }

    void postPostEvacuateCSetPhaseDuration(String phase, double duration) {
        this.postEvacuateCSetPhaseDurations.put(phase, duration);
    }

    Stream<String> postEvacuateCSetPhaseNames() {
        return this.postEvacuateCSetPhaseDurations.keySet().stream();
    }

    double postEvacuateCSetPhaseDuration(String phaseName) {
        return this.postEvacuateCSetPhaseDurations.get(phaseName);
    }

    void setOtherDuration(double duration) {
        this.youngCollectionPhases[3] = duration;
    }

    void setProcessedBuffersSummary(UnifiedCountSummary summary) {
        this.unifiedCountSummary = summary;
    }

    void setTerminationAttempts(UnifiedCountSummary summary) {
        this.terminationAttempts = summary;
    }

    void toSpaceExhausted() {
        this.toSpaceExhausted = true;
    }

    void evacuationWorkers(int workersUsed, int available) {
        this.evacuationWorkersUsed = workersUsed;
        this.evacuationWorkersAvailable = available;
    }

    void concurrentMarkWorkers(int used, int available) {
        this.concurrentMarkWorkersUsed = used;
        this.concurrentMarkWorkersAvailable = available;
    }

    void setMarkFromRootsDuration(double duration) {
        this.markFromRootsDuration = duration;
    }

    void setPrecleanDuration(double duration) {
        this.precleanDuration = duration;
    }

    void abortConcurrentMark() {
        this.aborted = true;
    }

    private SurvivorMemoryPoolSummary getSurvivorMemoryPoolSummary() {
        if (this.memoryPoolMeasurment[8] == -1L) {
            return null;
        }
        return new SurvivorMemoryPoolSummary(this.memoryPoolMeasurment[8], this.memoryPoolMeasurment[9], this.memoryPoolMeasurment[11]);
    }

    private MemoryPoolSummary getMemoryPoolSummary(int offset) {
        if (this.memoryPoolMeasurment[offset + 0] == -1L) {
            return null;
        }
        long sizeBeforeCollection = this.memoryPoolMeasurment[offset + 2] > -1L ? this.memoryPoolMeasurment[offset + 2] : this.memoryPoolMeasurment[offset + 3];
        return new MemoryPoolSummary(this.memoryPoolMeasurment[offset + 0], sizeBeforeCollection, this.memoryPoolMeasurment[offset + 1], this.memoryPoolMeasurment[offset + 3]);
    }

    private void fillInMemoryPoolStats(G1GCPauseEvent collection) {
        MemoryPoolSummary heap = this.getMemoryPoolSummary(0);
        MemoryPoolSummary young = this.getMemoryPoolSummary(12);
        MemoryPoolSummary eden = this.getMemoryPoolSummary(4);
        SurvivorMemoryPoolSummary survivor = this.getSurvivorMemoryPoolSummary();
        MemoryPoolSummary tenured = this.getMemoryPoolSummary(16);
        MemoryPoolSummary humongous = this.getMemoryPoolSummary(20);
        collection.addHeapRegionSize(this.heapRegionSize);
        if (heap != null && eden != null && survivor != null) {
            collection.addMemorySummary(eden, survivor, heap);
        } else if (eden == null && survivor == null && heap != null) {
            collection.addMemorySummary(heap);
        }
    }

    private void fillInMetaspaceStats(G1GCPauseEvent collection) {
        collection.addPermOrMetaSpaceRecord(this.getMemoryPoolSummary(28));
    }

    void setEdenRegionSummary(RegionSummary summary) {
        this.regionSummaries[REGIONS.EDEN.ordinal()] = summary;
        if (this.heapRegionSize > 0) {
            this.setEdenOccupancyBeforeCollection((long)(summary.getBefore() * this.heapRegionSize) * 1024L);
            this.setEdenOccupancyAfterCollection((long)(summary.getAfter() * this.heapRegionSize) * 1024L);
            this.setEdenSizeBeforeCollection((long)(summary.getBefore() * this.heapRegionSize) * 1024L);
            this.setEdenSizeAfterCollection((long)(summary.getAssigned() * this.heapRegionSize) * 1024L);
        }
    }

    void setSurvivorRegionSummary(RegionSummary summary) {
        this.regionSummaries[REGIONS.SURVIVOR.ordinal()] = summary;
        if (this.heapRegionSize > 0) {
            this.setSurvivorOccupancyBeforeCollection((long)(summary.getBefore() * this.heapRegionSize) * 1024L);
            this.setSurvivorOccupancyAfterCollection((long)(summary.getAfter() * this.heapRegionSize) * 1024L);
            this.setSurvivorSizeBeforeCollection((long)(summary.getBefore() * this.heapRegionSize) * 1024L);
            this.setSurvivorSizeAfterCollection((long)(summary.getAssigned() * this.heapRegionSize) * 1024L);
        }
    }

    void setOldRegionSummary(RegionSummary summary) {
        this.regionSummaries[REGIONS.OLD.ordinal()] = summary;
        if (this.heapRegionSize > 0) {
            this.setOldOccupancyBeforeCollection((long)(summary.getBefore() * this.heapRegionSize) * 1024L);
            this.setOldOccupancyAfterCollection((long)(summary.getAfter() * this.heapRegionSize) * 1024L);
            this.setOldSizeBeforeCollection((long)(summary.getBefore() * this.heapRegionSize) * 1024L);
            this.setOldSizeAfterCollection((long)(summary.getAfter() * this.heapRegionSize) * 1024L);
        }
    }

    void setHumongousRegionSummary(RegionSummary summary) {
        this.regionSummaries[REGIONS.HUMONGOUS.ordinal()] = summary;
        if (this.heapRegionSize > 0) {
            this.setHumongousOccupancyBeforeCollection((long)(summary.getBefore() * this.heapRegionSize) * 1024L);
            this.setHumongousOccupancyAfterCollection((long)(summary.getAfter() * this.heapRegionSize) * 1024L);
            this.setHumongousSizeBeforeCollection((long)(summary.getBefore() * this.heapRegionSize) * 1024L);
            this.setHumongousSizeAfterCollection((long)(summary.getAfter() * this.heapRegionSize) * 1024L);
        }
    }

    void setArchiveRegionSummary(RegionSummary summary) {
        this.regionSummaries[REGIONS.ARCHIVE.ordinal()] = summary;
        if (this.heapRegionSize > 0) {
            this.setArchiveOccupancyBeforeCollection(summary.getBefore() * this.heapRegionSize * 1024);
            this.setArchiveOccupancyAfterCollection(summary.getAfter() * this.heapRegionSize * 1024);
            this.setArchiveSizeBeforeCollection(summary.getBefore() * this.heapRegionSize * 1024);
            this.setArchiveSizeAfterCollection(summary.getAfter() * this.heapRegionSize * 1024);
        }
    }

    private void fillInRegionSummary(G1GCPauseEvent collection) {
        collection.addRegionSummary(this.regionSummaries[REGIONS.EDEN.ordinal()], this.regionSummaries[REGIONS.SURVIVOR.ordinal()], this.regionSummaries[REGIONS.OLD.ordinal()], this.regionSummaries[REGIONS.HUMONGOUS.ordinal()], this.regionSummaries[REGIONS.ARCHIVE.ordinal()]);
    }

    private void fullInInternalPhases(G1FullGC collection) {
        String key;
        int index = 0;
        while ((key = this.fullGCInternalPhaseOrder.get(++index)) != null) {
            collection.addInternalPhase(key, this.fullGCInternalPhases.get(key));
        }
    }

    private void fillInPhases(G1Young collection) {
        collection.addPhaseDuration("Pre Evacuate Collection", this.youngCollectionPhases[0]);
        collection.addPhaseDuration("Evacuate Collection", this.youngCollectionPhases[1]);
        collection.addPhaseDuration("Post Evacuate Collection Set", this.youngCollectionPhases[2]);
        collection.addPhaseDuration("Other", this.youngCollectionPhases[3]);
        this.preEvacuateCSetPhaseNames().forEach(name -> collection.addPreEvacuationCollectionPhase(name, this.preEvacuateCSetPhaseDuration((String)name)));
        this.evacuateCSetPhaseNames().forEach(name -> collection.addEvacuationCollectionPhase(name, this.evacuateCSetPhaseDuration((String)name)));
        this.postEvacuateCSetPhaseNames().forEach(name -> collection.addPostEvacuationCollectionPhase(name, this.postEvacuateCSetPhaseDuration((String)name)));
    }

    private void fillInWorkers(G1Young collection) {
        collection.setEvacuationWorkersUsed(this.evacuationWorkersUsed);
        collection.setEvacuationWorkersAvailable(this.evacuationWorkersAvailable);
    }

    void pausePhaseDuringConcurrentCycle(GarbageCollectionTypes pausePhase) {
        this.pausePhaseDuringConcurrentCycle = pausePhase;
    }

    void pausePhaseDuringConcurrentCycleStart(DateTimeStamp clock) {
        this.pausePhaseDuringConcurrentCycleTime = clock;
    }

    void pausePhaseDuringConcurrentCycleDuration(double duration) {
        this.pausePhaseDuringConcurrentCycleDuration = duration;
    }

    void finalizeMarkingDuration(double duration) {
        this.finalizeMarkingDuration = duration;
    }

    void systemDictionaryUnloadingDuration(double duration) {
        this.systemDictionaryUnloadingDuration = duration;
    }

    void stringTableProcessedAndRemoved(int processed, int removed) {
        this.stringTableProcessed = processed;
        this.stringTableRemoved = removed;
    }

    void symbolTableProcessedAndRemoved(int processed, int removed) {
        this.symbolTableProcessed = processed;
        this.symbolTableRemoved = removed;
    }

    void parallelUnloadingDuration(double duration) {
        this.parallelUnloadingDuration = duration;
    }

    G1GCConcurrentEvent buildConcurrentPhaseEvent() {
        switch (this.getConcurrentPhase()) {
            case ConcurrentClearClaimedMarks: {
                return new ConcurrentClearClaimedMarks(this.getStartTime(), this.getDuration());
            }
            case ConcurrentScanRootRegions: {
                return new ConcurrentScanRootRegion(this.getStartTime(), this.getDuration());
            }
            case Concurrent_Mark: {
                return this.buildConcurrentMark();
            }
            case ConcurrentCompleteCleanup: {
                return new ConcurrentCompleteCleanup(this.getStartTime(), this.getDuration());
            }
            case ConcurrentCreateLiveData: {
                return new ConcurrentCreateLiveData(this.getStartTime(), this.getDuration());
            }
            case ConcurrentCleanupForNextMark: {
                return new ConcurrentCleanupForNextMark(this.getStartTime(), this.getDuration());
            }
            case G1ConcurrentRebuildRememberedSets: {
                return new G1ConcurrentRebuildRememberedSets(this.getStartTime(), this.getDuration());
            }
        }
        LOGGER.warning("Unrecognized Concurrent Event " + String.valueOf(this.getConcurrentPhase()));
        return null;
    }

    G1GCConcurrentEvent buildConcurrentUndoCycleEvent() {
        return new G1ConcurrentUndoCycle(this.getConcurrentCycleStartTime(), this.getDuration());
    }

    G1GCPauseEvent buildEvent() throws MalformedEvent {
        if (this.gcType == null) {
            throw new MalformedEvent("G1GC Event type is undefined (null): " + this.toString());
        }
        switch (this.gcType) {
            case Young: {
                return this.buildYoung();
            }
            case Initial_Mark: {
                return this.buildInitialMark();
            }
            case Mixed: {
                return this.buildMixed();
            }
            case G1GCFull: {
                return this.buildFull();
            }
            case Concurrent_Cycle: {
                switch (this.pausePhaseDuringConcurrentCycle) {
                    case G1GCRemark: {
                        return this.buildRemark();
                    }
                    case G1GCCleanup: {
                        return this.buildCleanup();
                    }
                }
                throw new MalformedEvent("Unrecognized (mostly) Concurrent Cycle Pause Event " + String.valueOf(this.getConcurrentPhase()));
            }
            case G1GCConcurrentUndoCycle: {
                return null;
            }
        }
        throw new MalformedEvent("Unrecognized Event " + String.valueOf(this.gcType));
    }

    private G1Young buildYoung(G1Young collection) {
        this.fillInMemoryPoolStats((G1GCPauseEvent)collection);
        this.fillInRegionSummary((G1GCPauseEvent)collection);
        this.fillInMetaspaceStats((G1GCPauseEvent)collection);
        this.fillInPhases(collection);
        this.fillInWorkers(collection);
        if (this.toSpaceExhausted) {
            collection.toSpaceExhausted();
        }
        if (this.hasReferenceGCSummary()) {
            collection.add(this.generateReferenceGCSummary());
        }
        if (this.survivorRecord != null) {
            collection.add(this.survivorRecord);
        }
        collection.addCPUSummary(this.getCPUSummary());
        return collection;
    }

    private G1Young buildYoung() {
        return this.buildYoung(new G1Young(this.getStartTime(), this.getGCCause(), this.getDuration()));
    }

    private G1YoungInitialMark buildInitialMark() {
        return (G1YoungInitialMark)this.buildYoung((G1Young)new G1YoungInitialMark(this.getStartTime(), this.getGCCause(), this.getDuration()));
    }

    private G1Mixed buildMixed() {
        return (G1Mixed)this.buildYoung((G1Young)new G1Mixed(this.getStartTime(), this.getGCCause(), this.getDuration()));
    }

    private G1ConcurrentMark buildConcurrentMark() {
        G1ConcurrentMark concurrentMark = new G1ConcurrentMark(this.getStartTime(), this.getDuration());
        if (this.aborted) {
            concurrentMark.abort();
        }
        if (this.markFromRootsDuration > -1.0) {
            concurrentMark.setMarkFromRootsDuration(this.markFromRootsDuration);
            concurrentMark.setActiveWorkerThreads(this.concurrentMarkWorkersUsed);
            concurrentMark.setAvailableWorkerThreads(this.concurrentMarkWorkersAvailable);
        }
        if (this.precleanDuration > -1.0) {
            concurrentMark.setPrecleanDuration(this.precleanDuration);
        }
        return concurrentMark;
    }

    private G1Remark buildRemark() {
        G1Remark remark = new G1Remark(this.pausePhaseDuringConcurrentCycleTime, 0.0, this.pausePhaseDuringConcurrentCycleDuration);
        if (this.hasReferenceGCSummary()) {
            remark.add(this.generateReferenceGCSummary());
        }
        this.fillInMemoryPoolStats((G1GCPauseEvent)remark);
        remark.addCPUSummary(this.getCPUSummary());
        return remark;
    }

    private G1Cleanup buildCleanup() {
        G1Cleanup cleanup = new G1Cleanup(this.pausePhaseDuringConcurrentCycleTime, this.pausePhaseDuringConcurrentCycleDuration);
        this.fillInMemoryPoolStats((G1GCPauseEvent)cleanup);
        cleanup.addCPUSummary(this.getCPUSummary());
        return cleanup;
    }

    private G1FullGC buildFull() {
        Object collection = this.getGCCause() == GCCause.JAVA_LANG_SYSTEM ? new G1SystemGC(this.getStartTime(), this.getDuration()) : new G1FullGCNES(this.getStartTime(), this.getGCCause(), this.getDuration());
        this.fillInMemoryPoolStats((G1GCPauseEvent)collection);
        this.fullInInternalPhases((G1FullGC)collection);
        this.fillInRegionSummary((G1GCPauseEvent)collection);
        if (this.hasReferenceGCSummary()) {
            collection.add(this.generateReferenceGCSummary());
        }
        collection.addCPUSummary(this.getCPUSummary());
        return collection;
    }

    void fullPhase(int integerGroup, String fullGCInternalPhase, double duration) {
        this.fullGCInternalPhaseOrder.put(integerGroup, fullGCInternalPhase);
        this.fullGCInternalPhases.put(fullGCInternalPhase, duration);
    }

    public String toString() {
        return this.getStartTime().toString() + " : " + (this.gcType == null ? "null" : this.gcType.toString()) + " : " + (this.getGCCause() == null ? "null" : this.getGCCause().toString()) + " : " + this.getDuration();
    }

    boolean setArchiveOccupancyBeforeCollection(int value) {
        return this.setMemoryPoolMeasurement(24, value);
    }

    boolean setArchiveOccupancyAfterCollection(int value) {
        return this.setMemoryPoolMeasurement(25, value);
    }

    boolean setArchiveSizeBeforeCollection(int value) {
        return this.setMemoryPoolMeasurement(26, value);
    }

    boolean setArchiveSizeAfterCollection(int value) {
        return this.setMemoryPoolMeasurement(27, value);
    }

    void setConcurrentCycleStartTime(DateTimeStamp clock) {
        this.concurrentCycleStartTime = clock;
    }

    DateTimeStamp getConcurrentCycleStartTime() {
        return this.concurrentCycleStartTime;
    }

    static enum REGIONS {
        EDEN,
        SURVIVOR,
        OLD,
        HUMONGOUS,
        ARCHIVE;

    }
}

